/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser.cpp;

import java.util.Map;
import org.eclipse.cdt.core.dom.parser.GNUScannerExtensionConfiguration;
import org.eclipse.cdt.core.parser.GCCKeywords;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.Keywords;

public class GPPScannerExtensionConfiguration
extends GNUScannerExtensionConfiguration {
    private static final int VERSION_4_3 = GPPScannerExtensionConfiguration.version(4, 3);
    private static final int VERSION_4_6 = GPPScannerExtensionConfiguration.version(4, 6);
    private static final int VERSION_4_7 = GPPScannerExtensionConfiguration.version(4, 7);
    private static GPPScannerExtensionConfiguration CONFIG = new GPPScannerExtensionConfiguration();
    private static GPPScannerExtensionConfiguration CONFIG_4_3 = new GPPScannerExtensionConfiguration(VERSION_4_3);
    private static GPPScannerExtensionConfiguration CONFIG_4_6 = new GPPScannerExtensionConfiguration(VERSION_4_6);
    private static GPPScannerExtensionConfiguration CONFIG_4_7 = new GPPScannerExtensionConfiguration(VERSION_4_7);

    public static GPPScannerExtensionConfiguration getInstance() {
        return CONFIG;
    }

    public static GPPScannerExtensionConfiguration getInstance(IScannerInfo info) {
        if (info != null) {
            try {
                Map<String, String> definedSymbols = info.getDefinedSymbols();
                int major = Integer.valueOf(definedSymbols.get("__GNUC__"));
                int minor = Integer.valueOf(definedSymbols.get("__GNUC_MINOR__"));
                int version = GPPScannerExtensionConfiguration.version(major, minor);
                if (version >= VERSION_4_7) {
                    return CONFIG_4_7;
                }
                if (version >= VERSION_4_6) {
                    return CONFIG_4_6;
                }
                if (version >= VERSION_4_3) {
                    return CONFIG_4_3;
                }
            }
            catch (Exception exception) {}
        }
        return CONFIG;
    }

    public GPPScannerExtensionConfiguration() {
        this(0);
    }

    public GPPScannerExtensionConfiguration(int version) {
        this.addMacro("__null", "0");
        this.addMacro("__builtin_offsetof(T,m)", "(reinterpret_cast <size_t>(&reinterpret_cast <const volatile char &>(static_cast<T*> (0)->m)))");
        this.addKeyword(Keywords.c_COMPLEX, 135);
        this.addKeyword(Keywords.c_IMAGINARY, 136);
        if (version >= VERSION_4_3) {
            this.addKeyword(GCCKeywords.cp__has_nothrow_assign, 156);
            this.addKeyword(GCCKeywords.cp__has_nothrow_constructor, 158);
            this.addKeyword(GCCKeywords.cp__has_nothrow_copy, 157);
            this.addKeyword(GCCKeywords.cp__has_trivial_assign, 159);
            this.addKeyword(GCCKeywords.cp__has_trivial_constructor, 161);
            this.addKeyword(GCCKeywords.cp__has_trivial_copy, 160);
            this.addKeyword(GCCKeywords.cp__has_trivial_destructor, 162);
            this.addKeyword(GCCKeywords.cp__has_virtual_destructor, 163);
            this.addKeyword(GCCKeywords.cp__is_abstract, 164);
            this.addKeyword(GCCKeywords.cp__is_base_of, 165);
            this.addKeyword(GCCKeywords.cp__is_class, 166);
            this.addKeyword(GCCKeywords.cp__is_empty, 167);
            this.addKeyword(GCCKeywords.cp__is_enum, 168);
            this.addKeyword(GCCKeywords.cp__is_pod, 169);
            this.addKeyword(GCCKeywords.cp__is_polymorphic, 170);
            this.addKeyword(GCCKeywords.cp__is_union, 171);
        }
        if (version >= VERSION_4_6) {
            this.addKeyword(GCCKeywords.cp__is_literal_type, 172);
            this.addKeyword(GCCKeywords.cp__is_standard_layout, 173);
            this.addKeyword(GCCKeywords.cp__is_trivial, 174);
        }
        if (version >= VERSION_4_7) {
            this.addKeyword(GCCKeywords.cp__float128, 176);
            this.addKeyword(GCCKeywords.cp__int128, 175);
            this.addKeyword(GCCKeywords.cp__is_final, 177);
            this.addKeyword(GCCKeywords.cp__underlying_type, 178);
        }
    }

    @Override
    public boolean supportMinAndMaxOperators() {
        return true;
    }

    @Override
    public boolean supportRawStringLiterals() {
        return true;
    }
}

