/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core;

import java.util.HashMap;
import java.util.Map;

public class CheckersTimeStats {
    public static final String ALL = "ALL";
    public static final String ELAPSED = "ELAPSED";
    private static CheckersTimeStats instance = new CheckersTimeStats();
    private Map<String, TimeRecord> records = new HashMap<String, TimeRecord>();

    public static CheckersTimeStats getInstance() {
        return instance;
    }

    private TimeRecord getTimeRecord(String id) {
        TimeRecord record = this.records.get(id);
        if (record == null) {
            record = new TimeRecord();
            this.records.put(id, record);
        }
        return record;
    }

    public void checkerStart(String id) {
        this.checkerStart(id, ELAPSED);
    }

    public void checkerStart(String id, String counter) {
        TimeRecord record = this.getTimeRecord(String.valueOf(id) + ":" + counter);
        record.start();
    }

    public void checkerStop(String id, String counter) {
        this.getTimeRecord(String.valueOf(id) + ":" + counter).stop();
    }

    public void checkerStop(String id) {
        this.checkerStop(id, ELAPSED);
    }

    public void traceStats() {
        this.printStats();
    }

    public void printStats() {
        System.out.println("---");
        for (String id : this.records.keySet()) {
            TimeRecord timeRecord = this.getTimeRecord(id);
            System.out.println(String.valueOf(timeRecord.toString()) + " " + id);
        }
    }

    public void reset() {
        this.records.clear();
    }

    private static class TimeRecord {
        private long duration;
        private long current;
        private int count;

        private TimeRecord() {
        }

        public void start() {
            this.current = System.currentTimeMillis();
        }

        public void stop() {
            ++this.count;
            this.duration += System.currentTimeMillis() - this.current;
            this.current = 0L;
        }

        public String toString() {
            if (this.count != 0) {
                return String.valueOf(this.duration) + " " + this.count + " " + this.duration / (long)this.count;
            }
            return "";
        }
    }
}

