/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.preferences.AbstractPreferencePage;
import org.eclipse.cdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.text.c.hover.SourceViewerInformationControl;
import org.eclipse.cdt.internal.ui.text.doctools.DocCommentOwnerManager;
import org.eclipse.cdt.ui.dialogs.DocCommentOwnerComposite;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CEditorPreferencePage
extends AbstractPreferencePage {
    protected final String[][] fAppearanceColorListModel;
    private List fAppearanceColorList;
    private ColorSelector fAppearanceColorEditor;
    private Button fAppearanceColorDefault;
    private DocCommentOwnerComposite fDocCommentOwnerComposite;

    public CEditorPreferencePage() {
        String[][] stringArrayArray = new String[7][];
        String[] stringArray = new String[3];
        stringArray[0] = PreferencesMessages.CEditorPreferencePage_behaviorPage_matchingBracketColor;
        stringArray[1] = "matchingBracketsColor";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = PreferencesMessages.CEditorPreferencePage_behaviorPage_inactiveCodeColor;
        stringArray2[1] = "inactiveCodeColor";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = PreferencesMessages.CEditorPreferencePage_ContentAssistPage_completionProposalBackgroundColor;
        stringArray3[1] = "content_assist_proposals_background";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = PreferencesMessages.CEditorPreferencePage_ContentAssistPage_completionProposalForegroundColor;
        stringArray4[1] = "content_assist_proposals_foreground";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = PreferencesMessages.CEditorPreferencePage_ContentAssistPage_parameterBackgroundColor;
        stringArray5[1] = "content_assist_parameters_background";
        stringArrayArray[4] = stringArray5;
        String[] stringArray6 = new String[3];
        stringArray6[0] = PreferencesMessages.CEditorPreferencePage_ContentAssistPage_parameterForegroundColor;
        stringArray6[1] = "content_assist_parameters_foreground";
        stringArrayArray[5] = stringArray6;
        stringArrayArray[6] = new String[]{PreferencesMessages.CEditorPreferencePage_sourceHoverBackgroundColor, "sourceHoverBackgroundColor", "sourceHoverBackgroundColor.SystemDefault"};
        this.fAppearanceColorListModel = stringArrayArray;
    }

    @Override
    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "subWordNavigation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "handleTemporaryProblems"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "matchingBracketsColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "matchingBrackets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "inactiveCodeColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "inactiveCodeEnable"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "sourceHoverBackgroundColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "sourceHoverBackgroundColor.SystemDefault"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault("subWordNavigation", true);
        store.setDefault("matchingBrackets", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"matchingBracketsColor", (RGB)new RGB(170, 170, 170));
        store.setDefault("inactiveCodeEnable", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"inactiveCodeColor", (RGB)new RGB(224, 224, 224));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.ui.c_editor_gen");
    }

    protected static void setEnabled(Control control, boolean enable) {
        control.setEnabled(enable);
        if (control instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)control;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                CEditorPreferencePage.setEnabled(element, enable);
                ++n2;
            }
        }
    }

    private Control createBehaviorBlock(Composite parent) {
        Group behaviorComposite = ControlFactory.createGroup(parent, PreferencesMessages.CEditorPreferencePage_GeneralAppearanceGroupTitle, 1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        behaviorComposite.setLayout((Layout)layout);
        String label = PreferencesMessages.CEditorPreferencePage_behaviorPage_subWordNavigation;
        this.addCheckBox((Composite)behaviorComposite, label, "subWordNavigation", 0);
        label = PreferencesMessages.CEditorPreferencePage_behaviourPage_EnableEditorProblemAnnotation;
        this.addCheckBox((Composite)behaviorComposite, label, "handleTemporaryProblems", 0);
        label = PreferencesMessages.CEditorPreferencePage_behaviorPage_matchingBrackets;
        this.addCheckBox((Composite)behaviorComposite, label, "matchingBrackets", 0);
        label = PreferencesMessages.CEditorPreferencePage_behaviorPage_inactiveCode;
        this.addCheckBox((Composite)behaviorComposite, label, "inactiveCodeEnable", 0);
        Label l = new Label((Composite)behaviorComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label((Composite)behaviorComposite, 16384);
        l.setText(PreferencesMessages.CEditorPreferencePage_behaviorPage_appearanceColorOptions);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite((Composite)behaviorComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText(PreferencesMessages.CEditorPreferencePage_behaviorPage_Color);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        SelectionAdapter colorDefaultSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean systemDefault = CEditorPreferencePage.this.fAppearanceColorDefault.getSelection();
                CEditorPreferencePage.this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
                int i = CEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = CEditorPreferencePage.this.fAppearanceColorListModel[i][2];
                if (key != null) {
                    CEditorPreferencePage.this.fOverlayStore.setValue(key, systemDefault);
                }
            }
        };
        this.fAppearanceColorDefault = new Button(stylesComposite, 32);
        this.fAppearanceColorDefault.setText(PreferencesMessages.CEditorPreferencePage_colorPage_systemDefault);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fAppearanceColorDefault.setLayoutData((Object)gd);
        this.fAppearanceColorDefault.setVisible(false);
        this.fAppearanceColorDefault.addSelectionListener((SelectionListener)colorDefaultSelectionListener);
        this.fAppearanceColorList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = CEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = CEditorPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)CEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)CEditorPreferencePage.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return behaviorComposite;
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
        this.updateAppearanceColorWidgets(this.fAppearanceColorListModel[i][2]);
    }

    private void updateAppearanceColorWidgets(String systemDefaultKey) {
        if (systemDefaultKey == null) {
            this.fAppearanceColorDefault.setSelection(false);
            this.fAppearanceColorDefault.setVisible(false);
            this.fAppearanceColorEditor.getButton().setEnabled(true);
        } else {
            boolean systemDefault = this.fOverlayStore.getBoolean(systemDefaultKey);
            this.fAppearanceColorDefault.setSelection(systemDefault);
            this.fAppearanceColorDefault.setVisible(true);
            this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
        }
    }

    private Control createHeader(Composite parent) {
        String text = PreferencesMessages.CEditorPreferencePage_link;
        Link link = new Link(parent, 0);
        link.setText(text);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String u = event.text;
                PreferencesUtil.createPreferenceDialogOn((Shell)CEditorPreferencePage.this.getShell(), (String)u, null, null);
            }
        });
        link.setToolTipText(PreferencesMessages.CEditorPreferencePage_link_tooltip);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
        return link;
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite contents = ControlFactory.createComposite(parent, 1);
        contents.setLayoutData((Object)new GridData(1808));
        this.createHeader(contents);
        ControlFactory.createEmptySpace(contents, 2);
        this.createBehaviorBlock(contents);
        ControlFactory.createEmptySpace(contents, 2);
        String dsc = PreferencesMessages.CEditorPreferencePage_SelectDocToolDescription;
        String msg = PreferencesMessages.CEditorPreferencePage_WorkspaceDefaultLabel;
        IDocCommentOwner workspaceOwner = DocCommentOwnerManager.getInstance().getWorkspaceCommentOwner();
        this.fDocCommentOwnerComposite = new DocCommentOwnerComposite(contents, workspaceOwner, dsc, msg);
        this.fDocCommentOwnerComposite.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
        this.initialize();
        return contents;
    }

    private void initialize() {
        this.initializeFields();
        this.initializeDefaultColors();
        String[][] stringArray = this.fAppearanceColorListModel;
        int n = this.fAppearanceColorListModel.length;
        int n2 = 0;
        while (n2 < n) {
            String[] element = stringArray[n2];
            this.fAppearanceColorList.add(element[0]);
            ++n2;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CEditorPreferencePage.this.fAppearanceColorList.select(0);
                CEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
    }

    @Override
    public boolean performOk() {
        DocCommentOwnerManager.getInstance().setWorkspaceCommentOwner(this.fDocCommentOwnerComposite.getSelectedDocCommentOwner());
        return super.performOk();
    }

    private void initializeDefaultColors() {
        if (this.getPreferenceStore().getBoolean("sourceHoverBackgroundColor.SystemDefault")) {
            Display display = this.fAppearanceColorList.getDisplay();
            RGB rgb = SourceViewerInformationControl.getVisibleBackgroundColor(display);
            if (rgb == null) {
                rgb = display.getSystemColor(29).getRGB();
            }
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"sourceHoverBackgroundColor", (RGB)rgb);
        }
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaultColors();
        this.handleAppearanceColorListSelection();
    }
}

