/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.ibm.icu.text.MessageFormat;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.launch.CudaRunControl;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.CudaFocusChangedEvent;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.KernelCallSite;
import com.nvidia.cuda.ide.debug.model.RangeContext;
import com.nvidia.cuda.ide.debug.service.IDebuggerUIState;
import com.nvidia.cuda.ide.debug.ui.IDebugLabelProvider;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaUIConstants;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LayoutChangeEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LinkedSelectionChangedEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.AbstractCudaDMVMNode;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.CudaGdbExecutionContextLabelText;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelHierarchy;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelImage;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelColors;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import com.nvidia.cuda.ide.debug.util.OccupancyImage;
import java.lang.ref.WeakReference;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.MessagesForLaunchVM;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IMemento;

public final class KernelVMNode
extends AbstractCudaDMVMNode<Kernel> {
    private static final int MAX_EVENT_PROCESSING_DEPTH = 1000;
    private static final String PROP_ACTIVE_AND_SUSPENDED = "prop.active.suspended";
    private WeakReference<Object> eventReference = null;
    private final KernelHierarchy hierarchy;
    private int recursionDepth;
    private final boolean flatLayout;

    private static boolean isRunning(Object event) {
        return event instanceof IRunControl.IResumedDMEvent && ((IRunControl.IResumedDMEvent)event).getReason() != IRunControl.StateChangeReason.STEP || event instanceof SteppingController.SteppingTimedOutEvent;
    }

    public static boolean isSameKernel(Kernel kernel, IMemento memento) {
        boolean id = DebugUtil.compare(kernel.getId(), memento, "MEMENTO_KERNEL_ID");
        boolean deviceId = DebugUtil.compare(kernel.getDeviceId(), memento, "MEMENTO_KERNEL_DEVICE_ID");
        return id && deviceId;
    }

    public static void store(Kernel kernel, IMemento memento) {
        if (kernel != null) {
            memento.putInteger("MEMENTO_KERNEL_ID", (int)kernel.getId());
            memento.putInteger("MEMENTO_KERNEL_DEVICE_ID", (int)kernel.getDeviceId());
        }
    }

    public KernelVMNode(AbstractDMVMProvider provider, DsfSession session, boolean flatLayout) {
        super(provider, session, Kernel.class);
        this.flatLayout = flatLayout;
        this.hierarchy = new KernelHierarchy(this.getServicesTracker(), flatLayout);
    }

    @Override
    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (KernelVMNode.isRunning(event)) {
            parent.setFlags(parent.getFlags() | 0x400);
        } else if (event instanceof FullStackRefreshEvent) {
            this.buildSuspendedEventDelta(parent, nodeOffset, requestMonitor);
            return;
        }
        super.buildDelta(event, parent, nodeOffset, requestMonitor);
    }

    @Override
    protected void buildProxyInstalledDelta(VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        this.expand(parent, true, requestMonitor);
    }

    @Override
    protected void buildSelectionDelta(Kernel element, final VMDelta delta, final int nodeOffset, final boolean select, final boolean collapseTheRest, final RequestMonitor rm) {
        KernelCallSite site;
        IDebuggerUIState service;
        String val = Activator.getDefault().getPreferenceStore().getString("device.kernels.mode");
        if (!this.flatLayout && "device_kernels_filtered".equals(val) && (service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class)) != null && service.getFocus() != null && (site = service.getFocus().getKernel().getCallSite(element.getId())) != null) {
            super.buildSelectionDelta(service.getFocus().getKernel(), delta, nodeOffset, false, false, rm);
            return;
        }
        this.hierarchy.getAncestor(element, delta, new DataRequestMonitor<Kernel>(ImmediateExecutor.getInstance(), rm){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                if (this.getData() != null) {
                    KernelVMNode.super.buildSelectionDelta((Kernel)this.getData(), delta, nodeOffset, select, collapseTheRest, rm);
                } else {
                    rm.done();
                }
            }
        });
    }

    private void buildSuspendedEventDelta(VMDelta parent, int nodeOffset, RequestMonitor rm) {
        parent.setFlags(parent.getFlags() | 0x400);
        this.expand(parent, false, rm);
    }

    @Override
    protected boolean compareElement(Kernel object, IMemento memento) {
        return KernelVMNode.isSameKernel(object, memento);
    }

    private LabelColumnInfo createLabelColumn() {
        String[] properties = new String[]{"name", "grid_dim", "block_dim", "kernel_id", "short_name", "active_kernel_blocks"};
        return new LabelColumnInfo(new LabelAttribute[]{new LabelText("[{3}] {5,choice,0#{4}|0<{0}} <<<{1}, {2}>>>", properties), new LabelText(MessagesForLaunchVM.AbstractThreadVMNode_No_columns__Error__label, new String[0]), new KernelImage(false), new ConditionalLabelColors("active_kernel_blocks", 0)});
    }

    private LabelColumnInfo createLabelNoColumn() {
        String[] properties = new String[]{"short_name", "device.name", "is_suspended", "state_change_reason_known", "state_change_reason", "state_change_details_known", "state_change_details", "kernel_id", "device_id", PROP_ACTIVE_AND_SUSPENDED, "errorPCKnown", "errorPC"};
        return new LabelColumnInfo(new LabelAttribute[]{new CudaGdbExecutionContextLabelText("{0} [{7}] [device {8} ({1})] {9,choice,0#(Running|1#|2#}{3,choice,0#|1# ({4})}{5,choice,0#|1# - {6}}{9,choice,0#)|1#|2#}{10,choice,0#|1# ; ExceptionPC={11}}", properties), new LabelText(MessagesForLaunchVM.AbstractThreadVMNode_No_columns__Error__label, new String[0]), new KernelImage(true), new ConditionalLabelColors(null, new RGB(255, 192, 192), "prop.is.error", 1), new ConditionalLabelColors("active_kernel_blocks", 0)});
    }

    @Override
    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", this.createLabelColumn());
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__DEVICE, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0}", new String[]{"device_id"}), new ConditionalLabelColors("active_kernel_blocks", 0)}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__HARDWARE, new LabelColumnInfo(new LabelAttribute[]{new LabelText("Device {1} ({0})", new String[]{"device.name", "device_id"}), new ConditionalLabelColors("active_kernel_blocks", 0)}));
        provider.setColumnInfo(ICudaUIConstants.COLUMN_ID__DETAILS, new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0,choice,0#No active blocks of {1}|1#1 block of {1} is running|1<{0} blocks of {1} are running}", new String[]{"active_kernel_blocks", "grid_size"}), new OccupancyImage("grid_size", "active_kernel_blocks"), new ConditionalLabelColors("active_kernel_blocks", 0)}));
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", this.createLabelNoColumn());
        return provider;
    }

    @Override
    protected void encodeElement(Kernel object, IMemento memento) {
        KernelVMNode.store(object, memento);
    }

    private void expand(VMDelta parent, boolean collapseOthers, RequestMonitor rm) {
        IDebuggerUIState service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class);
        if (service != null && service.getFocus() != null) {
            Kernel kernel = service.getFocus().getKernel();
            this.buildSelectionDelta(kernel, parent, 0, false, collapseOthers, rm);
        } else {
            rm.done();
        }
    }

    @Override
    protected boolean fetchChildren(final ICudaRuntimeObject parent, final int offset, final int length, final DataRequestMonitor<IDMContext[]> drm) {
        this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                KernelVMNode.this.hierarchy.getChildren(parent, offset, length, (DataRequestMonitor<IDMContext[]>)drm, KernelVMNode.this.getFilter());
            }
        });
        return true;
    }

    private void fillBasicProperties(Kernel kernel, IPropertiesUpdate update) {
        IDebugLabelProvider formatter = this.getFormatter();
        update.setProperty("name", (Object)kernel.getName());
        update.setProperty("short_name", (Object)kernel.getShortName());
        CudaDim gridDim = kernel.getGridDim();
        update.setProperty("grid_dim", (Object)formatter.format(gridDim));
        update.setProperty("block_dim", (Object)formatter.format(kernel.getBlockDim()));
        update.setProperty("grid_size", (Object)(gridDim != null ? gridDim.elementCount() : 0));
        update.setProperty("id", (Object)kernel.getId());
        update.setProperty("kernel_id", (Object)kernel.getId());
        update.setProperty("device_id", (Object)kernel.getDeviceId());
    }

    private void fillBlockCount(Kernel kernel, final IPropertiesUpdate update, final RequestMonitor crm, final boolean[] suspendedAndActive) {
        if (update.getProperties().contains("active_kernel_blocks")) {
            kernel.getActiveBlocksCount(new DataRequestMonitor<Integer>(this.getExecutor(), crm){

                protected void handleFailure() {
                    update.setProperty("active_kernel_blocks", (Object)0);
                    crm.done();
                }

                protected void handleSuccess() {
                    Integer data = (Integer)this.getData();
                    suspendedAndActive[1] = !Integer.valueOf(0).equals(data);
                    update.setProperty("active_kernel_blocks", (Object)data);
                    crm.done();
                }
            });
        } else {
            crm.done();
        }
    }

    protected void fillExecutionDataProperties(IPropertiesUpdate update, IRunControl.IExecutionDMData data) {
        String errorPC;
        String details;
        IRunControl.StateChangeReason reason = data.getStateChangeReason();
        if (reason != null) {
            update.setProperty("state_change_reason", (Object)data.getStateChangeReason().name());
            update.setProperty("prop.is.error", (Object)(DebugUtil.isInError(data) ? 1 : 0));
        }
        if (data instanceof IRunControl.IExecutionDMData2 && (details = ((IRunControl.IExecutionDMData2)data).getDetails()) != null) {
            update.setProperty("state_change_details", (Object)details);
        }
        if (data instanceof IRunControl.IExecutionDMData3 && (errorPC = ((IRunControl.IExecutionDMData3)data).getErrorPC()) != null) {
            update.setProperty("errorPC", (Object)errorPC);
        }
    }

    private void fillRunData(IRunControl.IExecutionDMContext dmc, Kernel kernel, final IPropertiesUpdate update, final RequestMonitor crm, boolean[] suspendedAndActive) {
        CudaRunControl service = (CudaRunControl)((Object)this.getServicesTracker().getService(CudaRunControl.class));
        if (service != null) {
            suspendedAndActive[0] = service.isSuspended(dmc);
            update.setProperty("is_suspended", (Object)suspendedAndActive[0]);
            update.setProperty("is_stepping", (Object)service.isStepping(dmc));
            service.getKernelExecutionData(dmc, kernel, new DataRequestMonitor<IRunControl.IExecutionDMData>(this.getExecutor(), crm){

                protected void handleSuccess() {
                    KernelVMNode.this.fillExecutionDataProperties(update, (IRunControl.IExecutionDMData)this.getData());
                    crm.done();
                }
            });
        } else {
            this.handleFailedUpdate((IViewerUpdate)update);
        }
    }

    @Override
    public void getContextsForEvent(VMDelta parentDelta, Object event, final DataRequestMonitor<IVMContext[]> rm) {
        if (this.eventReference != null && event.equals(this.eventReference.get())) {
            if (this.recursionDepth > 1000) {
                Activator.log("[KernelVMNode] Exhasted stack, event is %s\n", event.getClass());
                rm.done((Object)new IVMContext[0]);
            } else {
                ++this.recursionDepth;
            }
        } else {
            this.eventReference = new WeakReference<Object>(event);
            this.recursionDepth = 0;
        }
        if (event instanceof CudaFocusChangedEvent) {
            DeviceThread context = ((CudaFocusChangedEvent)((Object)event)).getNewFocus();
            if (context == null) {
                rm.done((Object)new IVMContext[0]);
            } else {
                this.hierarchy.getAncestor(context.getKernel(), parentDelta, new DataRequestMonitor<Kernel>(ImmediateExecutor.getInstance(), rm){

                    @ConfinedToDsfExecutor(value="fExecutor")
                    protected void handleSuccess() {
                        if (this.getData() != null) {
                            rm.done((Object)new IVMContext[]{KernelVMNode.this.createVMContext((IDMContext)this.getData())});
                        } else {
                            rm.done((Object)new IVMContext[0]);
                        }
                    }
                });
            }
        } else if (event instanceof IRunControl.IExitedDMEvent || event instanceof SteppingController.SteppingTimedOutEvent) {
            rm.done((Object)new IVMContext[0]);
        } else {
            super.getContextsForEvent(parentDelta, event, rm);
        }
    }

    @Override
    public int getDeltaFlags(Object event) {
        if (event instanceof FullStackRefreshEvent) {
            return 0x100C01;
        }
        if (KernelVMNode.isRunning(event)) {
            return 1024;
        }
        if (event instanceof LinkedSelectionChangedEvent | event instanceof LayoutChangeEvent) {
            return 0x2300000 | (this.kernelListChanged((IDMEvent)event) ? 1024 : 0);
        }
        if (event instanceof ModelProxyInstalledEvent) {
            return 0x100000;
        }
        return super.getDeltaFlags(event);
    }

    @Override
    protected String getInactiveElementRangeStateLabel(RangeContext rangeContext) {
        return MessageFormat.format((String)"{0} Inactive Elements", (Object[])new Object[]{rangeContext.getEnd() - rangeContext.getStart() + 1L});
    }

    @Override
    protected CudaDebugImages getInactiveImageDescriptor() {
        return CudaDebugImages.KERNEL_INACTIVE;
    }

    @Override
    protected boolean isLogicalNode() {
        return true;
    }

    private boolean kernelListChanged(IDMEvent<?> event) {
        DeviceThread focus;
        IDebuggerUIState service;
        Kernel kernel;
        if (this.hierarchy.isFiltering() && (kernel = DebugUtil.getObject(event, Kernel.class, null)) != null && (service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class)) != null && ((focus = service.getFocus()) == null || !focus.getKernel().equals(kernel))) {
            return service.pinKernel(kernel);
        }
        return false;
    }

    private void setDeviceName(final Kernel kernel, final IPropertiesUpdate update, final RequestMonitor rm) {
        ICudaApplication application = (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)kernel, ICudaApplication.class);
        application.getDevices(new DataRequestMonitor<Device[]>(ImmediateExecutor.getInstance(), rm){

            protected void handleSuccess() {
                Device[] deviceArray = (Device[])this.getData();
                int n = deviceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Device device = deviceArray[n2];
                    if (device.getId() == kernel.getDeviceId()) {
                        update.setProperty("device.name", (Object)device.getName());
                    }
                    ++n2;
                }
                rm.done();
            }
        });
    }

    private void setIsCdpKernelProperty(Kernel kernel, IPropertiesUpdate update, CountingRequestMonitor crm) {
        if (update.getProperties().contains("is_cdp_kernel")) {
            update.setProperty("is_cdp_kernel", (Object)(kernel.getCallSite() != null ? 1 : 0));
        }
        crm.done();
    }

    public String toString() {
        return "KernelVM";
    }

    @Override
    public void update(IChildrenCountUpdate[] updates) {
        this.baseUpdate(updates);
    }

    @Override
    public void update(IHasChildrenUpdate[] updates) {
        this.baseUpdate(updates);
    }

    @Override
    protected void updatePropertiesInSessionThread(final Kernel kernel, final IPropertiesUpdate update) {
        final boolean[] suspendedAndActive = new boolean[]{true, true};
        CountingRequestMonitor crm = new CountingRequestMonitor(this.getExecutor(), (RequestMonitor)new ViewerRequestMonitor(this.getExecutor(), (IViewerUpdate)update)){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                int value = suspendedAndActive[0] && suspendedAndActive[1] ? 1 : (suspendedAndActive[0] && !suspendedAndActive[1] ? 2 : 0);
                update.setProperty(KernelVMNode.PROP_ACTIVE_AND_SUSPENDED, (Object)value);
                KernelVMNode.this.fillBasicProperties(kernel, update);
                super.handleSuccess();
            }
        };
        crm.setDoneCount(4);
        IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (dmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
        } else {
            if (update.getProperties().contains("is_suspended")) {
                this.fillRunData(dmc, kernel, update, (RequestMonitor)crm, suspendedAndActive);
            } else {
                crm.done();
            }
            this.fillBlockCount(kernel, update, (RequestMonitor)crm, suspendedAndActive);
            this.setDeviceName(kernel, update, (RequestMonitor)crm);
            this.setIsCdpKernelProperty(kernel, update, crm);
        }
    }
}

