/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.common.util.Tuple;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.KernelCallSite;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.ICudaElementFilter;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelHierarchy;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.jface.preference.IPreferenceStore;

public final class KernelTree
implements KernelHierarchy.IDelegate {
    @Override
    public void getChildren(ICudaRuntimeObject parent, int offset, int length, DataRequestMonitor<IDMContext[]> rm, ICudaElementFilter filter) {
        ICudaApplication root = KernelHierarchy.isDebugHierarchyRoot(parent);
        filter.updateChildren(true, (ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)parent, ICudaApplication.class), offset, length, ICoordSorter.CUDA, this.unfilteredMode(root, parent, rm));
    }

    @Override
    public void getChildrenCount(ICudaRuntimeObject parent, DataRequestMonitor<Tuple<Integer, Integer, ?>> drm) {
        drm.done(null);
    }

    @Override
    public boolean isCdpStackVisible() {
        return false;
    }

    private DataRequestMonitor<IDMContext[]> unfilteredMode(ICudaApplication root, final ICudaRuntimeObject object, DataRequestMonitor<IDMContext[]> rm) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        boolean isCdpTreeMode = "device_kernels_child".equals(preferenceStore.getString("device.kernels.mode"));
        if (root != null) {
            if (isCdpTreeMode) {
                return new FilteringRequestMonitor(ImmediateExecutor.getInstance(), rm){

                    @Override
                    protected boolean matches(KernelCallSite data) {
                        return data == null;
                    }
                };
            }
            return rm;
        }
        if (object instanceof Kernel && isCdpTreeMode) {
            return new FilteringRequestMonitor(ImmediateExecutor.getInstance(), rm){

                @Override
                protected boolean matches(KernelCallSite data) {
                    return data != null && data.getParent().equals(object);
                }
            };
        }
        return null;
    }

    @Override
    public Kernel getAncestor(Kernel element, VMDelta delta) {
        Object e = delta.getElement();
        if (e instanceof IDMVMContext) {
            IDMContext context = ((IDMVMContext)e).getDMContext();
            if (context instanceof ICudaRuntimeObject && KernelHierarchy.isDebugHierarchyRoot((ICudaRuntimeObject)context) != null) {
                return this.getTopmostFrame(element, null);
            }
            if (context instanceof Kernel) {
                return this.getTopmostFrame(element, (Kernel)context);
            }
            return null;
        }
        return this.getTopmostFrame(element, null);
    }

    private Kernel getTopmostFrame(Kernel element, Kernel context) {
        KernelCallSite callSite = element.getCallSite();
        if (callSite != null) {
            if (context != null && callSite.getParent().equals(context)) {
                return element;
            }
            return this.getTopmostFrame(callSite.getParent(), context);
        }
        return context == null ? element : null;
    }

    @Override
    public boolean isParent(Kernel kernel, VMDelta delta) {
        Object element = delta.getElement();
        if (kernel.getCallSite() == null) {
            return !(element instanceof IDMVMContext) || !(((IDMVMContext)element).getDMContext() instanceof ICudaRuntimeObject);
        }
        if (element instanceof IDMVMContext) {
            IDMContext deltaContext = ((IDMVMContext)element).getDMContext();
            if (deltaContext instanceof Kernel) {
                return kernel.getCallSite().getParent().equals(deltaContext);
            }
            return false;
        }
        return true;
    }

    private static abstract class FilteringRequestMonitor
    extends DataRequestMonitor<IDMContext[]> {
        private final DataRequestMonitor<IDMContext[]> rm;

        private FilteringRequestMonitor(Executor executor, DataRequestMonitor<IDMContext[]> rm) {
            super(executor, rm);
            this.rm = rm;
        }

        @ConfinedToDsfExecutor(value="fExecutor")
        protected void handleSuccess() {
            IDMContext[] data = (IDMContext[])this.getData();
            ConcurrentLinkedQueue<IDMContext> filtered = new ConcurrentLinkedQueue<IDMContext>();
            IDMContext[] iDMContextArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                IDMContext kernel = iDMContextArray[n2];
                if (kernel instanceof Kernel && this.matches(((Kernel)kernel).getCallSite())) {
                    filtered.add(kernel);
                }
                ++n2;
            }
            this.rm.done((Object)filtered.toArray(new IDMContext[filtered.size()]));
        }

        protected abstract boolean matches(KernelCallSite var1);
    }
}

