/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.common.util.Tuple;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.service.ICudaProcesses;
import com.nvidia.cuda.ide.debug.service.IDebuggerUIState;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LayoutChangeEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelHierarchy;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class FilteredKernelsNode
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementPropertiesProvider {
    private static final String PROPERTY_FILTERED_OUT = "filtered.out.kernels.count";
    private final KernelHierarchy kernelHierarchy = new KernelHierarchy(this.getServicesTracker(), false);
    private PropertiesBasedLabelProvider labelProvider;

    public FilteredKernelsNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, FilteredKernelsDMContext.class);
    }

    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof LayoutChangeEvent) {
            parent.setFlags(parent.getFlags() | 0x400);
        }
        requestMonitor.done();
    }

    protected void fillChildrenUpdate(int shown, int allKernels, ICudaRuntimeObject parent, IChildrenUpdate update) {
        if (shown >= 0 && allKernels >= 0 && shown < allKernels) {
            this.fillUpdateWithVMCs(update, new IDMContext[]{new FilteredKernelsDMContext(this.getSession(), parent, shown, allKernels)});
        }
    }

    public int getDeltaFlags(Object event) {
        if (event instanceof FullStackRefreshEvent) {
            return 1024;
        }
        if (this.isExpandEvent(event)) {
            IDebuggerUIState service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class);
            ICudaProcesses processes = (ICudaProcesses)this.getServicesTracker().getService(ICudaProcesses.class);
            if (service != null && processes != null) {
                service.enableFiltering(processes.getApplication(), false);
            }
            return 0;
        }
        if (event instanceof LayoutChangeEvent) {
            return 1024;
        }
        return 0;
    }

    private boolean isExpandEvent(Object event) {
        IStructuredSelection strSelection;
        ISelection selection;
        return event instanceof DoubleClickEvent && !(selection = ((DoubleClickEvent)event).getSelection()).isEmpty() && selection instanceof IStructuredSelection && (strSelection = (IStructuredSelection)selection).size() == 1 && strSelection.getFirstElement() instanceof IVMContext && ((IVMContext)strSelection.getFirstElement()).getVMNode() == this;
    }

    private synchronized IElementLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new PropertiesBasedLabelProvider();
            this.labelProvider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new LabelText("{0} filtered out kernels", new String[]{PROPERTY_FILTERED_OUT}), new LabelImage(CudaDebugImages.KERNEL_INACTIVE.getDescriptor())}));
        }
        return this.labelProvider;
    }

    public void update(ILabelUpdate[] updates) {
        this.getLabelProvider().update(updates);
    }

    public void update(IPropertiesUpdate[] updates) {
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            FilteredKernelsDMContext context = DebugUtil.getObject(update, FilteredKernelsDMContext.class, this.getServicesTracker());
            if (context != null) {
                update.setProperty(PROPERTY_FILTERED_OUT, (Object)String.valueOf(context.allKernels - context.shown));
            }
            update.done();
            ++n2;
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        final ICudaRuntimeObject parent = DebugUtil.getObject(update, ICudaRuntimeObject.class, this.getServicesTracker());
        this.kernelHierarchy.getFilteredOutChildrenCount(parent, (DataRequestMonitor<Tuple<Integer, Integer, ?>>)new ViewerDataRequestMonitor<Tuple<Integer, Integer, ?>>(this.getExecutor(), (IViewerUpdate)update){

            protected void handleSuccess() {
                Tuple counts = (Tuple)this.getData();
                if (counts != null) {
                    FilteredKernelsNode.this.fillChildrenUpdate((Integer)counts.getObject1(), (Integer)counts.getObject2(), parent, update);
                }
                update.done();
            }
        });
    }

    private static final class FilteredKernelsDMContext
    extends AbstractDMContext {
        public final int allKernels;
        public final int shown;

        public FilteredKernelsDMContext(DsfSession session, IDMContext parent, int shown, int allKernels) {
            super(session, new IDMContext[]{parent});
            this.shown = shown;
            this.allKernels = allKernels;
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj);
        }

        public int hashCode() {
            return this.baseHashCode() * 31;
        }
    }
}

