/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.filters;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;

public final class CountChildren
implements ICudaVisitor {
    private final IElementQuery query;
    private final DataRequestMonitor<Integer> rm;
    private final boolean logicalMode;

    public CountChildren(IElementQuery query, DataRequestMonitor<Integer> vrm, boolean logicalMode) {
        this.query = query;
        this.rm = vrm;
        this.logicalMode = logicalMode;
    }

    @Override
    public void visitApplication(ICudaApplication application) {
        if (this.logicalMode) {
            application.getKernels((DataRequestMonitor<? super Kernel[]>)new DataRequestMonitor<Kernel[]>(application.getExecutor(), this.rm){

                protected void handleSuccess() {
                    CountChildren.this.countKernels((Kernel[])this.getData());
                }
            });
        } else {
            application.getDevices(new DataRequestMonitor<Device[]>(application.getExecutor(), this.rm){

                protected void handleSuccess() {
                    CountChildren.this.countDevices((Device[])this.getData());
                }
            });
        }
    }

    protected void countDevices(Device[] devices) {
        int i = 0;
        Device[] deviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            Device device = deviceArray[n2];
            if (this.query.match(device)) {
                ++i;
            }
            ++n2;
        }
        this.setResult(i);
    }

    protected void countKernels(Kernel[] kernels) {
        int i = 0;
        Kernel[] kernelArray = kernels;
        int n = kernels.length;
        int n2 = 0;
        while (n2 < n) {
            Kernel kernel = kernelArray[n2];
            if (this.query.match(kernel)) {
                ++i;
            }
            ++n2;
        }
        this.setResult(i);
    }

    private void setResult(Integer i) {
        if (i != null) {
            this.rm.setData((Object)i);
        }
        this.rm.done();
    }

    @Override
    public void visitBlock(Block block) {
        CudaCoord[] threads = this.query.filterThreads(block);
        if (threads == null) {
            this.setResult(null);
        } else {
            this.setResult(threads.length);
        }
    }

    @Override
    public void visitDevice(Device device) {
        byte[] sms = this.query.filterSMs(device);
        if (sms == null) {
            this.setResult(null);
        } else {
            this.setResult(sms.length);
        }
    }

    @Override
    public void visitKernel(Kernel kernel) {
        CudaCoord[] blocks = this.query.filterBlocks(kernel);
        if (blocks == null) {
            this.setResult(null);
        } else {
            this.setResult(blocks.length);
        }
    }

    @Override
    public void visitLane(Lane lane) {
        this.setResult(0);
    }

    @Override
    public void visitSM(StreamingMultiprocessor sm) {
        byte[] warps = this.query.filterWarps(sm);
        if (warps == null) {
            this.setResult(null);
        } else {
            this.setResult(warps.length);
        }
    }

    @Override
    public void visitThread(DeviceThread deviceThread) {
        this.setResult(0);
    }

    @Override
    public void visitWarp(Warp warp) {
        byte[] lanes = this.query.filterLanes(warp);
        this.setResult(lanes != null ? Integer.valueOf(lanes.length) : null);
    }
}

