/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.project;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.common.util.OS;
import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.core.Cpu;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;

public final class BuildUtils {
    private static final String CCBIN_FLAG = "-ccbin";
    private static final String CCBIN_FLAG_REGEX = ".*(?=\\W|^)" + CCBIN_FLAG + "(?=\\W|$).*";

    public static String addCcbinSwitch(String flags, Cpu cpu) {
        String compilerBinary = cpu.getCompilerBinaryName();
        if (compilerBinary == null || flags.matches(CCBIN_FLAG_REGEX)) {
            return flags;
        }
        return CoreUtil.concat((String[])new String[]{flags, CCBIN_FLAG, compilerBinary});
    }

    public static String[] addCcbinSwitch(String[] flags, Cpu cpu) {
        String compilerBinary = cpu.getCompilerBinaryName();
        if (compilerBinary == null || BuildUtils.hasCompilerNameFlag(flags)) {
            return flags;
        }
        return (String[])CoreUtil.append((Object[])flags, (Object[])new String[]{CCBIN_FLAG, compilerBinary});
    }

    public static boolean getBooleanCompilerOptionValue(IResourceInfo info, String option) {
        ITool[] tools;
        ITool[] iToolArray = tools = info.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (BuildUtils.isATool(tool, "nvcc.compiler")) {
                IOption opt = tool.getOptionBySuperClassId(option);
                try {
                    return opt.getBooleanValue();
                }
                catch (BuildException e) {
                    Activator.log((Exception)((Object)e));
                }
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }

    public static IOption getCompilerOption(IResourceInfo info, String optionName) {
        ITool[] tools = info.getTools();
        if (tools != null) {
            ITool[] iToolArray = tools;
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                if (BuildUtils.isATool(tool, "nvcc.compiler")) {
                    return tool.getOptionBySuperClassId(optionName);
                }
                ++n2;
            }
        }
        return null;
    }

    public static Cpu getCpu(ITool tool) {
        IProject project = tool.getParentResourceInfo().getParent().getOwner().getProject();
        SyncConfig active = SyncConfigManager.getActive((IProject)project);
        if (active == null || SyncConfigManager.isLocal((SyncConfig)active)) {
            return Cpu.getLocalTargetCpu(project);
        }
        return Cpu.getRemoteTargetCpu(active);
    }

    public static String getNvccPath(ITool tool) {
        final IBuildObject parent = tool.getParent();
        if (parent instanceof IToolChain) {
            IConfiguration configuration = ((IToolChain)parent).getParent();
            IProject project = configuration.getOwner().getProject();
            final SyncConfig config = SyncConfigManager.getActive((IProject)project);
            try {
                return (String)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, String>(){

                    public String runWithService(IToolkitManager service) throws CoreException {
                        ICudaToolkit toolkit = config == null || SyncConfigManager.isLocal((SyncConfig)config) ? service.getToolkitByName(parent.getName()) : service.getToolkit(config.getConnectionName());
                        if (toolkit != null) {
                            return toolkit.getToolPath(ICudaToolkit.Tool.Nvcc);
                        }
                        return ICudaToolkit.Tool.Nvcc.executable(OS.Linux);
                    }
                });
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
        return ICudaToolkit.Tool.Nvcc.executable(OS.Linux);
    }

    public static String[] getSMVersionFlags(ICudaModule module, boolean linker) {
        boolean dlink = module.isDeviceLinkingEnabled();
        int virtualArchitectures = module.getVirtualArchitectures();
        int physicalArchitectures = module.getPhysicalArchitectures();
        if (dlink && virtualArchitectures == 0 && physicalArchitectures == 0) {
            virtualArchitectures = Architecture.get(2, 0).getBit();
        }
        if (linker && dlink && physicalArchitectures == 0) {
            physicalArchitectures = CoreUtil.getLowestSetBit((int)virtualArchitectures);
        }
        return (String[])CoreUtil.join((Object[])new String[0], (Object[])new Object[]{BuildUtils.getRDCFlag(dlink), Architecture.convertToCommandLineOptions(false, virtualArchitectures), Architecture.convertToCommandLineOptions(true, physicalArchitectures)});
    }

    public static String getRDCFlag(boolean deviceLinkerEnabled) {
        return "--relocatable-device-code=" + deviceLinkerEnabled;
    }

    private static boolean hasCompilerNameFlag(String[] flags) {
        String[] stringArray = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            String flag = stringArray[n2];
            if (flag.matches(CCBIN_FLAG_REGEX)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isATool(ITool tool, String id) {
        if (tool == null) {
            return false;
        }
        if (id.equals(tool.getId())) {
            return true;
        }
        return BuildUtils.isATool(tool.getSuperClass(), id);
    }

    public static boolean isCudaToolkit(ICResourceDescription resDesc) {
        return BuildUtils.isToolkitProject(resDesc.getConfiguration().getProjectDescription().getProject());
    }

    public static boolean isCudaToolkit(IToolChain toolChain) {
        return toolChain != null && ("com.nvidia.cuda.ide.toolchain.base".equals(toolChain.getId()) || BuildUtils.isCudaToolkit(toolChain.getSuperClass()));
    }

    public static IConfiguration[] getProjectConfigurations(IProject project) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject managedProject = info != null ? info.getManagedProject() : null;
        return managedProject != null ? managedProject.getConfigurations() : new IConfiguration[]{};
    }

    public static String getProjectToolchainName(IProject project) {
        IConfiguration[] iConfigurationArray = BuildUtils.getProjectConfigurations(project);
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration conf = iConfigurationArray[n2];
            IToolChain tc = conf.getToolChain();
            if (tc != null) {
                return tc.getName();
            }
            ++n2;
        }
        return null;
    }

    public static boolean isToolkitProject(IProject project) {
        IConfiguration[] configurations;
        IConfiguration[] iConfigurationArray = configurations = BuildUtils.getProjectConfigurations(project);
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration configuration = iConfigurationArray[n2];
            if (configuration.isManagedBuildOn() && BuildUtils.isCudaToolkit(configuration.getToolChain())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void setCompilerOptionValue(IFileInfo info, IConfiguration c, String option, boolean value) {
        ITool[] tools;
        ITool[] iToolArray = tools = info.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (BuildUtils.isATool(tool, "nvcc.compiler")) {
                IOption opt = tool.getOptionBySuperClassId(option);
                ManagedBuildManager.setOption((IResourceInfo)info, (IHoldsOptions)tool, (IOption)opt, (boolean)value);
                return;
            }
            ++n2;
        }
    }

    public static void setCompilerOptionValue(IResourceInfo info, IConfiguration c, String option, String[] value) {
        ITool[] tools;
        ITool[] iToolArray = tools = info.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            if (BuildUtils.isATool(tool, "nvcc.compiler")) {
                IOption opt = tool.getOptionBySuperClassId(option);
                ManagedBuildManager.setOption((IResourceInfo)info, (IHoldsOptions)tool, (IOption)opt, (String[])value);
                return;
            }
            ++n2;
        }
    }

    private BuildUtils() {
    }
}

