/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.internal.toolkit;

import com.nvidia.common.internal.Activator;
import com.nvidia.common.internal.toolkit.CudaToolkit;
import com.nvidia.common.internal.toolkit.IToolkitLookup;
import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.OS;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public final class BundledToolkit
implements IToolkitLookup {
    private IPath getBundledToolkit() {
        String protocol;
        Location location = Platform.getInstallLocation();
        URL url = location != null ? location.getURL() : null;
        String string = protocol = url != null ? url.getProtocol() : null;
        if (url != null && (protocol == null || "file".equals(protocol))) {
            try {
                String nvccFname = ICudaToolkit.Tool.Nvcc.executable(OS.local());
                File file = new File(url.getPath()).getParentFile();
                File binDir = new File(file, "bin");
                File nvcc = new File(binDir.isDirectory() ? binDir : file, nvccFname);
                if (nvcc.isFile()) {
                    File absoluteParent = nvcc.getParentFile().getAbsoluteFile();
                    return new Path(absoluteParent.getCanonicalPath());
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        return null;
    }

    @Override
    public ICudaToolkit[] discover() {
        IPath toolkit = this.getBundledToolkit();
        if (toolkit != null) {
            return new ICudaToolkit[]{new CudaToolkit("bundled.toolkit", toolkit, "CUDA Toolkit Bundled")};
        }
        return null;
    }
}

