/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import org.eclipse.cdt.dsf.gdb.internal.CoreInfo;
import org.eclipse.cdt.internal.core.ICoreInfo;

public class CoreList {
    private ICoreInfo[] fCoreList;
    private String fCoreFileName;

    public CoreList() {
        this.fCoreFileName = "/proc/cpuinfo";
    }

    public CoreList(String fileName) {
        this.fCoreFileName = fileName;
    }

    public ICoreInfo[] getCoreList() {
        Vector<CoreInfo> coreInfo;
        block20: {
            if (this.fCoreList != null) {
                return this.fCoreList;
            }
            File cpuInfo = new File(this.fCoreFileName);
            coreInfo = new Vector<CoreInfo>();
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    String processorId = null;
                    String physicalId = null;
                    InputStreamReader r = new InputStreamReader(new FileInputStream(cpuInfo));
                    reader = new BufferedReader(r);
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).startsWith("processor")) {
                            if (processorId != null) {
                                physicalId = "0";
                                coreInfo.add(new CoreInfo(processorId, physicalId));
                                processorId = null;
                            }
                            processorId = line.split(":")[1].trim();
                            continue;
                        }
                        if (!line.startsWith("physical id")) continue;
                        assert (physicalId == null);
                        physicalId = line.split(":")[1].trim();
                        coreInfo.add(new CoreInfo(processorId, physicalId));
                        processorId = null;
                        physicalId = null;
                    }
                    if (processorId != null) {
                        coreInfo.add(new CoreInfo(processorId, "0"));
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    reader = null;
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                reader = null;
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            reader = null;
        }
        this.fCoreList = coreInfo.toArray(new ICoreInfo[coreInfo.size()]);
        return this.fCoreList;
    }
}

