/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.git.ui;

import java.net.URI;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.ptp.internal.rdt.sync.git.ui.messages.Messages;
import org.eclipse.ptp.rdt.sync.ui.AbstractSynchronizeParticipant;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeParticipantDescriptor;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.remote.ui.IRemoteUIFileManager;
import org.eclipse.remote.ui.IRemoteUIServices;
import org.eclipse.remote.ui.RemoteUIServices;
import org.eclipse.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GitParticipant
extends AbstractSynchronizeParticipant {
    private static final String FILE_SCHEME = "file";
    private IRemoteConnection fSelectedConnection;
    private String fProjectName = "";
    private Button fBrowseButton;
    private Text fLocationText;
    private RemoteConnectionWidget fRemoteConnectionWidget;
    private IWizardContainer container;
    private final boolean showProviderCombo = false;

    public GitParticipant(ISynchronizeParticipantDescriptor descriptor) {
        super(descriptor);
    }

    private void checkConnection() {
        IRemoteUIConnectionManager mgr = this.getUIConnectionManager();
        if (mgr != null) {
            mgr.openConnectionWithProgress(this.fRemoteConnectionWidget.getShell(), null, this.fSelectedConnection);
        }
    }

    public void createConfigurationArea(Composite parent, IRunnableContext context) {
        this.container = (IWizardContainer)context;
        Composite configArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        configArea.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        configArea.setLayoutData((Object)gd);
        int flags = 0;
        this.fRemoteConnectionWidget = new RemoteConnectionWidget(configArea, 0, null, flags |= RemoteConnectionWidget.FLAG_NO_LOCAL_SELECTION, context);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.fRemoteConnectionWidget.setLayoutData((Object)gd);
        this.fRemoteConnectionWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitParticipant.this.handleConnectionSelected();
            }
        });
        Label locationLabel = new Label(configArea, 16384);
        locationLabel.setText(Messages.GitParticipant_location);
        this.fLocationText = new Text(configArea, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 250;
        this.fLocationText.setLayoutData((Object)gd);
        this.fLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GitParticipant.this.update();
            }
        });
        this.handleConnectionSelected();
        this.fBrowseButton = new Button(configArea, 8);
        this.fBrowseButton.setText(Messages.GitParticipant_browse);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GitParticipant.this.fSelectedConnection != null) {
                    IRemoteUIFileManager fileMgr;
                    IRemoteUIServices remoteUIServices;
                    GitParticipant.this.checkConnection();
                    if (GitParticipant.this.fSelectedConnection.isOpen() && (remoteUIServices = RemoteUIServices.getRemoteUIServices((IRemoteServices)GitParticipant.this.fSelectedConnection.getRemoteServices())) != null && (fileMgr = remoteUIServices.getUIFileManager()) != null) {
                        fileMgr.setConnection(GitParticipant.this.fSelectedConnection);
                        String correctPath = GitParticipant.this.fLocationText.getText();
                        String selectedPath = fileMgr.browseDirectory(GitParticipant.this.fLocationText.getShell(), "Project Location (" + GitParticipant.this.fSelectedConnection.getName() + ")", correctPath, 0);
                        if (selectedPath != null) {
                            GitParticipant.this.fLocationText.setText(selectedPath);
                        }
                    }
                }
            }
        });
    }

    private String getDefaultPathDisplayString() {
        if (this.fSelectedConnection != null && this.fSelectedConnection.isOpen()) {
            IRemoteFileManager fileMgr = this.fSelectedConnection.getFileManager();
            URI defaultURI = fileMgr.toURI(this.fSelectedConnection.getWorkingDirectory());
            if (defaultURI != null && defaultURI.getScheme().equals(FILE_SCHEME)) {
                return Platform.getLocation().append(this.fProjectName).toString();
            }
            if (defaultURI == null) {
                return "";
            }
            return new Path(defaultURI.getPath()).append(this.fProjectName).toString();
        }
        return "";
    }

    public String getErrorMessage() {
        if (this.fSelectedConnection == null) {
            return Messages.GitParticipant_1;
        }
        if (this.fLocationText.getText().length() == 0) {
            return Messages.GitParticipant_2;
        }
        IRemoteFileManager fileManager = this.fSelectedConnection.getFileManager();
        if (fileManager.toURI(this.fLocationText.getText()) == null) {
            return Messages.GitParticipant_3;
        }
        return null;
    }

    public IRemoteConnection getConnection() {
        return this.fSelectedConnection;
    }

    public String getLocation() {
        return this.fLocationText.getText();
    }

    public String getSyncConfigName() {
        return this.fSelectedConnection.getName();
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        if (this.fSelectedConnection != null) {
            IRemoteUIConnectionManager connectionManager = RemoteUIServices.getRemoteUIServices((IRemoteServices)this.fSelectedConnection.getRemoteServices()).getUIConnectionManager();
            return connectionManager;
        }
        return null;
    }

    private void handleConnectionSelected() {
        this.fSelectedConnection = this.fRemoteConnectionWidget.getConnection();
        this.fLocationText.setText(this.getDefaultPathDisplayString());
        this.update();
    }

    public boolean isConfigComplete() {
        return this.getErrorMessage() == null;
    }

    public void setProjectName(String projectName) {
        this.fProjectName = projectName;
        this.fLocationText.setText(this.getDefaultPathDisplayString());
    }

    private void update() {
        this.container.updateMessage();
        if (this.container.getCurrentPage() == null) {
            return;
        }
        this.container.updateButtons();
    }
}

