########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Friday 13 April 2007 13:42:19 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/matplotlib/PSD_net.py,v 1.3 2007/08/29 20:37:16 vareille Exp $
#
# $Id: PSD_net.py,v 1.3 2007/08/29 20:37:16 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Vision.matplotlibNodes import matplotliblib
masterNet.getEditor().addLibraryInstance(matplotliblib,"Vision.matplotlibNodes", "matplotliblib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_127 = ReadTable(constrkw = {}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_127,76,22)
    ReadTable_127.inputPortByName['filename'].widget.set("Data/psd_plot_data.dat", run=False)
    ReadTable_127.inputPortByName['sep'].widget.set(",", run=False)
    ReadTable_127.inputPortByName['datatype'].widget.set("float", run=False)
    apply(ReadTable_127.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_127=None

try:
    ## saving node PSD ##
    from Vision.matplotlibNodes import PSDNE
    PSD_128 = PSDNE(constrkw = {}, name='PSD', library=matplotliblib)
    masterNet.addNode(PSD_128,117,329)
    PSD_128.inputPortByName['NFFT'].widget.set("512", run=False)
    PSD_128.inputPortByName['nOverlap'].widget.set("0", run=False)
except:
    print "WARNING: failed to restore PSDNE named PSD in network masterNet"
    print_exc()
    PSD_128=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_129 = Index(constrkw = {}, name='Index', library=stdlib)
    masterNet.addNode(Index_129,93,181)
    apply(Index_129.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_129=None

masterNet.freeze()

## saving connections for network PSD ##
if ReadTable_127 is not None and Index_129 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_127, Index_129, "data", "data", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_127 and Index_129 in network masterNet"
if Index_129 is not None and PSD_128 is not None:
    try:
        masterNet.connectNodes(
            Index_129, PSD_128, "data", "arraylistx", blocking=True)
    except:
        print "WARNING: failed to restore connection between Index_129 and PSD_128 in network masterNet"
masterNet.unfreeze()
#masterNet.run()

