/* martian.h: 
 *	modem program/module common data structure
 *	shared bamil_d7, BaseAddressIndex, BaseAddress

 *	program to module connection ioctl
 */

#ifndef __MARTIAN_DRIVERHELPER_COMMON
#define __MARTIAN_DRIVERHELPER_COMMON

#ifndef __KERNEL__
#define LOCK	"lock; "
typedef struct { volatile int counter; } atomic_t;
#else
#include <asm/atomic.h>
#endif

struct mcirc {
	int head;
	int tail;
};

/* martian program/module shared structure, 
 * mapped into user space via mmap call on device file
 */
#define MARTIAN_SIGNATURE	"Martian" 	// signature at the page start
#define MARTIAN_TSIGNATURE	"martiaN" 	/* terminating signature */
#define DECLARE_FIFO(type, fifo, size, bname)	\
	type fifo##_##bname[size];		\
	__u32 fifo##_wptr, fifo##_rptr;		\
	__u32 fifo##_buff_um;

struct martian_common {
	char signature[sizeof MARTIAN_SIGNATURE];

	/*** core relocated symbols ***/
	__u16	BaseAddressIndex;
	__u16	BaseAddressData;	/* TODO: to be removed */
	__u8 	BaseValue;
	__u8	dp_bamil_rd7;
	__u8	dp_byte_f;
	__u8	x_dsp_mars;	/* TODO: to be removed */
	__u8	x_dsp_mars3;	/* TODO: to be removed */
	__u8	dp_version;	/* TODO: to be removed */

	__u16	BaseAddress;	/* TODO: to be removed */
	__u16	BaseAddress2;	/* TODO: to be removed */
	

	__u8	x_chip_version;
	DECLARE_FIFO (__u16, io_dce_tx, 0x400, buff);
	DECLARE_FIFO (__u16, io_dce_rx, 0x800, buff);
	DECLARE_FIFO (__u8,  io_pdm_rx, 0x4b0, buff);

	__u16	V34Mode;
	__u8	S[0x12c];
	__u8	dp_dsp_data_in_progress;
	__u16	init_RBS_tick_flag;
	__u8	RBS_tick_rx;
	__u8	dp_ring_int_count;
	__u8	dp_sleep;	/* TODO: to be removed */

	__u8 	rd7_isr;
	__u8	byte_c;
	__u8	byte_d;
	__u8	byte_e;
	//__u8	byte_f;

	struct mcirc dcp_circ;
	__u8	dcp_buf[0x40];

	__u32	OverlappedIrqs; 	/* those came in the middle previous 
					 * were served in UM 
					 */
	__u32	RepeatedIrqs; 	        /* those came before previous 
					 * were served in UM 
					 */
	atomic_t UnservedIrqs;
	atomic_t UnpassedIrqs;

	int rx_overrun, pdm_rx_overrun;
	int rx_incorrespondence, tx_incorrespondence;
	int pdm_rx_incorrespondence;

	int rx, tx, pdm_rx;
	int dual_port_rx, dual_port_tx, io_dual_port_rx;

	int dirty, pdm_dirty;
	__u32 latest_rptr, latest_wptr;

	char write_check;
	char kstamp[9];
	char tsignature[sizeof MARTIAN_TSIGNATURE];
};

struct martian_conf {
	__u16 BaseAddress;
	__u16 CommAddress;

	__u8 irq;

	unsigned short vendor, device;
	unsigned subsys_vendor;
	unsigned subsys_device;
	unsigned flags;

	int index; 	// device index; to find slot in ; can be derived
};




#define IR			0xd7
#define IR_SIGNIFICANT		0x0e

#define MARTIAN_DEV_TOSHIBA	0x00000001

struct irqcount {
	int b, f, n, i, o;
};

struct martian_irq_state {
	char string[11];
	struct irqcount counts;
	int count;
};

struct _mstore {
	unsigned short addr;
	unsigned short val;
};

struct _andor_params {
	__u8 reg;
	__u8 mask_and;
	__u8 mask_or;
};

struct _command_params {
	__u8 cmd;
	__u8 a1;
	__u8 a2;
};

struct _longcmd_params {
	__u8 cmd;
	__u8 a1;
	__u8 a2;
	__u8 a3;
	__u8 a4;
};

struct _mdsp {
	__u16 *data;
	__u16 num;
	/* environment */
	__u8 DCPAudioOn;
	__u8 *pdp_byte_f;
};

enum _rw_type {
	Byte  = 0,
	Word  = 1,
	Dword = 2
};

struct _read_params {
	__u16 	      addr;
	enum _rw_type type;
};

struct _write_params {
	__u16 	      addr;
	__u32	      val;
	enum _rw_type type;
};

#define MARTIAN_CONF_GET 	_IOR ('S', 0, struct martian_conf)
#define MARTIAN_IRQ_STATE 	_IOR ('S', 1, struct martian_irq_state)
#define MARTIAN_IOCTL_CMD_READ_DSP 	_IOW ('S', 10, unsigned short )
#define MARTIAN_IOCTL_CMD_WRITE_DSP 	_IOW ('S', 11, struct _mstore )
#define MARTIAN_IOCTL_CMD_CLEAR_DSP 	_IO  ('S', 12)
#define MARTIAN_IOCTL_CMD_DLOAD_DSP 	_IOW ('S', 13, struct _mdsp )
#define	MARTIAN_IOCTL_CMD_READREG	_IOW ('S', 14, unsigned char )
#define MARTIAN_IOCTL_CMD_WRITEREG 	_IOW ('S', 15, struct _mstore )
#define MARTIAN_IOCTL_CMD_REGANDOR 	_IOW ('S', 16, struct _andor_params )
#define MARTIAN_IOCTL_CMD_COMMAND 	_IOW ('S', 17, struct _command_params )
#define MARTIAN_IOCTL_CMD_LONGCMD 	_IOW ('S', 18, struct _longcmd_params )
#define	MARTIAN_IOCTL_CMD_READ		_IOW ('S', 19, struct _read_params )
#define	MARTIAN_IOCTL_CMD_WRITE		_IOW ('S', 20, struct _write_params )
#define MARTIAN_IOCTL_CMD_INIT		_IO  ('S', 30)
#define MARTIAN_IOCTL_CMD_DEINIT 	_IO  ('S', 31)
#define MARTIAN_IOCTL_CMD_DCPAUDIO 	_IO  ('S', 32)
#define MARTIAN_IOCTL_CMD_CSUM 		_IO  ('S', 33)
#define MARTIAN_IOCTL_CMD_OUTINIT	_IO  ('S', 34)
#define MARTIAN_DUMP_VARS 	_IO  ('S', 2)
#define MARTIAN_SERVE_IRQS 	_IO  ('S', 3)
#define MARTIAN_MODEM_READY 	_IO  ('S', 4)
#define MARTIAN_CHECK_SMP 	_IOW ('S', 5, int)
#define MARTIAN_TRUE_SMP 	_IO  ('S', 6)
#define MARTIAN_SCREWUP_DCE_RX 	_IO  ('S', 7)
#define MARTIAN_FIFO_FAULT 	_IO  ('S', 8)
#define MARTIAN_KDEBUG	 	_IO  ('S', 9)

/* next is 14 */

#undef DECLARE_FIFO	/* static */

#endif /* __MARTIAN_DRIVERHELPER_COMMON */

