###############################################################################
#
# Find clang binary.
#
# Author: Maxime Arthaud
#
# Contact: ikos@lists.nasa.gov
#
# Notices:
#
# Copyright (c) 2018-2019 United States Government as represented by the
# Administrator of the National Aeronautics and Space Administration.
# All Rights Reserved.
#
# Disclaimers:
#
# No Warranty: THE SUBJECT SOFTWARE IS PROVIDED "AS IS" WITHOUT ANY WARRANTY OF
# ANY KIND, EITHER EXPRESSED, IMPLIED, OR STATUTORY, INCLUDING, BUT NOT LIMITED
# TO, ANY WARRANTY THAT THE SUBJECT SOFTWARE WILL CONFORM TO SPECIFICATIONS,
# ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
# OR FREEDOM FROM INFRINGEMENT, ANY WARRANTY THAT THE SUBJECT SOFTWARE WILL BE
# ERROR FREE, OR ANY WARRANTY THAT DOCUMENTATION, IF PROVIDED, WILL CONFORM TO
# THE SUBJECT SOFTWARE. THIS AGREEMENT DOES NOT, IN ANY MANNER, CONSTITUTE AN
# ENDORSEMENT BY GOVERNMENT AGENCY OR ANY PRIOR RECIPIENT OF ANY RESULTS,
# RESULTING DESIGNS, HARDWARE, SOFTWARE PRODUCTS OR ANY OTHER APPLICATIONS
# RESULTING FROM USE OF THE SUBJECT SOFTWARE.  FURTHER, GOVERNMENT AGENCY
# DISCLAIMS ALL WARRANTIES AND LIABILITIES REGARDING THIRD-PARTY SOFTWARE,
# IF PRESENT IN THE ORIGINAL SOFTWARE, AND DISTRIBUTES IT "AS IS."
#
# Waiver and Indemnity:  RECIPIENT AGREES TO WAIVE ANY AND ALL CLAIMS AGAINST
# THE UNITED STATES GOVERNMENT, ITS CONTRACTORS AND SUBCONTRACTORS, AS WELL
# AS ANY PRIOR RECIPIENT.  IF RECIPIENT'S USE OF THE SUBJECT SOFTWARE RESULTS
# IN ANY LIABILITIES, DEMANDS, DAMAGES, EXPENSES OR LOSSES ARISING FROM SUCH
# USE, INCLUDING ANY DAMAGES FROM PRODUCTS BASED ON, OR RESULTING FROM,
# RECIPIENT'S USE OF THE SUBJECT SOFTWARE, RECIPIENT SHALL INDEMNIFY AND HOLD
# HARMLESS THE UNITED STATES GOVERNMENT, ITS CONTRACTORS AND SUBCONTRACTORS,
# AS WELL AS ANY PRIOR RECIPIENT, TO THE EXTENT PERMITTED BY LAW.
# RECIPIENT'S SOLE REMEDY FOR ANY SUCH MATTER SHALL BE THE IMMEDIATE,
# UNILATERAL TERMINATION OF THIS AGREEMENT.
#
###############################################################################

if (NOT CLANG_FOUND)
  find_program(CLANG_EXECUTABLE CACHE NAMES clang
    HINTS ${LLVM_TOOLS_BINARY_DIR}
    DOC "Path to clang binary")

  if (CLANG_EXECUTABLE)
    get_filename_component(CLANG_BINARY_DIR "${CLANG_EXECUTABLE}" DIRECTORY)
    find_program(CLANGXX_EXECUTABLE CACHE NAMES clang++
      HINTS ${CLANG_BINARY_DIR} ${LLVM_TOOLS_BINARY_DIR}
      DOC "Path to clang++ binary")
  endif()

  if (CLANG_EXECUTABLE)
    # Detect the version using `clang --version`
    execute_process(
      COMMAND ${CLANG_EXECUTABLE} --version
      RESULT_VARIABLE HAD_ERROR
      OUTPUT_VARIABLE CLANG_VERSION_OUTPUT
      OUTPUT_STRIP_TRAILING_WHITESPACE
    )
    if (HAD_ERROR)
      message(FATAL_ERROR "clang failed with status: ${HAD_ERROR}")
    endif()
    if (NOT (CLANG_VERSION_OUTPUT MATCHES "clang version ([0-9]+(\\.[0-9]+)*)"))
      message(FATAL_ERROR "unexpected output for `clang --version`: ${CLANG_VERSION_OUTPUT}")
    endif()
    set(CLANG_VERSION "${CMAKE_MATCH_1}")
  endif()

  include(FindPackageHandleStandardArgs)
  find_package_handle_standard_args(Clang
    REQUIRED_VARS
      CLANG_EXECUTABLE
      CLANGXX_EXECUTABLE
      CLANG_VERSION
    VERSION_VAR
      CLANG_VERSION
    FAIL_MESSAGE
      "Could NOT find Clang. Please provide -DCLANG_EXECUTABLE=/path/to/clang")
endif()
