/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import org.broadinstitute.gatk.utils.commandline.Argument;
import org.broadinstitute.gatk.utils.commandline.CommandLineProgram;

public class JavaIOSpeedTest
extends CommandLineProgram {
    @Argument(fullName="input", shortName="i", doc="file to read", required=true)
    public String filename;
    @Argument(fullName="buffer_size", shortName="s", doc="read buffer size in mb", required=false)
    public int bufferSize = -1;

    @Override
    protected int execute() {
        System.out.println("Filename: " + this.filename);
        try {
            int incr;
            File file = new File(this.filename);
            InputStreamReader reader = this.filename.endsWith(".gz") ? new InputStreamReader(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)))) : new FileReader(file);
            BufferedReader br = this.bufferSize != -1 ? new BufferedReader(reader, this.bufferSize * 1000000) : new BufferedReader(reader);
            System.out.println("Reading...");
            int next = incr = 10000000;
            int counter = 0;
            while (br.ready()) {
                br.readLine();
                if (++counter != next) continue;
                next += incr;
                System.err.println(new Date() + " - file: " + this.filename + ",  buffer size: " + this.bufferSize + "mb,  read " + counter + " lines...");
            }
            System.out.println("Read " + counter + " lines from " + this.filename);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
        return 0;
    }

    public static void main(String[] args) {
        try {
            CommandLineProgram.start(new JavaIOSpeedTest(), args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

