/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.classloader;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.classloader.ProtectedPackageSource;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class GATKLiteUtils {
    private static Set<String> fullVersionGATKWalkers = new HashSet<String>();
    private static final String DummyProtectedClassName = "org.broadinstitute.sting.gatk.DummyProtectedClass";
    private static Boolean isLiteVersion;

    private GATKLiteUtils() {
    }

    public static boolean isAvailableOnlyInFullGATK(String walkerName) {
        return fullVersionGATKWalkers.contains(walkerName);
    }

    public static boolean isGATKLite() {
        if (isLiteVersion == null) {
            try {
                Class.forName(DummyProtectedClassName);
                isLiteVersion = false;
            }
            catch (ClassNotFoundException e) {
                isLiteVersion = true;
            }
        }
        return isLiteVersion;
    }

    public static Class getProtectedClassIfAvailable(Class interfaceClass) {
        List classes = new PluginManager(interfaceClass).getPlugins();
        if (classes.isEmpty()) {
            throw new ReviewedStingException("No classes implementing the interface class " + interfaceClass.getSimpleName() + " were found");
        }
        Class result = null;
        for (Class c : classes) {
            if (!ProtectedPackageSource.class.isAssignableFrom(c)) continue;
            result = c;
            break;
        }
        if (result == null) {
            result = classes.get(0);
        }
        return result;
    }

    static {
        fullVersionGATKWalkers.add("HaplotypeCaller");
        fullVersionGATKWalkers.add("ReduceReads");
        isLiteVersion = null;
    }
}

