/* $Id: cigar.h 222835 2020-06-04 18:43:23Z twu $ */
#ifndef CIGAR_INCLUDED
#define CIGAR_INCLUDED

#include "bool.h"
#include "filestring.h"
#include "list.h"
#include "substring.h"
#include "stage3hr.h"
#include "genome.h"


extern void
Cigar_setup (Genome_T genome_in, bool cigar_extended_p_in, bool hide_soft_clips_p_in,
	     bool merge_samechr_p_in, bool md_lowercase_variant_p_in,
	     bool sam_hardclip_use_S_p_in, bool sam_insert_0M_p_in);
extern int
Cigar_length (List_T tokens);
extern void
Cigar_print_tokens (Filestring_T fp, List_T tokens);
extern int
Cigar_length_substrings (Stage3end_T stage3end, int querylength, int hardclip_low, int hardclip_high);

extern void
Cigar_compute_main (Filestring_T *cigar_fp, Filestring_T *md_fp,
		    int *nmismatches_refdiff, int *nmismatches_bothdiff,
		    int *sequence_hardclip_low, int *sequence_hardclip_high,
		    List_T *prevp, List_T *nextp, List_T *finalp,
		    int *nindels, bool *plusp, Chrnum_T *chrnum, Chrpos_T *chrpos,
		    Stage3end_T stage3end, int querylength, bool first_read_p, Stage3end_T mate,
		    int hardclip_low, int hardclip_high, bool hide_soft_clips_p);

extern void
Cigar_compute_supplemental (Filestring_T *cigar_fp, Filestring_T *md_fp,
			    int *nmismatches_refdiff, int *nmismatches_bothdiff,
			    int *sequence_hardclip_low, int *sequence_hardclip_high,
			    List_T *prevp, List_T *nextp, List_T *finalp,
			    int *nindels, bool *plusp, Chrnum_T *chrnum, Chrpos_T *chrpos,
			    Stage3end_T stage3end, int querylength, bool first_read_p, Stage3end_T mate,
			    int hardclip_low, int hardclip_high, bool hide_soft_clips_p);

#endif

