/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_PCL.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfgPushCmdLine(struct Cfg_Getopt *optstru)

 *	Push the command line supplied by DOS.
 *	If this works for the particular compiler is not sure, it may lead to
 *	have only the first argument.

ob(ject): cfgPushCmdLine
su(bsystem): cmdline
ty(pe): H
sy(nopsis): 
sh(ort description): Push the DOS command line
he(ader files): 
lo(ng description): Push the DOS command line onto input stack. Because the
	memory, where the command line is located, is overwritten by default,
	it is duplicated into the heap.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_pcl.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <portable.h>
#include "fmemory.h"
#include "msgs.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_PCL.C 1.5 1999/12/13 02:22:02 ska Exp ska $";
#endif

void cfgPushCmdLine(struct Cfg_Getopt * const optstru)
{	char *buf;		/* the command line is duplicated into the heap
					because the memory area, where it resides now,
					might be re-used

					The command line is situated in the PSP at offset 0x80.
					The complete buffer as a size of 0x80 bytes.
					Format:
					<1 byte>	length of command line
					<N bytes>	command line
					<1 byte>	'\n' or '\r'
					<1 byte>	'\0'
					*/
	int len;

	DBG_ENTER("cfgPushCmdLine", Suppl_cmdline)

	if((len = peekb(_psp, 0x80)) <= 0x80 - 1 - 1 - 1
	 && len
	 && _fstrlen(MK_FP(_psp, 0x81)) <= len + 3) {
	 /* OK, there is something there */
	 	/* duplicate the string into the heap */
	chkHeap
	 	buf = _fdupstr(MK_FP(_psp, 0x81));
	 	if(!buf)	Esuppl_noMem();
	 	cfgPushDynString(optstru, buf);
	}

	chkHeap
	DBG_EXIT
}
