/*******************************************************************
 * morpho_easy_hdr.h
 * [CP932/CRLF] {  p }
 *------------------------------------------------------------------
 * Copyright (C) 2010-2012 Morpho,Inc.
 *******************************************************************/

#ifndef MORPHO_EASY_HDR_H
#define MORPHO_EASY_HDR_H

/*******************************************************************/

#include "morpho_api.h"
#include "morpho_error.h"
#include "morpho_image_data.h"
#include "morpho_rect_int.h"

/*******************************************************************/

#define MORPHO_EASY_HDR_VER "Morpho EasyHDR Ver.2.0.1 2012/07/18"

/*-----------------------------------------------------------------*/

/* (input-limitaion) */

#define MORPHO_EASY_HDR_MIN_IMAGE_WIDTH    100
#define MORPHO_EASY_HDR_MAX_IMAGE_WIDTH   8192
#define MORPHO_EASY_HDR_MIN_IMAGE_HEIGHT   100
#define MORPHO_EASY_HDR_MAX_IMAGE_HEIGHT  8192
#define MORPHO_EASY_HDR_MIN_NIMAGES   2
#define MORPHO_EASY_HDR_MAX_NIMAGES  10

/*-----------------------------------------------------------------*/

/* (parameter) */

#define MORPHO_EASY_HDR_DISABLED 0
#define MORPHO_EASY_HDR_ENABLED  1

#define MORPHO_EASY_HDR_IMAGE_ALIGNMENT_DEFAULT  MORPHO_EASY_HDR_ENABLED

#define MORPHO_EASY_HDR_GHOST_REMOVAL_DEFAULT  MORPHO_EASY_HDR_ENABLED

#define MORPHO_EASY_HDR_AUTO_SCALING_DEFAULT  MORPHO_EASY_HDR_ENABLED

#define MORPHO_EASY_HDR_FACE_DETECTION_DEFAULT  MORPHO_EASY_HDR_ENABLED

#define MORPHO_EASY_HDR_FAIL_SOFT_MERGING_DEFAULT  MORPHO_EASY_HDR_ENABLED

#define MORPHO_EASY_HDR_GHOST_DETECTION_SENSITIVITY_LEVEL_MIN      0
#define MORPHO_EASY_HDR_GHOST_DETECTION_SENSITIVITY_LEVEL_MAX     10
#define MORPHO_EASY_HDR_GHOST_DETECTION_SENSITIVITY_LEVEL_DEFAULT  7

#define MORPHO_EASY_HDR_MERGE_SMOOTHNESS_LEVEL_MIN      0
#define MORPHO_EASY_HDR_MERGE_SMOOTHNESS_LEVEL_MAX     10
#define MORPHO_EASY_HDR_MERGE_SMOOTHNESS_LEVEL_DEFAULT  6

#define MORPHO_EASY_HDR_MERGE_PARAM_MIN        0
#define MORPHO_EASY_HDR_MERGE_PARAM_MAX      255
#define MORPHO_EASY_HDR_MERGE_PARAM1_DEFAULT   0
#define MORPHO_EASY_HDR_MERGE_PARAM2_DEFAULT 128
#define MORPHO_EASY_HDR_MERGE_PARAM3_DEFAULT   0
#define MORPHO_EASY_HDR_MERGE_PARAM4_DEFAULT 255

#define MORPHO_EASY_HDR_RELIABLE_RECT_RATE_THRESHOLD_MIN       0
#define MORPHO_EASY_HDR_RELIABLE_RECT_RATE_THRESHOLD_MAX     100
#define MORPHO_EASY_HDR_RELIABLE_RECT_RATE_THRESHOLD_DEFAULT  80

#define MORPHO_EASY_HDR_GHOST_RATE_THRESHOLD_MIN       0
#define MORPHO_EASY_HDR_GHOST_RATE_THRESHOLD_MAX     100
#define MORPHO_EASY_HDR_GHOST_RATE_THRESHOLD_DEFAULT  90

#define MORPHO_EASY_HDR_CC_OFFSET_MIN          0
#define MORPHO_EASY_HDR_CC_OFFSET_MAX        255
#define MORPHO_EASY_HDR_CC_Y_OFFSET_DEFAULT    0
#define MORPHO_EASY_HDR_CC_C_OFFSET_DEFAULT    0

#define MORPHO_EASY_HDR_CC_GAIN_MIN        100
#define MORPHO_EASY_HDR_CC_GAIN_MAX       2000
#define MORPHO_EASY_HDR_CC_Y_GAIN_DEFAULT 1000
#define MORPHO_EASY_HDR_CC_C_GAIN_DEFAULT 1000

#define MORPHO_EASY_HDR_CC_GAMMA_MIN        100
#define MORPHO_EASY_HDR_CC_GAMMA_MAX       2000
#define MORPHO_EASY_HDR_CC_Y_GAMMA_DEFAULT 1000
#define MORPHO_EASY_HDR_CC_C_GAMMA_DEFAULT 1000

/*-----------------------------------------------------------------*/

/* (merge-status) */

#define MORPHO_EASY_HDR_OK                             0x00000000
#define MORPHO_EASY_HDR_ERROR_IMAGE_ALIGNMENT_FAILURE  0x00000001
#define MORPHO_EASY_HDR_ERROR_EXP_ESTIMATION_FAILURE   0x00000002
#define MORPHO_EASY_HDR_ERROR_MOSTLY_GHOST             0x00000004
#define MORPHO_EASY_HDR_ERROR_INTERNAL                 0x80000000

/*******************************************************************/

typedef struct _morpho_EasyHDR morpho_EasyHDR;
typedef struct _morpho_EasyHDR_Callback morpho_EasyHDR_Callback;

/*-----------------------------------------------------------------*/

/** EasyHDR */
struct _morpho_EasyHDR
{
    void *p; /**< \̂ւ̃|C^ */
};

/** EasyHDR Callback (for multi-thread processing) */
struct _morpho_EasyHDR_Callback
{
    void *p; /**< R[obN֐̑Ƃēnl */

    void * (* thread_create )(void *p, int index, void *(*start_routine)(void *arg), void *arg);
    int    (* thread_destroy)(void *p, void *thread);
    int    (* thread_join   )(void *p, void *thread, void **value_ptr);

    void * (* mutex_create )(void *p);
    int    (* mutex_destroy)(void *p, void *mutex);
    int    (* mutex_lock   )(void *p, void *mutex);
    int    (* mutex_trylock)(void *p, void *mutex);
    int    (* mutex_unlock )(void *p, void *mutex);

    void * (* cond_create   )(void *p);
    int    (* cond_destroy  )(void *p, void *cond);
    int    (* cond_wait     )(void *p, void *cond, void *lock);
    int    (* cond_signal   )(void *p, void *cond);
    int    (* cond_broadcast)(void *p, void *cond);
};

/*******************************************************************/

#ifdef __cplusplus
extern "C"
{
#endif

/*-----------------------------------------------------------------*/

/**
 * o[W擾
 *
 * @return o[W(MORPHO_EASY_HDR_VER)
 */
MORPHO_API(char const *)
morpho_EasyHDR_getVersion(void);

/*-----------------------------------------------------------------*/

/**
 * KvȃTCY擾
 *
 * @param[in]  max_width   ͉摜̍ő啝
 * @param[in]  max_height  ͉摜̍ő卂
 * @param[in]  format      摜tH[}bg
 *
 * @return KvȃTCY(byte)
 */
MORPHO_API(int)
morpho_EasyHDR_getBufferSize(
    int max_width,
    int max_height,
    char const *format);

/**
 * 
 *
 * gpXbh0ȉ̒lݒ肵ꍇA
 * ssB
 *
 * gpXbh1ȏ̒lݒ肵ꍇA
 * ꊇssB
 *
 * gpXbh2ȏ̒lݒ肵ꍇA
 * }`Xbhɂs(ꊇs)sB
 * callback ɓK؂Ȓlݒ肷KvB
 *
 * ysԂ̑Jځz
 *     ?_UNKNOWN  0_INITIALIZED
 *
 * @param[in,out]  p            EasyHDR CX^X
 * @param[out]     buffer       EasyHDRɊ蓖Ă郁ւ̃|C^
 * @param[in]      buffer_size  EasyHDRɊ蓖Ă郁̃TCY
 * @param[in]      nthreads     gpXbh (RA)
 * @param[in]      callback     R[obN֐Q
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_initialize(
    morpho_EasyHDR *p,
    void *buffer,
    int buffer_size,
    int nthreads,
    morpho_EasyHDR_Callback const *callback);

/**
 * N[Abv
 * initialize() sɎs\
 *
 * @param[in,out]  p  EasyHDR CX^X
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_finalize(
    morpho_EasyHDR *p);

/*-----------------------------------------------------------------*/

/**
 * ̊JnEs
 * setImageFormat() sɎs\
 *
 * ysԂ̑J (ꊇs)z
 *     0_INITIALIZED  (1_PROCESSING)  0_INITIALIZED ()
 *                                      2_SUSPENDED   (suspend()Ăяo)
 *
 * ysԂ̑J (s)z
 *     0_INITIALIZED  3_PAUSED      ()
 *                    0_INITIALIZED ()
 *
 * @param[in,out]  p             EasyHDR CX^X
 * @param[out]     output_image  ʉ摜 (u1ځv͉̓摜w\)
 * @param[in,out]  input_images  ͉摜Q (GWɂď)
 * @param[in]      nimages       ͉摜̐
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_merge(
    morpho_EasyHDR *p,
    morpho_ImageData *output_image,
    morpho_ImageData *input_images[],
    int nimages);

/*-----------------------------------------------------------------*/

/**
 * ̌ps
 *
 * merge() sɎs\
 *
 * s(initialize()  nthreads  0 w肵Ƃ)̂ݗL
 *
 * ysԂ̑J (s)z
 *     3_PAUSED  3_PAUSED      ()
 *               0_INITIALIZED ()
 *
 * @param[in,out]  p  EasyHDR CX^X
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_process(
    morpho_EasyHDR *p);

/*-----------------------------------------------------------------*/

/**
 * ̒f (ʃReLXǧĂяoɂ)
 * merge() sɎs\
 *
 * ysԂ̑J (ꊇs)z
 *     1_PROCESSING  2_SUSPENDED
 *
 * @param[in,out]  p  EasyHDR CX^X
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_suspend(
    morpho_EasyHDR *p);

/**
 * ̍ĊJ
 * suspend() sɎs\
 *
 * ysԂ̑J (ꊇs)z
 *     2_SUSPENDED  (1_PROCESSING)  0_INITIALIZED ()
 *                                    2_SUSPENDED   (suspend()Ăяo)
 *
 * @param[in,out]  p  EasyHDR CX^X
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_resume(
    morpho_EasyHDR *p);

/*-----------------------------------------------------------------*/

/**
 * 摜tH[}bg̐ݒ
 * initialize() sɎs\
 *
 * @param[in,out]  p       EasyHDR CX^X
 * @param[in]      format  摜tH[}bg킷
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setImageFormat(
    morpho_EasyHDR *p,
    char const *format);

/**
 * 摜tH[}bg̎擾
 * setImageFormat() sɎs\
 *
 * @param[in,out]  p            EasyHDR CX^X
 * @param[out]     buffer       摜tH[}bg킷񂪊i[obt@
 * @param[in]      buffer_size  obt@̃TCY(I[܂)
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getImageFormat(
    morpho_EasyHDR *p,
    char *buffer,
    int buffer_size);

/*-----------------------------------------------------------------*/

/**
 * ʒu킹(Ԃ␳)̗L̐ݒ
 * initialize() sɎs\
 *
 * value:
 *   MOR_EASY_HDR_ENABLED  : ʒu킹
 *   MOR_EASY_HDR_DISABLED : ʒu킹Ȃ
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[in]      value  ݒl
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setImageAlignmentStatus(
    morpho_EasyHDR *p,
    int value);

/**
 * ʒu킹(Ԃ␳)̗L̎擾
 * initialize() sɎs\
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[out]     value  ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getImageAlignmentStatus(
    morpho_EasyHDR *p,
    int *value);

/*-----------------------------------------------------------------*/

/**
 * S[Xg(ʑ̂Ԃ␳)̗L̐ݒ
 * initialize() sɎs\
 *
 * value:
 *   MOR_EASY_HDR_ENABLED  : S[Xg
 *   MOR_EASY_HDR_DISABLED : S[XgȂ
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[in]      value  ݒl
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setGhostRemovalStatus(
    morpho_EasyHDR *p,
    int value);

/**
 * S[Xg(ʑ̂Ԃ␳)̗L̎擾
 * initialize() sɎs\
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[out]     value  ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getGhostRemovalStatus(
    morpho_EasyHDR *p,
    int *value);

/*-----------------------------------------------------------------*/

/**
 * g(NbsO)̗L̐ݒ
 * initialize() sɎs\
 *
 * value:
 *   MOR_EASY_HDR_ENABLED  : g傠
 *   MOR_EASY_HDR_DISABLED : gȂ
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[in]      value  ݒl
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setAutoScalingStatus(
    morpho_EasyHDR *p,
    int value);

/**
 * g(NbsO)̗L̎擾
 * initialize() sɎs\
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[out]     value  ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getAutoScalingStatus(
    morpho_EasyHDR *p,
    int *value);

/*-----------------------------------------------------------------*/

/**
 * 猟o␳̗L̐ݒ
 * initialize() sɎs\
 *
 * value:
 *   MOR_EASY_HDR_ENABLED  : 猟o␳
 *   MOR_EASY_HDR_DISABLED : 猟o␳Ȃ
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[in]      value  ݒl
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setFaceDetectionStatus(
    morpho_EasyHDR *p,
    int value);

/**
 * 猟o␳̗L̎擾
 * initialize() sɎs\
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[out]     value  ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getFaceDetectionStatus(
    morpho_EasyHDR *p,
    int *value);

/*-----------------------------------------------------------------*/

/**
 * Fail-soft-merging ̗L̐ݒ
 * initialize() sɎs\
 *
 * value:
 *   MOR_EASY_HDR_ENABLED  : Fail-soft-merging 
 *   MOR_EASY_HDR_DISABLED : Fail-soft-merging Ȃ
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[in]      value  ݒl
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setFailSoftMergingStatus(
    morpho_EasyHDR *p,
    int value);

/**
 * Fail-soft-merging ̗L̎擾
 * initialize() sɎs\
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[out]     value  ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getFailSoftMergingStatus(
    morpho_EasyHDR *p,
    int *value);

/*-----------------------------------------------------------------*/

/**
 * S[Xg芴xx̐ݒ
 * initialize() sɎs\
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[in]      value  ݒl
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setGhostDetectionSensitivityLevel(
    morpho_EasyHDR *p,
    int value);

/**
 * S[Xg芴xx̎擾
 * initialize() sɎs\
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[out]     value  ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getGhostDetectionSensitivityLevel(
    morpho_EasyHDR *p,
    int *value);

/*-----------------------------------------------------------------*/

/**
 * Ȃ߂炩̐ݒ
 * initialize() sɎs\
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[in]      value  ݒl
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setMergeSmoothnessLevel(
    morpho_EasyHDR *p,
    int value);

/**
 * Ȃ߂炩̎擾
 * initialize() sɎs\
 *
 * @param[in,out]  p      EasyHDR CX^X
 * @param[out]     value  ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getMergeSmoothnessLevel(
    morpho_EasyHDR *p,
    int *value);

/*-----------------------------------------------------------------*/

/**
 * p[^̐ݒ
 * initialize() sɎs\
 *
 * @param[in,out]  p       EasyHDR CX^X
 * @param[in]      value1  ݒl
 * @param[in]      value2  ݒl
 * @param[in]      value3  ݒl
 * @param[in]      value4  ݒl
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setMergeParameters(
    morpho_EasyHDR *p,
    int value1,
    int value2,
    int value3,
    int value4);

/**
 * p[^̎擾
 * initialize() sɎs\
 *
 * @param[in,out]  p       EasyHDR CX^X
 * @param[out]     value1  ݒli[
 * @param[out]     value2  ݒli[
 * @param[out]     value3  ݒli[
 * @param[out]     value4  ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getMergeParameters(
    morpho_EasyHDR *p,
    int *value1,
    int *value2,
    int *value3,
    int *value4);

/*-----------------------------------------------------------------*/

/**
 * L̈臒l̐ݒ
 * initialize() sɎs\
 *
 * @param[in,out]  p     EasyHDR CX^X
 * @param[in]      rate  ݒl ( rate % `)
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setReliableRectRateThreshold(
    morpho_EasyHDR *p,
    int rate);

/**
 * L̈臒l̎擾
 * initialize() sɎs\
 *
 * @param[in,out]  p     EasyHDR CX^X
 * @param[out]     rate  ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getReliableRectRateThreshold(
    morpho_EasyHDR *p,
    int *rate);

/**
 * L̈̎擾
 * initialize() sɎs\
 * (LȒlZbĝ merge() )
 *
 * @param[in,out]  p     EasyHDR CX^X
 * @param[out]     rect  ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getReliableRect(
    morpho_EasyHDR *p,
    morpho_RectInt *rect);

/*-----------------------------------------------------------------*/

/**
 * S[Xg臒l̐ݒ
 * initialize() sɎs\
 *
 * @param[in,out]  p     EasyHDR CX^X
 * @param[in]      rate  ݒl
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setGhostRateThreshold(
    morpho_EasyHDR *p,
    int rate);

/**
 * S[Xg臒l̎擾
 * initialize() sɎs\
 *
 * @param[in,out]  p     EasyHDR CX^X
 * @param[out]     rate  ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getGhostRateThreshold(
    morpho_EasyHDR *p,
    int *rate);

/*-----------------------------------------------------------------*/

/**
 * F␳p[^̐ݒ
 * initialize() sɎs\
 *
 * @param[in,out]  p         EasyHDR CX^X
 * @param[in]      y_offset  ݒl
 * @param[in]      y_gain    ݒl
 * @param[in]      y_gamma   ݒl
 * @param[in]      c_offset  ݒl
 * @param[in]      c_gain    ݒl
 * @param[in]      c_gamma   ݒl
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_setColorCorrectionParameters(
    morpho_EasyHDR *p,
    int y_offset,
    int y_gain,
    int y_gamma,
    int c_offset,
    int c_gain,
    int c_gamma);

/**
 * F␳p[^̎擾
 * initialize() sɎs\
 *
 * @param[in,out]  p         EasyHDR CX^X
 * @param[out]     y_offset  ݒli[
 * @param[out]     y_gain    ݒli[
 * @param[out]     y_gamma   ݒli[
 * @param[out]     c_offset  ݒli[
 * @param[out]     c_gain    ݒli[
 * @param[out]     c_gamma   ݒli[
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_getColorCorrectionParameters(
    morpho_EasyHDR *p,
    int *y_offset,
    int *y_gain,
    int *y_gamma,
    int *c_offset,
    int *c_gain,
    int *c_gamma);

/*-----------------------------------------------------------------*/

/**
 * Xe[^X̎擾
 * initialize() sɎs\
 *
 * Xe[^XR[h
 *   MORPHO_EASY_HDR_OK
 *   MORPHO_EASY_HDR_ERROR_*
 *
 * @param[in,out]  p  EasyHDR CX^X
 *
 * @return Xe[^XR[h (MORPHO_EASMORPHO_EASY_HDR_ERROR_
 */
MORPHO_API(int)
morpho_EasyHDR_getMergeStatus(
    morpho_EasyHDR *p);

/*-----------------------------------------------------------------*/

/**
 * TlC̍쐬 (o͉摜̏k)
 * morpho_EasyHDR_setImageFormat() sɎs\
 *
 * @param[in,out]  p                EasyHDR CX^X
 * @param[out]     thumbnail_image  o͉摜
 * @param[in]      output_image     ͉摜
 *
 * @return G[R[h (see morpho_error.h)
 */
MORPHO_API(int)
morpho_EasyHDR_makeThumbnail(
    morpho_EasyHDR *p,
    morpho_ImageData *thumbnail_image,
    morpho_ImageData const *output_image);

/*-----------------------------------------------------------------*/

#ifdef __cplusplus
} /* extern "C" */
#endif

/*******************************************************************/

#endif /* !MORPHO_EASY_HDR_H */

/*******************************************************************/
/* [EOF] */
