/* Header for module multfile, generated by p2c 1.21alpha-07.Dec.93 */
#ifndef MULTFILE_H
#define MULTFILE_H


#ifdef MULTFILE_G
# define vextern
#else
# define vextern extern
#endif
/* DPL 2004-03-06
(* Support for including files into an input stream.
(* Intended for an application that does not require Pascal formatting,
(*   but reads complete lines one at a time.
(* You never actually work with any files, except by supplying the
(    filename when the file is opened.
(* At any stage, you can switch the input to a new file.
(* When the new file is at EOF, and a "read" is issued, the file is
(*   closed and the previous one resumed transparently.    This inclusion
(*   can be nested to any level, memory permitting.
(* --- Normal mode of operation, replacing the usual Pascal style ---
   Instead of:  assign(textfile,filename); reset(textfile)
          use:  pushFile(filename)
   When another file should be included before the current file is done,
          use:  pushFile(newfilename)
   Instead of:  readln(textfile,line)
          use:  line:=readLine
   Instead of:  eof(textfilen)
           or:  eofAll;    {Are all files at EOF?}
(* --- Abnormal mode of operation ---
   To abort a file before EOF is reached:
          use:  popFile;
   To abort all files:
          use:  closeAll;
   To test whether only the current file is at EOF:
          use:  eofCurrent;
(* Additional features:
   fileError: boolean function, was there an error during file open or read?
   currentFilename: string function, name of current file
   currentLineNo: integer function, number of line just read from current file
   isEmpty(var s: string): boolean function, is s empty?
   readData: string function, like readLine, but continue reading until
     a non-blank line is found, return blank only at EOF
   skipBlanks: skip blank lines in input: next call to readLine will be
     non-blank unless EOF is encountered
   report(items): procedure to control which messages are printed,
     "items" is the sum of the following options
     (constants with the appropriate values are defined in the interface)
     1: reportnewfile - file is opened
     2: reportoldfile - file is resumed
     4: reportclose - file is closed
     8: reporterror - a file error is encountered
    16: reportrecursive - there is a recursive include
        The default value is items=27 (all the above except reportclose)
     At present you cannot turn reportrecursive off.
   */

extern void pushFile(Char *filename);
extern void popFile(void);
extern void closeAll(void);
extern void report(short items);
extern Char *currentFilename(Char *Result);
extern boolean eofAll(void);
extern boolean eofCurrent(void);
extern boolean fileError(void);
extern Char *readLine(Char *Result);
extern Char *readData(Char *Result);
extern boolean isEmpty(Char *s);
extern short currentLineNo(void);
extern void skipBlanks(void);


#define reportnewfile   1
#define reportoldfile   2
#define reportclose     4
#define reporterror     8
#define reportrecursive  16


extern Char nextData[256];


#undef vextern

#endif /*MULTFILE_H*/

/* End. */
