/* shotwell-video-thumbnailer.c generated by valac 0.40.4, the Vala compiler
 * generated from shotwell-video-thumbnailer.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * 
 * This is a Vala-rewrite of GStreamer snapshot example. Adapted from earlier 
 * work from Wim Taymans.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Shotwell Thumbnailer takes in a video file and returns a thumbnail to stdout.  This is*/
/* a replacement for totem-video-thumbnailer*/


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <unistd.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SHOTWELL_THUMBNAILER (shotwell_thumbnailer_get_type ())
#define SHOTWELL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailer))
#define SHOTWELL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailerClass))
#define IS_SHOTWELL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOTWELL_THUMBNAILER))
#define IS_SHOTWELL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOTWELL_THUMBNAILER))
#define SHOTWELL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailerClass))

typedef struct _ShotwellThumbnailer ShotwellThumbnailer;
typedef struct _ShotwellThumbnailerClass ShotwellThumbnailerClass;
typedef struct _ShotwellThumbnailerPrivate ShotwellThumbnailerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecShotwellThumbnailer ParamSpecShotwellThumbnailer;

struct _ShotwellThumbnailer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ShotwellThumbnailerPrivate * priv;
};

struct _ShotwellThumbnailerClass {
	GTypeClass parent_class;
	void (*finalize) (ShotwellThumbnailer *self);
};

struct _ParamSpecShotwellThumbnailer {
	GParamSpec parent_instance;
};


static gpointer shotwell_thumbnailer_parent_class = NULL;

gpointer shotwell_thumbnailer_ref (gpointer instance);
void shotwell_thumbnailer_unref (gpointer instance);
GParamSpec* param_spec_shotwell_thumbnailer (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
void value_set_shotwell_thumbnailer (GValue* value,
                                     gpointer v_object);
void value_take_shotwell_thumbnailer (GValue* value,
                                      gpointer v_object);
gpointer value_get_shotwell_thumbnailer (const GValue* value);
GType shotwell_thumbnailer_get_type (void) G_GNUC_CONST;
#define SHOTWELL_THUMBNAILER_caps_string "video/x-raw,format=RGB,pixel-aspect-ratio=1/1"
gint shotwell_thumbnailer_main (gchar** args,
                                int args_length1);
static gboolean __lambda4_ (GstPluginFeature* f);
static gboolean ___lambda4__gst_plugin_feature_filter (GstPluginFeature* feature,
                                                gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
ShotwellThumbnailer* shotwell_thumbnailer_new (void);
ShotwellThumbnailer* shotwell_thumbnailer_construct (GType object_type);
static void shotwell_thumbnailer_finalize (ShotwellThumbnailer * obj);


static gpointer
_g_object_ref0 (gpointer self)
{
#line 29 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return self ? g_object_ref (self) : NULL;
#line 93 "shotwell-video-thumbnailer.c"
}


static gboolean
__lambda4_ (GstPluginFeature* f)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
#line 30 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	g_return_val_if_fail (GST_IS_PLUGIN_FEATURE (f), FALSE);
#line 31 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp0_ = gst_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (f, gst_object_get_type (), GstObject));
#line 31 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp1_ = _tmp0_;
#line 31 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp2_ = g_str_has_prefix (_tmp1_, "vaapi");
#line 31 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_g_free0 (_tmp1_);
#line 31 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	result = _tmp2_;
#line 31 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return result;
#line 118 "shotwell-video-thumbnailer.c"
}


static gboolean
___lambda4__gst_plugin_feature_filter (GstPluginFeature* feature,
                                       gpointer self)
{
	gboolean result;
	result = __lambda4_ (feature);
#line 30 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return result;
#line 130 "shotwell-video-thumbnailer.c"
}


static void
_g_object_unref0_ (gpointer var)
{
#line 41 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 139 "shotwell-video-thumbnailer.c"
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 41 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 148 "shotwell-video-thumbnailer.c"
}


gint
shotwell_thumbnailer_main (gchar** args,
                           int args_length1)
{
	gint result = 0;
	GstElement* pipeline = NULL;
	GstElement* sink = NULL;
	gchar* descr = NULL;
	GdkPixbuf* pixbuf = NULL;
	guint8* pngdata = NULL;
	gint pngdata_length1 = 0;
	gint _pngdata_size_ = 0;
	gint64 duration = 0LL;
	gint64 position = 0LL;
	GstStateChangeReturn ret = 0;
	GstRegistry* registry = NULL;
	GstRegistry* _tmp0_;
	GstRegistry* _tmp1_;
	GList* features = NULL;
	GstRegistry* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError * _inner_error_ = NULL;
#line 23 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (nice (19) < 0) {
#line 24 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		g_debug ("shotwell-video-thumbnailer.vala:24: Failed to reduce thumbnailer nice " \
"level. Continuing anyway");
#line 185 "shotwell-video-thumbnailer.c"
	}
#line 27 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	gst_init (&args_length1, &args);
#line 29 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp0_ = gst_registry_get ();
#line 29 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 29 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	registry = _tmp1_;
#line 30 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp2_ = registry;
#line 30 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp3_ = gst_registry_feature_filter (_tmp2_, ___lambda4__gst_plugin_feature_filter, FALSE, NULL);
#line 30 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	features = _tmp3_;
#line 34 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp4_ = features;
#line 203 "shotwell-video-thumbnailer.c"
	{
		GList* feature_collection = NULL;
		GList* feature_it = NULL;
#line 34 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		feature_collection = _tmp4_;
#line 34 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		for (feature_it = feature_collection; feature_it != NULL; feature_it = feature_it->next) {
#line 211 "shotwell-video-thumbnailer.c"
			GstPluginFeature* _tmp5_;
			GstPluginFeature* feature = NULL;
#line 34 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_tmp5_ = _g_object_ref0 ((GstPluginFeature*) feature_it->data);
#line 34 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			feature = _tmp5_;
#line 218 "shotwell-video-thumbnailer.c"
			{
				GstPluginFeature* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				GstRegistry* _tmp9_;
				GstPluginFeature* _tmp10_;
#line 35 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_tmp6_ = feature;
#line 35 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_tmp7_ = gst_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gst_object_get_type (), GstObject));
#line 35 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_tmp8_ = _tmp7_;
#line 35 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				g_debug ("shotwell-video-thumbnailer.vala:35: Removing registry feature %s", _tmp8_);
#line 35 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_g_free0 (_tmp8_);
#line 36 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_tmp9_ = registry;
#line 36 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_tmp10_ = feature;
#line 36 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				gst_registry_remove_feature (_tmp9_, _tmp10_);
#line 34 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_g_object_unref0 (feature);
#line 243 "shotwell-video-thumbnailer.c"
			}
		}
	}
#line 39 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (args_length1 != 2) {
#line 249 "shotwell-video-thumbnailer.c"
		FILE* _tmp11_;
		const gchar* _tmp12_;
#line 40 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp11_ = stdout;
#line 40 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp12_ = args[0];
#line 40 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		fprintf (_tmp11_, "usage: %s [filename]\n Writes video thumbnail to stdout\n", _tmp12_);
#line 41 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		result = 1;
#line 41 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		__g_list_free__g_object_unref0_0 (features);
#line 41 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (registry);
#line 41 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		pngdata = (g_free (pngdata), NULL);
#line 41 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (pixbuf);
#line 41 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_free0 (descr);
#line 41 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (sink);
#line 41 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (pipeline);
#line 41 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		return result;
#line 276 "shotwell-video-thumbnailer.c"
	}
#line 44 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp13_ = args[1];
#line 44 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp14_ = g_strdup_printf ("filesrc location=\"%s\" ! decodebin ! videoconvert ! videoscale ! ", _tmp13_);
#line 44 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp15_ = _tmp14_;
#line 44 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp16_ = g_strdup_printf ("%s ! gdkpixbufsink name=sink", SHOTWELL_THUMBNAILER_caps_string);
#line 44 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp17_ = _tmp16_;
#line 44 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
#line 44 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_g_free0 (descr);
#line 44 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	descr = _tmp18_;
#line 44 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_g_free0 (_tmp17_);
#line 44 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_g_free0 (_tmp15_);
#line 298 "shotwell-video-thumbnailer.c"
	{
		GstElement* _tmp19_ = NULL;
		const gchar* _tmp20_;
		GstElement* _tmp21_;
		GstElement* _tmp22_;
		GstElement* _tmp23_;
		GstElement* _tmp24_;
		GstElement* _tmp25_;
		GstStateChangeReturn _tmp26_;
		GstElement* _tmp30_;
		GstStateChangeReturn _tmp31_;
		GstStateChangeReturn _tmp32_;
		GstElement* _tmp34_;
		gint64 _tmp35_ = 0LL;
		gboolean _tmp36_;
		GstElement* _tmp38_;
		gint64 _tmp39_;
		GstElement* _tmp40_;
		GstStateChangeReturn _tmp41_;
		GstStateChangeReturn _tmp42_;
		GstElement* _tmp44_;
		GdkPixbuf* _tmp45_;
		guint8* _tmp46_ = NULL;
		gsize _tmp47_;
		FILE* _tmp48_;
		guint8* _tmp49_;
		gint _tmp49__length1;
		GstElement* _tmp50_;
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp20_ = descr;
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp21_ = gst_parse_launch_full (_tmp20_, NULL, GST_PARSE_FLAG_NONE, &_inner_error_);
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		if (_tmp21_ != NULL) {
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			g_object_ref_sink (_tmp21_);
#line 335 "shotwell-video-thumbnailer.c"
		}
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp19_ = _tmp21_;
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 341 "shotwell-video-thumbnailer.c"
			goto __catch0_g_error;
		}
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp22_ = _tmp19_;
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp19_ = NULL;
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		if (_tmp22_ != NULL) {
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			g_object_ref_sink (_tmp22_);
#line 352 "shotwell-video-thumbnailer.c"
		}
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (pipeline);
#line 49 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		pipeline = _tmp22_;
#line 52 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp23_ = pipeline;
#line 52 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp24_ = gst_bin_get_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gst_bin_get_type (), GstBin), "sink");
#line 52 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (sink);
#line 52 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		sink = _tmp24_;
#line 55 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp25_ = pipeline;
#line 55 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		ret = gst_element_set_state (_tmp25_, GST_STATE_PAUSED);
#line 56 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp26_ = ret;
#line 56 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		if (_tmp26_ == GST_STATE_CHANGE_FAILURE) {
#line 374 "shotwell-video-thumbnailer.c"
			FILE* _tmp27_;
#line 57 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_tmp27_ = stderr;
#line 57 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			fprintf (_tmp27_, "Failed to play the file: couldn't set state\n");
#line 58 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			result = 3;
#line 58 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (_tmp19_);
#line 58 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			__g_list_free__g_object_unref0_0 (features);
#line 58 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (registry);
#line 58 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			pngdata = (g_free (pngdata), NULL);
#line 58 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (pixbuf);
#line 58 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_free0 (descr);
#line 58 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (sink);
#line 58 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (pipeline);
#line 58 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			return result;
#line 400 "shotwell-video-thumbnailer.c"
		} else {
			GstStateChangeReturn _tmp28_;
#line 59 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_tmp28_ = ret;
#line 59 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			if (_tmp28_ == GST_STATE_CHANGE_NO_PREROLL) {
#line 407 "shotwell-video-thumbnailer.c"
				FILE* _tmp29_;
#line 60 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_tmp29_ = stderr;
#line 60 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				fprintf (_tmp29_, "Live sources not supported yet.\n");
#line 61 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				result = 4;
#line 61 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_g_object_unref0 (_tmp19_);
#line 61 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				__g_list_free__g_object_unref0_0 (features);
#line 61 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_g_object_unref0 (registry);
#line 61 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				pngdata = (g_free (pngdata), NULL);
#line 61 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_g_object_unref0 (pixbuf);
#line 61 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_g_free0 (descr);
#line 61 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_g_object_unref0 (sink);
#line 61 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				_g_object_unref0 (pipeline);
#line 61 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
				return result;
#line 433 "shotwell-video-thumbnailer.c"
			}
		}
#line 67 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp30_ = pipeline;
#line 67 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp31_ = gst_element_get_state (_tmp30_, NULL, NULL, (GstClockTime) (5 * GST_SECOND));
#line 67 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		ret = _tmp31_;
#line 68 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp32_ = ret;
#line 68 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		if (_tmp32_ == GST_STATE_CHANGE_FAILURE) {
#line 446 "shotwell-video-thumbnailer.c"
			FILE* _tmp33_;
#line 69 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_tmp33_ = stderr;
#line 69 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			fprintf (_tmp33_, "Failed to play the file: couldn't get state.\n");
#line 70 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			result = 3;
#line 70 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (_tmp19_);
#line 70 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			__g_list_free__g_object_unref0_0 (features);
#line 70 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (registry);
#line 70 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			pngdata = (g_free (pngdata), NULL);
#line 70 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (pixbuf);
#line 70 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_free0 (descr);
#line 70 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (sink);
#line 70 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (pipeline);
#line 70 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			return result;
#line 472 "shotwell-video-thumbnailer.c"
		}
#line 74 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp34_ = pipeline;
#line 74 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp36_ = gst_element_query_duration (_tmp34_, GST_FORMAT_TIME, &_tmp35_);
#line 74 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		duration = _tmp35_;
#line 74 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		if (!_tmp36_) {
#line 482 "shotwell-video-thumbnailer.c"
			FILE* _tmp37_;
#line 75 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_tmp37_ = stderr;
#line 75 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			fprintf (_tmp37_, "Failed to query file for duration\n");
#line 76 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			result = 3;
#line 76 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (_tmp19_);
#line 76 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			__g_list_free__g_object_unref0_0 (features);
#line 76 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (registry);
#line 76 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			pngdata = (g_free (pngdata), NULL);
#line 76 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (pixbuf);
#line 76 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_free0 (descr);
#line 76 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (sink);
#line 76 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (pipeline);
#line 76 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			return result;
#line 508 "shotwell-video-thumbnailer.c"
		}
#line 79 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		position = (gint64) (1 * GST_SECOND);
#line 85 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp38_ = pipeline;
#line 85 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp39_ = position;
#line 85 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		gst_element_seek_simple (_tmp38_, GST_FORMAT_TIME, GST_SEEK_FLAG_KEY_UNIT | GST_SEEK_FLAG_FLUSH, _tmp39_);
#line 87 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp40_ = pipeline;
#line 87 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp41_ = gst_element_get_state (_tmp40_, NULL, NULL, (GstClockTime) (5 * GST_SECOND));
#line 87 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		ret = _tmp41_;
#line 88 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp42_ = ret;
#line 88 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		if (_tmp42_ == GST_STATE_CHANGE_FAILURE) {
#line 528 "shotwell-video-thumbnailer.c"
			FILE* _tmp43_;
#line 89 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_tmp43_ = stderr;
#line 89 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			fprintf (_tmp43_, "Failed to play the file: couldn't get state.\n");
#line 90 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			result = 3;
#line 90 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (_tmp19_);
#line 90 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			__g_list_free__g_object_unref0_0 (features);
#line 90 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (registry);
#line 90 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			pngdata = (g_free (pngdata), NULL);
#line 90 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (pixbuf);
#line 90 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_free0 (descr);
#line 90 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (sink);
#line 90 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (pipeline);
#line 90 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			return result;
#line 554 "shotwell-video-thumbnailer.c"
		}
#line 93 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp44_ = sink;
#line 93 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, G_TYPE_OBJECT, GObject), "last-pixbuf", &pixbuf, NULL);
#line 96 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp45_ = pixbuf;
#line 96 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		gdk_pixbuf_save_to_buffer (_tmp45_, &_tmp46_, &_tmp47_, "png", &_inner_error_, NULL);
#line 96 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		pngdata = (g_free (pngdata), NULL);
#line 96 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		pngdata = _tmp46_;
#line 96 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		pngdata_length1 = _tmp47_;
#line 96 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_pngdata_size_ = pngdata_length1;
#line 96 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 96 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			_g_object_unref0 (_tmp19_);
#line 576 "shotwell-video-thumbnailer.c"
			goto __catch0_g_error;
		}
#line 97 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp48_ = stdout;
#line 97 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp49_ = pngdata;
#line 97 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp49__length1 = pngdata_length1;
#line 97 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		fwrite (_tmp49_, (gsize) 1, _tmp49__length1, _tmp48_);
#line 100 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp50_ = pipeline;
#line 100 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		gst_element_set_state (_tmp50_, GST_STATE_NULL);
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (_tmp19_);
#line 593 "shotwell-video-thumbnailer.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp51_;
		GError* _tmp52_;
		const gchar* _tmp53_;
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		e = _inner_error_;
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_inner_error_ = NULL;
#line 103 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp51_ = stderr;
#line 103 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp52_ = e;
#line 103 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_tmp53_ = _tmp52_->message;
#line 103 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		fprintf (_tmp51_, "%s", _tmp53_);
#line 104 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		result = 2;
#line 104 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_error_free0 (e);
#line 104 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		__g_list_free__g_object_unref0_0 (features);
#line 104 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (registry);
#line 104 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		pngdata = (g_free (pngdata), NULL);
#line 104 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (pixbuf);
#line 104 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_free0 (descr);
#line 104 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (sink);
#line 104 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (pipeline);
#line 104 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		return result;
#line 634 "shotwell-video-thumbnailer.c"
	}
	__finally0:
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 639 "shotwell-video-thumbnailer.c"
		gint _tmp54_ = 0;
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		__g_list_free__g_object_unref0_0 (features);
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (registry);
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		pngdata = (g_free (pngdata), NULL);
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (pixbuf);
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_free0 (descr);
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (sink);
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		_g_object_unref0 (pipeline);
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		g_clear_error (&_inner_error_);
#line 47 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		return _tmp54_;
#line 661 "shotwell-video-thumbnailer.c"
	}
#line 107 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	result = 0;
#line 107 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	__g_list_free__g_object_unref0_0 (features);
#line 107 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_g_object_unref0 (registry);
#line 107 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	pngdata = (g_free (pngdata), NULL);
#line 107 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_g_object_unref0 (pixbuf);
#line 107 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_g_free0 (descr);
#line 107 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_g_object_unref0 (sink);
#line 107 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	_g_object_unref0 (pipeline);
#line 107 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return result;
#line 681 "shotwell-video-thumbnailer.c"
}


int
main (int argc,
      char ** argv)
{
#line 15 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return shotwell_thumbnailer_main (argv, argc);
#line 691 "shotwell-video-thumbnailer.c"
}


ShotwellThumbnailer*
shotwell_thumbnailer_construct (GType object_type)
{
	ShotwellThumbnailer* self = NULL;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	self = (ShotwellThumbnailer*) g_type_create_instance (object_type);
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return self;
#line 703 "shotwell-video-thumbnailer.c"
}


ShotwellThumbnailer*
shotwell_thumbnailer_new (void)
{
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return shotwell_thumbnailer_construct (TYPE_SHOTWELL_THUMBNAILER);
#line 712 "shotwell-video-thumbnailer.c"
}


static void
value_shotwell_thumbnailer_init (GValue* value)
{
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	value->data[0].v_pointer = NULL;
#line 721 "shotwell-video-thumbnailer.c"
}


static void
value_shotwell_thumbnailer_free_value (GValue* value)
{
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		shotwell_thumbnailer_unref (value->data[0].v_pointer);
#line 732 "shotwell-video-thumbnailer.c"
	}
}


static void
value_shotwell_thumbnailer_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		dest_value->data[0].v_pointer = shotwell_thumbnailer_ref (src_value->data[0].v_pointer);
#line 745 "shotwell-video-thumbnailer.c"
	} else {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		dest_value->data[0].v_pointer = NULL;
#line 749 "shotwell-video-thumbnailer.c"
	}
}


static gpointer
value_shotwell_thumbnailer_peek_pointer (const GValue* value)
{
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return value->data[0].v_pointer;
#line 759 "shotwell-video-thumbnailer.c"
}


static gchar*
value_shotwell_thumbnailer_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (collect_values[0].v_pointer) {
#line 771 "shotwell-video-thumbnailer.c"
		ShotwellThumbnailer * object;
		object = collect_values[0].v_pointer;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 778 "shotwell-video-thumbnailer.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 782 "shotwell-video-thumbnailer.c"
		}
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		value->data[0].v_pointer = shotwell_thumbnailer_ref (object);
#line 786 "shotwell-video-thumbnailer.c"
	} else {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		value->data[0].v_pointer = NULL;
#line 790 "shotwell-video-thumbnailer.c"
	}
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return NULL;
#line 794 "shotwell-video-thumbnailer.c"
}


static gchar*
value_shotwell_thumbnailer_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	ShotwellThumbnailer ** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (!object_p) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 810 "shotwell-video-thumbnailer.c"
	}
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		*object_p = NULL;
#line 816 "shotwell-video-thumbnailer.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		*object_p = value->data[0].v_pointer;
#line 820 "shotwell-video-thumbnailer.c"
	} else {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		*object_p = shotwell_thumbnailer_ref (value->data[0].v_pointer);
#line 824 "shotwell-video-thumbnailer.c"
	}
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return NULL;
#line 828 "shotwell-video-thumbnailer.c"
}


GParamSpec*
param_spec_shotwell_thumbnailer (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ParamSpecShotwellThumbnailer* spec;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SHOTWELL_THUMBNAILER), NULL);
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return G_PARAM_SPEC (spec);
#line 848 "shotwell-video-thumbnailer.c"
}


gpointer
value_get_shotwell_thumbnailer (const GValue* value)
{
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHOTWELL_THUMBNAILER), NULL);
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return value->data[0].v_pointer;
#line 859 "shotwell-video-thumbnailer.c"
}


void
value_set_shotwell_thumbnailer (GValue* value,
                                gpointer v_object)
{
	ShotwellThumbnailer * old;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHOTWELL_THUMBNAILER));
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (v_object) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SHOTWELL_THUMBNAILER));
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		shotwell_thumbnailer_ref (value->data[0].v_pointer);
#line 882 "shotwell-video-thumbnailer.c"
	} else {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		value->data[0].v_pointer = NULL;
#line 886 "shotwell-video-thumbnailer.c"
	}
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (old) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		shotwell_thumbnailer_unref (old);
#line 892 "shotwell-video-thumbnailer.c"
	}
}


void
value_take_shotwell_thumbnailer (GValue* value,
                                 gpointer v_object)
{
	ShotwellThumbnailer * old;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHOTWELL_THUMBNAILER));
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (v_object) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SHOTWELL_THUMBNAILER));
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		value->data[0].v_pointer = v_object;
#line 914 "shotwell-video-thumbnailer.c"
	} else {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		value->data[0].v_pointer = NULL;
#line 918 "shotwell-video-thumbnailer.c"
	}
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (old) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		shotwell_thumbnailer_unref (old);
#line 924 "shotwell-video-thumbnailer.c"
	}
}


static void
shotwell_thumbnailer_class_init (ShotwellThumbnailerClass * klass)
{
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	shotwell_thumbnailer_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	((ShotwellThumbnailerClass *) klass)->finalize = shotwell_thumbnailer_finalize;
#line 936 "shotwell-video-thumbnailer.c"
}


static void
shotwell_thumbnailer_instance_init (ShotwellThumbnailer * self)
{
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	self->ref_count = 1;
#line 945 "shotwell-video-thumbnailer.c"
}


static void
shotwell_thumbnailer_finalize (ShotwellThumbnailer * obj)
{
	ShotwellThumbnailer * self;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailer);
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	g_signal_handlers_destroy (self);
#line 957 "shotwell-video-thumbnailer.c"
}


GType
shotwell_thumbnailer_get_type (void)
{
	static volatile gsize shotwell_thumbnailer_type_id__volatile = 0;
	if (g_once_init_enter (&shotwell_thumbnailer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_shotwell_thumbnailer_init, value_shotwell_thumbnailer_free_value, value_shotwell_thumbnailer_copy_value, value_shotwell_thumbnailer_peek_pointer, "p", value_shotwell_thumbnailer_collect_value, "p", value_shotwell_thumbnailer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ShotwellThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shotwell_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShotwellThumbnailer), 0, (GInstanceInitFunc) shotwell_thumbnailer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType shotwell_thumbnailer_type_id;
		shotwell_thumbnailer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ShotwellThumbnailer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&shotwell_thumbnailer_type_id__volatile, shotwell_thumbnailer_type_id);
	}
	return shotwell_thumbnailer_type_id__volatile;
}


gpointer
shotwell_thumbnailer_ref (gpointer instance)
{
	ShotwellThumbnailer * self;
	self = instance;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	return instance;
#line 986 "shotwell-video-thumbnailer.c"
}


void
shotwell_thumbnailer_unref (gpointer instance)
{
	ShotwellThumbnailer * self;
	self = instance;
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		SHOTWELL_THUMBNAILER_GET_CLASS (self)->finalize (self);
#line 12 "/home/jens/Source/shotwell/thumbnailer/shotwell-video-thumbnailer.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1001 "shotwell-video-thumbnailer.c"
	}
}



