#ifndef INCLUDE_CLASS_CONFIG_H
#define INCLUDE_CLASS_CONFIG_H
/**
 * @brief Prototypes and definitions for configuration class
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation
 * (http://www.gnu.org/licenses/gpl.html)
 *
 * @file    src/class_config.h
 * @author  Matthias Grimm <matthias.grimm@users.sourceforge.net>
 */

#include <glib.h>

/* public prototypes class config*/
gboolean config_new (char *configfile);
void config_destroy ();
gboolean config_save ();
gboolean config_iswritable ();
gboolean config_has_key (const char *group, const char *key);
int config_get_int (const char *group, const char *key, int default_value);
void config_set_int (const char *group, const char *key, int value);
int config_get_percent (const char *group, const char *key, int default_value);
void config_set_percent (const char *group, const char *key, int value);
char *config_get_string (const char *group, const char *key, const char *default_value);
void config_set_string (const char *group, const char *key, const char *value);
int config_get_keycode (const char *group, const char *key, int default_value);
int config_get_modmask (const char *group, const char *key, int default_value);
void config_set_keymod (const char *group, const char *key, int keycode, int modmask);
gboolean config_get_boolean (const char *group, const char *key, gboolean default_value);
void config_set_boolean (const char *group, const char *key, gboolean value);
gchar **config_get_strlist (const char *group, const char *key, char *default_values);
void config_set_strlist (const char *group, const char *key, const char *values[]);
gint *config_get_intlist (const char *group, const char *key, unsigned int count, ...);
void config_set_intlist (const char *group, const char *key, unsigned int count, ...);
int config_get_option (const char *group, const char *key, const char *optionlist[], int default_value);
void config_set_option (const char *group, const char *key, const char *optionlist[], int value);

/* private prototypes class config*/
void decode_key_and_modifier(char *arg, int *key, int *mod);

#endif    /* INCLUDE_CLASS_CONFIG_H */
