/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.net.URL;
import javax.swing.ImageIcon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;

public class SelectionOpacityIcon
extends ImageIcon {
    private DrawingEditor editor;
    private AttributeKey<Double> opacityKey;
    private AttributeKey<Color> fillColorKey;
    private AttributeKey<Color> strokeColorKey;
    private Shape fillShape;
    private Shape strokeShape;

    public SelectionOpacityIcon(DrawingEditor drawingEditor, AttributeKey<Double> attributeKey, AttributeKey<Color> attributeKey2, AttributeKey<Color> attributeKey3, URL uRL, Shape shape, Shape shape2) {
        super(uRL);
        this.editor = drawingEditor;
        this.opacityKey = attributeKey;
        this.fillColorKey = attributeKey2;
        this.strokeColorKey = attributeKey3;
        this.fillShape = shape;
        this.strokeShape = shape2;
    }

    public SelectionOpacityIcon(DrawingEditor drawingEditor, AttributeKey<Double> attributeKey, AttributeKey<Color> attributeKey2, AttributeKey<Color> attributeKey3, Image image, Shape shape, Shape shape2) {
        super(image);
        this.editor = drawingEditor;
        this.opacityKey = attributeKey;
        this.fillColorKey = attributeKey2;
        this.strokeColorKey = attributeKey3;
        this.fillShape = shape;
        this.strokeShape = shape2;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color;
        Color color2;
        Double d;
        DrawingView drawingView;
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        DrawingView drawingView2 = drawingView = this.editor == null ? null : this.editor.getActiveView();
        if (drawingView != null && drawingView.getSelectedFigures().size() == 1) {
            Figure figure = drawingView.getSelectedFigures().iterator().next();
            d = figure.get(this.opacityKey);
            color2 = this.fillColorKey == null ? null : figure.get(this.fillColorKey);
            color = this.strokeColorKey == null ? null : figure.get(this.strokeColorKey);
        } else if (this.editor != null) {
            d = this.opacityKey.get(this.editor.getDefaultAttributes());
            color2 = this.fillColorKey == null ? null : this.fillColorKey.get(this.editor.getDefaultAttributes());
            color = this.strokeColorKey == null ? null : this.strokeColorKey.get(this.editor.getDefaultAttributes());
        } else {
            d = this.opacityKey.getDefaultValue();
            color2 = this.fillColorKey == null ? null : this.fillColorKey.getDefaultValue();
            Color color3 = color = this.strokeColorKey == null ? null : this.strokeColorKey.getDefaultValue();
        }
        if (this.fillColorKey != null && this.fillShape != null && d != null) {
            if (color2 == null) {
                color2 = Color.BLACK;
            }
            graphics2D.setColor(new Color((int)(d * 255.0) << 24 | color2.getRGB() & 0xFFFFFF, true));
            graphics2D.translate(n, n2);
            graphics2D.fill(this.fillShape);
            graphics2D.translate(-n, -n2);
        }
        if (this.strokeColorKey != null && this.strokeShape != null && d != null) {
            if (color == null) {
                color = Color.BLACK;
            }
            graphics2D.setColor(new Color((int)(d * 255.0) << 24 | color.getRGB() & 0xFFFFFF, true));
            graphics2D.translate(n, n2);
            graphics2D.draw(this.strokeShape);
            graphics2D.translate(-n, -n2);
        }
    }
}

