.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XGrabKey __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XGrabKey, XUngrabKey \- grab keyboard keys
.SH SYNTAX
.HP
int XGrabKey\^(\^Display *\fIdisplay\fP\^, int \fIkeycode\fP\^, unsigned int
\fImodifiers\fP\^, Window \fIgrab_window\fP\^, Bool \fIowner_events\fP\^, int
\fIpointer_mode\fP\^, int \fIkeyboard_mode\fP\^);
.HP
int XUngrabKey\^(\^Display *\fIdisplay\fP\^, int \fIkeycode\fP\^, unsigned int
\fImodifiers\fP\^, Window \fIgrab_window\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIgrab_window\fP 1i
Specifies the grab window.
.IP \fIkeyboard_mode\fP 1i
Specifies further processing of keyboard events.
You can pass
.B GrabModeSync
or
.BR GrabModeAsync .
.IP \fIkeycode\fP 1i
Specifies the KeyCode or
.BR AnyKey .
.IP \fImodifiers\fP 1i
Specifies the set of keymasks or
.BR AnyModifier .
The mask is the bitwise inclusive OR of the valid keymask bits.
.IP \fIowner_events\fP 1i
Specifies a Boolean value that indicates whether the keyboard events
are to be reported as usual.
.IP \fIpointer_mode\fP 1i
Specifies further processing of pointer events.
You can pass
.B GrabModeSync
or
.BR GrabModeAsync .
.SH DESCRIPTION
The
.B XGrabKey
function establishes a passive grab on the keyboard.
In the future,
the keyboard is actively grabbed (as for
.BR XGrabKeyboard ),
the last-keyboard-grab time is set to the time at which the key was pressed
(as transmitted in the
.B KeyPress
event), and the
.B KeyPress
event is reported if all of the following conditions are true:
.IP \(bu 5
The keyboard is not grabbed and the specified key
(which can itself be a modifier key) is logically pressed
when the specified modifier keys are logically down,
and no other modifier keys are logically down.
.IP \(bu 5
Either the grab_window is an ancestor of (or is) the focus window,
or the grab_window is a descendant of the focus window and contains the pointer.
.IP \(bu 5
A passive grab on the same key combination does not exist
on any ancestor of grab_window.
.LP
The interpretation of the remaining arguments is as for
.BR XGrabKeyboard .
The active grab is terminated automatically when the logical state of the
keyboard has the specified key released
(independent of the logical state of the modifier keys),
at which point a
.B KeyRelease
event is reported to the grabbing window.
.LP
Note that the logical state of a device (as seen by client applications)
may lag the physical state if device event processing is frozen.
.LP
A modifiers argument of
.B AnyModifier
is equivalent to issuing the request for all
possible modifier combinations (including the combination of no
modifiers).
It is not required that all modifiers specified have
currently assigned KeyCodes.
A keycode argument of
.B AnyKey
is equivalent to issuing
the request for all possible KeyCodes.
Otherwise, the specified keycode must be in
the range specified by min_keycode and max_keycode in the connection
setup,
or a
.B BadValue
error results.
.LP
If some other client has issued a
.B XGrabKey
with the same key combination on the same window, a
.B BadAccess
error results.
When using
.B AnyModifier
or
.BR AnyKey ,
the request fails completely,
and a
.B BadAccess
error results (no grabs are established)
if there is a conflicting grab for any combination.
.LP
.B XGrabKey
can generate
.BR BadAccess ,
.BR BadValue ,
and
.B BadWindow
errors.
.LP
The
.B XUngrabKey
function releases the key combination on the specified window if it was grabbed
by this client.
It has no effect on an active grab.
A modifiers of
.B AnyModifier
is equivalent to issuing
the request for all possible modifier combinations
(including the combination of no modifiers).
A keycode argument of
.B AnyKey
is equivalent to issuing the request for all possible key codes.
.LP
.B XUngrabKey
can generate
.B BadValue
and
.B BadWindow
error.
.SH DIAGNOSTICS
.TP 1i
.B BadAccess
A client attempted
to grab a key/button combination already grabbed by another client.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllowEvents(__libmansuffix__),
XGrabButton(__libmansuffix__),
XGrabKeyboard(__libmansuffix__),
XGrabPointer(__libmansuffix__)
.br
\fI\*(xL\fP
