/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.Builtin;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.Node_RuleVariable;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.impl.BindingVector;
import org.apache.jena.reasoner.rulesys.impl.FRuleEngine;
import org.apache.jena.reasoner.rulesys.impl.FRuleEngineI;
import org.apache.jena.reasoner.rulesys.impl.RETEClauseFilter;
import org.apache.jena.reasoner.rulesys.impl.RETEConflictSet;
import org.apache.jena.reasoner.rulesys.impl.RETENode;
import org.apache.jena.reasoner.rulesys.impl.RETEQueue;
import org.apache.jena.reasoner.rulesys.impl.RETERuleContext;
import org.apache.jena.reasoner.rulesys.impl.RETESourceNode;
import org.apache.jena.reasoner.rulesys.impl.RETETerminal;
import org.apache.jena.util.OneToManyMap;
import org.apache.jena.util.PrintUtil;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RETEEngine
implements FRuleEngineI {
    protected ForwardRuleInfGraphI infGraph;
    protected List<Rule> rules;
    protected OneToManyMap<Node, RETENode> clauseIndex;
    protected List<Triple> addsPending = new ArrayList<Triple>();
    protected HashSet<Triple> addsHash = new HashSet();
    protected List<Triple> deletesPending = new ArrayList<Triple>();
    protected RETEConflictSet conflictSet;
    protected OneToManyMap<Node, Node> predicatePatterns;
    protected boolean wildcardRule;
    protected boolean recordDerivations;
    long nRulesFired = 0L;
    boolean processedAxioms = false;
    boolean isMonotonic = true;
    protected static Logger logger = LoggerFactory.getLogger(FRuleEngine.class);

    public RETEEngine(ForwardRuleInfGraphI parent, List<Rule> rules) {
        this.infGraph = parent;
        this.rules = rules;
        this.isMonotonic = true;
        for (Rule r : rules) {
            if (r.isMonotonic()) continue;
            this.isMonotonic = false;
            break;
        }
    }

    public RETEEngine(ForwardRuleInfGraphI parent) {
        this.infGraph = parent;
    }

    @Override
    public void init(boolean ignoreBrules, Finder inserts) {
        this.compile(this.rules, ignoreBrules);
        this.findAndProcessAxioms();
        this.fastInit(inserts);
    }

    @Override
    public void fastInit(Finder inserts) {
        this.conflictSet = new RETEConflictSet(new RETERuleContext(this.infGraph, this), this.isMonotonic);
        this.findAndProcessActions();
        if (this.infGraph.getRawGraph() != null) {
            if (this.wildcardRule) {
                ExtendedIterator<Triple> i = inserts.find(new TriplePattern(null, null, null));
                while (i.hasNext()) {
                    this.addTriple((Triple)i.next(), false);
                }
            } else {
                for (Map.Entry<Node, Node> ent : this.predicatePatterns.entrySet()) {
                    ExtendedIterator<Triple> i = inserts.find(new TriplePattern(null, ent.getKey(), ent.getValue()));
                    while (i.hasNext()) {
                        Triple t = (Triple)i.next();
                        this.addTriple(t, false);
                    }
                }
            }
        }
        this.runAll();
    }

    @Override
    public synchronized void add(Triple t) {
        this.addTriple(t, false);
        this.runAll();
    }

    @Override
    public synchronized boolean delete(Triple t) {
        this.deleteTriple(t, false);
        this.runAll();
        return true;
    }

    @Override
    public long getNRulesFired() {
        return this.nRulesFired;
    }

    @Override
    public boolean shouldTrace() {
        return true;
    }

    @Override
    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
    }

    @Override
    public Object getRuleStore() {
        return new RuleStore(this.clauseIndex, this.predicatePatterns, this.wildcardRule, this.isMonotonic);
    }

    @Override
    public void setRuleStore(Object ruleStore) {
        RuleStore rs = (RuleStore)ruleStore;
        this.predicatePatterns = rs.predicatePatterns;
        this.wildcardRule = rs.wildcardRule;
        this.isMonotonic = rs.isMonotonic;
        RETERuleContext context = new RETERuleContext(this.infGraph, this);
        HashMap<RETENode, RETENode> netCopy = new HashMap<RETENode, RETENode>();
        this.clauseIndex = new OneToManyMap();
        for (Map.Entry<Node, RETENode> entry : rs.clauseIndex.entrySet()) {
            this.clauseIndex.put(entry.getKey(), entry.getValue().clone(netCopy, context));
        }
    }

    public void requestRuleFiring(Rule rule, BindingEnvironment env, boolean isAdd) {
        this.conflictSet.add(rule, env, isAdd);
    }

    public void compile(List<Rule> rules, boolean ignoreBrules) {
        this.clauseIndex = new OneToManyMap();
        this.predicatePatterns = new OneToManyMap();
        this.wildcardRule = false;
        for (Rule rule : rules) {
            if (ignoreBrules && rule.isBackward()) continue;
            int numVars = rule.getNumVars();
            boolean[] seenVar = new boolean[numVars];
            RETESourceNode prior = null;
            for (int i = 0; i < rule.bodyLength(); ++i) {
                ClauseEntry clause = rule.getBodyElement(i);
                if (!(clause instanceof TriplePattern)) continue;
                ArrayList<Node> clauseVars = new ArrayList<Node>(numVars);
                RETEClauseFilter clauseNode = RETEClauseFilter.compile((TriplePattern)clause, numVars, clauseVars);
                Node predicate = ((TriplePattern)clause).getPredicate();
                Node object = ((TriplePattern)clause).getObject();
                if (predicate.isVariable()) {
                    this.clauseIndex.put(Node.ANY, clauseNode);
                    this.wildcardRule = true;
                } else {
                    this.clauseIndex.put(predicate, clauseNode);
                    if (!this.wildcardRule) {
                        if (object.isVariable()) {
                            object = Node.ANY;
                        }
                        if (Functor.isFunctor(object)) {
                            object = Node.ANY;
                        }
                        this.recordPredicatePattern(predicate, object);
                    }
                }
                ArrayList<Byte> matchIndices = new ArrayList<Byte>(numVars);
                Iterator<Node> iv = clauseVars.iterator();
                while (iv.hasNext()) {
                    int varIndex = ((Node_RuleVariable)iv.next()).getIndex();
                    if (seenVar[varIndex]) {
                        matchIndices.add(new Byte((byte)varIndex));
                    }
                    seenVar[varIndex] = true;
                }
                if (prior == null) {
                    prior = clauseNode;
                    continue;
                }
                RETEQueue leftQ = new RETEQueue(matchIndices);
                RETEQueue rightQ = new RETEQueue(matchIndices);
                leftQ.setSibling(rightQ);
                rightQ.setSibling(leftQ);
                clauseNode.setContinuation(rightQ);
                prior.setContinuation(leftQ);
                prior = leftQ;
            }
            if (prior == null) continue;
            RETETerminal term = this.createTerminal(rule);
            prior.setContinuation(term);
        }
        if (this.wildcardRule) {
            this.predicatePatterns = null;
        }
    }

    private void recordPredicatePattern(Node predicate, Node value) {
        if (!this.predicatePatterns.contains(predicate, Node.ANY)) {
            if (value.equals(Node.ANY)) {
                this.predicatePatterns.remove(predicate);
                this.predicatePatterns.put(predicate, value);
            } else {
                this.predicatePatterns.put(predicate, value);
            }
        }
    }

    protected RETETerminal createTerminal(Rule rule) {
        return new RETETerminal(rule, this, this.infGraph);
    }

    public synchronized void addTriple(Triple triple, boolean deduction) {
        if (this.infGraph.shouldTrace()) {
            logger.debug("Add triple: " + PrintUtil.print(triple));
        }
        if (this.deletesPending.size() > 0) {
            this.deletesPending.remove(triple);
        }
        if (!this.addsHash.contains(triple)) {
            this.addsPending.add(triple);
            this.addsHash.add(triple);
        }
        if (deduction) {
            this.infGraph.addDeduction(triple);
        }
    }

    public synchronized void deleteTriple(Triple triple, boolean deduction) {
        this.addsPending.remove(triple);
        this.addsHash.remove(triple);
        this.deletesPending.add(triple);
        if (deduction) {
            this.infGraph.getCurrentDeductionsGraph().delete(triple);
            Graph raw = this.infGraph.getRawGraph();
            if (raw.contains(triple)) {
                this.deletesPending.remove(triple);
            }
        }
    }

    protected void incRuleCount() {
        ++this.nRulesFired;
    }

    protected synchronized Triple nextAddTriple() {
        int size = this.addsPending.size();
        if (size > 0) {
            Triple t = this.addsPending.remove(size - 1);
            this.addsHash.remove(t);
            return t;
        }
        return null;
    }

    protected synchronized Triple nextDeleteTriple() {
        int size = this.deletesPending.size();
        if (size > 0) {
            return this.deletesPending.remove(size - 1);
        }
        return null;
    }

    public void runAll() {
        while (true) {
            boolean isAdd = false;
            Triple next = this.nextDeleteTriple();
            if (next == null) {
                next = this.nextAddTriple();
                isAdd = true;
            }
            if (next == null) {
                if (this.conflictSet.isEmpty()) {
                    return;
                }
                this.conflictSet.fireOne();
                continue;
            }
            this.inject(next, isAdd);
        }
    }

    private void inject(Triple t, boolean isAdd) {
        if (this.infGraph.shouldTrace()) {
            logger.debug((isAdd ? "Inserting" : "Deleting") + " triple: " + PrintUtil.print(t));
        }
        Iterator<RETENode> i1 = this.clauseIndex.getAll(t.getPredicate());
        Iterator<RETENode> i2 = this.clauseIndex.getAll(Node.ANY);
        ExtendedIterator<RETENode> i = WrappedIterator.create(i1).andThen(i2);
        while (i.hasNext()) {
            RETEClauseFilter cf = (RETEClauseFilter)i.next();
            cf.fire(t, isAdd);
        }
    }

    public void testTripleInsert(Triple t) {
        Iterator<RETENode> i1 = this.clauseIndex.getAll(t.getPredicate());
        Iterator<RETENode> i2 = this.clauseIndex.getAll(Node.ANY);
        ExtendedIterator<RETENode> i = WrappedIterator.create(i1).andThen(i2);
        while (i.hasNext()) {
            RETEClauseFilter cf = (RETEClauseFilter)i.next();
            cf.fire(t, true);
        }
    }

    protected void findAndProcessAxioms() {
        for (Rule r : this.rules) {
            if (!r.isAxiom()) continue;
            RETERuleContext context = new RETERuleContext(this.infGraph, this);
            context.setEnv(new BindingVector(new Node[r.getNumVars()]));
            context.setRule(r);
            if (!context.shouldFire(true)) continue;
            RETEConflictSet.execute(context, true);
        }
        this.processedAxioms = true;
    }

    protected void findAndProcessActions() {
        RETERuleContext tempContext = new RETERuleContext(this.infGraph, this);
        for (Rule r : this.rules) {
            if (r.bodyLength() != 0) continue;
            for (int j = 0; j < r.headLength(); ++j) {
                ClauseEntry head = r.getHeadElement(j);
                if (!(head instanceof Functor)) continue;
                Functor f = (Functor)head;
                Builtin imp = f.getImplementor();
                if (imp != null) {
                    tempContext.setRule(r);
                    tempContext.setEnv(new BindingVector(r.getNumVars()));
                    imp.headAction(f.getArgs(), f.getArgLength(), tempContext);
                    continue;
                }
                throw new ReasonerException("Invoking undefined Functor " + f.getName() + " in " + r.toShortString());
            }
        }
    }

    public static class RuleStore {
        protected OneToManyMap<Node, RETENode> clauseIndex;
        protected OneToManyMap<Node, Node> predicatePatterns;
        protected boolean wildcardRule;
        protected boolean isMonotonic = true;

        RuleStore(OneToManyMap<Node, RETENode> clauseIndex, OneToManyMap<Node, Node> predicatesPatterns, boolean wildcardRule, boolean isMonotonic) {
            this.clauseIndex = clauseIndex;
            this.predicatePatterns = predicatesPatterns;
            this.wildcardRule = wildcardRule;
            this.isMonotonic = isMonotonic;
        }
    }

    protected static class ClausePointer {
        protected Rule rule;
        protected int index;

        ClausePointer(Rule rule, int index) {
            this.rule = rule;
            this.index = index;
        }

        TriplePattern getClause() {
            return (TriplePattern)this.rule.getBodyElement(this.index);
        }
    }
}

