/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.taglet;

import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class OdfElementTaglet
implements Taglet {
    private static final Logger LOG = Logger.getLogger(OdfElementTaglet.class.getName());
    private static final String NAME = "odf.element";
    private static final String ODF_SPEC_PART1_PATH = "../../../../../../doc-files/OpenDocument-v1.2-part1.html";
    private static final String ODF_SPEC_PART3_PATH = "../../../../../doc-files/OpenDocument-v1.2-part3.html";
    private static String mOdfSpecPart1Path = null;
    private static String mOdfSpecPart3Path = null;
    private static Set<String> mNS_IN_PART3 = new HashSet<String>();

    public String getName() {
        return NAME;
    }

    public boolean inField() {
        return true;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean isInlineTag() {
        return true;
    }

    public static void register(Map<String, Taglet> tagletMap) {
        OdfElementTaglet tag = new OdfElementTaglet();
        Taglet t = tagletMap.get(tag.getName());
        if (t != null) {
            tagletMap.remove(tag.getName());
        }
        tagletMap.put(tag.getName(), tag);
    }

    public String toString(Tag tag) {
        int pos = tag.text().lastIndexOf(":");
        String namespace = tag.text().substring(0, pos);
        String name = tag.text().substring(pos + 1);
        String mOdfSpecPath = mOdfSpecPart1Path;
        if (mNS_IN_PART3.contains(namespace)) {
            mOdfSpecPath = mOdfSpecPart3Path;
        }
        String fragmentIdentifier = "element-" + namespace + "_" + name;
        if ("ds:Signature".equals(tag.text())) {
            fragmentIdentifier = "element2-xmldsig_Signature";
        }
        return "<a href=\"" + mOdfSpecPath + "#" + fragmentIdentifier + "\">" + tag.text() + "</a>";
    }

    public String toString(Tag[] tags) {
        return null;
    }

    static {
        mNS_IN_PART3.add("manifest");
        mNS_IN_PART3.add("dsig");
        mNS_IN_PART3.add("ds");
        mOdfSpecPart1Path = System.getProperty("ODF_SPEC_PART1_PATH");
        if (mOdfSpecPart1Path == null) {
            mOdfSpecPart1Path = System.getenv("ODF_SPEC_PATH");
            if (mOdfSpecPart1Path == null) {
                mOdfSpecPart1Path = ODF_SPEC_PART1_PATH;
                LOG.info("OdfSpecPart1Path was set to " + mOdfSpecPart1Path + " by class declaration.");
            } else {
                LOG.info("OdfSpecPart1Path was set to " + mOdfSpecPart1Path + " by environment property 'ODF_SPEC_PATH'.");
            }
        } else {
            LOG.info("OdfSpecPart1Path was set to " + mOdfSpecPart1Path + " by Java System property 'ODF_SPEC_PATH'.");
        }
        mOdfSpecPart3Path = System.getProperty("ODF_SPEC_PART3_PATH");
        if (mOdfSpecPart3Path == null) {
            mOdfSpecPart3Path = System.getenv("ODF_SPEC_PATH");
            if (mOdfSpecPart3Path == null) {
                mOdfSpecPart3Path = ODF_SPEC_PART3_PATH;
                LOG.info("OdfSpecPart3Path was set to " + mOdfSpecPart3Path + " by class declaration.");
            } else {
                LOG.info("OdfSpecPart3Path was set to " + mOdfSpecPart3Path + " by environment property 'ODF_SPEC_PATH'.");
            }
        } else {
            LOG.info("OdfSpecPart3Path was set to " + mOdfSpecPart3Path + " by Java System property 'ODF_SPEC_PATH'.");
        }
    }
}

