/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextKindAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextMeasureElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "measure");

    public TextMeasureElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getTextKindAttribute() {
        TextKindAttribute attr = (TextKindAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "kind");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextKindAttribute(String textKindValue) {
        TextKindAttribute attr = new TextKindAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textKindValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

