; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instsimplify < %s | FileCheck %s

declare i32 @llvm.fptosi.sat.i32.f64(double)
declare i32 @llvm.fptoui.sat.i32.f64(double)
declare i32 @llvm.fptosi.sat.i32.f32(float)
declare i32 @llvm.fptoui.sat.i32.f32(float)

declare <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double>)
declare <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double>)
declare <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float>)
declare <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float>)

;
;
; F64 -> I32
;
;

define i32 @fptosi_f64_to_i32_poison() {
; CHECK-LABEL: @fptosi_f64_to_i32_poison(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double poison)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_undef() {
; CHECK-LABEL: @fptosi_f64_to_i32_undef(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double undef)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_pos_zero() {
; CHECK-LABEL: @fptosi_f64_to_i32_pos_zero(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 0.0)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_neg_zero() {
; CHECK-LABEL: @fptosi_f64_to_i32_neg_zero(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double -0.0)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_exact() {
; CHECK-LABEL: @fptosi_f64_to_i32_exact(
; CHECK-NEXT:    ret i32 42
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 42.0)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_trunc() {
; CHECK-LABEL: @fptosi_f64_to_i32_trunc(
; CHECK-NEXT:    ret i32 42
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 42.9)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_trunc_neg() {
; CHECK-LABEL: @fptosi_f64_to_i32_trunc_neg(
; CHECK-NEXT:    ret i32 -42
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double -42.9)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_max_minus_1() {
; CHECK-LABEL: @fptosi_f64_to_i32_max_minus_1(
; CHECK-NEXT:    ret i32 2147483646
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 2147483646.0)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_max() {
; CHECK-LABEL: @fptosi_f64_to_i32_max(
; CHECK-NEXT:    ret i32 2147483647
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 2147483647.0)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_max_plus_1() {
; CHECK-LABEL: @fptosi_f64_to_i32_max_plus_1(
; CHECK-NEXT:    ret i32 2147483647
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 2147483648.0)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_min_plus_1() {
; CHECK-LABEL: @fptosi_f64_to_i32_min_plus_1(
; CHECK-NEXT:    ret i32 -2147483647
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double -2147483647.0)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_min() {
; CHECK-LABEL: @fptosi_f64_to_i32_min(
; CHECK-NEXT:    ret i32 -2147483648
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double -2147483648.0)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_min_minus_1() {
; CHECK-LABEL: @fptosi_f64_to_i32_min_minus_1(
; CHECK-NEXT:    ret i32 -2147483648
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double -2147483649.0)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_inf() {
; CHECK-LABEL: @fptosi_f64_to_i32_inf(
; CHECK-NEXT:    ret i32 2147483647
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 0x7ff0000000000000)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_neg_inf() {
; CHECK-LABEL: @fptosi_f64_to_i32_neg_inf(
; CHECK-NEXT:    ret i32 -2147483648
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 0xfff0000000000000)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_nan1() {
; CHECK-LABEL: @fptosi_f64_to_i32_nan1(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 0x7ff8000000000000)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_nan2() {
; CHECK-LABEL: @fptosi_f64_to_i32_nan2(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 0x7ff4000000000000)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_nan3() {
; CHECK-LABEL: @fptosi_f64_to_i32_nan3(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 0xfff8000000000000)
  ret i32 %r
}

define i32 @fptosi_f64_to_i32_nan4() {
; CHECK-LABEL: @fptosi_f64_to_i32_nan4(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f64(double 0xfff4000000000000)
  ret i32 %r
}

define <2 x i32> @fptosi_f64_to_i32_vec() {
; CHECK-LABEL: @fptosi_f64_to_i32_vec(
; CHECK-NEXT:    ret <2 x i32> <i32 42, i32 -42>
;
  %r = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f64(<2 x double> <double 42.9, double -42.9>)
  ret <2 x i32> %r
}

;
;
; F64 -> U32
;
;

define i32 @fptoui_f64_to_i32_poison() {
; CHECK-LABEL: @fptoui_f64_to_i32_poison(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double poison)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_undef() {
; CHECK-LABEL: @fptoui_f64_to_i32_undef(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double undef)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_pos_zero() {
; CHECK-LABEL: @fptoui_f64_to_i32_pos_zero(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 0.0)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_neg_zero() {
; CHECK-LABEL: @fptoui_f64_to_i32_neg_zero(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double -0.0)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_exact() {
; CHECK-LABEL: @fptoui_f64_to_i32_exact(
; CHECK-NEXT:    ret i32 42
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 42.0)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_trunc() {
; CHECK-LABEL: @fptoui_f64_to_i32_trunc(
; CHECK-NEXT:    ret i32 42
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 42.9)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_trunc_neg() {
; CHECK-LABEL: @fptoui_f64_to_i32_trunc_neg(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double -42.9)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_max_minus_1() {
; CHECK-LABEL: @fptoui_f64_to_i32_max_minus_1(
; CHECK-NEXT:    ret i32 -2
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 4294967294.0)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_max() {
; CHECK-LABEL: @fptoui_f64_to_i32_max(
; CHECK-NEXT:    ret i32 -1
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 4294967295.0)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_max_plus_1() {
; CHECK-LABEL: @fptoui_f64_to_i32_max_plus_1(
; CHECK-NEXT:    ret i32 -1
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 4294967296.0)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_inf() {
; CHECK-LABEL: @fptoui_f64_to_i32_inf(
; CHECK-NEXT:    ret i32 -1
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 0x7ff0000000000000)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_neg_inf() {
; CHECK-LABEL: @fptoui_f64_to_i32_neg_inf(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 0xfff0000000000000)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_nan1() {
; CHECK-LABEL: @fptoui_f64_to_i32_nan1(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 0x7ff8000000000000)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_nan2() {
; CHECK-LABEL: @fptoui_f64_to_i32_nan2(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 0x7ff4000000000000)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_nan3() {
; CHECK-LABEL: @fptoui_f64_to_i32_nan3(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 0xfff8000000000000)
  ret i32 %r
}

define i32 @fptoui_f64_to_i32_nan4() {
; CHECK-LABEL: @fptoui_f64_to_i32_nan4(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f64(double 0xfff4000000000000)
  ret i32 %r
}

define <2 x i32> @fptoui_f64_to_i32_vec() {
; CHECK-LABEL: @fptoui_f64_to_i32_vec(
; CHECK-NEXT:    ret <2 x i32> <i32 42, i32 0>
;
  %r = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f64(<2 x double> <double 42.9, double -42.9>)
  ret <2 x i32> %r
}

;
;
; F32 -> I32
;
;

define i32 @fptosi_f32_to_i32_poison() {
; CHECK-LABEL: @fptosi_f32_to_i32_poison(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float poison)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_undef() {
; CHECK-LABEL: @fptosi_f32_to_i32_undef(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float undef)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_pos_zero() {
; CHECK-LABEL: @fptosi_f32_to_i32_pos_zero(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float 0.0)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_neg_zero() {
; CHECK-LABEL: @fptosi_f32_to_i32_neg_zero(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float -0.0)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_exact() {
; CHECK-LABEL: @fptosi_f32_to_i32_exact(
; CHECK-NEXT:    ret i32 42
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float 42.0)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_trunc() {
; CHECK-LABEL: @fptosi_f32_to_i32_trunc(
; CHECK-NEXT:    ret i32 42
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float 42.5)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_trunc_neg() {
; CHECK-LABEL: @fptosi_f32_to_i32_trunc_neg(
; CHECK-NEXT:    ret i32 -42
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float -42.5)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_below_max() {
; CHECK-LABEL: @fptosi_f32_to_i32_below_max(
; CHECK-NEXT:    ret i32 2147483520
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float 2147483520.0)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_above_max() {
; CHECK-LABEL: @fptosi_f32_to_i32_above_max(
; CHECK-NEXT:    ret i32 2147483647
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float 2147483648.0)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_above_min() {
; CHECK-LABEL: @fptosi_f32_to_i32_above_min(
; CHECK-NEXT:    ret i32 -2147483520
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float -2147483520.0)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_min() {
; CHECK-LABEL: @fptosi_f32_to_i32_min(
; CHECK-NEXT:    ret i32 -2147483648
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float -2147483648.0)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_below_min() {
; CHECK-LABEL: @fptosi_f32_to_i32_below_min(
; CHECK-NEXT:    ret i32 -2147483648
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float -2147483904.0)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_inf() {
; CHECK-LABEL: @fptosi_f32_to_i32_inf(
; CHECK-NEXT:    ret i32 2147483647
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float 0x7ff0000000000000)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_neg_inf() {
; CHECK-LABEL: @fptosi_f32_to_i32_neg_inf(
; CHECK-NEXT:    ret i32 -2147483648
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float 0xfff0000000000000)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_nan1() {
; CHECK-LABEL: @fptosi_f32_to_i32_nan1(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float 0x7ff8000000000000)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_nan2() {
; CHECK-LABEL: @fptosi_f32_to_i32_nan2(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float 0x7ff4000000000000)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_nan3() {
; CHECK-LABEL: @fptosi_f32_to_i32_nan3(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float 0xfff8000000000000)
  ret i32 %r
}

define i32 @fptosi_f32_to_i32_nan4() {
; CHECK-LABEL: @fptosi_f32_to_i32_nan4(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptosi.sat.i32.f32(float 0xfff4000000000000)
  ret i32 %r
}

define <2 x i32> @fptosi_f32_to_i32_vec() {
; CHECK-LABEL: @fptosi_f32_to_i32_vec(
; CHECK-NEXT:    ret <2 x i32> <i32 42, i32 -42>
;
  %r = call <2 x i32> @llvm.fptosi.sat.v2i32.v2f32(<2 x float> <float 42.5, float -42.5>)
  ret <2 x i32> %r
}

;
;
; F32 -> U32
;
;

define i32 @fptoui_f32_to_i32_poison() {
; CHECK-LABEL: @fptoui_f32_to_i32_poison(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float poison)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_undef() {
; CHECK-LABEL: @fptoui_f32_to_i32_undef(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float undef)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_pos_zero() {
; CHECK-LABEL: @fptoui_f32_to_i32_pos_zero(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float 0.0)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_neg_zero() {
; CHECK-LABEL: @fptoui_f32_to_i32_neg_zero(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float -0.0)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_exact() {
; CHECK-LABEL: @fptoui_f32_to_i32_exact(
; CHECK-NEXT:    ret i32 42
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float 42.0)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_trunc() {
; CHECK-LABEL: @fptoui_f32_to_i32_trunc(
; CHECK-NEXT:    ret i32 42
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float 42.5)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_trunc_neg() {
; CHECK-LABEL: @fptoui_f32_to_i32_trunc_neg(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float -42.5)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_below_max() {
; CHECK-LABEL: @fptoui_f32_to_i32_below_max(
; CHECK-NEXT:    ret i32 -256
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float 4294967040.0)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_above_max() {
; CHECK-LABEL: @fptoui_f32_to_i32_above_max(
; CHECK-NEXT:    ret i32 -1
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float 4294967296.0)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_inf() {
; CHECK-LABEL: @fptoui_f32_to_i32_inf(
; CHECK-NEXT:    ret i32 -1
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float 0x7ff0000000000000)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_neg_inf() {
; CHECK-LABEL: @fptoui_f32_to_i32_neg_inf(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float 0xfff0000000000000)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_nan1() {
; CHECK-LABEL: @fptoui_f32_to_i32_nan1(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float 0x7ff8000000000000)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_nan2() {
; CHECK-LABEL: @fptoui_f32_to_i32_nan2(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float 0x7ff4000000000000)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_nan3() {
; CHECK-LABEL: @fptoui_f32_to_i32_nan3(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float 0xfff8000000000000)
  ret i32 %r
}

define i32 @fptoui_f32_to_i32_nan4() {
; CHECK-LABEL: @fptoui_f32_to_i32_nan4(
; CHECK-NEXT:    ret i32 0
;
  %r = call i32 @llvm.fptoui.sat.i32.f32(float 0xfff4000000000000)
  ret i32 %r
}

define <2 x i32> @fptoui_f32_to_i32_vec() {
; CHECK-LABEL: @fptoui_f32_to_i32_vec(
; CHECK-NEXT:    ret <2 x i32> <i32 42, i32 0>
;
  %r = call <2 x i32> @llvm.fptoui.sat.v2i32.v2f32(<2 x float> <float 42.5, float -42.5>)
  ret <2 x i32> %r
}
