/* SPDX-License-Identifier: (BSD-3-Clause)
 * Copyright(c) 2018-2020 Intel Corporation
 */

#ifndef TEST_COMPRESSDEV_TEST_BUFFERS_H_
#define TEST_COMPRESSDEV_TEST_BUFFERS_H_

/*
 * These test buffers are snippets obtained
 * from the Canterbury and Calgary Corpus
 * collection.
 */

/* Snippet of Alice's Adventures in Wonderland */
static const char test_buf_alice[] =
	"  Alice was beginning to get very tired of sitting by her sister\n"
	"on the bank, and of having nothing to do:  once or twice she had\n"
	"peeped into the book her sister was reading, but it had no\n"
	"pictures or conversations in it, `and what is the use of a book,'\n"
	"thought Alice `without pictures or conversation?'\n\n"
	"  So she was considering in her own mind (as well as she could,\n"
	"for the hot day made her feel very sleepy and stupid), whether\n"
	"the pleasure of making a daisy-chain would be worth the trouble\n"
	"of getting up and picking the daisies, when suddenly a White\n"
	"Rabbit with pink eyes ran close by her.\n\n"
	"  There was nothing so VERY remarkable in that; nor did Alice\n"
	"think it so VERY much out of the way to hear the Rabbit say to\n"
	"itself, `Oh dear!  Oh dear!  I shall be late!'  (when she thought\n"
	"it over afterwards, it occurred to her that she ought to have\n"
	"wondered at this, but at the time it all seemed quite natural);\n"
	"but when the Rabbit actually TOOK A WATCH OUT OF ITS WAISTCOAT-\n"
	"POCKET, and looked at it, and then hurried on, Alice started to\n"
	"her feet, for it flashed across her mind that she had never\n"
	"before seen a rabbit with either a waistcoat-pocket, or a watch to\n"
	"take out of it, and burning with curiosity, she ran across the\n"
	"field after it, and fortunately was just in time to see it pop\n"
	"down a large rabbit-hole under the hedge.\n\n"
	"  In another moment down went Alice after it, never once\n"
	"considering how in the world she was to get out again.\n\n"
	"  The rabbit-hole went straight on like a tunnel for some way,\n"
	"and then dipped suddenly down, so suddenly that Alice had not a\n"
	"moment to think about stopping herself before she found herself\n"
	"falling down a very deep well.\n\n"
	"  Either the well was very deep, or she fell very slowly, for she\n"
	"had plenty of time as she went down to look about her and to\n"
	"wonder what was going to happen next.  First, she tried to look\n"
	"down and make out what she was coming to, but it was too dark to\n"
	"see anything; then she looked at the sides of the well, and\n"
	"noticed that they were filled with cupboards and book-shelves;\n"
	"here and there she saw maps and pictures hung upon pegs.  She\n"
	"took down a jar from one of the shelves as she passed; it was\n"
	"labelled `ORANGE MARMALADE', but to her great disappointment it\n"
	"was empty:  she did not like to drop the jar for fear of killing\n"
	"somebody, so managed to put it into one of the cupboards as she\n"
	"fell past it.\n\n"
	"  `Well!' thought Alice to herself, `after such a fall as this, I\n"
	"shall think nothing of tumbling down stairs!  How brave they'll\n"
	"all think me at home!  Why, I wouldn't say anything about it,\n"
	"even if I fell off the top of the house!' (Which was very likely\n"
	"true.)\n\n"
	"  Down, down, down.  Would the fall NEVER come to an end!  `I\n"
	"wonder how many miles I've fallen by this time?' she said aloud.\n"
	"`I must be getting somewhere near the centre of the earth.  Let\n"
	"me see:  that would be four thousand miles down, I think--' (for,\n"
	"you see, Alice had learnt several things of this sort in her\n"
	"lessons in the schoolroom, and though this was not a VERY good\n"
	"opportunity for showing off her knowledge, as there was no one to\n"
	"listen to her, still it was good practice to say it over) `--yes,\n"
	"that's about the right distance--but then I wonder what Latitude\n"
	"or Longitude I've got to?'  (Alice had no idea what Latitude was,\n"
	"or Longitude either, but thought they were nice grand words to\n"
	"say.)\n\n"
	"  Presently she began again.  `I wonder if I shall fall right\n"
	"THROUGH the earth!  How funny it'll seem to come out among the\n"
	"people that walk with their heads downward!  The Antipathies, I\n"
	"think--' (she was rather glad there WAS no one listening, this\n"
	"time, as it didn't sound at all the right word) `--but I shall\n"
	"have to ask them what the name of the country is, you know.\n"
	"Please, Ma'am, is this New Zealand or Australia?' (and she tried\n"
	"to curtsey as she spoke--fancy CURTSEYING as you're falling\n"
	"through the air!  Do you think you could manage it?)  `And what\n"
	"an ignorant little girl she'll think me for asking!  No, it'll\n"
	"never do to ask:  perhaps I shall see it written up somewhere.'\n"
	"  Down, down, down.  There was nothing else to do, so Alice soon\n"
	"began talking again.  `Dinah'll miss me very much to-night, I\n"
	"should think!'  (Dinah was the cat.)  `I hope they'll remember\n"
	"her saucer of milk at tea-time.  Dinah my dear!  I wish you were\n"
	"down here with me!  There are no mice in the air, I'm afraid, but\n"
	"you might catch a bat, and that's very like a mouse, you know.\n"
	"But do cats eat bats, I wonder?'  And here Alice began to get\n"
	"rather sleepy, and went on saying to herself, in a dreamy sort of\n"
	"way, `Do cats eat bats?  Do cats eat bats?' and sometimes, `Do\n"
	"bats eat cats?' for, you see, as she couldn't answer either\n"
	"question, it didn't much matter which way she put it.  She felt\n"
	"that she was dozing off, and had just begun to dream that she\n"
	"was walking hand in hand with Dinah, and saying to her very\n"
	"earnestly, `Now, Dinah, tell me the truth:  did you ever eat a\n"
	"bat?' when suddenly, thump! thump! down she came upon a heap of\n"
	"sticks and dry leaves, and the fall was over.\n\n";

/* Snippet of Shakespeare play */
static const char test_buf_shakespeare[] =
	"CHARLES	wrestler to Frederick.\n"
	"\n"
	"\n"
	"OLIVER		|\n"
	"		|\n"
	"JAQUES (JAQUES DE BOYS:)  	|  sons of Sir Rowland de Boys.\n"
	"		|\n"
	"ORLANDO		|\n"
	"\n"
	"\n"
	"ADAM	|\n"
	"	|  servants to Oliver.\n"
	"DENNIS	|\n"
	"\n"
	"\n"
	"TOUCHSTONE	a clown.\n"
	"\n"
	"SIR OLIVER MARTEXT	a vicar.\n"
	"\n"
	"\n"
	"CORIN	|\n"
	"	|  shepherds.\n"
	"SILVIUS	|\n"
	"\n"
	"\n"
	"WILLIAM	a country fellow in love with Audrey.\n"
	"\n"
	"	A person representing HYMEN. (HYMEN:)\n"
	"\n"
	"ROSALIND	daughter to the banished duke.\n"
	"\n"
	"CELIA	daughter to Frederick.\n"
	"\n"
	"PHEBE	a shepherdess.\n"
	"\n"
	"AUDREY	a country wench.\n"
	"\n"
	"	Lords, pages, and attendants, &c.\n"
	"	(Forester:)\n"
	"	(A Lord:)\n"
	"	(First Lord:)\n"
	"	(Second Lord:)\n"
	"	(First Page:)\n"
	"	(Second Page:)\n"
	"\n"
	"\n"
	"SCENE	Oliver's house; Duke Frederick's court; and the\n"
	"	Forest of Arden.\n"
	"\n"
	"\n"
	"\n"
	"\n"
	"	AS YOU LIKE IT\n"
	"\n"
	"\n"
	"ACT I\n"
	"\n"
	"\n"
	"\n"
	"SCENE I	Orchard of Oliver's house.\n"
	"\n"
	"\n"
	"	[Enter ORLANDO and ADAM]\n"
	"\n"
	"ORLANDO	As I remember, Adam, it was upon this fashion\n"
	"	bequeathed me by will but poor a thousand crowns,\n"
	"	and, as thou sayest, charged my brother, on his\n"
	"	blessing, to breed me well: and there begins my\n"
	"	sadness. My brother Jaques he keeps at school, and\n"
	"	report speaks goldenly of his profit: for my part,\n"
	"	he keeps me rustically at home, or, to speak more\n"
	"	properly, stays me here at home unkept; for call you\n"
	"	that keeping for a gentleman of my birth, that\n"
	"	differs not from the stalling of an ox? His horses\n"
	"	are bred better; for, besides that they are fair\n"
	"	with their feeding, they are taught their manage,\n"
	"	and to that end riders dearly hired: but I, his\n"
	"	brother, gain nothing under him but growth; for the\n"
	"	which his animals on his dunghills are as much\n"
	"	bound to him as I. Besides this nothing that he so\n"
	"	plentifully gives me, the something that nature gave\n"
	"	me his countenance seems to take from me: he lets\n"
	"	me feed with his hinds, bars me the place of a\n"
	"	brother, and, as much as in him lies, mines my\n"
	"	gentility with my education. This is it, Adam, that\n"
	"	grieves me; and the spirit of my father, which I\n"
	"	think is within me, begins to mutiny against this\n"
	"	servitude: I will no longer endure it, though yet I\n"
	"	know no wise remedy how to avoid it.\n"
	"\n"
	"ADAM	Yonder comes my master, your brother.\n"
	"\n"
	"ORLANDO	Go apart, Adam, and thou shalt hear how he will\n";

/* Snippet of Alice's Adventures in Wonderland */
static const char test_buf_alice2[] =
	"`Curiouser and curiouser!' cried Alice (she was so much\n"
	"surprised, that for the moment she quite forgot how to speak good\n"
	"English); `now I'm opening out like the largest telescope that\n"
	"ever was!  Good-bye, feet!' (for when she looked down at her\n"
	"feet, they seemed to be almost out of sight, they were getting so\n"
	"far off).  `Oh, my poor little feet, I wonder who will put on\n"
	"your shoes and stockings for you now, dears?  I'm sure _I_ shan't\n"
	"be able!  I shall be a great deal too far off to trouble myself\n"
	"about you:  you must manage the best way you can; --but I must be\n"
	"kind to them,' thought Alice, `or perhaps they won't walk the\n"
	"way I want to go!  Let me see:  I'll give them a new pair of\n"
	"boots every Christmas.'\n"
	"\n"
	"  And she went on planning to herself how she would manage it.\n"
	"`They must go by the carrier,' she thought; `and how funny it'll\n"
	"seem, sending presents to one's own feet!  And how odd the\n"
	"directions will look!\n"
	"\n"
	"	    ALICE'S RIGHT FOOT, ESQ.\n"
	"		HEARTHRUG,\n"
	"		    NEAR THE FENDER,\n"
	"			(WITH ALICE'S LOVE).\n"
	"\n"
	"Oh dear, what nonsense I'm talking!'\n"
	"\n"
	"  Just then her head struck against the roof of the hall:  in\n"
	"fact she was now more than nine feet high, and she at once took\n"
	"up the little golden key and hurried off to the garden door.\n"
	"\n"
	"  Poor Alice!  It was as much as she could do, lying down on one\n"
	"side, to look through into the garden with one eye; but to get\n"
	"through was more hopeless than ever:  she sat down and began to\n"
	"cry again.\n"
	"\n"
	"  `You ought to be ashamed of yourself,' said Alice, `a great\n"
	"girl like you,' (she might well say this), `to go on crying in\n"
	"this way!  Stop this moment, I tell you!'  But she went on all\n"
	"the same, shedding gallons of tears, until there was a large pool\n"
	"all round her, about four inches deep and reaching half down the\n"
	"hall.\n"
	"\n"
	" After a time she heard a little pattering of feet in the\n"
	"distance, and she hastily dried her eyes to see what was coming.\n"
	"It was the White Rabbit returning, splendidly dressed, with a\n"
	"pair of white kid gloves in one hand and a large fan in the\n"
	"other:  he came trotting along in a great hurry, muttering to\n"
	"himself as he came, `Oh! the Duchess, the Duchess! Oh! won't she\n"
	"be savage if I've kept her waiting!'  Alice felt so desperate\n"
	"that she was ready to ask help of any one; so, when the Rabbit\n"
	"came near her, she began, in a low, timid voice, `If you please,\n"
	"sir--'  The Rabbit started violently, dropped the white kid\n"
	"gloves and the fan, and skurried away into the darkness as hard\n"
	"as he could go.\n"
	"\n"
	"  Alice took up the fan and gloves, and, as the hall was very\n"
	"hot, she kept fanning herself all the time she went on talking:\n"
	"`Dear, dear!  How queer everything is to-day!  And yesterday\n"
	"things went on just as usual.  I wonder if I've been changed in\n"
	"the night?  Let me think:  was I the same when I got up this\n"
	"morning?  I almost think I can remember feeling a little\n"
	"different.  But if I'm not the same, the next question is, Who in\n"
	"the world am I?  Ah, THAT'S the great puzzle!'  And she began\n"
	"thinking over all the children she knew that were of the same age\n"
	"as herself, to see if she could have been changed for any of\n"
	"them.\n"
	"\n"
	"  `I'm sure I'm not Ada,' she said, `for her hair goes in such\n"
	"long ringlets, and mine doesn't go in ringlets at all; and I'm\n"
	"sure I can't be Mabel, for I know all sorts of things, and she,\n"
	"oh! she knows such a very little!  Besides, SHE'S she, and I'm I,\n"
	"and--oh dear, how puzzling it all is!  I'll try if I know all the\n"
	"things I used to know.  Let me see:  four times five is twelve,\n"
	"and four times six is thirteen, and four times seven is--oh dear!\n"
	"I shall never get to twenty at that rate!  However, the\n"
	"Multiplication Table doesn't signify:  let's try Geography.\n"
	"London is the capital of Paris, and Paris is the capital of Rome,\n"
	"and Rome--no, THAT'S all wrong, I'm certain!  I must have been\n"
	"changed for Mabel!  I'll try and say ''How doth the little--''\n"
	"and she crossed her hands on her lap as if she were saying lessons,\n"
	"and began to repeat it, but her voice sounded hoarse and\n"
	"strange, and the words did not come the same as they used to do:--\n"
	"\n"
	"	    `How doth the little crocodile\n"
	"	      Improve his shining tail,\n"
	"	    And pour the waters of the Nile\n"
	"	      On every golden scale!\n"
	"\n"
	"	    `How cheerfully he seems to grin,\n"
	"	      How neatly spread his claws,\n"
	"	    And welcome little fishes in\n"
	"	      With gently smiling jaws!'\n";

static const char * const compress_test_bufs[] = {
	test_buf_alice,
	test_buf_shakespeare,
	test_buf_alice2
};

#endif /* TEST_COMPRESSDEV_TEST_BUFFERS_H_ */
