.. -*- rst -*-

=======
Subnets
=======

Lists, shows details for, creates, updates, and deletes subnet
resources.

List subnets
============

.. rest_method::  GET /v2.0/subnets

Lists subnets that the project has access to.

Default policy settings return only subnets owned by the
project of the user submitting the request, unless the
user has administrative role. You can control which attributes
are returned by using the fields query parameter. You can filter
results by using query string parameters.

Use the ``fields`` query parameter to control which fields are
returned in the response body. Additionally, you can filter results
by using query string parameters. For information, see `Filtering
and Column Selection <https://wiki.openstack.org/wiki/Neutron/APIv2
-specification#Filtering_and_Column_Selection>`__.

Normal response codes: 200

Error response codes: 401

Request
-------

.. rest_parameters:: parameters.yaml

   - fields: fields

Response Parameters
-------------------

.. rest_parameters:: parameters.yaml

   - subnets: subnets-obj
   - id: subnet-id-body
   - tenant_id: project_id
   - project_id: project_id
   - name: subnet-name
   - enable_dhcp: subnet-enable_dhcp
   - network_id: subnet-network_id
   - dns_nameservers: subnet-dns_nameservers
   - allocation_pools: subnet-allocation_pools
   - host_routes: subnet-host_routes
   - ip_version: subnet-ip_version
   - gateway_ip: subnet-gateway_ip
   - cidr: cidr
   - created_at: subnet-created_at
   - description: subnet-description
   - ipv6_address_mode: subnet-ipv6_address_mode
   - ipv6_ra_mode: subnet-ipv6_ra_mode
   - revision_number: subnet-revision_number
   - segment_id: subnet-segment_id
   - service_types: subnet-service_types
   - subnetpool_id: subnet-subnetpool_id
   - updated_at: subnet-updated_at

Response Example
----------------

.. literalinclude:: samples/subnets/subnets-list-response.json
   :language: javascript

Create subnet
=============

.. rest_method::  POST /v2.0/subnets

Creates a subnet on a network.

OpenStack Networking does not try to derive the correct IP version
from the CIDR. If you do not specify the ``gateway_ip`` attribute,
OpenStack Networking allocates an address from the CIDR for the
gateway for the subnet.

To specify a subnet without a gateway, set the ``gateway_ip``
attribute to ``null`` in the request body. If you do not specify
the ``allocation_pools`` attribute, OpenStack Networking
automatically allocates pools for covering all IP addresses in the
CIDR, excluding the address reserved for the subnet gateway.
Otherwise, you can explicitly specify allocation pools as shown in
the following example.

When you specify both the ``allocation_pools`` and ``gateway_ip``
attributes, you must ensure that the gateway IP does not overlap
with the allocation pools; otherwise, the call returns the
``Conflict (409)`` response code.

A subnet can have one or more name servers and host routes. Hosts
in this subnet use the name servers. Devices with IP addresses from
this subnet, not including the local subnet route, use the host
routes.

Specify the ``ipv6_ra_mode`` and ``ipv6_address_mode`` attributes
to create subnets that support IPv6 configurations, such as
stateless address autoconfiguration (SLAAC), DHCPv6 stateful, and
DHCPv6 stateless configurations.

A subnet can optionally be associated with a network segment when
it is created by specifying the ``segment_id`` of a valid segment
on the specified network. A network with subnets associated in this
way is called a routed network. On any given network, all of the
subnets must be associated with segments or none of them can be.
Neutron enforces this invariant. Currently, routed networks are
only supported for provider networks.

Normal response codes: 201

Error response codes: 404, 403, 401, 400, 409

Request
-------

.. rest_parameters:: parameters.yaml

   - subnet: subnet-obj
   - tenant_id: project_id-request
   - project_id: project_id-request
   - name: subnet-name-request
   - enable_dhcp: subnet-enable_dhcp-request
   - network_id: subnet-network_id
   - dns_nameservers: subnet-dns_nameservers-request
   - allocation_pools: subnet-allocation_pools-request
   - host_routes: subnet-host_routes-request
   - ip_version: subnet-ip_version
   - gateway_ip: subnet-gateway_ip-request
   - cidr: cidr
   - description: description-request
   - ipv6_address_mode: subnet-ipv6_address_mode-request
   - ipv6_ra_mode: subnet-ipv6_ra_mode-request
   - segment_id: subnet-segment_id-request
   - subnetpool_id: subnet-subnetpool_id-request

Request Example
---------------

.. literalinclude:: samples/subnets/subnet-create-request.json
   :language: javascript

Response Parameters
-------------------

.. rest_parameters:: parameters.yaml

   - subnet: subnet-obj
   - id: subnet-id-body
   - tenant_id: project_id
   - project_id: project_id
   - name: subnet-name
   - enable_dhcp: subnet-enable_dhcp
   - network_id: subnet-network_id
   - dns_nameservers: subnet-dns_nameservers
   - allocation_pools: subnet-allocation_pools
   - host_routes: subnet-host_routes
   - ip_version: subnet-ip_version
   - gateway_ip: subnet-gateway_ip
   - cidr: cidr
   - created_at: subnet-created_at
   - description: subnet-description
   - ipv6_address_mode: subnet-ipv6_address_mode
   - ipv6_ra_mode: subnet-ipv6_ra_mode
   - revision_number: subnet-revision_number
   - service_types: subnet-service_types
   - subnetpool_id: subnet-subnetpool_id
   - segment_id: subnet-segment_id
   - updated_at: subnet-updated_at

Response Example
----------------

.. literalinclude:: samples/subnets/subnet-create-response.json
   :language: javascript

Bulk create subnet
==================

.. rest_method::  POST /v2.0/subnets

Creates multiple subnets in a single request. Specify a list of subnets in the request body.

The bulk create operation is always atomic. Either all or no
subnets in the request body are created.

Normal response codes: 201

Error response codes: 404, 403, 401, 400, 409

Request
-------

.. rest_parameters:: parameters.yaml

   - subnets: subnets-obj
   - tenant_id: project_id-request
   - project_id: project_id-request
   - name: subnet-name-request
   - enable_dhcp: subnet-enable_dhcp-request
   - network_id: subnet-network_id
   - dns_nameservers: subnet-dns_nameservers-request
   - allocation_pools: subnet-allocation_pools-request
   - host_routes: subnet-host_routes-request
   - ip_version: subnet-ip_version
   - gateway_ip: subnet-gateway_ip-request
   - cidr: cidr
   - description: description-request
   - ipv6_address_mode: subnet-ipv6_address_mode-request
   - ipv6_ra_mode: subnet-ipv6_ra_mode-request
   - segment_id: subnet-segment_id-request
   - subnetpool_id: subnet-subnetpool_id-request

Request Example
---------------

.. literalinclude:: samples/subnets/subnets-create-bulk-request.json
   :language: javascript

Response Parameters
-------------------

.. rest_parameters:: parameters.yaml

   - subnets: subnets-obj
   - id: subnet-id-body
   - tenant_id: project_id
   - project_id: project_id
   - name: subnet-name
   - enable_dhcp: subnet-enable_dhcp
   - network_id: subnet-network_id
   - dns_nameservers: subnet-dns_nameservers
   - allocation_pools: subnet-allocation_pools
   - host_routes: subnet-host_routes
   - ip_version: subnet-ip_version
   - gateway_ip: subnet-gateway_ip
   - cidr: cidr
   - created_at: subnet-created_at
   - description: subnet-description
   - ipv6_address_mode: subnet-ipv6_address_mode
   - ipv6_ra_mode: subnet-ipv6_ra_mode
   - revision_number: subnet-revision_number
   - segment_id: subnet-segment_id
   - service_types: subnet-service_types
   - subnetpool_id: subnet-subnetpool_id
   - updated_at: subnet-updated_at

Response Example
----------------

.. literalinclude:: samples/subnets/subnets-create-bulk-response.json
   :language: javascript

Show subnet details
===================

.. rest_method::  GET /v2.0/subnets/{subnet_id}

Shows details for a subnet.

Use the fields query parameter to filter the results.

Normal response codes: 200

Error response codes: 404,401

Request
-------

.. rest_parameters:: parameters.yaml

   - subnet_id: subnet_id-path

Response Parameters
-------------------

.. rest_parameters:: parameters.yaml

   - subnet: subnet-obj
   - id: subnet-id-body
   - tenant_id: project_id
   - project_id: project_id
   - created_at: subnet-created_at
   - name: subnet-name
   - enable_dhcp: subnet-enable_dhcp
   - network_id: subnet-network_id
   - dns_nameservers: subnet-dns_nameservers
   - allocation_pools: subnet-allocation_pools
   - host_routes: subnet-host_routes
   - ip_version: subnet-ip_version
   - gateway_ip: subnet-gateway_ip
   - cidr: cidr
   - updated_at: subnet-updated_at
   - description: subnet-description
   - ipv6_address_mode: subnet-ipv6_address_mode
   - ipv6_ra_mode: subnet-ipv6_ra_mode
   - revision_number: subnet-revision_number
   - segment_id: subnet-segment_id
   - service_types: subnet-service_types
   - subnetpool_id: subnet-subnetpool_id

Response Example
----------------

.. literalinclude:: samples/subnets/subnet-show-response.json
   :language: javascript

Update subnet
=============

.. rest_method::  PUT /v2.0/subnets/{subnet_id}

Updates a subnet.

Some attributes, such as IP version (ip_version), CIDR (cidr), and
segment (segment_id) cannot be updated. Attempting to update these
attributes results in a ``400 Bad Request`` error.

Normal response codes: 200

Error response codes: 404,403,401,400

Request
-------

.. rest_parameters:: parameters.yaml

   - subnet_id: subnet_id-path
   - name: subnet-name-update-request
   - enable_dhcp: subnet-enable_dhcp-request
   - dns_nameservers: subnet-dns_nameservers-request
   - allocation_pools: subnet-allocation_pools-request
   - host_routes: subnet-host_routes-request
   - gateway_ip: subnet-gateway_ip-request

Request Example
---------------

.. literalinclude:: samples/subnets/subnet-update-request.json
   :language: javascript

Response Parameters
-------------------

.. rest_parameters:: parameters.yaml

   - subnet: subnet-obj
   - id: subnet-id-body
   - tenant_id: project_id
   - project_id: project_id
   - name: subnet-name
   - enable_dhcp: subnet-enable_dhcp
   - network_id: subnet-network_id
   - dns_nameservers: subnet-dns_nameservers
   - allocation_pools: subnet-allocation_pools
   - host_routes: subnet-host_routes
   - ip_version: subnet-ip_version
   - gateway_ip: subnet-gateway_ip
   - cidr: cidr
   - created_at: subnet-created_at
   - description: subnet-description
   - ipv6_address_mode: subnet-ipv6_address_mode
   - ipv6_ra_mode: subnet-ipv6_ra_mode
   - revision_number: subnet-revision_number
   - segment_id: subnet-segment_id
   - service_types: subnet-service_types
   - subnetpool_id: subnet-subnetpool_id
   - updated_at: subnet-updated_at

Response Example
----------------

.. literalinclude:: samples/subnets/subnet-update-response.json
   :language: javascript

Delete subnet
=============

.. rest_method::  DELETE /v2.0/subnets/{subnet_id}

Deletes a subnet.

The operation fails if subnet IP addresses are still allocated.

Normal response codes: 204

Error response codes: 404, 401

Request
-------

.. rest_parameters:: parameters.yaml

   - subnet_id: subnet_id-path

Response
--------

There is no body content for the response of a successful DELETE request.

