# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AccessKeys(msrest.serialization.Model):
    """The secret access keys used for authenticating connections to redis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_key: The current primary key that clients can use to authenticate.
    :vartype primary_key: str
    :ivar secondary_key: The current secondary key that clients can use to authenticate.
    :vartype secondary_key: str
    """

    _validation = {
        'primary_key': {'readonly': True},
        'secondary_key': {'readonly': True},
    }

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessKeys, self).__init__(**kwargs)
        self.primary_key = None
        self.secondary_key = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class Cluster(TrackedResource):
    """Describes the RedisEnterprise cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param sku: Required. The SKU to create, which affects price, performance, and features.
    :type sku: ~azure.mgmt.redisenterprise.models.Sku
    :param zones: The Availability Zones where this cluster will be deployed.
    :type zones: list[str]
    :param minimum_tls_version: The minimum TLS version for the cluster to support, e.g. '1.2'.
     Possible values include: "1.0", "1.1", "1.2".
    :type minimum_tls_version: str or ~azure.mgmt.redisenterprise.models.TlsVersion
    :ivar host_name: DNS name of the cluster endpoint.
    :vartype host_name: str
    :ivar provisioning_state: Current provisioning status of the cluster. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.redisenterprise.models.ProvisioningState
    :ivar resource_state: Current resource status of the cluster. Possible values include:
     "Running", "Creating", "CreateFailed", "Updating", "UpdateFailed", "Deleting", "DeleteFailed",
     "Enabling", "EnableFailed", "Disabling", "DisableFailed", "Disabled".
    :vartype resource_state: str or ~azure.mgmt.redisenterprise.models.ResourceState
    :ivar redis_version: Version of redis the cluster supports, e.g. '6'.
    :vartype redis_version: str
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     specified RedisEnterprise cluster.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.redisenterprise.models.PrivateEndpointConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'host_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
        'redis_version': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'redis_version': {'key': 'properties.redisVersion', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Cluster, self).__init__(**kwargs)
        self.sku = kwargs['sku']
        self.zones = kwargs.get('zones', None)
        self.minimum_tls_version = kwargs.get('minimum_tls_version', None)
        self.host_name = None
        self.provisioning_state = None
        self.resource_state = None
        self.redis_version = None
        self.private_endpoint_connections = None


class ClusterList(msrest.serialization.Model):
    """The response of a list-all operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of clusters.
    :type value: list[~azure.mgmt.redisenterprise.models.Cluster]
    :ivar next_link: The URI to fetch the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Cluster]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ClusterUpdate(msrest.serialization.Model):
    """A partial update to the RedisEnterprise cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param sku: The SKU to create, which affects price, performance, and features.
    :type sku: ~azure.mgmt.redisenterprise.models.Sku
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param minimum_tls_version: The minimum TLS version for the cluster to support, e.g. '1.2'.
     Possible values include: "1.0", "1.1", "1.2".
    :type minimum_tls_version: str or ~azure.mgmt.redisenterprise.models.TlsVersion
    :ivar host_name: DNS name of the cluster endpoint.
    :vartype host_name: str
    :ivar provisioning_state: Current provisioning status of the cluster. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.redisenterprise.models.ProvisioningState
    :ivar resource_state: Current resource status of the cluster. Possible values include:
     "Running", "Creating", "CreateFailed", "Updating", "UpdateFailed", "Deleting", "DeleteFailed",
     "Enabling", "EnableFailed", "Disabling", "DisableFailed", "Disabled".
    :vartype resource_state: str or ~azure.mgmt.redisenterprise.models.ResourceState
    :ivar redis_version: Version of redis the cluster supports, e.g. '6'.
    :vartype redis_version: str
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     specified RedisEnterprise cluster.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.redisenterprise.models.PrivateEndpointConnection]
    """

    _validation = {
        'host_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
        'redis_version': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'redis_version': {'key': 'properties.redisVersion', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterUpdate, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.tags = kwargs.get('tags', None)
        self.minimum_tls_version = kwargs.get('minimum_tls_version', None)
        self.host_name = None
        self.provisioning_state = None
        self.resource_state = None
        self.redis_version = None
        self.private_endpoint_connections = None


class Database(Resource):
    """Describes a database on the RedisEnterprise cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param client_protocol: Specifies whether redis clients can connect using TLS-encrypted or
     plaintext redis protocols. Default is TLS-encrypted. Possible values include: "Encrypted",
     "Plaintext".
    :type client_protocol: str or ~azure.mgmt.redisenterprise.models.Protocol
    :param port: TCP port of the database endpoint. Specified at create time. Defaults to an
     available port.
    :type port: int
    :ivar provisioning_state: Current provisioning status of the database. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.redisenterprise.models.ProvisioningState
    :ivar resource_state: Current resource status of the database. Possible values include:
     "Running", "Creating", "CreateFailed", "Updating", "UpdateFailed", "Deleting", "DeleteFailed",
     "Enabling", "EnableFailed", "Disabling", "DisableFailed", "Disabled".
    :vartype resource_state: str or ~azure.mgmt.redisenterprise.models.ResourceState
    :param clustering_policy: Clustering policy - default is OSSCluster. Specified at create time.
     Possible values include: "EnterpriseCluster", "OSSCluster".
    :type clustering_policy: str or ~azure.mgmt.redisenterprise.models.ClusteringPolicy
    :param eviction_policy: Redis eviction policy - default is VolatileLRU. Possible values
     include: "AllKeysLFU", "AllKeysLRU", "AllKeysRandom", "VolatileLRU", "VolatileLFU",
     "VolatileTTL", "VolatileRandom", "NoEviction".
    :type eviction_policy: str or ~azure.mgmt.redisenterprise.models.EvictionPolicy
    :param persistence: Persistence settings.
    :type persistence: ~azure.mgmt.redisenterprise.models.Persistence
    :param modules: Optional set of redis modules to enable in this database - modules can only be
     added at creation time.
    :type modules: list[~azure.mgmt.redisenterprise.models.Module]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'client_protocol': {'key': 'properties.clientProtocol', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'clustering_policy': {'key': 'properties.clusteringPolicy', 'type': 'str'},
        'eviction_policy': {'key': 'properties.evictionPolicy', 'type': 'str'},
        'persistence': {'key': 'properties.persistence', 'type': 'Persistence'},
        'modules': {'key': 'properties.modules', 'type': '[Module]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Database, self).__init__(**kwargs)
        self.client_protocol = kwargs.get('client_protocol', None)
        self.port = kwargs.get('port', None)
        self.provisioning_state = None
        self.resource_state = None
        self.clustering_policy = kwargs.get('clustering_policy', None)
        self.eviction_policy = kwargs.get('eviction_policy', None)
        self.persistence = kwargs.get('persistence', None)
        self.modules = kwargs.get('modules', None)


class DatabaseList(msrest.serialization.Model):
    """The response of a list-all operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of databases.
    :type value: list[~azure.mgmt.redisenterprise.models.Database]
    :ivar next_link: The URI to fetch the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Database]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class DatabaseUpdate(msrest.serialization.Model):
    """A partial update to the RedisEnterprise database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param client_protocol: Specifies whether redis clients can connect using TLS-encrypted or
     plaintext redis protocols. Default is TLS-encrypted. Possible values include: "Encrypted",
     "Plaintext".
    :type client_protocol: str or ~azure.mgmt.redisenterprise.models.Protocol
    :param port: TCP port of the database endpoint. Specified at create time. Defaults to an
     available port.
    :type port: int
    :ivar provisioning_state: Current provisioning status of the database. Possible values include:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.redisenterprise.models.ProvisioningState
    :ivar resource_state: Current resource status of the database. Possible values include:
     "Running", "Creating", "CreateFailed", "Updating", "UpdateFailed", "Deleting", "DeleteFailed",
     "Enabling", "EnableFailed", "Disabling", "DisableFailed", "Disabled".
    :vartype resource_state: str or ~azure.mgmt.redisenterprise.models.ResourceState
    :param clustering_policy: Clustering policy - default is OSSCluster. Specified at create time.
     Possible values include: "EnterpriseCluster", "OSSCluster".
    :type clustering_policy: str or ~azure.mgmt.redisenterprise.models.ClusteringPolicy
    :param eviction_policy: Redis eviction policy - default is VolatileLRU. Possible values
     include: "AllKeysLFU", "AllKeysLRU", "AllKeysRandom", "VolatileLRU", "VolatileLFU",
     "VolatileTTL", "VolatileRandom", "NoEviction".
    :type eviction_policy: str or ~azure.mgmt.redisenterprise.models.EvictionPolicy
    :param persistence: Persistence settings.
    :type persistence: ~azure.mgmt.redisenterprise.models.Persistence
    :param modules: Optional set of redis modules to enable in this database - modules can only be
     added at creation time.
    :type modules: list[~azure.mgmt.redisenterprise.models.Module]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'client_protocol': {'key': 'properties.clientProtocol', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'clustering_policy': {'key': 'properties.clusteringPolicy', 'type': 'str'},
        'eviction_policy': {'key': 'properties.evictionPolicy', 'type': 'str'},
        'persistence': {'key': 'properties.persistence', 'type': 'Persistence'},
        'modules': {'key': 'properties.modules', 'type': '[Module]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseUpdate, self).__init__(**kwargs)
        self.client_protocol = kwargs.get('client_protocol', None)
        self.port = kwargs.get('port', None)
        self.provisioning_state = None
        self.resource_state = None
        self.clustering_policy = kwargs.get('clustering_policy', None)
        self.eviction_policy = kwargs.get('eviction_policy', None)
        self.persistence = kwargs.get('persistence', None)
        self.modules = kwargs.get('modules', None)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.redisenterprise.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.redisenterprise.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~azure.mgmt.redisenterprise.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ExportClusterParameters(msrest.serialization.Model):
    """Parameters for a Redis Enterprise export operation.

    All required parameters must be populated in order to send to Azure.

    :param sas_uri: Required. SAS URI for the target directory to export to.
    :type sas_uri: str
    """

    _validation = {
        'sas_uri': {'required': True},
    }

    _attribute_map = {
        'sas_uri': {'key': 'sasUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExportClusterParameters, self).__init__(**kwargs)
        self.sas_uri = kwargs['sas_uri']


class ImportClusterParameters(msrest.serialization.Model):
    """Parameters for a Redis Enterprise import operation.

    All required parameters must be populated in order to send to Azure.

    :param sas_uri: Required. SAS URI for the target blob to import from.
    :type sas_uri: str
    """

    _validation = {
        'sas_uri': {'required': True},
    }

    _attribute_map = {
        'sas_uri': {'key': 'sasUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportClusterParameters, self).__init__(**kwargs)
        self.sas_uri = kwargs['sas_uri']


class Module(msrest.serialization.Model):
    """Specifies configuration of a redis module.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the module, e.g. 'RedisBloom', 'RediSearch',
     'RedisTimeSeries'.
    :type name: str
    :param args: Configuration options for the module, e.g. 'ERROR_RATE 0.00 INITIAL_SIZE 400'.
    :type args: str
    :ivar version: The version of the module, e.g. '1.0'.
    :vartype version: str
    """

    _validation = {
        'name': {'required': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'args': {'key': 'args', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Module, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.args = kwargs.get('args', None)
        self.version = None


class Operation(msrest.serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for data-
     plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :param display: Localized display information for this particular operation.
    :type display: ~azure.mgmt.redisenterprise.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Possible values include: "user",
     "system", "user,system".
    :vartype origin: str or ~azure.mgmt.redisenterprise.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Possible values include: "Internal".
    :vartype action_type: str or ~azure.mgmt.redisenterprise.models.ActionType
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = kwargs.get('display', None)
        self.origin = None
        self.action_type = None


class OperationDisplay(msrest.serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.redisenterprise.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationStatus(msrest.serialization.Model):
    """The status of a long-running operation.

    :param id: The operation's unique id.
    :type id: str
    :param name: The operation's name.
    :type name: str
    :param start_time: The start time of the operation.
    :type start_time: str
    :param end_time: The end time of the operation.
    :type end_time: str
    :param status: The current status of the operation.
    :type status: str
    :param error: Error response describing why the operation failed.
    :type error: ~azure.mgmt.redisenterprise.models.ErrorResponse
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationStatus, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class Persistence(msrest.serialization.Model):
    """Persistence-related configuration for the RedisEnterprise database.

    :param aof_enabled: Sets whether AOF is enabled.
    :type aof_enabled: bool
    :param rdb_enabled: Sets whether RDB is enabled.
    :type rdb_enabled: bool
    :param aof_frequency: Sets the frequency at which data is written to disk. Possible values
     include: "1s", "always".
    :type aof_frequency: str or ~azure.mgmt.redisenterprise.models.AofFrequency
    :param rdb_frequency: Sets the frequency at which a snapshot of the database is created.
     Possible values include: "1h", "6h", "12h".
    :type rdb_frequency: str or ~azure.mgmt.redisenterprise.models.RdbFrequency
    """

    _attribute_map = {
        'aof_enabled': {'key': 'aofEnabled', 'type': 'bool'},
        'rdb_enabled': {'key': 'rdbEnabled', 'type': 'bool'},
        'aof_frequency': {'key': 'aofFrequency', 'type': 'str'},
        'rdb_frequency': {'key': 'rdbFrequency', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Persistence, self).__init__(**kwargs)
        self.aof_enabled = kwargs.get('aof_enabled', None)
        self.rdb_enabled = kwargs.get('rdb_enabled', None)
        self.aof_frequency = kwargs.get('aof_frequency', None)
        self.rdb_frequency = kwargs.get('rdb_frequency', None)


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~azure.mgmt.redisenterprise.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.redisenterprise.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.redisenterprise.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :param value: Array of private endpoint connections.
    :type value: list[~azure.mgmt.redisenterprise.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = kwargs.get('required_zone_names', None)


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: Array of private link resources.
    :type value: list[~azure.mgmt.redisenterprise.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :param status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected".
    :type status: str or ~azure.mgmt.redisenterprise.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = kwargs.get('actions_required', None)


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class RegenerateKeyParameters(msrest.serialization.Model):
    """Specifies which access keys to reset to a new random value.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. Which access key to regenerate. Possible values include: "Primary",
     "Secondary".
    :type key_type: str or ~azure.mgmt.redisenterprise.models.AccessKeyType
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegenerateKeyParameters, self).__init__(**kwargs)
        self.key_type = kwargs['key_type']


class Sku(msrest.serialization.Model):
    """SKU parameters supplied to the create RedisEnterprise operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The type of RedisEnterprise cluster to deploy. Possible values:
     (Enterprise_E10, EnterpriseFlash_F300 etc.). Possible values include: "Enterprise_E10",
     "Enterprise_E20", "Enterprise_E50", "Enterprise_E100", "EnterpriseFlash_F300",
     "EnterpriseFlash_F700", "EnterpriseFlash_F1500".
    :type name: str or ~azure.mgmt.redisenterprise.models.SkuName
    :param capacity: The size of the RedisEnterprise cluster. Defaults to 2 or 3 depending on SKU.
     Valid values are (2, 4, 6, ...) for Enterprise SKUs and (3, 9, 15, ...) for Flash SKUs.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.capacity = kwargs.get('capacity', None)
