A Docker swarm cluster with Heat
==============================

These [Heat][] templates will deploy an *N*-node [swarm][] cluster,
where *N* is the value of the `number_of_nodes` parameter you
specify when creating the stack.

[heat]: https://wiki.openstack.org/wiki/Heat
[swarm]: https://github.com/docker/swarm/

## Requirements

### OpenStack

These templates will work with the Juno version of Heat.

### Guest image

These templates will work with either CentOS Atomic Host or Fedora 21
Atomic.

## Creating the stack

First, you must create a swarm token, which is used to uniquely identify
the cluster to the global discovery service. This can be done by issuing
a create call to the swarm CLI. Alternatively, if you have access to
Docker you can use the dockerswarm/swarm image.

    $ swarm create
    afeb445bcb2f573aeb8ff3a199785f45

    $ docker run dockerswarm/swarm create
    d8cdfe5128af6e1075b34aa06ff1cc2c

Creating an environment file `local.yaml` with parameters specific to
your environment:

    parameters:
      ssh_key_name: testkey
      external_network: 028d70dd-67b8-4901-8bdd-0c62b06cce2d
      dns_nameserver: 192.168.200.1
      server_image: fedora-atomic-newton
      discovery_url: token://d8cdfe5128af6e1075b34aa06ff1cc2c

And then create the stack, referencing that environment file:

    heat stack-create -f swarm.yaml -e local.yaml my-swarm-cluster

You must provide values for:

- `ssh_key_name`
- `external_network`
- `server_image`
- `discovery_url`

## Interacting with Swarm

The Docker CLI interacts with the cluster through the swarm master
listening on port 2376.

You can get the ip address of the swarm master using the `heat
output-show` command:

    $ heat output-show my-swarm-cluster swarm_master
    "192.168.200.86"

Provide the Docker CLI with the address for the swarm master.

    $ docker -H tcp://192.168.200.86:2376 info
    Containers: 4
    Nodes: 3
     swarm-master: 10.0.0.1:2375
     swarm-node1: 10.0.0.2:2375
     swarm-node2: 10.0.0.3:2375

## Testing

You can test the swarm cluster with the Docker CLI by running a container.
In the example below, a container is spawned in the cluster to ping 8.8.8.8.

    $ docker -H tcp://192.168.200.86:2376 run -i cirros /bin/ping -c 4 8.8.8.8
    PING 8.8.8.8 (8.8.8.8): 56 data bytes
    64 bytes from 8.8.8.8: seq=0 ttl=127 time=40.749 ms
    64 bytes from 8.8.8.8: seq=1 ttl=127 time=46.264 ms
    64 bytes from 8.8.8.8: seq=2 ttl=127 time=42.808 ms
    64 bytes from 8.8.8.8: seq=3 ttl=127 time=42.270 ms

    --- 8.8.8.8 ping statistics ---
    4 packets transmitted, 4 packets received, 0% packet loss
    round-trip min/avg/max = 40.749/43.022/46.264 ms

## License

Copyright 2014 Lars Kellogg-Stedman <lars@redhat.com>
Copyright 2015 Rackspace Hosting

Licensed under the Apache License, Version 2.0 (the "License");
you may not use these files except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
