/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbPooledConnection;
import org.mariadb.jdbc.MariaXaConnection;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.DefaultOptions;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.constant.HaMode;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbDataSource
implements DataSource,
ConnectionPoolDataSource,
XADataSource {
    private final UrlParser urlParser;

    public MariaDbDataSource(String hostname, int port, String database) throws SQLException {
        ArrayList<HostAddress> hostAddresses = new ArrayList<HostAddress>();
        hostAddresses.add(new HostAddress(hostname, port));
        this.urlParser = new UrlParser(database, hostAddresses, DefaultOptions.defaultValues(HaMode.NONE), HaMode.NONE);
    }

    public MariaDbDataSource(String url) throws SQLException {
        this.urlParser = UrlParser.parse(url);
    }

    public MariaDbDataSource() {
        ArrayList<HostAddress> hostAddresses = new ArrayList<HostAddress>();
        hostAddresses.add(new HostAddress("localhost", 3306));
        UrlParser tmpUrlParser = null;
        try {
            tmpUrlParser = new UrlParser("", hostAddresses, DefaultOptions.defaultValues(HaMode.NONE), HaMode.NONE);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.urlParser = tmpUrlParser;
    }

    public String getDatabaseName() {
        return this.urlParser.getDatabase() != null ? this.urlParser.getDatabase() : "";
    }

    public void setDatabaseName(String dbName) {
        this.urlParser.setDatabase(dbName);
    }

    public String getUser() {
        return this.urlParser.getUsername();
    }

    public void setUser(String userName) {
        this.setUserName(userName);
    }

    public String getUserName() {
        return this.urlParser.getUsername();
    }

    public void setUserName(String userName) {
        this.urlParser.setUsername(userName);
    }

    public void setPassword(String pass) {
        this.urlParser.setPassword(pass);
    }

    public int getPort() {
        return this.urlParser.getHostAddresses().get((int)0).port;
    }

    public void setPort(int port) {
        this.urlParser.getHostAddresses().get((int)0).port = port;
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public void setPortNumber(int port) {
        if (port > 0) {
            this.setPort(port);
        }
    }

    public void setProperties(String properties) {
        this.urlParser.setProperties(properties);
    }

    @Deprecated
    public void setURL(String url) throws SQLException {
        this.setUrl(url);
    }

    public void setUrl(String url) throws SQLException {
        this.urlParser.parseUrl(url);
    }

    public String getServerName() {
        return this.urlParser.getHostAddresses().get((int)0).host != null ? this.urlParser.getHostAddresses().get((int)0).host : "";
    }

    public void setServerName(String serverName) {
        if (serverName != null && !serverName.isEmpty()) {
            this.urlParser.getHostAddresses().get((int)0).host = serverName;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            ReentrantLock lock = new ReentrantLock();
            Protocol proxyfiedProtocol = Utils.retrieveProxy(this.urlParser, lock);
            return MariaDbConnection.newConnection(proxyfiedProtocol, lock);
        }
        catch (QueryException e2) {
            ExceptionMapper.throwException(e2, null, null);
            return null;
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.urlParser.setUsername(username);
        this.urlParser.setPassword(password);
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return new MariaDbPooledConnection((MariaDbConnection)this.getConnection());
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new MariaDbPooledConnection((MariaDbConnection)this.getConnection(user, password));
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return new MariaXaConnection((MariaDbConnection)this.getConnection());
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return new MariaXaConnection((MariaDbConnection)this.getConnection(user, password));
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

