/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.LongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class StreamParameter
extends LongDataParameterHolder {
    private InputStream is;
    private long length;
    private boolean noBackslashEscapes;
    private ArrayList<byte[]> readArrays = null;

    public StreamParameter(InputStream is, long length, boolean noBackslashEscapes) {
        this.is = is;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public StreamParameter(InputStream is, boolean noBackSlashEscapes) {
        this(is, Long.MAX_VALUE, noBackSlashEscapes);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.readArrays != null) {
            ParameterWriter.writeBytesArray(os, this.readArrays, this.noBackslashEscapes);
        } else if (this.length == Long.MAX_VALUE) {
            ParameterWriter.write(os, this.is, this.noBackslashEscapes);
        } else {
            ParameterWriter.write(os, this.is, this.length, this.noBackslashEscapes);
        }
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        if (this.length == Long.MAX_VALUE) {
            int len;
            this.readArrays = new ArrayList();
            int length = 0;
            byte[] buffer = new byte[1024];
            while ((len = this.is.read(buffer)) >= 0) {
                this.readArrays.add(buffer);
                buffer = new byte[1024];
                length += len;
            }
            this.is = null;
            return 2 + length * 2;
        }
        return this.length;
    }

    @Override
    public void writeBinary(PacketOutputStream os) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            os.sendStream(this.is);
        } else {
            os.sendStream(this.is, this.length);
        }
    }

    @Override
    public String toString() {
        return "<Stream> " + this.is;
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.BLOB;
    }
}

