/* composite.c - Tables for UCC.EAN Composite Symbols */

/*
    libzint - the open source barcode library
    Copyright (C) 2008 - 2020 Robin Stuart <rstuart114@gmail.com>

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the project nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
    OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
 */
/* vim: set ts=4 sw=4 et : */

/* CC-A component coefficients from ISO/IEC 24728:2006 Annex F */
static const unsigned short int ccaCoeffs[30] = {
    /* k = 4 */
    522, 568, 723, 809,

    /* k = 5 */
    427, 919, 460, 155, 566,

    /* k = 6 */
    861, 285, 19, 803, 17, 766,

    /* k = 7 */
    76, 925, 537, 597, 784, 691, 437,

    /* k = 8 */
    237, 308, 436, 284, 646, 653, 428, 379
};

/* rows, error codewords, k-offset of valid CC-A sizes from ISO/IEC 24723:2006 Table 9 */
static const char ccaVariants[51] = {
    5, 6, 7, 8, 9, 10, 12, 4, 5, 6, 7, 8, 3, 4, 5, 6, 7,
    4, 4, 5, 5, 6, 6, 7, 4, 5, 6, 7, 7, 4, 5, 6, 7, 8,
    0, 0, 4, 4, 9, 9, 15, 0, 4, 9, 15, 15, 0, 4, 9, 15, 22
};

/* following is Left RAP, Centre RAP, Right RAP and Start Cluster from ISO/IEC 24723:2006 tables 10 and 11 */
static const char aRAPTable[68] = {
    39, 1, 32, 8, 14, 43, 20, 11, 1, 5, 15, 21, 40, 43, 46, 34, 29,
    0, 0, 0, 0, 0, 0, 0, 43, 33, 37, 47, 1, 20, 23, 26, 14, 9,
    19, 33, 12, 40, 46, 23, 52, 23, 13, 17, 27, 33, 52, 3, 6, 46, 41,
    6, 0, 3, 3, 3, 0, 3, 3, 0, 3, 6, 6, 0, 0, 0, 0, 3
};

/* Row Address Patterns are as defined in pdf417.h */

/* Generated by tools/gen_pwr928_table.php */
static UINT pwr928[69][7] = {
    {   0,   0,   0,   0,   0,   0,   1, },
    {   0,   0,   0,   0,   0,   0,   2, },
    {   0,   0,   0,   0,   0,   0,   4, },
    {   0,   0,   0,   0,   0,   0,   8, },
    {   0,   0,   0,   0,   0,   0,  16, },
    {   0,   0,   0,   0,   0,   0,  32, },
    {   0,   0,   0,   0,   0,   0,  64, },
    {   0,   0,   0,   0,   0,   0, 128, },
    {   0,   0,   0,   0,   0,   0, 256, },
    {   0,   0,   0,   0,   0,   0, 512, },
    {   0,   0,   0,   0,   0,   1,  96, },
    {   0,   0,   0,   0,   0,   2, 192, },
    {   0,   0,   0,   0,   0,   4, 384, },
    {   0,   0,   0,   0,   0,   8, 768, },
    {   0,   0,   0,   0,   0,  17, 608, },
    {   0,   0,   0,   0,   0,  35, 288, },
    {   0,   0,   0,   0,   0,  70, 576, },
    {   0,   0,   0,   0,   0, 141, 224, },
    {   0,   0,   0,   0,   0, 282, 448, },
    {   0,   0,   0,   0,   0, 564, 896, },
    {   0,   0,   0,   0,   1, 201, 864, },
    {   0,   0,   0,   0,   2, 403, 800, },
    {   0,   0,   0,   0,   4, 807, 672, },
    {   0,   0,   0,   0,   9, 687, 416, },
    {   0,   0,   0,   0,  19, 446, 832, },
    {   0,   0,   0,   0,  38, 893, 736, },
    {   0,   0,   0,   0,  77, 859, 544, },
    {   0,   0,   0,   0, 155, 791, 160, },
    {   0,   0,   0,   0, 311, 654, 320, },
    {   0,   0,   0,   0, 623, 380, 640, },
    {   0,   0,   0,   1, 318, 761, 352, },
    {   0,   0,   0,   2, 637, 594, 704, },
    {   0,   0,   0,   5, 347, 261, 480, },
    {   0,   0,   0,  10, 694, 523,  32, },
    {   0,   0,   0,  21, 461, 118,  64, },
    {   0,   0,   0,  42, 922, 236, 128, },
    {   0,   0,   0,  85, 916, 472, 256, },
    {   0,   0,   0, 171, 905,  16, 512, },
    {   0,   0,   0, 343, 882,  33,  96, },
    {   0,   0,   0, 687, 836,  66, 192, },
    {   0,   0,   1, 447, 744, 132, 384, },
    {   0,   0,   2, 895, 560, 264, 768, },
    {   0,   0,   5, 863, 192, 529, 608, },
    {   0,   0,  11, 798, 385, 131, 288, },
    {   0,   0,  23, 668, 770, 262, 576, },
    {   0,   0,  47, 409, 612, 525, 224, },
    {   0,   0,  94, 819, 297, 122, 448, },
    {   0,   0, 189, 710, 594, 244, 896, },
    {   0,   0, 379, 493, 260, 489, 864, },
    {   0,   0, 759,  58, 521,  51, 800, },
    {   0,   1, 590, 117, 114, 103, 672, },
    {   0,   3, 252, 234, 228, 207, 416, },
    {   0,   6, 504, 468, 456, 414, 832, },
    {   0,  13,  81,   8, 912, 829, 736, },
    {   0,  26, 162,  17, 897, 731, 544, },
    {   0,  52, 324,  35, 867, 535, 160, },
    {   0, 104, 648,  71, 807, 142, 320, },
    {   0, 209, 368, 143, 686, 284, 640, },
    {   0, 418, 736, 287, 444, 569, 352, },
    {   0, 837, 544, 574, 889, 210, 704, },
    {   1, 747, 161, 221, 850, 421, 480, },
    {   3, 566, 322, 443, 772, 843,  32, },
    {   7, 204, 644, 887, 617, 758,  64, },
    {  14, 409, 361, 847, 307, 588, 128, },
    {  28, 818, 723, 766, 615, 248, 256, },
    {  57, 709, 519, 605, 302, 496, 512, },
    { 115, 491, 111, 282, 605,  65,  96, },
    { 231,  54, 222, 565, 282, 130, 192, },
    { 462, 108, 445, 202, 564, 260, 384, },
};
