/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.BaseMath;

class MoreMath
extends BaseMath {
    private static final double LOG2E = 1.4426950408889634;
    static final double[] FACT = new double[]{1.0, 40320.0, 2.0922789888E13, 6.204484017332394E23, 2.631308369336935E35, 8.159152832478977E47, 1.2413915592536073E61, 7.109985878048635E74, 1.2688693218588417E89, 6.1234458376886085E103, 7.156945704626381E118, 1.8548264225739844E134, 9.916779348709496E149, 1.0299016745145628E166, 1.974506857221074E182, 6.689502913449127E198, 3.856204823625804E215, 3.659042881952549E232, 5.5502938327393044E249, 1.3113358856834524E267, 4.7147236359920616E284, 2.5260757449731984E302};

    MoreMath() {
    }

    public static final double asinh(double d) {
        return d < 0.0 ? -MoreMath.asinh(-d) : MoreMath.log(d + d + 1.0 / (Math.sqrt(d * d + 1.0) + d));
    }

    public static final double acosh(double d) {
        return MoreMath.log(d + d - 1.0 / (Math.sqrt(d * d - 1.0) + d));
    }

    public static final double atanh(double d) {
        return d < 0.0 ? -MoreMath.atanh(-d) : 0.5 * MoreMath.log(1.0 + (d + d) / (1.0 - d));
    }

    public static final double trunc(double d) {
        return d >= 0.0 ? Math.floor(d) : Math.ceil(d);
    }

    public static final double gcd(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isInfinite(d) || Double.isInfinite(d2)) {
            return Double.NaN;
        }
        d = Math.abs(d);
        d2 = Math.abs(d2);
        while (d2 > 1.0E-12) {
            double d3 = d2;
            d2 = d % d2;
            d = d3;
        }
        return d > 1.0E-10 ? d : 0.0;
    }

    public static final double lgamma(double d) {
        double d2 = d + 5.2421875;
        double d3 = d + 1.0;
        d = d3;
        double d4 = d + 1.0;
        d = d4;
        double d5 = d + 1.0;
        d = d5;
        double d6 = d + 1.0;
        d = d6;
        double d7 = d + 1.0;
        d = d7;
        double d8 = d + 1.0;
        d = d8;
        double d9 = d + 1.0;
        d = d9;
        double d10 = d + 1.0;
        d = d10;
        double d11 = d + 1.0;
        d = d11;
        double d12 = d + 1.0;
        d = d12;
        double d13 = d + 1.0;
        d = d13;
        double d14 = d + 1.0;
        d = d14;
        d = d + 1.0;
        return 0.9189385332046728 + MoreMath.log(0.9999999999999971 + 57.15623566586292 / d3 + -59.59796035547549 / d4 + 14.136097974741746 / d5 + -0.4919138160976202 / d6 + 3.399464998481189E-5 / d7 + 4.652362892704858E-5 / d8 + -9.837447530487956E-5 / d9 + 1.580887032249125E-4 / d10 + -2.1026444172410488E-4 / d11 + 2.1743961811521265E-4 / d12 + -1.643181065367639E-4 / d13 + 8.441822398385275E-5 / d14 + -2.6190838401581408E-5 / d + 3.6899182659531625E-6 / (d += 1.0)) + (d2 - 4.7421875) * MoreMath.log(d2) - d2;
    }

    public static final double factorial(double d) {
        if (d < 0.0) {
            return Double.NaN;
        }
        if (d <= 170.0 && Math.floor(d) == d) {
            int n = (int)d;
            double d2 = d;
            switch (n & 7) {
                case 7: {
                    d2 *= (d -= 1.0);
                }
                case 6: {
                    d2 *= (d -= 1.0);
                }
                case 5: {
                    d2 *= (d -= 1.0);
                }
                case 4: {
                    d2 *= (d -= 1.0);
                }
                case 3: {
                    d2 *= (d -= 1.0);
                }
                case 2: {
                    d2 *= (d -= 1.0);
                }
                case 1: {
                    return FACT[n >> 3] * d2;
                }
                case 0: {
                    return FACT[n >> 3];
                }
            }
        }
        return MoreMath.exp(MoreMath.lgamma(d));
    }

    public static final double comb(double d, double d2) {
        if (d < 0.0 || d2 < 0.0) {
            return Double.NaN;
        }
        if (d < d2) {
            return 0.0;
        }
        if (Math.floor(d) == d && Math.floor(d2) == d2) {
            d2 = Math.min(d2, d - d2);
            if (d <= 170.0 && 12.0 < d2 && d2 <= 170.0) {
                return MoreMath.factorial(d) / MoreMath.factorial(d2) / MoreMath.factorial(d - d2);
            }
            double d3 = 1.0;
            double d4 = d - d2;
            for (double d5 = d2; d5 > 0.5 && d3 < Double.POSITIVE_INFINITY; d3 *= (d4 + d5) / d5, d5 -= 1.0) {
            }
            return d3;
        }
        return MoreMath.exp(MoreMath.lgamma(d) - MoreMath.lgamma(d2) - MoreMath.lgamma(d - d2));
    }

    public static final double perm(double d, double d2) {
        if (d < 0.0 || d2 < 0.0) {
            return Double.NaN;
        }
        if (d < d2) {
            return 0.0;
        }
        if (Math.floor(d) == d && Math.floor(d2) == d2) {
            if (d <= 170.0 && 10.0 < d2 && d2 <= 170.0) {
                return MoreMath.factorial(d) / MoreMath.factorial(d - d2);
            }
            double d3 = 1.0;
            double d4 = d - d2 + 0.5;
            for (double d5 = d; d5 > d4 && d3 < Double.POSITIVE_INFINITY; d3 *= d5, d5 -= 1.0) {
            }
            return d3;
        }
        return MoreMath.exp(MoreMath.lgamma(d) - MoreMath.lgamma(d - d2));
    }

    public static final double log2(double d) {
        return MoreMath.log(d) * 1.4426950408889634;
    }

    private static final boolean isPiMultiple(double d) {
        return d % Math.PI == 0.0;
    }

    public static final int intLog10(double d) {
        return (int)Math.floor(MoreMath.log10(d));
    }

    public static final double intExp10(int n) {
        return Double.parseDouble("1E" + n);
    }
}

