// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(add)                       \
  M(sub)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_T32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  int32_t immediate;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] =
    {{{mi, r3, r3, 90}, true, mi, "mi r3 r3 90", "mi_r3_r3_90"},
     {{vc, r6, r6, 138}, true, vc, "vc r6 r6 138", "vc_r6_r6_138"},
     {{cc, r5, r5, 72}, true, cc, "cc r5 r5 72", "cc_r5_r5_72"},
     {{ge, r6, r6, 181}, true, ge, "ge r6 r6 181", "ge_r6_r6_181"},
     {{cc, r1, r1, 143}, true, cc, "cc r1 r1 143", "cc_r1_r1_143"},
     {{vc, r5, r5, 114}, true, vc, "vc r5 r5 114", "vc_r5_r5_114"},
     {{ge, r4, r4, 195}, true, ge, "ge r4 r4 195", "ge_r4_r4_195"},
     {{lt, r0, r0, 203}, true, lt, "lt r0 r0 203", "lt_r0_r0_203"},
     {{hi, r1, r1, 98}, true, hi, "hi r1 r1 98", "hi_r1_r1_98"},
     {{gt, r3, r3, 0}, true, gt, "gt r3 r3 0", "gt_r3_r3_0"},
     {{vs, r5, r5, 195}, true, vs, "vs r5 r5 195", "vs_r5_r5_195"},
     {{le, r6, r6, 39}, true, le, "le r6 r6 39", "le_r6_r6_39"},
     {{mi, r0, r0, 231}, true, mi, "mi r0 r0 231", "mi_r0_r0_231"},
     {{mi, r5, r5, 220}, true, mi, "mi r5 r5 220", "mi_r5_r5_220"},
     {{hi, r4, r4, 60}, true, hi, "hi r4 r4 60", "hi_r4_r4_60"},
     {{vc, r0, r0, 83}, true, vc, "vc r0 r0 83", "vc_r0_r0_83"},
     {{lt, r3, r3, 207}, true, lt, "lt r3 r3 207", "lt_r3_r3_207"},
     {{vs, r3, r3, 101}, true, vs, "vs r3 r3 101", "vs_r3_r3_101"},
     {{cs, r0, r0, 182}, true, cs, "cs r0 r0 182", "cs_r0_r0_182"},
     {{vs, r0, r0, 53}, true, vs, "vs r0 r0 53", "vs_r0_r0_53"},
     {{hi, r7, r7, 142}, true, hi, "hi r7 r7 142", "hi_r7_r7_142"},
     {{ls, r5, r5, 89}, true, ls, "ls r5 r5 89", "ls_r5_r5_89"},
     {{ls, r5, r5, 32}, true, ls, "ls r5 r5 32", "ls_r5_r5_32"},
     {{ls, r1, r1, 29}, true, ls, "ls r1 r1 29", "ls_r1_r1_29"},
     {{hi, r3, r3, 62}, true, hi, "hi r3 r3 62", "hi_r3_r3_62"},
     {{eq, r3, r3, 216}, true, eq, "eq r3 r3 216", "eq_r3_r3_216"},
     {{mi, r5, r5, 167}, true, mi, "mi r5 r5 167", "mi_r5_r5_167"},
     {{ge, r6, r6, 88}, true, ge, "ge r6 r6 88", "ge_r6_r6_88"},
     {{lt, r1, r1, 158}, true, lt, "lt r1 r1 158", "lt_r1_r1_158"},
     {{ge, r5, r5, 242}, true, ge, "ge r5 r5 242", "ge_r5_r5_242"},
     {{ls, r4, r4, 225}, true, ls, "ls r4 r4 225", "ls_r4_r4_225"},
     {{eq, r0, r0, 4}, true, eq, "eq r0 r0 4", "eq_r0_r0_4"},
     {{vs, r1, r1, 98}, true, vs, "vs r1 r1 98", "vs_r1_r1_98"},
     {{lt, r7, r7, 224}, true, lt, "lt r7 r7 224", "lt_r7_r7_224"},
     {{eq, r5, r5, 162}, true, eq, "eq r5 r5 162", "eq_r5_r5_162"},
     {{gt, r5, r5, 139}, true, gt, "gt r5 r5 139", "gt_r5_r5_139"},
     {{cc, r4, r4, 68}, true, cc, "cc r4 r4 68", "cc_r4_r4_68"},
     {{vc, r0, r0, 2}, true, vc, "vc r0 r0 2", "vc_r0_r0_2"},
     {{ls, r3, r3, 114}, true, ls, "ls r3 r3 114", "ls_r3_r3_114"},
     {{vs, r7, r7, 220}, true, vs, "vs r7 r7 220", "vs_r7_r7_220"},
     {{cs, r6, r6, 78}, true, cs, "cs r6 r6 78", "cs_r6_r6_78"},
     {{cs, r7, r7, 129}, true, cs, "cs r7 r7 129", "cs_r7_r7_129"},
     {{hi, r3, r3, 17}, true, hi, "hi r3 r3 17", "hi_r3_r3_17"},
     {{cs, r0, r0, 14}, true, cs, "cs r0 r0 14", "cs_r0_r0_14"},
     {{hi, r3, r3, 20}, true, hi, "hi r3 r3 20", "hi_r3_r3_20"},
     {{ne, r4, r4, 210}, true, ne, "ne r4 r4 210", "ne_r4_r4_210"},
     {{eq, r3, r3, 172}, true, eq, "eq r3 r3 172", "eq_r3_r3_172"},
     {{vc, r3, r3, 203}, true, vc, "vc r3 r3 203", "vc_r3_r3_203"},
     {{hi, r3, r3, 52}, true, hi, "hi r3 r3 52", "hi_r3_r3_52"},
     {{eq, r0, r0, 248}, true, eq, "eq r0 r0 248", "eq_r0_r0_248"},
     {{lt, r3, r3, 43}, true, lt, "lt r3 r3 43", "lt_r3_r3_43"},
     {{eq, r4, r4, 233}, true, eq, "eq r4 r4 233", "eq_r4_r4_233"},
     {{eq, r6, r6, 158}, true, eq, "eq r6 r6 158", "eq_r6_r6_158"},
     {{vs, r7, r7, 194}, true, vs, "vs r7 r7 194", "vs_r7_r7_194"},
     {{hi, r5, r5, 116}, true, hi, "hi r5 r5 116", "hi_r5_r5_116"},
     {{vc, r7, r7, 11}, true, vc, "vc r7 r7 11", "vc_r7_r7_11"},
     {{le, r4, r4, 0}, true, le, "le r4 r4 0", "le_r4_r4_0"},
     {{ge, r1, r1, 103}, true, ge, "ge r1 r1 103", "ge_r1_r1_103"},
     {{eq, r0, r0, 124}, true, eq, "eq r0 r0 124", "eq_r0_r0_124"},
     {{mi, r5, r5, 57}, true, mi, "mi r5 r5 57", "mi_r5_r5_57"},
     {{ge, r7, r7, 22}, true, ge, "ge r7 r7 22", "ge_r7_r7_22"},
     {{mi, r6, r6, 99}, true, mi, "mi r6 r6 99", "mi_r6_r6_99"},
     {{hi, r7, r7, 195}, true, hi, "hi r7 r7 195", "hi_r7_r7_195"},
     {{vs, r4, r4, 142}, true, vs, "vs r4 r4 142", "vs_r4_r4_142"},
     {{hi, r6, r6, 74}, true, hi, "hi r6 r6 74", "hi_r6_r6_74"},
     {{ne, r1, r1, 131}, true, ne, "ne r1 r1 131", "ne_r1_r1_131"},
     {{hi, r1, r1, 96}, true, hi, "hi r1 r1 96", "hi_r1_r1_96"},
     {{eq, r2, r2, 248}, true, eq, "eq r2 r2 248", "eq_r2_r2_248"},
     {{le, r2, r2, 252}, true, le, "le r2 r2 252", "le_r2_r2_252"},
     {{cc, r2, r2, 93}, true, cc, "cc r2 r2 93", "cc_r2_r2_93"},
     {{cc, r3, r3, 130}, true, cc, "cc r3 r3 130", "cc_r3_r3_130"},
     {{pl, r0, r0, 0}, true, pl, "pl r0 r0 0", "pl_r0_r0_0"},
     {{gt, r3, r3, 109}, true, gt, "gt r3 r3 109", "gt_r3_r3_109"},
     {{vs, r1, r1, 192}, true, vs, "vs r1 r1 192", "vs_r1_r1_192"},
     {{gt, r3, r3, 53}, true, gt, "gt r3 r3 53", "gt_r3_r3_53"},
     {{lt, r6, r6, 229}, true, lt, "lt r6 r6 229", "lt_r6_r6_229"},
     {{lt, r4, r4, 128}, true, lt, "lt r4 r4 128", "lt_r4_r4_128"},
     {{ne, r2, r2, 168}, true, ne, "ne r2 r2 168", "ne_r2_r2_168"},
     {{cs, r7, r7, 91}, true, cs, "cs r7 r7 91", "cs_r7_r7_91"},
     {{mi, r5, r5, 112}, true, mi, "mi r5 r5 112", "mi_r5_r5_112"},
     {{vc, r0, r0, 200}, true, vc, "vc r0 r0 200", "vc_r0_r0_200"},
     {{cs, r5, r5, 82}, true, cs, "cs r5 r5 82", "cs_r5_r5_82"},
     {{mi, r4, r4, 176}, true, mi, "mi r4 r4 176", "mi_r4_r4_176"},
     {{ls, r2, r2, 202}, true, ls, "ls r2 r2 202", "ls_r2_r2_202"},
     {{mi, r1, r1, 106}, true, mi, "mi r1 r1 106", "mi_r1_r1_106"},
     {{cc, r4, r4, 144}, true, cc, "cc r4 r4 144", "cc_r4_r4_144"},
     {{cc, r4, r4, 241}, true, cc, "cc r4 r4 241", "cc_r4_r4_241"},
     {{vc, r3, r3, 107}, true, vc, "vc r3 r3 107", "vc_r3_r3_107"},
     {{ls, r2, r2, 21}, true, ls, "ls r2 r2 21", "ls_r2_r2_21"},
     {{mi, r2, r2, 54}, true, mi, "mi r2 r2 54", "mi_r2_r2_54"},
     {{ge, r1, r1, 69}, true, ge, "ge r1 r1 69", "ge_r1_r1_69"},
     {{pl, r2, r2, 165}, true, pl, "pl r2 r2 165", "pl_r2_r2_165"},
     {{gt, r2, r2, 154}, true, gt, "gt r2 r2 154", "gt_r2_r2_154"},
     {{gt, r4, r4, 195}, true, gt, "gt r4 r4 195", "gt_r4_r4_195"},
     {{ne, r0, r0, 223}, true, ne, "ne r0 r0 223", "ne_r0_r0_223"},
     {{vs, r6, r6, 79}, true, vs, "vs r6 r6 79", "vs_r6_r6_79"},
     {{lt, r4, r4, 57}, true, lt, "lt r4 r4 57", "lt_r4_r4_57"},
     {{vs, r0, r0, 157}, true, vs, "vs r0 r0 157", "vs_r0_r0_157"},
     {{vc, r2, r2, 69}, true, vc, "vc r2 r2 69", "vc_r2_r2_69"},
     {{vc, r7, r7, 167}, true, vc, "vc r7 r7 167", "vc_r7_r7_167"},
     {{lt, r4, r4, 216}, true, lt, "lt r4 r4 216", "lt_r4_r4_216"},
     {{le, r1, r1, 159}, true, le, "le r1 r1 159", "le_r1_r1_159"},
     {{hi, r6, r6, 193}, true, hi, "hi r6 r6 193", "hi_r6_r6_193"},
     {{gt, r7, r7, 194}, true, gt, "gt r7 r7 194", "gt_r7_r7_194"},
     {{pl, r1, r1, 39}, true, pl, "pl r1 r1 39", "pl_r1_r1_39"},
     {{lt, r5, r5, 215}, true, lt, "lt r5 r5 215", "lt_r5_r5_215"},
     {{vc, r1, r1, 11}, true, vc, "vc r1 r1 11", "vc_r1_r1_11"},
     {{le, r0, r0, 242}, true, le, "le r0 r0 242", "le_r0_r0_242"},
     {{eq, r3, r3, 215}, true, eq, "eq r3 r3 215", "eq_r3_r3_215"},
     {{vs, r3, r3, 37}, true, vs, "vs r3 r3 37", "vs_r3_r3_37"},
     {{cs, r5, r5, 78}, true, cs, "cs r5 r5 78", "cs_r5_r5_78"},
     {{ne, r1, r1, 158}, true, ne, "ne r1 r1 158", "ne_r1_r1_158"},
     {{ne, r0, r0, 174}, true, ne, "ne r0 r0 174", "ne_r0_r0_174"},
     {{le, r1, r1, 81}, true, le, "le r1 r1 81", "le_r1_r1_81"},
     {{le, r5, r5, 250}, true, le, "le r5 r5 250", "le_r5_r5_250"},
     {{pl, r7, r7, 101}, true, pl, "pl r7 r7 101", "pl_r7_r7_101"},
     {{hi, r7, r7, 188}, true, hi, "hi r7 r7 188", "hi_r7_r7_188"},
     {{hi, r4, r4, 88}, true, hi, "hi r4 r4 88", "hi_r4_r4_88"},
     {{ls, r1, r1, 42}, true, ls, "ls r1 r1 42", "ls_r1_r1_42"},
     {{vc, r2, r2, 19}, true, vc, "vc r2 r2 19", "vc_r2_r2_19"},
     {{mi, r6, r6, 125}, true, mi, "mi r6 r6 125", "mi_r6_r6_125"},
     {{ls, r2, r2, 82}, true, ls, "ls r2 r2 82", "ls_r2_r2_82"},
     {{gt, r4, r4, 150}, true, gt, "gt r4 r4 150", "gt_r4_r4_150"},
     {{ne, r5, r5, 40}, true, ne, "ne r5 r5 40", "ne_r5_r5_40"},
     {{cs, r4, r4, 221}, true, cs, "cs r4 r4 221", "cs_r4_r4_221"},
     {{cc, r6, r6, 120}, true, cc, "cc r6 r6 120", "cc_r6_r6_120"},
     {{cc, r2, r2, 211}, true, cc, "cc r2 r2 211", "cc_r2_r2_211"},
     {{cs, r6, r6, 67}, true, cs, "cs r6 r6 67", "cs_r6_r6_67"},
     {{gt, r0, r0, 47}, true, gt, "gt r0 r0 47", "gt_r0_r0_47"},
     {{pl, r7, r7, 75}, true, pl, "pl r7 r7 75", "pl_r7_r7_75"},
     {{ls, r1, r1, 234}, true, ls, "ls r1 r1 234", "ls_r1_r1_234"},
     {{gt, r2, r2, 113}, true, gt, "gt r2 r2 113", "gt_r2_r2_113"},
     {{lt, r2, r2, 85}, true, lt, "lt r2 r2 85", "lt_r2_r2_85"},
     {{hi, r6, r6, 240}, true, hi, "hi r6 r6 240", "hi_r6_r6_240"},
     {{lt, r3, r3, 93}, true, lt, "lt r3 r3 93", "lt_r3_r3_93"},
     {{lt, r4, r4, 192}, true, lt, "lt r4 r4 192", "lt_r4_r4_192"},
     {{gt, r1, r1, 148}, true, gt, "gt r1 r1 148", "gt_r1_r1_148"},
     {{cs, r2, r2, 122}, true, cs, "cs r2 r2 122", "cs_r2_r2_122"},
     {{ne, r4, r4, 111}, true, ne, "ne r4 r4 111", "ne_r4_r4_111"},
     {{cs, r2, r2, 47}, true, cs, "cs r2 r2 47", "cs_r2_r2_47"},
     {{cs, r4, r4, 186}, true, cs, "cs r4 r4 186", "cs_r4_r4_186"},
     {{le, r0, r0, 183}, true, le, "le r0 r0 183", "le_r0_r0_183"},
     {{vs, r6, r6, 232}, true, vs, "vs r6 r6 232", "vs_r6_r6_232"},
     {{cc, r3, r3, 99}, true, cc, "cc r3 r3 99", "cc_r3_r3_99"},
     {{lt, r4, r4, 81}, true, lt, "lt r4 r4 81", "lt_r4_r4_81"},
     {{lt, r3, r3, 192}, true, lt, "lt r3 r3 192", "lt_r3_r3_192"},
     {{ls, r5, r5, 219}, true, ls, "ls r5 r5 219", "ls_r5_r5_219"},
     {{lt, r4, r4, 153}, true, lt, "lt r4 r4 153", "lt_r4_r4_153"},
     {{vs, r6, r6, 76}, true, vs, "vs r6 r6 76", "vs_r6_r6_76"},
     {{eq, r7, r7, 37}, true, eq, "eq r7 r7 37", "eq_r7_r7_37"},
     {{vs, r6, r6, 202}, true, vs, "vs r6 r6 202", "vs_r6_r6_202"},
     {{vs, r2, r2, 7}, true, vs, "vs r2 r2 7", "vs_r2_r2_7"},
     {{vs, r3, r3, 99}, true, vs, "vs r3 r3 99", "vs_r3_r3_99"},
     {{vs, r0, r0, 224}, true, vs, "vs r0 r0 224", "vs_r0_r0_224"},
     {{le, r5, r5, 26}, true, le, "le r5 r5 26", "le_r5_r5_26"},
     {{eq, r0, r0, 92}, true, eq, "eq r0 r0 92", "eq_r0_r0_92"},
     {{cc, r7, r7, 142}, true, cc, "cc r7 r7 142", "cc_r7_r7_142"},
     {{ls, r2, r2, 20}, true, ls, "ls r2 r2 20", "ls_r2_r2_20"},
     {{hi, r4, r4, 0}, true, hi, "hi r4 r4 0", "hi_r4_r4_0"},
     {{ne, r0, r0, 107}, true, ne, "ne r0 r0 107", "ne_r0_r0_107"},
     {{vs, r6, r6, 156}, true, vs, "vs r6 r6 156", "vs_r6_r6_156"},
     {{le, r4, r4, 32}, true, le, "le r4 r4 32", "le_r4_r4_32"},
     {{vc, r6, r6, 184}, true, vc, "vc r6 r6 184", "vc_r6_r6_184"},
     {{cs, r7, r7, 215}, true, cs, "cs r7 r7 215", "cs_r7_r7_215"},
     {{gt, r7, r7, 69}, true, gt, "gt r7 r7 69", "gt_r7_r7_69"},
     {{le, r5, r5, 87}, true, le, "le r5 r5 87", "le_r5_r5_87"},
     {{cs, r7, r7, 153}, true, cs, "cs r7 r7 153", "cs_r7_r7_153"},
     {{mi, r0, r0, 54}, true, mi, "mi r0 r0 54", "mi_r0_r0_54"},
     {{ne, r1, r1, 215}, true, ne, "ne r1 r1 215", "ne_r1_r1_215"},
     {{pl, r2, r2, 175}, true, pl, "pl r2 r2 175", "pl_r2_r2_175"},
     {{ne, r5, r5, 46}, true, ne, "ne r5 r5 46", "ne_r5_r5_46"},
     {{le, r3, r3, 183}, true, le, "le r3 r3 183", "le_r3_r3_183"},
     {{pl, r3, r3, 89}, true, pl, "pl r3 r3 89", "pl_r3_r3_89"},
     {{ne, r0, r0, 229}, true, ne, "ne r0 r0 229", "ne_r0_r0_229"},
     {{cc, r0, r0, 142}, true, cc, "cc r0 r0 142", "cc_r0_r0_142"},
     {{ne, r3, r3, 101}, true, ne, "ne r3 r3 101", "ne_r3_r3_101"},
     {{vc, r3, r3, 108}, true, vc, "vc r3 r3 108", "vc_r3_r3_108"},
     {{eq, r7, r7, 96}, true, eq, "eq r7 r7 96", "eq_r7_r7_96"},
     {{cc, r0, r0, 204}, true, cc, "cc r0 r0 204", "cc_r0_r0_204"},
     {{hi, r6, r6, 58}, true, hi, "hi r6 r6 58", "hi_r6_r6_58"},
     {{vc, r6, r6, 2}, true, vc, "vc r6 r6 2", "vc_r6_r6_2"},
     {{cc, r0, r0, 21}, true, cc, "cc r0 r0 21", "cc_r0_r0_21"},
     {{ge, r0, r0, 223}, true, ge, "ge r0 r0 223", "ge_r0_r0_223"},
     {{eq, r3, r3, 82}, true, eq, "eq r3 r3 82", "eq_r3_r3_82"},
     {{hi, r3, r3, 209}, true, hi, "hi r3 r3 209", "hi_r3_r3_209"},
     {{vs, r3, r3, 89}, true, vs, "vs r3 r3 89", "vs_r3_r3_89"},
     {{ls, r2, r2, 19}, true, ls, "ls r2 r2 19", "ls_r2_r2_19"},
     {{ne, r3, r3, 127}, true, ne, "ne r3 r3 127", "ne_r3_r3_127"},
     {{cc, r1, r1, 87}, true, cc, "cc r1 r1 87", "cc_r1_r1_87"},
     {{lt, r0, r0, 36}, true, lt, "lt r0 r0 36", "lt_r0_r0_36"},
     {{ne, r3, r3, 217}, true, ne, "ne r3 r3 217", "ne_r3_r3_217"},
     {{hi, r2, r2, 92}, true, hi, "hi r2 r2 92", "hi_r2_r2_92"},
     {{vs, r3, r3, 231}, true, vs, "vs r3 r3 231", "vs_r3_r3_231"},
     {{vc, r2, r2, 8}, true, vc, "vc r2 r2 8", "vc_r2_r2_8"},
     {{vs, r3, r3, 49}, true, vs, "vs r3 r3 49", "vs_r3_r3_49"},
     {{pl, r3, r3, 223}, true, pl, "pl r3 r3 223", "pl_r3_r3_223"},
     {{ls, r3, r3, 201}, true, ls, "ls r3 r3 201", "ls_r3_r3_201"},
     {{vc, r7, r7, 215}, true, vc, "vc r7 r7 215", "vc_r7_r7_215"},
     {{ge, r4, r4, 208}, true, ge, "ge r4 r4 208", "ge_r4_r4_208"},
     {{eq, r4, r4, 170}, true, eq, "eq r4 r4 170", "eq_r4_r4_170"},
     {{vs, r0, r0, 45}, true, vs, "vs r0 r0 45", "vs_r0_r0_45"},
     {{mi, r4, r4, 237}, true, mi, "mi r4 r4 237", "mi_r4_r4_237"},
     {{eq, r5, r5, 142}, true, eq, "eq r5 r5 142", "eq_r5_r5_142"},
     {{eq, r4, r4, 100}, true, eq, "eq r4 r4 100", "eq_r4_r4_100"},
     {{mi, r1, r1, 73}, true, mi, "mi r1 r1 73", "mi_r1_r1_73"},
     {{lt, r0, r0, 244}, true, lt, "lt r0 r0 244", "lt_r0_r0_244"},
     {{ge, r7, r7, 233}, true, ge, "ge r7 r7 233", "ge_r7_r7_233"},
     {{vs, r3, r3, 253}, true, vs, "vs r3 r3 253", "vs_r3_r3_253"},
     {{cs, r5, r5, 20}, true, cs, "cs r5 r5 20", "cs_r5_r5_20"},
     {{pl, r2, r2, 84}, true, pl, "pl r2 r2 84", "pl_r2_r2_84"},
     {{ne, r4, r4, 90}, true, ne, "ne r4 r4 90", "ne_r4_r4_90"},
     {{ne, r6, r6, 32}, true, ne, "ne r6 r6 32", "ne_r6_r6_32"},
     {{gt, r6, r6, 55}, true, gt, "gt r6 r6 55", "gt_r6_r6_55"},
     {{pl, r2, r2, 95}, true, pl, "pl r2 r2 95", "pl_r2_r2_95"},
     {{vc, r4, r4, 67}, true, vc, "vc r4 r4 67", "vc_r4_r4_67"},
     {{vc, r3, r3, 236}, true, vc, "vc r3 r3 236", "vc_r3_r3_236"},
     {{mi, r7, r7, 109}, true, mi, "mi r7 r7 109", "mi_r7_r7_109"},
     {{hi, r0, r0, 174}, true, hi, "hi r0 r0 174", "hi_r0_r0_174"},
     {{ne, r3, r3, 6}, true, ne, "ne r3 r3 6", "ne_r3_r3_6"},
     {{mi, r4, r4, 17}, true, mi, "mi r4 r4 17", "mi_r4_r4_17"},
     {{ls, r3, r3, 20}, true, ls, "ls r3 r3 20", "ls_r3_r3_20"},
     {{mi, r7, r7, 93}, true, mi, "mi r7 r7 93", "mi_r7_r7_93"},
     {{eq, r5, r5, 9}, true, eq, "eq r5 r5 9", "eq_r5_r5_9"},
     {{cs, r4, r4, 88}, true, cs, "cs r4 r4 88", "cs_r4_r4_88"},
     {{cs, r4, r4, 92}, true, cs, "cs r4 r4 92", "cs_r4_r4_92"},
     {{gt, r4, r4, 69}, true, gt, "gt r4 r4 69", "gt_r4_r4_69"},
     {{ge, r0, r0, 219}, true, ge, "ge r0 r0 219", "ge_r0_r0_219"},
     {{gt, r4, r4, 15}, true, gt, "gt r4 r4 15", "gt_r4_r4_15"},
     {{gt, r5, r5, 105}, true, gt, "gt r5 r5 105", "gt_r5_r5_105"},
     {{hi, r2, r2, 229}, true, hi, "hi r2 r2 229", "hi_r2_r2_229"},
     {{ls, r7, r7, 32}, true, ls, "ls r7 r7 32", "ls_r7_r7_32"},
     {{gt, r5, r5, 79}, true, gt, "gt r5 r5 79", "gt_r5_r5_79"},
     {{ls, r7, r7, 57}, true, ls, "ls r7 r7 57", "ls_r7_r7_57"},
     {{pl, r2, r2, 17}, true, pl, "pl r2 r2 17", "pl_r2_r2_17"},
     {{cc, r6, r6, 67}, true, cc, "cc r6 r6 67", "cc_r6_r6_67"},
     {{cs, r7, r7, 11}, true, cs, "cs r7 r7 11", "cs_r7_r7_11"},
     {{mi, r6, r6, 150}, true, mi, "mi r6 r6 150", "mi_r6_r6_150"},
     {{pl, r3, r3, 241}, true, pl, "pl r3 r3 241", "pl_r3_r3_241"},
     {{cc, r2, r2, 65}, true, cc, "cc r2 r2 65", "cc_r2_r2_65"},
     {{ne, r4, r4, 81}, true, ne, "ne r4 r4 81", "ne_r4_r4_81"},
     {{lt, r4, r4, 176}, true, lt, "lt r4 r4 176", "lt_r4_r4_176"},
     {{cs, r7, r7, 58}, true, cs, "cs r7 r7 58", "cs_r7_r7_58"},
     {{gt, r1, r1, 114}, true, gt, "gt r1 r1 114", "gt_r1_r1_114"},
     {{vc, r7, r7, 4}, true, vc, "vc r7 r7 4", "vc_r7_r7_4"},
     {{le, r3, r3, 110}, true, le, "le r3 r3 110", "le_r3_r3_110"},
     {{vs, r1, r1, 149}, true, vs, "vs r1 r1 149", "vs_r1_r1_149"},
     {{cs, r3, r3, 179}, true, cs, "cs r3 r3 179", "cs_r3_r3_179"},
     {{vs, r7, r7, 199}, true, vs, "vs r7 r7 199", "vs_r7_r7_199"},
     {{ge, r4, r4, 46}, true, ge, "ge r4 r4 46", "ge_r4_r4_46"},
     {{ls, r1, r1, 98}, true, ls, "ls r1 r1 98", "ls_r1_r1_98"},
     {{cs, r3, r3, 60}, true, cs, "cs r3 r3 60", "cs_r3_r3_60"},
     {{vc, r2, r2, 201}, true, vc, "vc r2 r2 201", "vc_r2_r2_201"},
     {{le, r5, r5, 128}, true, le, "le r5 r5 128", "le_r5_r5_128"},
     {{vs, r4, r4, 39}, true, vs, "vs r4 r4 39", "vs_r4_r4_39"},
     {{ls, r4, r4, 106}, true, ls, "ls r4 r4 106", "ls_r4_r4_106"},
     {{le, r5, r5, 207}, true, le, "le r5 r5 207", "le_r5_r5_207"},
     {{cs, r6, r6, 7}, true, cs, "cs r6 r6 7", "cs_r6_r6_7"},
     {{ne, r5, r5, 133}, true, ne, "ne r5 r5 133", "ne_r5_r5_133"},
     {{eq, r7, r7, 28}, true, eq, "eq r7 r7 28", "eq_r7_r7_28"},
     {{pl, r7, r7, 154}, true, pl, "pl r7 r7 154", "pl_r7_r7_154"},
     {{vs, r3, r3, 242}, true, vs, "vs r3 r3 242", "vs_r3_r3_242"},
     {{eq, r6, r6, 221}, true, eq, "eq r6 r6 221", "eq_r6_r6_221"},
     {{vs, r5, r5, 97}, true, vs, "vs r5 r5 97", "vs_r5_r5_97"},
     {{ls, r5, r5, 70}, true, ls, "ls r5 r5 70", "ls_r5_r5_70"},
     {{vc, r6, r6, 236}, true, vc, "vc r6 r6 236", "vc_r6_r6_236"},
     {{ne, r2, r2, 236}, true, ne, "ne r2 r2 236", "ne_r2_r2_236"},
     {{eq, r1, r1, 198}, true, eq, "eq r1 r1 198", "eq_r1_r1_198"},
     {{vs, r3, r3, 134}, true, vs, "vs r3 r3 134", "vs_r3_r3_134"},
     {{ne, r5, r5, 42}, true, ne, "ne r5 r5 42", "ne_r5_r5_42"},
     {{ge, r6, r6, 223}, true, ge, "ge r6 r6 223", "ge_r6_r6_223"},
     {{ge, r0, r0, 48}, true, ge, "ge r0 r0 48", "ge_r0_r0_48"},
     {{hi, r7, r7, 146}, true, hi, "hi r7 r7 146", "hi_r7_r7_146"},
     {{ge, r4, r4, 175}, true, ge, "ge r4 r4 175", "ge_r4_r4_175"},
     {{gt, r4, r4, 142}, true, gt, "gt r4 r4 142", "gt_r4_r4_142"},
     {{ne, r6, r6, 24}, true, ne, "ne r6 r6 24", "ne_r6_r6_24"},
     {{lt, r2, r2, 152}, true, lt, "lt r2 r2 152", "lt_r2_r2_152"},
     {{hi, r2, r2, 113}, true, hi, "hi r2 r2 113", "hi_r2_r2_113"},
     {{vc, r4, r4, 135}, true, vc, "vc r4 r4 135", "vc_r4_r4_135"},
     {{ls, r4, r4, 40}, true, ls, "ls r4 r4 40", "ls_r4_r4_40"},
     {{cc, r2, r2, 199}, true, cc, "cc r2 r2 199", "cc_r2_r2_199"},
     {{vs, r6, r6, 164}, true, vs, "vs r6 r6 164", "vs_r6_r6_164"},
     {{le, r3, r3, 184}, true, le, "le r3 r3 184", "le_r3_r3_184"},
     {{cs, r4, r4, 158}, true, cs, "cs r4 r4 158", "cs_r4_r4_158"},
     {{vc, r5, r5, 212}, true, vc, "vc r5 r5 212", "vc_r5_r5_212"},
     {{gt, r5, r5, 143}, true, gt, "gt r5 r5 143", "gt_r5_r5_143"},
     {{ne, r0, r0, 186}, true, ne, "ne r0 r0 186", "ne_r0_r0_186"},
     {{cs, r5, r5, 233}, true, cs, "cs r5 r5 233", "cs_r5_r5_233"},
     {{le, r1, r1, 242}, true, le, "le r1 r1 242", "le_r1_r1_242"},
     {{ge, r6, r6, 70}, true, ge, "ge r6 r6 70", "ge_r6_r6_70"},
     {{cc, r7, r7, 234}, true, cc, "cc r7 r7 234", "cc_r7_r7_234"},
     {{ls, r0, r0, 191}, true, ls, "ls r0 r0 191", "ls_r0_r0_191"},
     {{pl, r3, r3, 236}, true, pl, "pl r3 r3 236", "pl_r3_r3_236"},
     {{cc, r7, r7, 27}, true, cc, "cc r7 r7 27", "cc_r7_r7_27"},
     {{vs, r0, r0, 169}, true, vs, "vs r0 r0 169", "vs_r0_r0_169"},
     {{vs, r2, r2, 193}, true, vs, "vs r2 r2 193", "vs_r2_r2_193"},
     {{lt, r6, r6, 198}, true, lt, "lt r6 r6 198", "lt_r6_r6_198"},
     {{ge, r7, r7, 137}, true, ge, "ge r7 r7 137", "ge_r7_r7_137"},
     {{vs, r1, r1, 183}, true, vs, "vs r1 r1 183", "vs_r1_r1_183"},
     {{lt, r5, r5, 180}, true, lt, "lt r5 r5 180", "lt_r5_r5_180"},
     {{le, r3, r3, 22}, true, le, "le r3 r3 22", "le_r3_r3_22"},
     {{ls, r7, r7, 41}, true, ls, "ls r7 r7 41", "ls_r7_r7_41"},
     {{vs, r6, r6, 71}, true, vs, "vs r6 r6 71", "vs_r6_r6_71"},
     {{vs, r1, r1, 81}, true, vs, "vs r1 r1 81", "vs_r1_r1_81"},
     {{vc, r0, r0, 181}, true, vc, "vc r0 r0 181", "vc_r0_r0_181"},
     {{lt, r0, r0, 1}, true, lt, "lt r0 r0 1", "lt_r0_r0_1"},
     {{le, r1, r1, 182}, true, le, "le r1 r1 182", "le_r1_r1_182"},
     {{ls, r1, r1, 167}, true, ls, "ls r1 r1 167", "ls_r1_r1_167"},
     {{hi, r7, r7, 221}, true, hi, "hi r7 r7 221", "hi_r7_r7_221"},
     {{ge, r1, r1, 72}, true, ge, "ge r1 r1 72", "ge_r1_r1_72"},
     {{pl, r7, r7, 95}, true, pl, "pl r7 r7 95", "pl_r7_r7_95"},
     {{cs, r3, r3, 252}, true, cs, "cs r3 r3 252", "cs_r3_r3_252"},
     {{eq, r3, r3, 224}, true, eq, "eq r3 r3 224", "eq_r3_r3_224"},
     {{mi, r5, r5, 176}, true, mi, "mi r5 r5 176", "mi_r5_r5_176"},
     {{le, r0, r0, 213}, true, le, "le r0 r0 213", "le_r0_r0_213"},
     {{gt, r1, r1, 91}, true, gt, "gt r1 r1 91", "gt_r1_r1_91"},
     {{vc, r5, r5, 236}, true, vc, "vc r5 r5 236", "vc_r5_r5_236"},
     {{hi, r4, r4, 68}, true, hi, "hi r4 r4 68", "hi_r4_r4_68"},
     {{ls, r6, r6, 201}, true, ls, "ls r6 r6 201", "ls_r6_r6_201"},
     {{vs, r6, r6, 146}, true, vs, "vs r6 r6 146", "vs_r6_r6_146"},
     {{le, r5, r5, 169}, true, le, "le r5 r5 169", "le_r5_r5_169"},
     {{pl, r1, r1, 88}, true, pl, "pl r1 r1 88", "pl_r1_r1_88"},
     {{cc, r4, r4, 26}, true, cc, "cc r4 r4 26", "cc_r4_r4_26"},
     {{gt, r2, r2, 228}, true, gt, "gt r2 r2 228", "gt_r2_r2_228"},
     {{vs, r5, r5, 175}, true, vs, "vs r5 r5 175", "vs_r5_r5_175"},
     {{ne, r3, r3, 167}, true, ne, "ne r3 r3 167", "ne_r3_r3_167"},
     {{ge, r6, r6, 21}, true, ge, "ge r6 r6 21", "ge_r6_r6_21"},
     {{eq, r7, r7, 114}, true, eq, "eq r7 r7 114", "eq_r7_r7_114"},
     {{cs, r0, r0, 26}, true, cs, "cs r0 r0 26", "cs_r0_r0_26"},
     {{pl, r4, r4, 29}, true, pl, "pl r4 r4 29", "pl_r4_r4_29"},
     {{le, r1, r1, 71}, true, le, "le r1 r1 71", "le_r1_r1_71"},
     {{cc, r0, r0, 62}, true, cc, "cc r0 r0 62", "cc_r0_r0_62"},
     {{eq, r4, r4, 138}, true, eq, "eq r4 r4 138", "eq_r4_r4_138"},
     {{cc, r4, r4, 232}, true, cc, "cc r4 r4 232", "cc_r4_r4_232"},
     {{vs, r3, r3, 111}, true, vs, "vs r3 r3 111", "vs_r3_r3_111"},
     {{ls, r5, r5, 80}, true, ls, "ls r5 r5 80", "ls_r5_r5_80"},
     {{hi, r4, r4, 102}, true, hi, "hi r4 r4 102", "hi_r4_r4_102"},
     {{vc, r0, r0, 160}, true, vc, "vc r0 r0 160", "vc_r0_r0_160"},
     {{eq, r4, r4, 81}, true, eq, "eq r4 r4 81", "eq_r4_r4_81"},
     {{le, r7, r7, 147}, true, le, "le r7 r7 147", "le_r7_r7_147"},
     {{ls, r5, r5, 122}, true, ls, "ls r5 r5 122", "ls_r5_r5_122"},
     {{lt, r3, r3, 19}, true, lt, "lt r3 r3 19", "lt_r3_r3_19"},
     {{mi, r1, r1, 149}, true, mi, "mi r1 r1 149", "mi_r1_r1_149"},
     {{cc, r1, r1, 199}, true, cc, "cc r1 r1 199", "cc_r1_r1_199"},
     {{pl, r3, r3, 75}, true, pl, "pl r3 r3 75", "pl_r3_r3_75"},
     {{eq, r6, r6, 187}, true, eq, "eq r6 r6 187", "eq_r6_r6_187"},
     {{gt, r3, r3, 205}, true, gt, "gt r3 r3 205", "gt_r3_r3_205"},
     {{lt, r1, r1, 24}, true, lt, "lt r1 r1 24", "lt_r1_r1_24"},
     {{mi, r6, r6, 55}, true, mi, "mi r6 r6 55", "mi_r6_r6_55"},
     {{cc, r3, r3, 183}, true, cc, "cc r3 r3 183", "cc_r3_r3_183"},
     {{cc, r3, r3, 116}, true, cc, "cc r3 r3 116", "cc_r3_r3_116"},
     {{ne, r3, r3, 139}, true, ne, "ne r3 r3 139", "ne_r3_r3_139"},
     {{mi, r2, r2, 57}, true, mi, "mi r2 r2 57", "mi_r2_r2_57"},
     {{pl, r2, r2, 67}, true, pl, "pl r2 r2 67", "pl_r2_r2_67"},
     {{lt, r1, r1, 117}, true, lt, "lt r1 r1 117", "lt_r1_r1_117"},
     {{ge, r6, r6, 24}, true, ge, "ge r6 r6 24", "ge_r6_r6_24"},
     {{cs, r2, r2, 96}, true, cs, "cs r2 r2 96", "cs_r2_r2_96"},
     {{vc, r5, r5, 156}, true, vc, "vc r5 r5 156", "vc_r5_r5_156"},
     {{vs, r0, r0, 125}, true, vs, "vs r0 r0 125", "vs_r0_r0_125"},
     {{ls, r7, r7, 183}, true, ls, "ls r7 r7 183", "ls_r7_r7_183"},
     {{vs, r1, r1, 30}, true, vs, "vs r1 r1 30", "vs_r1_r1_30"},
     {{cs, r1, r1, 62}, true, cs, "cs r1 r1 62", "cs_r1_r1_62"},
     {{vc, r1, r1, 8}, true, vc, "vc r1 r1 8", "vc_r1_r1_8"},
     {{vc, r4, r4, 184}, true, vc, "vc r4 r4 184", "vc_r4_r4_184"},
     {{vc, r1, r1, 235}, true, vc, "vc r1 r1 235", "vc_r1_r1_235"},
     {{gt, r2, r2, 78}, true, gt, "gt r2 r2 78", "gt_r2_r2_78"},
     {{hi, r2, r2, 160}, true, hi, "hi r2 r2 160", "hi_r2_r2_160"},
     {{le, r3, r3, 243}, true, le, "le r3 r3 243", "le_r3_r3_243"},
     {{gt, r5, r5, 46}, true, gt, "gt r5 r5 46", "gt_r5_r5_46"},
     {{ls, r5, r5, 148}, true, ls, "ls r5 r5 148", "ls_r5_r5_148"},
     {{vs, r2, r2, 232}, true, vs, "vs r2 r2 232", "vs_r2_r2_232"},
     {{hi, r0, r0, 13}, true, hi, "hi r0 r0 13", "hi_r0_r0_13"},
     {{hi, r2, r2, 45}, true, hi, "hi r2 r2 45", "hi_r2_r2_45"},
     {{mi, r1, r1, 197}, true, mi, "mi r1 r1 197", "mi_r1_r1_197"},
     {{ls, r7, r7, 91}, true, ls, "ls r7 r7 91", "ls_r7_r7_91"},
     {{cs, r2, r2, 192}, true, cs, "cs r2 r2 192", "cs_r2_r2_192"},
     {{cs, r4, r4, 202}, true, cs, "cs r4 r4 202", "cs_r4_r4_202"},
     {{ne, r6, r6, 115}, true, ne, "ne r6 r6 115", "ne_r6_r6_115"},
     {{mi, r7, r7, 173}, true, mi, "mi r7 r7 173", "mi_r7_r7_173"},
     {{vs, r1, r1, 236}, true, vs, "vs r1 r1 236", "vs_r1_r1_236"},
     {{pl, r3, r3, 49}, true, pl, "pl r3 r3 49", "pl_r3_r3_49"},
     {{cs, r1, r1, 193}, true, cs, "cs r1 r1 193", "cs_r1_r1_193"},
     {{gt, r4, r4, 200}, true, gt, "gt r4 r4 200", "gt_r4_r4_200"},
     {{lt, r4, r4, 141}, true, lt, "lt r4 r4 141", "lt_r4_r4_141"},
     {{gt, r6, r6, 142}, true, gt, "gt r6 r6 142", "gt_r6_r6_142"},
     {{le, r2, r2, 39}, true, le, "le r2 r2 39", "le_r2_r2_39"},
     {{cc, r3, r3, 98}, true, cc, "cc r3 r3 98", "cc_r3_r3_98"},
     {{le, r4, r4, 77}, true, le, "le r4 r4 77", "le_r4_r4_77"},
     {{ne, r2, r2, 140}, true, ne, "ne r2 r2 140", "ne_r2_r2_140"},
     {{cc, r3, r3, 117}, true, cc, "cc r3 r3 117", "cc_r3_r3_117"},
     {{gt, r3, r3, 242}, true, gt, "gt r3 r3 242", "gt_r3_r3_242"},
     {{ls, r5, r5, 90}, true, ls, "ls r5 r5 90", "ls_r5_r5_90"},
     {{gt, r7, r7, 16}, true, gt, "gt r7 r7 16", "gt_r7_r7_16"},
     {{vs, r5, r5, 131}, true, vs, "vs r5 r5 131", "vs_r5_r5_131"},
     {{vc, r6, r6, 145}, true, vc, "vc r6 r6 145", "vc_r6_r6_145"},
     {{lt, r0, r0, 94}, true, lt, "lt r0 r0 94", "lt_r0_r0_94"},
     {{vs, r3, r3, 246}, true, vs, "vs r3 r3 246", "vs_r3_r3_246"},
     {{le, r0, r0, 124}, true, le, "le r0 r0 124", "le_r0_r0_124"},
     {{eq, r7, r7, 60}, true, eq, "eq r7 r7 60", "eq_r7_r7_60"},
     {{mi, r3, r3, 244}, true, mi, "mi r3 r3 244", "mi_r3_r3_244"},
     {{ls, r5, r5, 110}, true, ls, "ls r5 r5 110", "ls_r5_r5_110"},
     {{lt, r2, r2, 168}, true, lt, "lt r2 r2 168", "lt_r2_r2_168"},
     {{cs, r3, r3, 217}, true, cs, "cs r3 r3 217", "cs_r3_r3_217"},
     {{lt, r2, r2, 155}, true, lt, "lt r2 r2 155", "lt_r2_r2_155"},
     {{gt, r2, r2, 43}, true, gt, "gt r2 r2 43", "gt_r2_r2_43"},
     {{pl, r3, r3, 247}, true, pl, "pl r3 r3 247", "pl_r3_r3_247"},
     {{mi, r0, r0, 193}, true, mi, "mi r0 r0 193", "mi_r0_r0_193"},
     {{pl, r7, r7, 22}, true, pl, "pl r7 r7 22", "pl_r7_r7_22"},
     {{vs, r7, r7, 222}, true, vs, "vs r7 r7 222", "vs_r7_r7_222"},
     {{le, r0, r0, 205}, true, le, "le r0 r0 205", "le_r0_r0_205"},
     {{lt, r4, r4, 67}, true, lt, "lt r4 r4 67", "lt_r4_r4_67"},
     {{cc, r1, r1, 60}, true, cc, "cc r1 r1 60", "cc_r1_r1_60"},
     {{cc, r4, r4, 4}, true, cc, "cc r4 r4 4", "cc_r4_r4_4"},
     {{vc, r1, r1, 22}, true, vc, "vc r1 r1 22", "vc_r1_r1_22"},
     {{vc, r4, r4, 94}, true, vc, "vc r4 r4 94", "vc_r4_r4_94"},
     {{ls, r5, r5, 180}, true, ls, "ls r5 r5 180", "ls_r5_r5_180"},
     {{cc, r7, r7, 87}, true, cc, "cc r7 r7 87", "cc_r7_r7_87"},
     {{ls, r3, r3, 175}, true, ls, "ls r3 r3 175", "ls_r3_r3_175"},
     {{ge, r7, r7, 222}, true, ge, "ge r7 r7 222", "ge_r7_r7_222"},
     {{ne, r2, r2, 166}, true, ne, "ne r2 r2 166", "ne_r2_r2_166"},
     {{ls, r1, r1, 191}, true, ls, "ls r1 r1 191", "ls_r1_r1_191"},
     {{vs, r0, r0, 20}, true, vs, "vs r0 r0 20", "vs_r0_r0_20"},
     {{hi, r1, r1, 253}, true, hi, "hi r1 r1 253", "hi_r1_r1_253"},
     {{eq, r1, r1, 2}, true, eq, "eq r1 r1 2", "eq_r1_r1_2"},
     {{ls, r6, r6, 74}, true, ls, "ls r6 r6 74", "ls_r6_r6_74"},
     {{mi, r6, r6, 242}, true, mi, "mi r6 r6 242", "mi_r6_r6_242"},
     {{le, r6, r6, 242}, true, le, "le r6 r6 242", "le_r6_r6_242"},
     {{cs, r7, r7, 110}, true, cs, "cs r7 r7 110", "cs_r7_r7_110"},
     {{ge, r5, r5, 23}, true, ge, "ge r5 r5 23", "ge_r5_r5_23"},
     {{lt, r5, r5, 87}, true, lt, "lt r5 r5 87", "lt_r5_r5_87"},
     {{lt, r0, r0, 91}, true, lt, "lt r0 r0 91", "lt_r0_r0_91"},
     {{cc, r2, r2, 68}, true, cc, "cc r2 r2 68", "cc_r2_r2_68"},
     {{vs, r2, r2, 171}, true, vs, "vs r2 r2 171", "vs_r2_r2_171"},
     {{pl, r6, r6, 118}, true, pl, "pl r6 r6 118", "pl_r6_r6_118"},
     {{gt, r6, r6, 232}, true, gt, "gt r6 r6 232", "gt_r6_r6_232"},
     {{ls, r0, r0, 255}, true, ls, "ls r0 r0 255", "ls_r0_r0_255"},
     {{mi, r4, r4, 142}, true, mi, "mi r4 r4 142", "mi_r4_r4_142"},
     {{lt, r5, r5, 198}, true, lt, "lt r5 r5 198", "lt_r5_r5_198"},
     {{lt, r0, r0, 114}, true, lt, "lt r0 r0 114", "lt_r0_r0_114"},
     {{lt, r5, r5, 129}, true, lt, "lt r5 r5 129", "lt_r5_r5_129"},
     {{pl, r5, r5, 145}, true, pl, "pl r5 r5 145", "pl_r5_r5_145"},
     {{hi, r7, r7, 43}, true, hi, "hi r7 r7 43", "hi_r7_r7_43"},
     {{vs, r1, r1, 67}, true, vs, "vs r1 r1 67", "vs_r1_r1_67"},
     {{vc, r7, r7, 78}, true, vc, "vc r7 r7 78", "vc_r7_r7_78"},
     {{cc, r1, r1, 56}, true, cc, "cc r1 r1 56", "cc_r1_r1_56"},
     {{vs, r0, r0, 12}, true, vs, "vs r0 r0 12", "vs_r0_r0_12"},
     {{pl, r5, r5, 35}, true, pl, "pl r5 r5 35", "pl_r5_r5_35"},
     {{vs, r5, r5, 105}, true, vs, "vs r5 r5 105", "vs_r5_r5_105"},
     {{vc, r1, r1, 88}, true, vc, "vc r1 r1 88", "vc_r1_r1_88"},
     {{lt, r2, r2, 69}, true, lt, "lt r2 r2 69", "lt_r2_r2_69"},
     {{cs, r3, r3, 255}, true, cs, "cs r3 r3 255", "cs_r3_r3_255"},
     {{ls, r6, r6, 5}, true, ls, "ls r6 r6 5", "ls_r6_r6_5"},
     {{vc, r6, r6, 171}, true, vc, "vc r6 r6 171", "vc_r6_r6_171"},
     {{pl, r5, r5, 166}, true, pl, "pl r5 r5 166", "pl_r5_r5_166"},
     {{ls, r1, r1, 121}, true, ls, "ls r1 r1 121", "ls_r1_r1_121"},
     {{ne, r4, r4, 120}, true, ne, "ne r4 r4 120", "ne_r4_r4_120"},
     {{ls, r4, r4, 130}, true, ls, "ls r4 r4 130", "ls_r4_r4_130"},
     {{ge, r6, r6, 104}, true, ge, "ge r6 r6 104", "ge_r6_r6_104"},
     {{ge, r3, r3, 227}, true, ge, "ge r3 r3 227", "ge_r3_r3_227"},
     {{vs, r3, r3, 202}, true, vs, "vs r3 r3 202", "vs_r3_r3_202"},
     {{ne, r4, r4, 198}, true, ne, "ne r4 r4 198", "ne_r4_r4_198"},
     {{cc, r5, r5, 78}, true, cc, "cc r5 r5 78", "cc_r5_r5_78"},
     {{cs, r3, r3, 7}, true, cs, "cs r3 r3 7", "cs_r3_r3_7"},
     {{mi, r0, r0, 35}, true, mi, "mi r0 r0 35", "mi_r0_r0_35"},
     {{hi, r3, r3, 53}, true, hi, "hi r3 r3 53", "hi_r3_r3_53"},
     {{cs, r5, r5, 150}, true, cs, "cs r5 r5 150", "cs_r5_r5_150"},
     {{ge, r2, r2, 143}, true, ge, "ge r2 r2 143", "ge_r2_r2_143"},
     {{hi, r0, r0, 229}, true, hi, "hi r0 r0 229", "hi_r0_r0_229"},
     {{vc, r6, r6, 141}, true, vc, "vc r6 r6 141", "vc_r6_r6_141"},
     {{pl, r7, r7, 76}, true, pl, "pl r7 r7 76", "pl_r7_r7_76"},
     {{ne, r5, r5, 135}, true, ne, "ne r5 r5 135", "ne_r5_r5_135"},
     {{hi, r5, r5, 51}, true, hi, "hi r5 r5 51", "hi_r5_r5_51"},
     {{eq, r6, r6, 95}, true, eq, "eq r6 r6 95", "eq_r6_r6_95"},
     {{cs, r6, r6, 227}, true, cs, "cs r6 r6 227", "cs_r6_r6_227"},
     {{ge, r6, r6, 46}, true, ge, "ge r6 r6 46", "ge_r6_r6_46"},
     {{ne, r1, r1, 150}, true, ne, "ne r1 r1 150", "ne_r1_r1_150"},
     {{eq, r1, r1, 22}, true, eq, "eq r1 r1 22", "eq_r1_r1_22"},
     {{vs, r2, r2, 220}, true, vs, "vs r2 r2 220", "vs_r2_r2_220"},
     {{ls, r6, r6, 240}, true, ls, "ls r6 r6 240", "ls_r6_r6_240"},
     {{le, r4, r4, 43}, true, le, "le r4 r4 43", "le_r4_r4_43"},
     {{ls, r7, r7, 243}, true, ls, "ls r7 r7 243", "ls_r7_r7_243"},
     {{hi, r3, r3, 191}, true, hi, "hi r3 r3 191", "hi_r3_r3_191"},
     {{hi, r0, r0, 235}, true, hi, "hi r0 r0 235", "hi_r0_r0_235"},
     {{gt, r1, r1, 59}, true, gt, "gt r1 r1 59", "gt_r1_r1_59"},
     {{vc, r3, r3, 165}, true, vc, "vc r3 r3 165", "vc_r3_r3_165"},
     {{vc, r1, r1, 46}, true, vc, "vc r1 r1 46", "vc_r1_r1_46"},
     {{eq, r6, r6, 232}, true, eq, "eq r6 r6 232", "eq_r6_r6_232"},
     {{ls, r3, r3, 132}, true, ls, "ls r3 r3 132", "ls_r3_r3_132"},
     {{ls, r7, r7, 207}, true, ls, "ls r7 r7 207", "ls_r7_r7_207"},
     {{vs, r7, r7, 129}, true, vs, "vs r7 r7 129", "vs_r7_r7_129"},
     {{ne, r3, r3, 41}, true, ne, "ne r3 r3 41", "ne_r3_r3_41"},
     {{ls, r3, r3, 153}, true, ls, "ls r3 r3 153", "ls_r3_r3_153"},
     {{vc, r4, r4, 34}, true, vc, "vc r4 r4 34", "vc_r4_r4_34"},
     {{cc, r7, r7, 140}, true, cc, "cc r7 r7 140", "cc_r7_r7_140"},
     {{ne, r0, r0, 108}, true, ne, "ne r0 r0 108", "ne_r0_r0_108"},
     {{ls, r7, r7, 44}, true, ls, "ls r7 r7 44", "ls_r7_r7_44"},
     {{cs, r6, r6, 128}, true, cs, "cs r6 r6 128", "cs_r6_r6_128"},
     {{ne, r3, r3, 195}, true, ne, "ne r3 r3 195", "ne_r3_r3_195"},
     {{hi, r1, r1, 239}, true, hi, "hi r1 r1 239", "hi_r1_r1_239"},
     {{cc, r3, r3, 243}, true, cc, "cc r3 r3 243", "cc_r3_r3_243"},
     {{pl, r1, r1, 30}, true, pl, "pl r1 r1 30", "pl_r1_r1_30"},
     {{lt, r4, r4, 48}, true, lt, "lt r4 r4 48", "lt_r4_r4_48"},
     {{gt, r5, r5, 92}, true, gt, "gt r5 r5 92", "gt_r5_r5_92"},
     {{pl, r6, r6, 167}, true, pl, "pl r6 r6 167", "pl_r6_r6_167"},
     {{lt, r0, r0, 8}, true, lt, "lt r0 r0 8", "lt_r0_r0_8"},
     {{vc, r4, r4, 49}, true, vc, "vc r4 r4 49", "vc_r4_r4_49"},
     {{mi, r3, r3, 109}, true, mi, "mi r3 r3 109", "mi_r3_r3_109"},
     {{lt, r7, r7, 58}, true, lt, "lt r7 r7 58", "lt_r7_r7_58"},
     {{lt, r6, r6, 54}, true, lt, "lt r6 r6 54", "lt_r6_r6_54"},
     {{eq, r7, r7, 36}, true, eq, "eq r7 r7 36", "eq_r7_r7_36"},
     {{ls, r0, r0, 230}, true, ls, "ls r0 r0 230", "ls_r0_r0_230"},
     {{eq, r7, r7, 133}, true, eq, "eq r7 r7 133", "eq_r7_r7_133"},
     {{hi, r0, r0, 153}, true, hi, "hi r0 r0 153", "hi_r0_r0_153"},
     {{cs, r6, r6, 154}, true, cs, "cs r6 r6 154", "cs_r6_r6_154"},
     {{eq, r6, r6, 178}, true, eq, "eq r6 r6 178", "eq_r6_r6_178"},
     {{hi, r0, r0, 206}, true, hi, "hi r0 r0 206", "hi_r0_r0_206"},
     {{ls, r4, r4, 164}, true, ls, "ls r4 r4 164", "ls_r4_r4_164"},
     {{lt, r3, r3, 60}, true, lt, "lt r3 r3 60", "lt_r3_r3_60"},
     {{cs, r5, r5, 44}, true, cs, "cs r5 r5 44", "cs_r5_r5_44"},
     {{le, r5, r5, 158}, true, le, "le r5 r5 158", "le_r5_r5_158"},
     {{lt, r3, r3, 40}, true, lt, "lt r3 r3 40", "lt_r3_r3_40"},
     {{le, r0, r0, 53}, true, le, "le r0 r0 53", "le_r0_r0_53"},
     {{le, r3, r3, 189}, true, le, "le r3 r3 189", "le_r3_r3_189"},
     {{vs, r3, r3, 8}, true, vs, "vs r3 r3 8", "vs_r3_r3_8"},
     {{vs, r1, r1, 141}, true, vs, "vs r1 r1 141", "vs_r1_r1_141"},
     {{vs, r3, r3, 141}, true, vs, "vs r3 r3 141", "vs_r3_r3_141"},
     {{vs, r2, r2, 141}, true, vs, "vs r2 r2 141", "vs_r2_r2_141"},
     {{ls, r6, r6, 254}, true, ls, "ls r6 r6 254", "ls_r6_r6_254"},
     {{ne, r3, r3, 142}, true, ne, "ne r3 r3 142", "ne_r3_r3_142"},
     {{hi, r0, r0, 167}, true, hi, "hi r0 r0 167", "hi_r0_r0_167"},
     {{cs, r6, r6, 84}, true, cs, "cs r6 r6 84", "cs_r6_r6_84"},
     {{cs, r2, r2, 234}, true, cs, "cs r2 r2 234", "cs_r2_r2_234"},
     {{le, r6, r6, 59}, true, le, "le r6 r6 59", "le_r6_r6_59"},
     {{hi, r2, r2, 135}, true, hi, "hi r2 r2 135", "hi_r2_r2_135"},
     {{gt, r7, r7, 47}, true, gt, "gt r7 r7 47", "gt_r7_r7_47"},
     {{eq, r6, r6, 122}, true, eq, "eq r6 r6 122", "eq_r6_r6_122"},
     {{vc, r7, r7, 118}, true, vc, "vc r7 r7 118", "vc_r7_r7_118"},
     {{cs, r2, r2, 180}, true, cs, "cs r2 r2 180", "cs_r2_r2_180"},
     {{cs, r2, r2, 181}, true, cs, "cs r2 r2 181", "cs_r2_r2_181"},
     {{cc, r1, r1, 190}, true, cc, "cc r1 r1 190", "cc_r1_r1_190"},
     {{ge, r5, r5, 205}, true, ge, "ge r5 r5 205", "ge_r5_r5_205"},
     {{gt, r7, r7, 26}, true, gt, "gt r7 r7 26", "gt_r7_r7_26"},
     {{gt, r4, r4, 70}, true, gt, "gt r4 r4 70", "gt_r4_r4_70"},
     {{eq, r5, r5, 102}, true, eq, "eq r5 r5 102", "eq_r5_r5_102"},
     {{ls, r0, r0, 57}, true, ls, "ls r0 r0 57", "ls_r0_r0_57"},
     {{pl, r1, r1, 229}, true, pl, "pl r1 r1 229", "pl_r1_r1_229"},
     {{ge, r2, r2, 185}, true, ge, "ge r2 r2 185", "ge_r2_r2_185"},
     {{ge, r7, r7, 80}, true, ge, "ge r7 r7 80", "ge_r7_r7_80"},
     {{cs, r6, r6, 123}, true, cs, "cs r6 r6 123", "cs_r6_r6_123"},
     {{pl, r4, r4, 137}, true, pl, "pl r4 r4 137", "pl_r4_r4_137"},
     {{cc, r1, r1, 137}, true, cc, "cc r1 r1 137", "cc_r1_r1_137"},
     {{cs, r1, r1, 67}, true, cs, "cs r1 r1 67", "cs_r1_r1_67"},
     {{vc, r6, r6, 207}, true, vc, "vc r6 r6 207", "vc_r6_r6_207"},
     {{cc, r0, r0, 50}, true, cc, "cc r0 r0 50", "cc_r0_r0_50"},
     {{mi, r3, r3, 72}, true, mi, "mi r3 r3 72", "mi_r3_r3_72"},
     {{ls, r3, r3, 31}, true, ls, "ls r3 r3 31", "ls_r3_r3_31"},
     {{vc, r2, r2, 253}, true, vc, "vc r2 r2 253", "vc_r2_r2_253"},
     {{vc, r3, r3, 155}, true, vc, "vc r3 r3 155", "vc_r3_r3_155"},
     {{lt, r0, r0, 115}, true, lt, "lt r0 r0 115", "lt_r0_r0_115"},
     {{mi, r5, r5, 236}, true, mi, "mi r5 r5 236", "mi_r5_r5_236"},
     {{eq, r5, r5, 151}, true, eq, "eq r5 r5 151", "eq_r5_r5_151"},
     {{eq, r5, r5, 11}, true, eq, "eq r5 r5 11", "eq_r5_r5_11"},
     {{pl, r5, r5, 119}, true, pl, "pl r5 r5 119", "pl_r5_r5_119"},
     {{cc, r3, r3, 192}, true, cc, "cc r3 r3 192", "cc_r3_r3_192"},
     {{vc, r7, r7, 0}, true, vc, "vc r7 r7 0", "vc_r7_r7_0"},
     {{hi, r1, r1, 163}, true, hi, "hi r1 r1 163", "hi_r1_r1_163"},
     {{hi, r2, r2, 136}, true, hi, "hi r2 r2 136", "hi_r2_r2_136"},
     {{cc, r5, r5, 235}, true, cc, "cc r5 r5 235", "cc_r5_r5_235"},
     {{pl, r5, r5, 96}, true, pl, "pl r5 r5 96", "pl_r5_r5_96"},
     {{ge, r3, r3, 163}, true, ge, "ge r3 r3 163", "ge_r3_r3_163"},
     {{cs, r5, r5, 239}, true, cs, "cs r5 r5 239", "cs_r5_r5_239"},
     {{vs, r5, r5, 27}, true, vs, "vs r5 r5 27", "vs_r5_r5_27"},
     {{le, r6, r6, 65}, true, le, "le r6 r6 65", "le_r6_r6_65"},
     {{gt, r0, r0, 169}, true, gt, "gt r0 r0 169", "gt_r0_r0_169"},
     {{ls, r7, r7, 190}, true, ls, "ls r7 r7 190", "ls_r7_r7_190"},
     {{lt, r5, r5, 205}, true, lt, "lt r5 r5 205", "lt_r5_r5_205"},
     {{ne, r2, r2, 253}, true, ne, "ne r2 r2 253", "ne_r2_r2_253"},
     {{cs, r1, r1, 224}, true, cs, "cs r1 r1 224", "cs_r1_r1_224"},
     {{vs, r1, r1, 85}, true, vs, "vs r1 r1 85", "vs_r1_r1_85"},
     {{le, r0, r0, 31}, true, le, "le r0 r0 31", "le_r0_r0_31"},
     {{lt, r2, r2, 7}, true, lt, "lt r2 r2 7", "lt_r2_r2_7"},
     {{ne, r0, r0, 161}, true, ne, "ne r0 r0 161", "ne_r0_r0_161"},
     {{le, r5, r5, 46}, true, le, "le r5 r5 46", "le_r5_r5_46"},
     {{pl, r0, r0, 235}, true, pl, "pl r0 r0 235", "pl_r0_r0_235"},
     {{eq, r6, r6, 113}, true, eq, "eq r6 r6 113", "eq_r6_r6_113"},
     {{mi, r6, r6, 45}, true, mi, "mi r6 r6 45", "mi_r6_r6_45"},
     {{cs, r0, r0, 62}, true, cs, "cs r0 r0 62", "cs_r0_r0_62"},
     {{ge, r2, r2, 225}, true, ge, "ge r2 r2 225", "ge_r2_r2_225"},
     {{vc, r7, r7, 47}, true, vc, "vc r7 r7 47", "vc_r7_r7_47"},
     {{vs, r5, r5, 125}, true, vs, "vs r5 r5 125", "vs_r5_r5_125"},
     {{ls, r2, r2, 184}, true, ls, "ls r2 r2 184", "ls_r2_r2_184"},
     {{ls, r3, r3, 113}, true, ls, "ls r3 r3 113", "ls_r3_r3_113"},
     {{gt, r3, r3, 126}, true, gt, "gt r3 r3 126", "gt_r3_r3_126"},
     {{gt, r5, r5, 101}, true, gt, "gt r5 r5 101", "gt_r5_r5_101"},
     {{lt, r2, r2, 147}, true, lt, "lt r2 r2 147", "lt_r2_r2_147"},
     {{le, r5, r5, 60}, true, le, "le r5 r5 60", "le_r5_r5_60"},
     {{ne, r3, r3, 249}, true, ne, "ne r3 r3 249", "ne_r3_r3_249"},
     {{cs, r3, r3, 6}, true, cs, "cs r3 r3 6", "cs_r3_r3_6"},
     {{vc, r3, r3, 65}, true, vc, "vc r3 r3 65", "vc_r3_r3_65"},
     {{ls, r0, r0, 137}, true, ls, "ls r0 r0 137", "ls_r0_r0_137"},
     {{ls, r0, r0, 148}, true, ls, "ls r0 r0 148", "ls_r0_r0_148"},
     {{cs, r2, r2, 128}, true, cs, "cs r2 r2 128", "cs_r2_r2_128"},
     {{eq, r4, r4, 38}, true, eq, "eq r4 r4 38", "eq_r4_r4_38"},
     {{ne, r2, r2, 57}, true, ne, "ne r2 r2 57", "ne_r2_r2_57"},
     {{ls, r2, r2, 125}, true, ls, "ls r2 r2 125", "ls_r2_r2_125"},
     {{lt, r7, r7, 139}, true, lt, "lt r7 r7 139", "lt_r7_r7_139"},
     {{eq, r2, r2, 213}, true, eq, "eq r2 r2 213", "eq_r2_r2_213"},
     {{vc, r0, r0, 7}, true, vc, "vc r0 r0 7", "vc_r0_r0_7"},
     {{lt, r0, r0, 243}, true, lt, "lt r0 r0 243", "lt_r0_r0_243"},
     {{lt, r0, r0, 227}, true, lt, "lt r0 r0 227", "lt_r0_r0_227"},
     {{ge, r6, r6, 110}, true, ge, "ge r6 r6 110", "ge_r6_r6_110"},
     {{lt, r3, r3, 152}, true, lt, "lt r3 r3 152", "lt_r3_r3_152"},
     {{ge, r7, r7, 198}, true, ge, "ge r7 r7 198", "ge_r7_r7_198"},
     {{mi, r3, r3, 158}, true, mi, "mi r3 r3 158", "mi_r3_r3_158"},
     {{cc, r5, r5, 171}, true, cc, "cc r5 r5 171", "cc_r5_r5_171"},
     {{lt, r5, r5, 227}, true, lt, "lt r5 r5 227", "lt_r5_r5_227"},
     {{gt, r4, r4, 197}, true, gt, "gt r4 r4 197", "gt_r4_r4_197"},
     {{hi, r0, r0, 77}, true, hi, "hi r0 r0 77", "hi_r0_r0_77"},
     {{mi, r2, r2, 223}, true, mi, "mi r2 r2 223", "mi_r2_r2_223"},
     {{pl, r1, r1, 62}, true, pl, "pl r1 r1 62", "pl_r1_r1_62"},
     {{lt, r7, r7, 53}, true, lt, "lt r7 r7 53", "lt_r7_r7_53"},
     {{ge, r5, r5, 153}, true, ge, "ge r5 r5 153", "ge_r5_r5_153"},
     {{ge, r0, r0, 169}, true, ge, "ge r0 r0 169", "ge_r0_r0_169"},
     {{vc, r2, r2, 57}, true, vc, "vc r2 r2 57", "vc_r2_r2_57"},
     {{eq, r4, r4, 121}, true, eq, "eq r4 r4 121", "eq_r4_r4_121"},
     {{lt, r1, r1, 26}, true, lt, "lt r1 r1 26", "lt_r1_r1_26"},
     {{pl, r4, r4, 209}, true, pl, "pl r4 r4 209", "pl_r4_r4_209"},
     {{vc, r3, r3, 233}, true, vc, "vc r3 r3 233", "vc_r3_r3_233"},
     {{hi, r6, r6, 159}, true, hi, "hi r6 r6 159", "hi_r6_r6_159"},
     {{pl, r2, r2, 5}, true, pl, "pl r2 r2 5", "pl_r2_r2_5"},
     {{ne, r4, r4, 227}, true, ne, "ne r4 r4 227", "ne_r4_r4_227"},
     {{cc, r4, r4, 116}, true, cc, "cc r4 r4 116", "cc_r4_r4_116"},
     {{cs, r3, r3, 90}, true, cs, "cs r3 r3 90", "cs_r3_r3_90"},
     {{lt, r5, r5, 178}, true, lt, "lt r5 r5 178", "lt_r5_r5_178"},
     {{cs, r6, r6, 144}, true, cs, "cs r6 r6 144", "cs_r6_r6_144"},
     {{cs, r2, r2, 255}, true, cs, "cs r2 r2 255", "cs_r2_r2_255"},
     {{mi, r2, r2, 207}, true, mi, "mi r2 r2 207", "mi_r2_r2_207"},
     {{ne, r4, r4, 116}, true, ne, "ne r4 r4 116", "ne_r4_r4_116"},
     {{pl, r4, r4, 215}, true, pl, "pl r4 r4 215", "pl_r4_r4_215"},
     {{cs, r5, r5, 24}, true, cs, "cs r5 r5 24", "cs_r5_r5_24"},
     {{vc, r4, r4, 206}, true, vc, "vc r4 r4 206", "vc_r4_r4_206"},
     {{ls, r4, r4, 124}, true, ls, "ls r4 r4 124", "ls_r4_r4_124"},
     {{cs, r4, r4, 169}, true, cs, "cs r4 r4 169", "cs_r4_r4_169"},
     {{ge, r7, r7, 168}, true, ge, "ge r7 r7 168", "ge_r7_r7_168"},
     {{gt, r5, r5, 36}, true, gt, "gt r5 r5 36", "gt_r5_r5_36"},
     {{le, r5, r5, 188}, true, le, "le r5 r5 188", "le_r5_r5_188"},
     {{ne, r6, r6, 157}, true, ne, "ne r6 r6 157", "ne_r6_r6_157"},
     {{eq, r1, r1, 236}, true, eq, "eq r1 r1 236", "eq_r1_r1_236"},
     {{ls, r1, r1, 49}, true, ls, "ls r1 r1 49", "ls_r1_r1_49"},
     {{vs, r3, r3, 127}, true, vs, "vs r3 r3 127", "vs_r3_r3_127"},
     {{le, r1, r1, 232}, true, le, "le r1 r1 232", "le_r1_r1_232"},
     {{ge, r3, r3, 145}, true, ge, "ge r3 r3 145", "ge_r3_r3_145"},
     {{ne, r0, r0, 187}, true, ne, "ne r0 r0 187", "ne_r0_r0_187"},
     {{lt, r0, r0, 30}, true, lt, "lt r0 r0 30", "lt_r0_r0_30"},
     {{mi, r7, r7, 236}, true, mi, "mi r7 r7 236", "mi_r7_r7_236"},
     {{mi, r3, r3, 2}, true, mi, "mi r3 r3 2", "mi_r3_r3_2"},
     {{pl, r0, r0, 192}, true, pl, "pl r0 r0 192", "pl_r0_r0_192"},
     {{ne, r0, r0, 214}, true, ne, "ne r0 r0 214", "ne_r0_r0_214"},
     {{eq, r5, r5, 224}, true, eq, "eq r5 r5 224", "eq_r5_r5_224"},
     {{cs, r7, r7, 157}, true, cs, "cs r7 r7 157", "cs_r7_r7_157"},
     {{vc, r1, r1, 108}, true, vc, "vc r1 r1 108", "vc_r1_r1_108"},
     {{eq, r3, r3, 227}, true, eq, "eq r3 r3 227", "eq_r3_r3_227"},
     {{pl, r0, r0, 185}, true, pl, "pl r0 r0 185", "pl_r0_r0_185"},
     {{cs, r1, r1, 42}, true, cs, "cs r1 r1 42", "cs_r1_r1_42"},
     {{cs, r1, r1, 46}, true, cs, "cs r1 r1 46", "cs_r1_r1_46"},
     {{mi, r5, r5, 132}, true, mi, "mi r5 r5 132", "mi_r5_r5_132"},
     {{ne, r3, r3, 187}, true, ne, "ne r3 r3 187", "ne_r3_r3_187"},
     {{hi, r2, r2, 26}, true, hi, "hi r2 r2 26", "hi_r2_r2_26"},
     {{cs, r5, r5, 135}, true, cs, "cs r5 r5 135", "cs_r5_r5_135"},
     {{vc, r2, r2, 125}, true, vc, "vc r2 r2 125", "vc_r2_r2_125"},
     {{lt, r1, r1, 74}, true, lt, "lt r1 r1 74", "lt_r1_r1_74"},
     {{mi, r7, r7, 83}, true, mi, "mi r7 r7 83", "mi_r7_r7_83"},
     {{cs, r5, r5, 168}, true, cs, "cs r5 r5 168", "cs_r5_r5_168"},
     {{eq, r3, r3, 207}, true, eq, "eq r3 r3 207", "eq_r3_r3_207"},
     {{vc, r0, r0, 44}, true, vc, "vc r0 r0 44", "vc_r0_r0_44"},
     {{ne, r0, r0, 182}, true, ne, "ne r0 r0 182", "ne_r0_r0_182"},
     {{cc, r2, r2, 206}, true, cc, "cc r2 r2 206", "cc_r2_r2_206"},
     {{le, r5, r5, 121}, true, le, "le r5 r5 121", "le_r5_r5_121"},
     {{mi, r4, r4, 133}, true, mi, "mi r4 r4 133", "mi_r4_r4_133"},
     {{le, r2, r2, 73}, true, le, "le r2 r2 73", "le_r2_r2_73"},
     {{gt, r6, r6, 77}, true, gt, "gt r6 r6 77", "gt_r6_r6_77"},
     {{hi, r6, r6, 222}, true, hi, "hi r6 r6 222", "hi_r6_r6_222"},
     {{vs, r4, r4, 113}, true, vs, "vs r4 r4 113", "vs_r4_r4_113"},
     {{cs, r1, r1, 225}, true, cs, "cs r1 r1 225", "cs_r1_r1_225"},
     {{cc, r5, r5, 143}, true, cc, "cc r5 r5 143", "cc_r5_r5_143"},
     {{vs, r0, r0, 117}, true, vs, "vs r0 r0 117", "vs_r0_r0_117"},
     {{vc, r7, r7, 191}, true, vc, "vc r7 r7 191", "vc_r7_r7_191"},
     {{vs, r3, r3, 164}, true, vs, "vs r3 r3 164", "vs_r3_r3_164"},
     {{gt, r0, r0, 185}, true, gt, "gt r0 r0 185", "gt_r0_r0_185"},
     {{gt, r7, r7, 33}, true, gt, "gt r7 r7 33", "gt_r7_r7_33"},
     {{le, r1, r1, 137}, true, le, "le r1 r1 137", "le_r1_r1_137"},
     {{mi, r7, r7, 192}, true, mi, "mi r7 r7 192", "mi_r7_r7_192"},
     {{ne, r0, r0, 82}, true, ne, "ne r0 r0 82", "ne_r0_r0_82"},
     {{mi, r3, r3, 55}, true, mi, "mi r3 r3 55", "mi_r3_r3_55"},
     {{vc, r5, r5, 183}, true, vc, "vc r5 r5 183", "vc_r5_r5_183"},
     {{cs, r5, r5, 22}, true, cs, "cs r5 r5 22", "cs_r5_r5_22"},
     {{cs, r3, r3, 136}, true, cs, "cs r3 r3 136", "cs_r3_r3_136"},
     {{lt, r5, r5, 18}, true, lt, "lt r5 r5 18", "lt_r5_r5_18"},
     {{lt, r5, r5, 154}, true, lt, "lt r5 r5 154", "lt_r5_r5_154"},
     {{le, r4, r4, 197}, true, le, "le r4 r4 197", "le_r4_r4_197"},
     {{lt, r1, r1, 185}, true, lt, "lt r1 r1 185", "lt_r1_r1_185"},
     {{cs, r5, r5, 43}, true, cs, "cs r5 r5 43", "cs_r5_r5_43"},
     {{le, r0, r0, 108}, true, le, "le r0 r0 108", "le_r0_r0_108"},
     {{mi, r1, r1, 227}, true, mi, "mi r1 r1 227", "mi_r1_r1_227"},
     {{cc, r0, r0, 69}, true, cc, "cc r0 r0 69", "cc_r0_r0_69"},
     {{le, r4, r4, 222}, true, le, "le r4 r4 222", "le_r4_r4_222"},
     {{cs, r2, r2, 86}, true, cs, "cs r2 r2 86", "cs_r2_r2_86"},
     {{vs, r3, r3, 10}, true, vs, "vs r3 r3 10", "vs_r3_r3_10"},
     {{mi, r5, r5, 247}, true, mi, "mi r5 r5 247", "mi_r5_r5_247"},
     {{gt, r0, r0, 241}, true, gt, "gt r0 r0 241", "gt_r0_r0_241"},
     {{vs, r3, r3, 109}, true, vs, "vs r3 r3 109", "vs_r3_r3_109"},
     {{ls, r1, r1, 102}, true, ls, "ls r1 r1 102", "ls_r1_r1_102"},
     {{cs, r2, r2, 87}, true, cs, "cs r2 r2 87", "cs_r2_r2_87"},
     {{lt, r0, r0, 253}, true, lt, "lt r0 r0 253", "lt_r0_r0_253"},
     {{eq, r1, r1, 56}, true, eq, "eq r1 r1 56", "eq_r1_r1_56"},
     {{vs, r7, r7, 147}, true, vs, "vs r7 r7 147", "vs_r7_r7_147"},
     {{vs, r5, r5, 10}, true, vs, "vs r5 r5 10", "vs_r5_r5_10"},
     {{lt, r1, r1, 226}, true, lt, "lt r1 r1 226", "lt_r1_r1_226"},
     {{gt, r1, r1, 102}, true, gt, "gt r1 r1 102", "gt_r1_r1_102"},
     {{ls, r7, r7, 66}, true, ls, "ls r7 r7 66", "ls_r7_r7_66"},
     {{cs, r5, r5, 179}, true, cs, "cs r5 r5 179", "cs_r5_r5_179"},
     {{eq, r5, r5, 76}, true, eq, "eq r5 r5 76", "eq_r5_r5_76"},
     {{ls, r2, r2, 217}, true, ls, "ls r2 r2 217", "ls_r2_r2_217"},
     {{pl, r1, r1, 82}, true, pl, "pl r1 r1 82", "pl_r1_r1_82"},
     {{cs, r0, r0, 66}, true, cs, "cs r0 r0 66", "cs_r0_r0_66"},
     {{ne, r4, r4, 69}, true, ne, "ne r4 r4 69", "ne_r4_r4_69"},
     {{cs, r7, r7, 164}, true, cs, "cs r7 r7 164", "cs_r7_r7_164"},
     {{cs, r7, r7, 159}, true, cs, "cs r7 r7 159", "cs_r7_r7_159"},
     {{ge, r6, r6, 123}, true, ge, "ge r6 r6 123", "ge_r6_r6_123"},
     {{ge, r6, r6, 3}, true, ge, "ge r6 r6 3", "ge_r6_r6_3"},
     {{lt, r0, r0, 160}, true, lt, "lt r0 r0 160", "lt_r0_r0_160"},
     {{gt, r4, r4, 228}, true, gt, "gt r4 r4 228", "gt_r4_r4_228"},
     {{hi, r5, r5, 156}, true, hi, "hi r5 r5 156", "hi_r5_r5_156"},
     {{gt, r0, r0, 191}, true, gt, "gt r0 r0 191", "gt_r0_r0_191"},
     {{pl, r1, r1, 178}, true, pl, "pl r1 r1 178", "pl_r1_r1_178"},
     {{vs, r0, r0, 243}, true, vs, "vs r0 r0 243", "vs_r0_r0_243"},
     {{lt, r4, r4, 217}, true, lt, "lt r4 r4 217", "lt_r4_r4_217"},
     {{hi, r3, r3, 90}, true, hi, "hi r3 r3 90", "hi_r3_r3_90"},
     {{eq, r7, r7, 25}, true, eq, "eq r7 r7 25", "eq_r7_r7_25"},
     {{vc, r2, r2, 212}, true, vc, "vc r2 r2 212", "vc_r2_r2_212"},
     {{pl, r0, r0, 252}, true, pl, "pl r0 r0 252", "pl_r0_r0_252"},
     {{cs, r4, r4, 236}, true, cs, "cs r4 r4 236", "cs_r4_r4_236"},
     {{cc, r0, r0, 105}, true, cc, "cc r0 r0 105", "cc_r0_r0_105"},
     {{mi, r3, r3, 134}, true, mi, "mi r3 r3 134", "mi_r3_r3_134"},
     {{pl, r4, r4, 116}, true, pl, "pl r4 r4 116", "pl_r4_r4_116"},
     {{lt, r5, r5, 223}, true, lt, "lt r5 r5 223", "lt_r5_r5_223"},
     {{vs, r2, r2, 242}, true, vs, "vs r2 r2 242", "vs_r2_r2_242"},
     {{cc, r4, r4, 150}, true, cc, "cc r4 r4 150", "cc_r4_r4_150"},
     {{ne, r4, r4, 126}, true, ne, "ne r4 r4 126", "ne_r4_r4_126"},
     {{le, r4, r4, 21}, true, le, "le r4 r4 21", "le_r4_r4_21"},
     {{gt, r2, r2, 159}, true, gt, "gt r2 r2 159", "gt_r2_r2_159"},
     {{vs, r5, r5, 139}, true, vs, "vs r5 r5 139", "vs_r5_r5_139"},
     {{eq, r2, r2, 46}, true, eq, "eq r2 r2 46", "eq_r2_r2_46"},
     {{mi, r4, r4, 68}, true, mi, "mi r4 r4 68", "mi_r4_r4_68"},
     {{mi, r4, r4, 112}, true, mi, "mi r4 r4 112", "mi_r4_r4_112"},
     {{vs, r5, r5, 186}, true, vs, "vs r5 r5 186", "vs_r5_r5_186"},
     {{cc, r5, r5, 216}, true, cc, "cc r5 r5 216", "cc_r5_r5_216"},
     {{lt, r4, r4, 12}, true, lt, "lt r4 r4 12", "lt_r4_r4_12"},
     {{ne, r1, r1, 8}, true, ne, "ne r1 r1 8", "ne_r1_r1_8"},
     {{cc, r1, r1, 83}, true, cc, "cc r1 r1 83", "cc_r1_r1_83"},
     {{eq, r7, r7, 109}, true, eq, "eq r7 r7 109", "eq_r7_r7_109"},
     {{ne, r4, r4, 3}, true, ne, "ne r4 r4 3", "ne_r4_r4_3"},
     {{pl, r5, r5, 62}, true, pl, "pl r5 r5 62", "pl_r5_r5_62"},
     {{gt, r1, r1, 205}, true, gt, "gt r1 r1 205", "gt_r1_r1_205"},
     {{ls, r2, r2, 209}, true, ls, "ls r2 r2 209", "ls_r2_r2_209"},
     {{vc, r6, r6, 252}, true, vc, "vc r6 r6 252", "vc_r6_r6_252"},
     {{cs, r1, r1, 218}, true, cs, "cs r1 r1 218", "cs_r1_r1_218"},
     {{vs, r1, r1, 71}, true, vs, "vs r1 r1 71", "vs_r1_r1_71"},
     {{vs, r2, r2, 247}, true, vs, "vs r2 r2 247", "vs_r2_r2_247"},
     {{pl, r0, r0, 42}, true, pl, "pl r0 r0 42", "pl_r0_r0_42"},
     {{mi, r7, r7, 226}, true, mi, "mi r7 r7 226", "mi_r7_r7_226"},
     {{hi, r4, r4, 14}, true, hi, "hi r4 r4 14", "hi_r4_r4_14"},
     {{ls, r7, r7, 246}, true, ls, "ls r7 r7 246", "ls_r7_r7_246"},
     {{ge, r4, r4, 239}, true, ge, "ge r4 r4 239", "ge_r4_r4_239"},
     {{eq, r1, r1, 187}, true, eq, "eq r1 r1 187", "eq_r1_r1_187"},
     {{gt, r4, r4, 105}, true, gt, "gt r4 r4 105", "gt_r4_r4_105"},
     {{cs, r5, r5, 85}, true, cs, "cs r5 r5 85", "cs_r5_r5_85"},
     {{le, r4, r4, 47}, true, le, "le r4 r4 47", "le_r4_r4_47"},
     {{mi, r4, r4, 98}, true, mi, "mi r4 r4 98", "mi_r4_r4_98"},
     {{gt, r0, r0, 180}, true, gt, "gt r0 r0 180", "gt_r0_r0_180"},
     {{ge, r5, r5, 38}, true, ge, "ge r5 r5 38", "ge_r5_r5_38"},
     {{cc, r2, r2, 61}, true, cc, "cc r2 r2 61", "cc_r2_r2_61"},
     {{lt, r7, r7, 180}, true, lt, "lt r7 r7 180", "lt_r7_r7_180"},
     {{gt, r7, r7, 149}, true, gt, "gt r7 r7 149", "gt_r7_r7_149"},
     {{pl, r6, r6, 146}, true, pl, "pl r6 r6 146", "pl_r6_r6_146"},
     {{pl, r4, r4, 202}, true, pl, "pl r4 r4 202", "pl_r4_r4_202"},
     {{hi, r0, r0, 225}, true, hi, "hi r0 r0 225", "hi_r0_r0_225"},
     {{cs, r5, r5, 142}, true, cs, "cs r5 r5 142", "cs_r5_r5_142"},
     {{lt, r0, r0, 224}, true, lt, "lt r0 r0 224", "lt_r0_r0_224"},
     {{vc, r5, r5, 170}, true, vc, "vc r5 r5 170", "vc_r5_r5_170"},
     {{le, r7, r7, 205}, true, le, "le r7 r7 205", "le_r7_r7_205"},
     {{cs, r2, r2, 228}, true, cs, "cs r2 r2 228", "cs_r2_r2_228"},
     {{cc, r0, r0, 96}, true, cc, "cc r0 r0 96", "cc_r0_r0_96"},
     {{vc, r0, r0, 134}, true, vc, "vc r0 r0 134", "vc_r0_r0_134"},
     {{le, r7, r7, 5}, true, le, "le r7 r7 5", "le_r7_r7_5"},
     {{ne, r0, r0, 33}, true, ne, "ne r0 r0 33", "ne_r0_r0_33"},
     {{vc, r3, r3, 162}, true, vc, "vc r3 r3 162", "vc_r3_r3_162"},
     {{mi, r2, r2, 111}, true, mi, "mi r2 r2 111", "mi_r2_r2_111"},
     {{vs, r1, r1, 210}, true, vs, "vs r1 r1 210", "vs_r1_r1_210"},
     {{mi, r2, r2, 244}, true, mi, "mi r2 r2 244", "mi_r2_r2_244"},
     {{cs, r6, r6, 208}, true, cs, "cs r6 r6 208", "cs_r6_r6_208"},
     {{gt, r1, r1, 213}, true, gt, "gt r1 r1 213", "gt_r1_r1_213"},
     {{ge, r7, r7, 63}, true, ge, "ge r7 r7 63", "ge_r7_r7_63"},
     {{mi, r2, r2, 214}, true, mi, "mi r2 r2 214", "mi_r2_r2_214"},
     {{ne, r6, r6, 224}, true, ne, "ne r6 r6 224", "ne_r6_r6_224"},
     {{vc, r1, r1, 169}, true, vc, "vc r1 r1 169", "vc_r1_r1_169"},
     {{vc, r2, r2, 228}, true, vc, "vc r2 r2 228", "vc_r2_r2_228"},
     {{ge, r1, r1, 161}, true, ge, "ge r1 r1 161", "ge_r1_r1_161"},
     {{vc, r1, r1, 250}, true, vc, "vc r1 r1 250", "vc_r1_r1_250"},
     {{cs, r0, r0, 214}, true, cs, "cs r0 r0 214", "cs_r0_r0_214"},
     {{lt, r0, r0, 104}, true, lt, "lt r0 r0 104", "lt_r0_r0_104"},
     {{cs, r2, r2, 210}, true, cs, "cs r2 r2 210", "cs_r2_r2_210"},
     {{mi, r2, r2, 229}, true, mi, "mi r2 r2 229", "mi_r2_r2_229"},
     {{cs, r5, r5, 55}, true, cs, "cs r5 r5 55", "cs_r5_r5_55"},
     {{lt, r2, r2, 17}, true, lt, "lt r2 r2 17", "lt_r2_r2_17"},
     {{ls, r2, r2, 169}, true, ls, "ls r2 r2 169", "ls_r2_r2_169"},
     {{vc, r6, r6, 74}, true, vc, "vc r6 r6 74", "vc_r6_r6_74"},
     {{ge, r1, r1, 242}, true, ge, "ge r1 r1 242", "ge_r1_r1_242"},
     {{vc, r4, r4, 234}, true, vc, "vc r4 r4 234", "vc_r4_r4_234"},
     {{eq, r2, r2, 147}, true, eq, "eq r2 r2 147", "eq_r2_r2_147"},
     {{vc, r1, r1, 101}, true, vc, "vc r1 r1 101", "vc_r1_r1_101"},
     {{pl, r6, r6, 226}, true, pl, "pl r6 r6 226", "pl_r6_r6_226"},
     {{gt, r6, r6, 184}, true, gt, "gt r6 r6 184", "gt_r6_r6_184"},
     {{gt, r3, r3, 177}, true, gt, "gt r3 r3 177", "gt_r3_r3_177"},
     {{ne, r1, r1, 126}, true, ne, "ne r1 r1 126", "ne_r1_r1_126"},
     {{ls, r5, r5, 222}, true, ls, "ls r5 r5 222", "ls_r5_r5_222"},
     {{hi, r4, r4, 2}, true, hi, "hi r4 r4 2", "hi_r4_r4_2"},
     {{ls, r2, r2, 190}, true, ls, "ls r2 r2 190", "ls_r2_r2_190"},
     {{mi, r4, r4, 254}, true, mi, "mi r4 r4 254", "mi_r4_r4_254"},
     {{pl, r4, r4, 19}, true, pl, "pl r4 r4 19", "pl_r4_r4_19"},
     {{ls, r0, r0, 241}, true, ls, "ls r0 r0 241", "ls_r0_r0_241"},
     {{cc, r3, r3, 148}, true, cc, "cc r3 r3 148", "cc_r3_r3_148"},
     {{gt, r1, r1, 195}, true, gt, "gt r1 r1 195", "gt_r1_r1_195"},
     {{vc, r4, r4, 91}, true, vc, "vc r4 r4 91", "vc_r4_r4_91"},
     {{gt, r0, r0, 227}, true, gt, "gt r0 r0 227", "gt_r0_r0_227"},
     {{vs, r6, r6, 86}, true, vs, "vs r6 r6 86", "vs_r6_r6_86"},
     {{ls, r1, r1, 241}, true, ls, "ls r1 r1 241", "ls_r1_r1_241"},
     {{le, r3, r3, 241}, true, le, "le r3 r3 241", "le_r3_r3_241"},
     {{vs, r2, r2, 217}, true, vs, "vs r2 r2 217", "vs_r2_r2_217"},
     {{ls, r7, r7, 33}, true, ls, "ls r7 r7 33", "ls_r7_r7_33"},
     {{ge, r1, r1, 76}, true, ge, "ge r1 r1 76", "ge_r1_r1_76"},
     {{lt, r2, r2, 34}, true, lt, "lt r2 r2 34", "lt_r2_r2_34"},
     {{gt, r7, r7, 91}, true, gt, "gt r7 r7 91", "gt_r7_r7_91"},
     {{le, r3, r3, 121}, true, le, "le r3 r3 121", "le_r3_r3_121"},
     {{ge, r0, r0, 128}, true, ge, "ge r0 r0 128", "ge_r0_r0_128"},
     {{vc, r6, r6, 199}, true, vc, "vc r6 r6 199", "vc_r6_r6_199"},
     {{hi, r6, r6, 138}, true, hi, "hi r6 r6 138", "hi_r6_r6_138"},
     {{pl, r4, r4, 241}, true, pl, "pl r4 r4 241", "pl_r4_r4_241"},
     {{vc, r5, r5, 246}, true, vc, "vc r5 r5 246", "vc_r5_r5_246"},
     {{cc, r5, r5, 133}, true, cc, "cc r5 r5 133", "cc_r5_r5_133"},
     {{cs, r5, r5, 1}, true, cs, "cs r5 r5 1", "cs_r5_r5_1"},
     {{mi, r1, r1, 233}, true, mi, "mi r1 r1 233", "mi_r1_r1_233"},
     {{cs, r3, r3, 195}, true, cs, "cs r3 r3 195", "cs_r3_r3_195"},
     {{pl, r0, r0, 13}, true, pl, "pl r0 r0 13", "pl_r0_r0_13"},
     {{eq, r5, r5, 187}, true, eq, "eq r5 r5 187", "eq_r5_r5_187"},
     {{ls, r2, r2, 74}, true, ls, "ls r2 r2 74", "ls_r2_r2_74"},
     {{ge, r4, r4, 33}, true, ge, "ge r4 r4 33", "ge_r4_r4_33"},
     {{hi, r3, r3, 253}, true, hi, "hi r3 r3 253", "hi_r3_r3_253"},
     {{pl, r1, r1, 185}, true, pl, "pl r1 r1 185", "pl_r1_r1_185"},
     {{gt, r2, r2, 103}, true, gt, "gt r2 r2 103", "gt_r2_r2_103"},
     {{ls, r3, r3, 255}, true, ls, "ls r3 r3 255", "ls_r3_r3_255"},
     {{vs, r6, r6, 207}, true, vs, "vs r6 r6 207", "vs_r6_r6_207"},
     {{cs, r5, r5, 255}, true, cs, "cs r5 r5 255", "cs_r5_r5_255"},
     {{lt, r1, r1, 107}, true, lt, "lt r1 r1 107", "lt_r1_r1_107"},
     {{le, r3, r3, 122}, true, le, "le r3 r3 122", "le_r3_r3_122"},
     {{vc, r0, r0, 223}, true, vc, "vc r0 r0 223", "vc_r0_r0_223"},
     {{cc, r7, r7, 38}, true, cc, "cc r7 r7 38", "cc_r7_r7_38"},
     {{cc, r4, r4, 207}, true, cc, "cc r4 r4 207", "cc_r4_r4_207"},
     {{hi, r3, r3, 101}, true, hi, "hi r3 r3 101", "hi_r3_r3_101"},
     {{gt, r0, r0, 237}, true, gt, "gt r0 r0 237", "gt_r0_r0_237"},
     {{mi, r6, r6, 13}, true, mi, "mi r6 r6 13", "mi_r6_r6_13"},
     {{cs, r1, r1, 109}, true, cs, "cs r1 r1 109", "cs_r1_r1_109"},
     {{le, r4, r4, 132}, true, le, "le r4 r4 132", "le_r4_r4_132"},
     {{le, r2, r2, 185}, true, le, "le r2 r2 185", "le_r2_r2_185"},
     {{lt, r3, r3, 220}, true, lt, "lt r3 r3 220", "lt_r3_r3_220"},
     {{eq, r7, r7, 248}, true, eq, "eq r7 r7 248", "eq_r7_r7_248"},
     {{le, r7, r7, 146}, true, le, "le r7 r7 146", "le_r7_r7_146"},
     {{hi, r1, r1, 34}, true, hi, "hi r1 r1 34", "hi_r1_r1_34"},
     {{pl, r3, r3, 146}, true, pl, "pl r3 r3 146", "pl_r3_r3_146"},
     {{cs, r6, r6, 22}, true, cs, "cs r6 r6 22", "cs_r6_r6_22"},
     {{lt, r2, r2, 187}, true, lt, "lt r2 r2 187", "lt_r2_r2_187"},
     {{cc, r4, r4, 176}, true, cc, "cc r4 r4 176", "cc_r4_r4_176"},
     {{ge, r3, r3, 233}, true, ge, "ge r3 r3 233", "ge_r3_r3_233"},
     {{ge, r2, r2, 41}, true, ge, "ge r2 r2 41", "ge_r2_r2_41"},
     {{lt, r0, r0, 207}, true, lt, "lt r0 r0 207", "lt_r0_r0_207"},
     {{vc, r0, r0, 147}, true, vc, "vc r0 r0 147", "vc_r0_r0_147"},
     {{pl, r4, r4, 89}, true, pl, "pl r4 r4 89", "pl_r4_r4_89"},
     {{cs, r2, r2, 57}, true, cs, "cs r2 r2 57", "cs_r2_r2_57"},
     {{vc, r0, r0, 24}, true, vc, "vc r0 r0 24", "vc_r0_r0_24"},
     {{mi, r6, r6, 114}, true, mi, "mi r6 r6 114", "mi_r6_r6_114"},
     {{pl, r4, r4, 109}, true, pl, "pl r4 r4 109", "pl_r4_r4_109"},
     {{mi, r7, r7, 98}, true, mi, "mi r7 r7 98", "mi_r7_r7_98"},
     {{eq, r5, r5, 124}, true, eq, "eq r5 r5 124", "eq_r5_r5_124"},
     {{le, r3, r3, 253}, true, le, "le r3 r3 253", "le_r3_r3_253"},
     {{hi, r5, r5, 149}, true, hi, "hi r5 r5 149", "hi_r5_r5_149"},
     {{cc, r5, r5, 5}, true, cc, "cc r5 r5 5", "cc_r5_r5_5"},
     {{cs, r1, r1, 149}, true, cs, "cs r1 r1 149", "cs_r1_r1_149"},
     {{gt, r3, r3, 149}, true, gt, "gt r3 r3 149", "gt_r3_r3_149"},
     {{vs, r3, r3, 20}, true, vs, "vs r3 r3 20", "vs_r3_r3_20"},
     {{lt, r7, r7, 241}, true, lt, "lt r7 r7 241", "lt_r7_r7_241"},
     {{cs, r2, r2, 42}, true, cs, "cs r2 r2 42", "cs_r2_r2_42"},
     {{vs, r2, r2, 122}, true, vs, "vs r2 r2 122", "vs_r2_r2_122"},
     {{ne, r0, r0, 203}, true, ne, "ne r0 r0 203", "ne_r0_r0_203"},
     {{cc, r4, r4, 80}, true, cc, "cc r4 r4 80", "cc_r4_r4_80"},
     {{gt, r0, r0, 162}, true, gt, "gt r0 r0 162", "gt_r0_r0_162"},
     {{gt, r4, r4, 155}, true, gt, "gt r4 r4 155", "gt_r4_r4_155"},
     {{mi, r1, r1, 93}, true, mi, "mi r1 r1 93", "mi_r1_r1_93"},
     {{gt, r2, r2, 94}, true, gt, "gt r2 r2 94", "gt_r2_r2_94"},
     {{eq, r0, r0, 87}, true, eq, "eq r0 r0 87", "eq_r0_r0_87"},
     {{pl, r1, r1, 141}, true, pl, "pl r1 r1 141", "pl_r1_r1_141"},
     {{cc, r6, r6, 42}, true, cc, "cc r6 r6 42", "cc_r6_r6_42"},
     {{vc, r0, r0, 178}, true, vc, "vc r0 r0 178", "vc_r0_r0_178"},
     {{pl, r6, r6, 109}, true, pl, "pl r6 r6 109", "pl_r6_r6_109"},
     {{mi, r0, r0, 186}, true, mi, "mi r0 r0 186", "mi_r0_r0_186"},
     {{gt, r6, r6, 116}, true, gt, "gt r6 r6 116", "gt_r6_r6_116"},
     {{vc, r3, r3, 249}, true, vc, "vc r3 r3 249", "vc_r3_r3_249"},
     {{vs, r6, r6, 197}, true, vs, "vs r6 r6 197", "vs_r6_r6_197"},
     {{hi, r5, r5, 176}, true, hi, "hi r5 r5 176", "hi_r5_r5_176"},
     {{ls, r3, r3, 10}, true, ls, "ls r3 r3 10", "ls_r3_r3_10"},
     {{ge, r0, r0, 120}, true, ge, "ge r0 r0 120", "ge_r0_r0_120"},
     {{ge, r0, r0, 197}, true, ge, "ge r0 r0 197", "ge_r0_r0_197"},
     {{ls, r7, r7, 149}, true, ls, "ls r7 r7 149", "ls_r7_r7_149"},
     {{mi, r2, r2, 219}, true, mi, "mi r2 r2 219", "mi_r2_r2_219"},
     {{lt, r4, r4, 130}, true, lt, "lt r4 r4 130", "lt_r4_r4_130"},
     {{pl, r4, r4, 220}, true, pl, "pl r4 r4 220", "pl_r4_r4_220"},
     {{gt, r2, r2, 101}, true, gt, "gt r2 r2 101", "gt_r2_r2_101"},
     {{pl, r6, r6, 111}, true, pl, "pl r6 r6 111", "pl_r6_r6_111"},
     {{hi, r2, r2, 21}, true, hi, "hi r2 r2 21", "hi_r2_r2_21"},
     {{lt, r5, r5, 174}, true, lt, "lt r5 r5 174", "lt_r5_r5_174"},
     {{hi, r0, r0, 190}, true, hi, "hi r0 r0 190", "hi_r0_r0_190"},
     {{ge, r7, r7, 166}, true, ge, "ge r7 r7 166", "ge_r7_r7_166"},
     {{vc, r5, r5, 251}, true, vc, "vc r5 r5 251", "vc_r5_r5_251"},
     {{ne, r2, r2, 174}, true, ne, "ne r2 r2 174", "ne_r2_r2_174"},
     {{eq, r6, r6, 255}, true, eq, "eq r6 r6 255", "eq_r6_r6_255"},
     {{ls, r5, r5, 186}, true, ls, "ls r5 r5 186", "ls_r5_r5_186"},
     {{vs, r3, r3, 75}, true, vs, "vs r3 r3 75", "vs_r3_r3_75"},
     {{cs, r2, r2, 15}, true, cs, "cs r2 r2 15", "cs_r2_r2_15"},
     {{hi, r6, r6, 133}, true, hi, "hi r6 r6 133", "hi_r6_r6_133"},
     {{vc, r0, r0, 188}, true, vc, "vc r0 r0 188", "vc_r0_r0_188"},
     {{ne, r2, r2, 85}, true, ne, "ne r2 r2 85", "ne_r2_r2_85"},
     {{hi, r2, r2, 116}, true, hi, "hi r2 r2 116", "hi_r2_r2_116"},
     {{le, r3, r3, 91}, true, le, "le r3 r3 91", "le_r3_r3_91"},
     {{pl, r1, r1, 222}, true, pl, "pl r1 r1 222", "pl_r1_r1_222"},
     {{mi, r0, r0, 33}, true, mi, "mi r0 r0 33", "mi_r0_r0_33"},
     {{vs, r3, r3, 26}, true, vs, "vs r3 r3 26", "vs_r3_r3_26"},
     {{cc, r5, r5, 182}, true, cc, "cc r5 r5 182", "cc_r5_r5_182"},
     {{gt, r0, r0, 62}, true, gt, "gt r0 r0 62", "gt_r0_r0_62"},
     {{vc, r1, r1, 189}, true, vc, "vc r1 r1 189", "vc_r1_r1_189"},
     {{pl, r2, r2, 180}, true, pl, "pl r2 r2 180", "pl_r2_r2_180"},
     {{mi, r5, r5, 15}, true, mi, "mi r5 r5 15", "mi_r5_r5_15"},
     {{lt, r4, r4, 24}, true, lt, "lt r4 r4 24", "lt_r4_r4_24"},
     {{cs, r6, r6, 190}, true, cs, "cs r6 r6 190", "cs_r6_r6_190"},
     {{ne, r6, r6, 168}, true, ne, "ne r6 r6 168", "ne_r6_r6_168"},
     {{ls, r2, r2, 48}, true, ls, "ls r2 r2 48", "ls_r2_r2_48"},
     {{vs, r7, r7, 6}, true, vs, "vs r7 r7 6", "vs_r7_r7_6"},
     {{cs, r4, r4, 80}, true, cs, "cs r4 r4 80", "cs_r4_r4_80"},
     {{ls, r3, r3, 75}, true, ls, "ls r3 r3 75", "ls_r3_r3_75"},
     {{ge, r2, r2, 236}, true, ge, "ge r2 r2 236", "ge_r2_r2_236"},
     {{hi, r1, r1, 9}, true, hi, "hi r1 r1 9", "hi_r1_r1_9"},
     {{cs, r1, r1, 51}, true, cs, "cs r1 r1 51", "cs_r1_r1_51"},
     {{cc, r1, r1, 139}, true, cc, "cc r1 r1 139", "cc_r1_r1_139"},
     {{cc, r2, r2, 204}, true, cc, "cc r2 r2 204", "cc_r2_r2_204"},
     {{gt, r2, r2, 216}, true, gt, "gt r2 r2 216", "gt_r2_r2_216"},
     {{vc, r7, r7, 60}, true, vc, "vc r7 r7 60", "vc_r7_r7_60"},
     {{pl, r6, r6, 249}, true, pl, "pl r6 r6 249", "pl_r6_r6_249"},
     {{cs, r1, r1, 169}, true, cs, "cs r1 r1 169", "cs_r1_r1_169"},
     {{eq, r6, r6, 33}, true, eq, "eq r6 r6 33", "eq_r6_r6_33"},
     {{ne, r0, r0, 91}, true, ne, "ne r0 r0 91", "ne_r0_r0_91"},
     {{vc, r4, r4, 56}, true, vc, "vc r4 r4 56", "vc_r4_r4_56"},
     {{ge, r5, r5, 26}, true, ge, "ge r5 r5 26", "ge_r5_r5_26"},
     {{lt, r6, r6, 210}, true, lt, "lt r6 r6 210", "lt_r6_r6_210"},
     {{le, r6, r6, 122}, true, le, "le r6 r6 122", "le_r6_r6_122"},
     {{ls, r4, r4, 118}, true, ls, "ls r4 r4 118", "ls_r4_r4_118"},
     {{lt, r3, r3, 59}, true, lt, "lt r3 r3 59", "lt_r3_r3_59"},
     {{cc, r3, r3, 144}, true, cc, "cc r3 r3 144", "cc_r3_r3_144"},
     {{le, r6, r6, 159}, true, le, "le r6 r6 159", "le_r6_r6_159"},
     {{lt, r0, r0, 25}, true, lt, "lt r0 r0 25", "lt_r0_r0_25"},
     {{vs, r0, r0, 150}, true, vs, "vs r0 r0 150", "vs_r0_r0_150"},
     {{ne, r1, r1, 91}, true, ne, "ne r1 r1 91", "ne_r1_r1_91"},
     {{ls, r2, r2, 65}, true, ls, "ls r2 r2 65", "ls_r2_r2_65"},
     {{lt, r3, r3, 80}, true, lt, "lt r3 r3 80", "lt_r3_r3_80"},
     {{eq, r0, r0, 37}, true, eq, "eq r0 r0 37", "eq_r0_r0_37"},
     {{ne, r4, r4, 71}, true, ne, "ne r4 r4 71", "ne_r4_r4_71"},
     {{ls, r7, r7, 169}, true, ls, "ls r7 r7 169", "ls_r7_r7_169"},
     {{cs, r0, r0, 141}, true, cs, "cs r0 r0 141", "cs_r0_r0_141"},
     {{pl, r3, r3, 190}, true, pl, "pl r3 r3 190", "pl_r3_r3_190"},
     {{pl, r7, r7, 53}, true, pl, "pl r7 r7 53", "pl_r7_r7_53"},
     {{vc, r3, r3, 60}, true, vc, "vc r3 r3 60", "vc_r3_r3_60"},
     {{ge, r3, r3, 104}, true, ge, "ge r3 r3 104", "ge_r3_r3_104"},
     {{pl, r1, r1, 93}, true, pl, "pl r1 r1 93", "pl_r1_r1_93"},
     {{pl, r7, r7, 234}, true, pl, "pl r7 r7 234", "pl_r7_r7_234"},
     {{lt, r0, r0, 226}, true, lt, "lt r0 r0 226", "lt_r0_r0_226"},
     {{mi, r1, r1, 207}, true, mi, "mi r1 r1 207", "mi_r1_r1_207"},
     {{le, r1, r1, 152}, true, le, "le r1 r1 152", "le_r1_r1_152"},
     {{gt, r6, r6, 151}, true, gt, "gt r6 r6 151", "gt_r6_r6_151"},
     {{ge, r4, r4, 127}, true, ge, "ge r4 r4 127", "ge_r4_r4_127"},
     {{lt, r1, r1, 167}, true, lt, "lt r1 r1 167", "lt_r1_r1_167"},
     {{pl, r2, r2, 206}, true, pl, "pl r2 r2 206", "pl_r2_r2_206"},
     {{ge, r1, r1, 241}, true, ge, "ge r1 r1 241", "ge_r1_r1_241"},
     {{vs, r3, r3, 156}, true, vs, "vs r3 r3 156", "vs_r3_r3_156"},
     {{gt, r0, r0, 125}, true, gt, "gt r0 r0 125", "gt_r0_r0_125"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rdlow-rnlow-operand-immediate-imm8-in-it-block-add-t32.h"
#include "aarch32/traces/assembler-cond-rdlow-rnlow-operand-immediate-imm8-in-it-block-sub-t32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   Register rn,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseT32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    int32_t immediate = kTests[i].operands.immediate;
    Operand op(immediate);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, rn, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RDLOW_RNLOW_OPERAND_IMMEDIATE_IMM8_IN_IT_"    \
      "BLOCK_" #mnemonic "_T32",                                            \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
