// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SRHADD_4H_TRACE_AARCH64_H_
#define VIXL_SIM_SRHADD_4H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_srhadd_4H[] = {
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x19d9, 0x4444, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x403e, 0x5999, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x5999, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x199a, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x0040, 0x199a, 0x2aac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x199b, 0x2ab3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x0041, 0x19a2, 0x2ae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x0048, 0x19d8, 0x2aea, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0047, 0x007e, 0x19d9, 0x2aea, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x19d9, 0x4444, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x19d9, 0x4444, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x403e, 0x5999, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x5999, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0xd99a, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0xc040, 0xd99a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc040, 0xeeef, 0x1111, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd595, 0x0000, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd594, 0xe6a6, 0x195a, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a5, 0x0000, 0x195a, 0x2a6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x195b, 0x2a6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x195b, 0x2a6c, 0x3ff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x195b, 0x2aa3, 0x3ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x1992, 0x2aa9, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0038, 0x1998, 0x2aaa, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x1999, 0x2aaa, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x1999, 0x2aab, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x199a, 0x2aab, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x199a, 0x2aac, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x199b, 0x2ab3, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0041, 0x19a2, 0x2ae9, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0048, 0x19d8, 0x2aea, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x19d9, 0x2aea, 0x5998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x19d9, 0x4444, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5999, 0x6aaa, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5999, 0xeaab, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0xd99a, 0xeaab, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd99a, 0x0000, 0x2665, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xeeef, 0x1111, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd595, 0x0000, 0x2a6b, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a6, 0x195a, 0x2a6b, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x195a, 0x2a6c, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195a, 0x2a6c, 0x3fc0, 0x3ff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195b, 0x2a6c, 0x3ff7, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195b, 0x2aa3, 0x3ffd, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1992, 0x2aa9, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1998, 0x2aaa, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x2aaa, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x2aab, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aab, 0x4000, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aac, 0x4007, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199b, 0x2ab3, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19a2, 0x2ae9, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2aea, 0x403e, 0x5999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aaa, 0x7ffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x6aaa, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0xeaab, 0xffff, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0xeaab, 0x1554, 0x2665, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0x0000, 0x2665, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0x1111, 0x3fbf, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2a6b, 0x3fbf, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195a, 0x2a6b, 0x3fc0, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6b, 0x3fc0, 0x3fc1, 0x3ff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6c, 0x3fc0, 0x3ff7, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6c, 0x3ff7, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa3, 0x3ffd, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x3ffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x3ffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x3fff, 0x4000, 0x4001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x3fff, 0x4000, 0x4008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x4000, 0x4007, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x4007, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ab3, 0x403d, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ae9, 0x403e, 0x403f, 0x5999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x403e, 0x5999, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x7ffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0xffff, 0x0000, 0x1555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0xffff, 0x1554, 0x2666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0x1554, 0x2665, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2665, 0x3fbf, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1111, 0x3fbf, 0x3fc0, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6b, 0x3fbf, 0x3fc0, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x3fc0, 0x3fc1, 0xfff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc1, 0x3ff8, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3ff7, 0x3ffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff7, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffd, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3fff, 0x4000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3fff, 0x4000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4001, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4008, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4007, 0x403e, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x403e, 0x403f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x403f, 0x199a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x5999, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5999, 0x6aaa, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aaa, 0x7ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffe, 0x7fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x0000, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xffff, 0x0000, 0xd555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x1555, 0xe666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x1554, 0x2666, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1554, 0x2665, 0x3fc0, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2665, 0x3fbf, 0x3fc0, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x3fc0, 0x3fc1, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc1, 0xffc2, 0xfff9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc1, 0xfff8, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0x3ff8, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff7, 0x3ffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3fff, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3fff, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x0001, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x0001, 0x0009, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4001, 0x0008, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4008, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x403e, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x0040, 0x199a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x199a, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5999, 0x2aab, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x6aaa, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x7ffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x4000, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0xc000, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0000, 0xc001, 0xd556, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0xd555, 0xe667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1555, 0xe666, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1554, 0x2666, 0xffc0, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2665, 0x3fc0, 0xffc1, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x3fc0, 0xffc1, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0xffc1, 0xffc2, 0xfff9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0xffc2, 0xfff9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0xfff8, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff8, 0xffff, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0xffff, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x0000, 0x0001, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x0000, 0x0001, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x0001, 0x0002, 0x0009, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x0001, 0x0009, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4001, 0x0008, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4008, 0x003f, 0x0040, 0x0041, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x003f, 0x0040, 0x199b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x0040, 0x199a, 0x2aac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x199a, 0x2aab, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x2aab, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x3fff, 0x4000, 0x4001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x3fff, 0x4000, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x4000, 0xc001, 0xc002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xc000, 0xc001, 0xd556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc001, 0xd556, 0xe667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xd555, 0xe667, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1555, 0xe666, 0xffc1, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2666, 0xffc0, 0xffc1, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0xffc1, 0xffc2, 0xffc3, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc2, 0xffc3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc2, 0xfff9, 0x0007, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc2, 0xfff9, 0x0000, 0x0007, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff8, 0xffff, 0x0000, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x0001, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x0001, 0x0009, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0009, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0002, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0009, 0x0047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0009, 0x0040, 0x0047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0008, 0x003f, 0x0040, 0x0048, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x0041, 0x19a2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x199b, 0x2ab3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x199a, 0x2aac, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aab, 0x4000, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x3fff, 0x4000, 0x4008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4001, 0xc008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0xc001, 0xc009, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0xc001, 0xc002, 0xd55d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc001, 0xd556, 0xe66e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xd556, 0xe667, 0xffc8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xe667, 0xffc1, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe666, 0xffc1, 0xffc2, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc0, 0xffc1, 0xffc2, 0xffca, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc2, 0xffca, 0x0037, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc2, 0xffc3, 0x0000, 0x003d, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc2, 0xfff9, 0x0007, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff9, 0x0000, 0x0007, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x0008, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0008, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0009, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0009, 0x0047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0002, 0x0010, 0x007d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0009, 0x0047, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0009, 0x0040, 0x0047, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x0048, 0x19d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x0041, 0x19a2, 0x2ae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x199b, 0x2ab3, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aac, 0x4007, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x4000, 0x4007, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4008, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4001, 0xc008, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0xc001, 0xc009, 0xd594, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc002, 0xd55d, 0xe6a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xd556, 0xe66e, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0xe667, 0xffc8, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xffc1, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc2, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc2, 0xffc9, 0x0000, 0x0037, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc2, 0xffca, 0x0037, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc3, 0x0000, 0x003d, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff9, 0x0007, 0x003e, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0007, 0x003e, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0008, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0008, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0009, 0x0040, 0x0047, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0009, 0x0047, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0010, 0x007d, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0009, 0x0047, 0x007e, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x0047, 0x007e, 0x19d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x0048, 0x19d8, 0x2aea, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0041, 0x19a2, 0x2ae9, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199b, 0x2ab3, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x4007, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4007, 0x403e, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4008, 0xc03f, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4001, 0xc008, 0xc03f, 0xd594, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc009, 0xd594, 0xe6a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc002, 0xd55d, 0xe6a5, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0xe66e, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xffc8, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc9, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc9, 0x0000, 0x0001, 0x0038, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc9, 0x0000, 0x0037, 0x003e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffca, 0x0037, 0x003e, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x003d, 0x003e, 0x003f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0007, 0x003e, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0007, 0x003e, 0x003f, 0x0040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0008, 0x003f, 0x0040, 0x0041, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0008, 0x003f, 0x0040, 0x0048, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0009, 0x0040, 0x0047, 0x007e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0009, 0x0047, 0x007e, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x007d, 0x007e, 0x007f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0047, 0x007e, 0x007f, 0x19d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0047, 0x007e, 0x19d9, 0x2aea, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0048, 0x19d8, 0x2aea, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19a2, 0x2ae9, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ab3, 0x403d, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x403e, 0x403f, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x403e, 0xc03f, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4008, 0xc03f, 0xc040, 0xd595, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc008, 0xc03f, 0xd594, 0xe6a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc009, 0xd594, 0xe6a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd55d, 0xe6a5, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe66e, 0xffff, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc8, 0xffff, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x0001, 0x1992, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0038, 0x1998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0037, 0x003e, 0x1999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0037, 0x003e, 0x003f, 0x1999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003d, 0x003e, 0x003f, 0x199a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x003f, 0x0040, 0x199a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x003f, 0x0040, 0x199b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x0041, 0x19a2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x0048, 0x19d8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x0047, 0x007e, 0x19d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0047, 0x007e, 0x007f, 0x19d9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x007e, 0x007f, 0x3333, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x19d9, 0x4444, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x19d9, 0x2aea, 0x5998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2aea, 0x403e, 0x5999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ae9, 0x403e, 0x403f, 0x5999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x403f, 0xd99a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0xc040, 0xd99a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0xc03f, 0xc040, 0xeeef, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc040, 0xd595, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xd594, 0xe6a6, 0x195a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd594, 0xe6a5, 0x0000, 0x195a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a5, 0xffff, 0x0000, 0x195b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x0001, 0x195b, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x195b, 0x2aa3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x1992, 0x2aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0038, 0x1998, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0037, 0x003e, 0x1999, 0x2aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x003f, 0x1999, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x003f, 0x199a, 0x2aab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x199a, 0x2aac, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x0040, 0x199b, 0x2ab3, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x0041, 0x19a2, 0x2ae9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x0048, 0x19d8, 0x2aea, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0047, 0x007e, 0x19d9, 0x2aea, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x19d9, 0x4444, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x19d9, 0x4444, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x403e, 0x5999, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x5999, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0xd99a, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0xc040, 0xd99a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc040, 0xeeef, 0x1111, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd595, 0x0000, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd594, 0xe6a6, 0x195a, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a5, 0x0000, 0x195a, 0x2a6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x195b, 0x2a6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x195b, 0x2a6c, 0x3ff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x195b, 0x2aa3, 0x3ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x1992, 0x2aa9, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0038, 0x1998, 0x2aaa, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x1999, 0x2aaa, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x1999, 0x2aab, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x199a, 0x2aab, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x199a, 0x2aac, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0040, 0x199b, 0x2ab3, 0x403d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0041, 0x19a2, 0x2ae9, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0048, 0x19d8, 0x2aea, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x19d9, 0x2aea, 0x5998, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x19d9, 0x4444, 0x6aa9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5999, 0x6aaa, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5999, 0xeaab, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0xd99a, 0xeaab, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd99a, 0x0000, 0x2665, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xeeef, 0x1111, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd595, 0x0000, 0x2a6b, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a6, 0x195a, 0x2a6b, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x195a, 0x2a6c, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195a, 0x2a6c, 0x3fc0, 0x3ff7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195b, 0x2a6c, 0x3ff7, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195b, 0x2aa3, 0x3ffd, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1992, 0x2aa9, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1998, 0x2aaa, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x2aaa, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x2aab, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aab, 0x4000, 0x4007, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199a, 0x2aac, 0x4007, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x199b, 0x2ab3, 0x403d, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19a2, 0x2ae9, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2aea, 0x403e, 0x5999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aaa, 0x7ffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x6aaa, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0xeaab, 0xffff, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0xeaab, 0x1554, 0x2665, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0x0000, 0x2665, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0x1111, 0x3fbf, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2a6b, 0x3fbf, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195a, 0x2a6b, 0x3fc0, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6b, 0x3fc0, 0x3fc1, 0x3ff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6c, 0x3fc0, 0x3ff7, 0x3ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6c, 0x3ff7, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa3, 0x3ffd, 0x3ffe, 0x3fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aa9, 0x3ffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x3ffe, 0x3fff, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x3fff, 0x4000, 0x4001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x3fff, 0x4000, 0x4008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aab, 0x4000, 0x4007, 0x403e, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x4007, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ab3, 0x403d, 0x403e, 0x403f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ae9, 0x403e, 0x403f, 0x5999, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x403e, 0x5999, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x7ffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0xffff, 0x0000, 0x1555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0xffff, 0x1554, 0x2666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0x1554, 0x2665, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2665, 0x3fbf, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1111, 0x3fbf, 0x3fc0, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6b, 0x3fbf, 0x3fc0, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x3fc0, 0x3fc1, 0xbff8, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc1, 0x3ff8, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3ff7, 0x3ffe, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff7, 0x3ffe, 0x3fff, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffd, 0x3ffe, 0x3fff, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3fff, 0x4000, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3fff, 0x4000, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4001, 0xc008, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0x4008, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4007, 0x403e, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x403e, 0x403f, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403d, 0x403e, 0x403f, 0xd99a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0x5999, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x5999, 0x6aaa, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5998, 0x6aaa, 0x7ffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aa9, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x0000, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xffff, 0x0000, 0x9555, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x1555, 0xa666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x1554, 0x2666, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1554, 0x2665, 0x3fc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2665, 0x3fbf, 0x3fc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x3fc0, 0x3fc1, 0xbfc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc1, 0xbfc2, 0xbff9, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0x3fc1, 0xbff8, 0xbfff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0x3ff8, 0xbfff, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff7, 0x3ffe, 0xbfff, 0xc000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3fff, 0xc000, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x3fff, 0xc000, 0xc001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0xc001, 0xc002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x4000, 0xc001, 0xc009, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4001, 0xc008, 0xc03f, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0x4008, 0xc03f, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4007, 0x403e, 0xc03f, 0xc040, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0xc040, 0xd99a, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0x403f, 0xd99a, 0xeaab, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0x5999, 0xeaab, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0x6aaa, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0x7ffe, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x0000, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x8000, 0x8001, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0000, 0x8001, 0x9556, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x9555, 0xa667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1555, 0xa666, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1554, 0x2666, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2665, 0x3fc0, 0xbfc1, 0xbfc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x3fc0, 0xbfc1, 0xbfc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0xbfc1, 0xbfc2, 0xd54d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0xbfc2, 0xbff9, 0xd554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc1, 0xbff8, 0xbfff, 0xd554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ff8, 0xbfff, 0xc000, 0xd555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0xbfff, 0xc000, 0xd555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0xc000, 0xc001, 0xd556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0xc000, 0xc001, 0xd556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0xc001, 0xc002, 0xd55d, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4000, 0xc001, 0xc009, 0xd594, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4001, 0xc008, 0xc03f, 0xd594, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4008, 0xc03f, 0xc040, 0xd595, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403e, 0xc03f, 0xc040, 0xeeef, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0xc040, 0xd99a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x403f, 0xd99a, 0xeaab, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5999, 0xeaab, 0xffff, 0x1554, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6aaa, 0xffff, 0x0000, 0x1555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0xffff, 0x0000, 0x9555, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0000, 0x8001, 0x9556, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x8000, 0x8001, 0xaaaa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8001, 0x9556, 0xbbbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9555, 0xa667, 0xd515, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1555, 0xa666, 0xbfc1, 0xd516, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2666, 0xbfc0, 0xbfc1, 0xd516, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0xbfc1, 0xbfc2, 0xd517, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc1, 0xbfc2, 0xd517, 0xe65e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc1, 0xbfc2, 0xd54d, 0xe665, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc2, 0xbff9, 0xd554, 0xe665, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbff8, 0xbfff, 0xd554, 0xe666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0xc000, 0xd555, 0xe666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0xc000, 0xd555, 0xe667, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc001, 0xd556, 0xe667, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xc001, 0xd556, 0xe66e, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc002, 0xd55d, 0xe6a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xc009, 0xd594, 0xe6a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc008, 0xc03f, 0xd594, 0xe6a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc040, 0xd595, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xc040, 0xeeef, 0x1111, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd99a, 0x0000, 0x2665, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0xeaab, 0x1554, 0x2665, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0xffff, 0x1554, 0x2666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x1555, 0xa666, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x9555, 0xa667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8001, 0x9556, 0xbbbb, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8000, 0x8001, 0xaaaa, 0xcccc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x9556, 0xbbbb, 0xe626, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9555, 0xa667, 0xd515, 0xe627, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa666, 0xbfc1, 0xd516, 0xe627, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbfc1, 0xd516, 0xe628, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc1, 0xd516, 0xe628, 0xffb8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc2, 0xd517, 0xe65e, 0xffbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc2, 0xd54d, 0xe665, 0xffbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbff9, 0xd554, 0xe665, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfff, 0xd554, 0xe666, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xd555, 0xe666, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc000, 0xd555, 0xe667, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xd556, 0xe667, 0xffc8, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc001, 0xd556, 0xe66e, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc002, 0xd55d, 0xe6a5, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc009, 0xd594, 0xe6a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc03f, 0xd594, 0xe6a6, 0x195a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xd595, 0x0000, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xc040, 0xeeef, 0x1111, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd99a, 0x0000, 0x2665, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0x1554, 0x2665, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x1554, 0x2666, 0xbfc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1555, 0xa666, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9555, 0xa667, 0xd515, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0x9556, 0xbbbb, 0xe626, 0x0000, 0x0000, 0x0000, 0x0000,
  0x8001, 0xaaaa, 0xcccc, 0xff80, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9556, 0xbbbb, 0xe626, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa667, 0xd515, 0xe627, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc1, 0xd516, 0xe627, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd516, 0xe627, 0xff82, 0xffb9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd516, 0xe628, 0xffb8, 0xffbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd517, 0xe65e, 0xffbf, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd54d, 0xe665, 0xffbf, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xe665, 0xffc0, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd554, 0xe666, 0xffc0, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xe666, 0xffc1, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd555, 0xe667, 0xffc1, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0xe667, 0xffc8, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd556, 0xe66e, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd55d, 0xe6a5, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd594, 0xe6a5, 0x0000, 0x195a, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd594, 0xe6a6, 0x195a, 0x2a6b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd595, 0x0000, 0x2a6b, 0x3fbf, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0x1111, 0x3fbf, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2665, 0x3fbf, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1554, 0x2665, 0x3fc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1554, 0x2666, 0xbfc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1555, 0xa666, 0xbfc1, 0xd516, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9555, 0xa667, 0xd515, 0xe627, 0x0000, 0x0000, 0x0000, 0x0000,
  0x9556, 0xbbbb, 0xe626, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xaaaa, 0xcccc, 0xff80, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbbbb, 0xe626, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd515, 0xe627, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe627, 0xff81, 0xff82, 0xffb9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe627, 0xff82, 0xffb9, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe628, 0xffb8, 0xffbf, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe65e, 0xffbf, 0xffc0, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe665, 0xffbf, 0xffc0, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe665, 0xffc0, 0xffc1, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe666, 0xffc0, 0xffc1, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe666, 0xffc1, 0xffc2, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xffc1, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe667, 0xffc8, 0xffff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe66e, 0xffff, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a5, 0xffff, 0x0000, 0x195b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a5, 0x0000, 0x195a, 0x2a6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a6, 0x195a, 0x2a6b, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2a6b, 0x3fbf, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1111, 0x3fbf, 0x3fc0, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2665, 0x3fbf, 0x3fc0, 0xbfc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2665, 0x3fc0, 0xbfc1, 0xbfc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2666, 0xbfc0, 0xbfc1, 0xd516, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa666, 0xbfc1, 0xd516, 0xe627, 0x0000, 0x0000, 0x0000, 0x0000,
  0xa667, 0xd515, 0xe627, 0xff81, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbbbb, 0xe626, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xcccc, 0xff80, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe626, 0xff81, 0xff82, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff82, 0xff83, 0xffba, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff81, 0xff82, 0xffb9, 0xffc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff82, 0xffb9, 0xffc0, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffb8, 0xffbf, 0xffc0, 0xffc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffbf, 0xffc0, 0xffc1, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffbf, 0xffc0, 0xffc1, 0xffc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc0, 0xffc1, 0xffc2, 0xffc3, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc0, 0xffc1, 0xffc2, 0xffca, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc2, 0xffc9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc1, 0xffc9, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc8, 0xffff, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x0001, 0x195b, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x0000, 0x195b, 0x2a6c, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x195a, 0x2a6c, 0x3fc0, 0x0000, 0x0000, 0x0000, 0x0000,
  0x195a, 0x2a6b, 0x3fc0, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a6b, 0x3fbf, 0x3fc0, 0x3fc1, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x3fc0, 0x3fc1, 0xbfc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fbf, 0x3fc0, 0xbfc1, 0xbfc2, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fc0, 0xbfc1, 0xbfc2, 0xd517, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc0, 0xbfc1, 0xd516, 0xe628, 0x0000, 0x0000, 0x0000, 0x0000,
  0xbfc1, 0xd516, 0xe627, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xd515, 0xe627, 0xff81, 0xff82, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe626, 0xff81, 0xff82, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
  0xff80, 0xff81, 0xff82, 0xff83, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_srhadd_4H = 576;

#endif  // VIXL_SIM_SRHADD_4H_TRACE_AARCH64_H_
