import { Spec } from 'vega';

export const spec: Spec = {
  $schema: 'https://vega.github.io/schema/vega/v5.json',
  width: 500,
  height: 80,
  padding: 5,

  data: [
    {
      name: 'people',
      values: [
        {
          label: 'Washington',
          born: -7506057600000,
          died: -5366196000000,
          enter: -5701424400000,
          leave: -5453884800000
        },
        {
          label: 'Adams',
          born: -7389766800000,
          died: -4528285200000,
          enter: -5453884800000,
          leave: -5327740800000
        },
        {
          label: 'Jefferson',
          born: -7154586000000,
          died: -4528285200000,
          enter: -5327740800000,
          leave: -5075280000000
        },
        {
          label: 'Madison',
          born: -6904544400000,
          died: -4213184400000,
          enter: -5075280000000,
          leave: -4822819200000
        },
        {
          label: 'Monroe',
          born: -6679904400000,
          died: -4370518800000,
          enter: -4822819200000,
          leave: -4570358400000
        }
      ]
    },
    {
      name: 'events',
      format: { type: 'json', parse: { when: 'date' } },
      values: [
        { name: 'Decl. of Independence', when: 'July 4, 1776' },
        { name: 'U.S. Constitution', when: '3/4/1789' },
        { name: 'Louisiana Purchase', when: 'April 30, 1803' },
        { name: 'Monroe Doctrine', when: 'Dec 2, 1823' }
      ]
    }
  ],

  scales: [
    {
      name: 'yscale',
      type: 'band',
      range: [0, { signal: 'height' }],
      domain: { data: 'people', field: 'label' }
    },
    {
      name: 'xscale',
      type: 'time',
      range: 'width',
      round: true,
      domain: { data: 'people', fields: ['born', 'died'] }
    }
  ],

  axes: [{ orient: 'bottom', scale: 'xscale', format: '%Y' }],

  marks: [
    {
      type: 'text',
      from: { data: 'events' },
      encode: {
        enter: {
          x: { scale: 'xscale', field: 'when' },
          y: { value: -10 },
          angle: { value: -25 },
          fill: { value: '#000' },
          text: { field: 'name' },
          font: { value: 'Helvetica Neue' },
          fontSize: { value: 10 }
        }
      }
    },
    {
      type: 'rect',
      from: { data: 'events' },
      encode: {
        enter: {
          x: { scale: 'xscale', field: 'when' },
          y: { value: -8 },
          width: { value: 1 },
          height: { field: { group: 'height' }, offset: 8 },
          fill: { value: '#888' }
        }
      }
    },
    {
      type: 'text',
      from: { data: 'people' },
      encode: {
        enter: {
          x: { scale: 'xscale', field: 'born' },
          y: { scale: 'yscale', field: 'label', offset: -3 },
          fill: { value: '#000' },
          text: { field: 'label' },
          font: { value: 'Helvetica Neue' },
          fontSize: { value: 10 }
        }
      }
    },
    {
      type: 'rect',
      from: { data: 'people' },
      encode: {
        enter: {
          x: { scale: 'xscale', field: 'born' },
          x2: { scale: 'xscale', field: 'died' },
          y: { scale: 'yscale', field: 'label' },
          height: { value: 2 },
          fill: { value: '#557' }
        }
      }
    },
    {
      type: 'rect',
      from: { data: 'people' },
      encode: {
        enter: {
          x: { scale: 'xscale', field: 'enter' },
          x2: { scale: 'xscale', field: 'leave' },
          y: { scale: 'yscale', field: 'label', offset: -1 },
          height: { value: 4 },
          fill: { value: '#e44' }
        }
      }
    }
  ]
};
