#!/usr/bin/env python
# -*- coding: UTF-8 -*-

# txt2pot.py for Tux Paint Stamps collection
#
# Last modified 2020-07-31
#
# Updates stamp description localization template (".pot")
# to capture any new strings, or changes to the main English
# translations, found within the stamp description files
# ("stampname.txt"), which contain both the textual description
# of the stamp in English, plus all languages it has been translated to.
# (As generated by "po2txt.py").

import sys, os, string
from time import gmtime, strftime

poHeader="""# Tuxpaint-stamps [Language] translation.
# Copyright (C) 2002-"""+\
strftime("%Y", gmtime())+"\n"\
"""# This file is distributed under the same license as the Tuxpaint-stamps package.
# [Translator's name] <translator@email.address>, """+\
strftime("%Y", gmtime())+"\n"\
"""#
msgid ""
msgstr ""
"Project-Id-Version: tuxpaint-stamps\\n"
"Report-Msgid-Bugs-To: tuxpaint-i18n@lists.sourceforge.net\\n"
"MIME-Version: 1.0\\n"
"POT-Creation-Date: """+\
strftime("%Y-%m-%d %H:%M:%S+0000", gmtime())+"\\n\"\n"\
""""PO-Revision-Date: \\n"
"Content-Type: text/plain; charset=UTF-8\\n"
"Content-Transfer-Encoding: 8bit\\n"
"""
localeList = []


def lister(poLocale, dirname, filesindir):
    filesindir.sort()
    for fname in filesindir:
        fnlist = os.path.splitext(fname)
        if fnlist[1] == ".txt":
            print dirname + "/" + fname
            if os.path.exists(dirname + "/" + fnlist[0] + '.svg') : #Check for SVG
                imgfile = fnlist[0] + '.svg'
            else :
                imgfile = fnlist[0] + '.png' # Else, assuming PNG
            txtFile = open(os.path.join(dirname, fname), 'rb')
            # write stamp filename down follow mark('#').
            poFile.write('\n#: ' + dirname + '/' + fnlist[0] + '\n')
            # provide an URL for viewing the stamp online
            poFile.write('#. View at https://tuxpaint.org/stamps/' + dirname[3:] + '/' + imgfile + '\n')
            # write description in msgid.
	    line = txtFile.readline()
	    if line[-1:] == "\n" :
		line = line[:-1]
	    line = string.replace(line, '"', '\\"')
            poFile.write('msgid "' + line + '"\n')
	    localeString = ""
            for line in txtFile.readlines():
                # replace " to \"
                line = string.replace(line, '"', '\\"')
                splitup = string.find(line,'.utf8')
                if splitup != -1 and line[0] != '#' :
                    locale = line[:splitup]
                    if locale not in localeList:
                        localeList.append(locale)
                    if locale == poLocale:
                        localeString = line[string.find(line, "=") + 1:-1]
            txtFile.close()
            # write translation or empty string in msgstr.
            poFile.write('msgstr "' + localeString + '"\n')

if __name__ == '__main__':
    poFile = open('./tuxpaint-stamps.pot', 'wb')
    print ">>", poFile.name
    poFile.write(poHeader)
    os.path.walk('../stamps/', lister, None)
    poFile.close()
