# Contributing to Tiled

All kinds of contributions are very appreciated, be it documentation, code or build system improvements, be it a small patch, a feature or maybe even becoming a co-maintainer of Tiled. Bug reports and feature requests are of course welcome too!

## Reporting an Issue

Make sure to mention the following things:

* How the issue can reproduced
* What behavior you expected instead
* What actually happened
* Tiled version, operating system, etc. if possibly relevant.

Also, please consider adding a screenshot or video if it helps illustrate the issue.

## Requesting a Feature

First of all, look around the already open issues to see if the feature was already requested in some form. In that case it's better to comment on the existing feature instead.

If you're not entirely sure about what feature you need, consider to [post your problem on the forum](https://discourse.mapeditor.org/) instead.

In any case, be sure to describe the feature in enough detail, to consider its implications on existing parts of the software if relevant and to describe how it would help you in particular. Also, please consider including a mockup if the issue includes UI changes.

## Submitting a Patch

* Ideally, start with something small to get familiar with the review process and work up from there.
* Make an effort to follow the overal coding style, which is roughly based on the [Qt Creator coding style](https://doc-snapshots.qt.io/qtcreator-extending/coding-style.html).
* Be prepared for detailed feedback on your patch and to make several revisions.
* Each pull request will be built automatically for Windows, Linux and macOS. If the build fails anywhere, please check if it may be a problem with your patch.

## Making a Donation

Please consider supporting further development of Tiled with [a monthly donation](https://www.mapeditor.org/donate).

Thanks a lot for your contribution!
