---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              limites, notation de limite, l cursif
---

# Comment obtenir les notations de limite ?

Deux notations mathématiques de la notion 
de [limite](wpfr:Limite_(mathématiques)) coexistent, sans qu'il y ait
de recommandation en la matière. Elles sont toutes deux présentées ici.


## Avec les commandes de base

La première notation peut être obtenue avec :
- la commande `\lim` qui affiche l'opérateur $\lim$ et positionne les éléments
  qui lui sont mis en indice selon le contexte (sur ce point, vous pouvez aussi
  consulter "[](/4_domaines_specialises/mathematiques/structures/operateurs/changer_la_position_des_limites_autour_des_sommes_et_integrales)"), 
  comme le montre l'exemple ci-dessous. Cette commande fait partie 
  d'un ensemble de différents opérateurs mis à disposition par LaTeX et listés
  à la question 
  "[](/4_domaines_specialises/mathematiques/structures/declarer_une_nouvelle_fonction)". 
  S'y trouvent en particulier les commandes proches `\liminf` et `\limsup` ;
- et la commande `\to` qui affiche la flèche signifiant "tend vers".

L'exemple suivant montre également, avec la commande `\ell`, comment obtenir 
le *l cursif* (ou *l ronde*) parfois utilisé pour noter la valeur de la limite.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Vous pouvez opter pour la notation $\lim_{n\to\infty} x_n = \ell $ 
qui donnera en mode hors-texte : 
\[  \lim_{n\to\infty} x_n = \ell  \]
\end{document}
```


## Avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) donne accès 
à la commande `\xrightarrow[⟨au-dessous⟩]{⟨au-dessus⟩}` permettant d'obtenir
la seconde notation : cette commande permet d'obtenir une flèche horizontale
dont la largeur est fonction des textes `⟨au-dessous⟩` et `⟨au-dessus⟩` 
de la flèche.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
Vous pouvez aussi opter pour la notation $x_n \xrightarrow[n\to\infty]{} L$ 
qui donnera en mode hors-texte : 
\[  x_n \xrightarrow[n\to\infty]{} L  \]
\end{document}
```


:::{sources}
- [Symbole limite](https://texnique.fr/osqa/questions/1816/symbole-limite),
sur [TeXnique.fr](https://texnique.fr)
:::