/*
 * Copyright (C) 2015 Andreas Steffen
 * HSR Hochschule fuer Technik Rapperswil
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include "test_suite.h"

#include <bliss_signature.h>

static chunk_t data = chunk_from_chars(
	0xC1, 0xA1, 0x96, 0x98, 0x4F, 0x60, 0xF5, 0xCA, 0x89, 0x9E,
	0x78, 0xAF, 0x64, 0xDD, 0x01, 0x76, 0x04, 0x29, 0x11, 0xD0,
	0x21, 0x9E, 0xE4, 0x2D, 0xC5, 0x82, 0x69, 0x19, 0x82, 0x75,
	0x30, 0xAC, 0xB0, 0x64, 0xCB, 0x65, 0x19, 0x22, 0x4A, 0x03,
	0x03, 0x61, 0x4A, 0x37, 0x8E, 0xA3, 0xB6, 0xB3, 0x58, 0x44,
	0xFD, 0x68, 0x38, 0xF1, 0x4B, 0xCF, 0xE8, 0xA2, 0x05, 0x39,
	0x87, 0xE0, 0x5E, 0x7C, 0x45, 0x33, 0x4A, 0xEB, 0x2E, 0xCF,
	0x98, 0x01, 0x3D, 0x28, 0x60, 0xCE, 0x90, 0x45, 0xF0, 0x8E,
	0x36, 0x25, 0x50, 0x8B, 0xA2, 0xC0, 0x6E, 0xDF, 0xC2, 0xA1,
	0x35, 0xC1, 0x16, 0x14, 0xE8, 0x6A, 0xE3, 0x9C, 0x0B, 0x32,
	0x53, 0x55, 0x60, 0x52, 0x43, 0x93, 0xBB, 0x9F, 0x1D, 0x17,
	0xDC, 0x6E, 0x26, 0x99, 0x60, 0x83, 0x12, 0x53, 0xB0, 0x2B,
	0x36, 0xE2, 0x95, 0xA7, 0xBF, 0x9B, 0xC0, 0x0A, 0x63, 0xD6,
	0x32, 0xA9, 0xE2, 0xAD, 0x02, 0x53, 0x10, 0x81, 0x00, 0xD4,
	0x9A, 0xC2, 0x04, 0x1B, 0x48, 0x53, 0x37, 0xF0, 0x95, 0x39,
	0x4B, 0x2E, 0x37, 0x28, 0xE2, 0x70, 0xAD, 0xB5, 0xF1, 0x63,
	0x48, 0x17, 0xEF, 0x45, 0xC0, 0x30, 0xA6, 0xAA, 0x37, 0x9A,
	0x00, 0x8F, 0x8D, 0xAC, 0x66, 0x2C, 0x96, 0x8C, 0xC2, 0x74,
	0x9D, 0x66, 0x16, 0x5D, 0x70, 0x70, 0x1D, 0x2F, 0x11, 0xBD,
	0x11, 0x62, 0x58, 0xC6, 0xB2, 0xA6, 0xFA, 0xB7, 0x8C, 0x10,
	0x6A, 0x13, 0x34, 0x25, 0xB8, 0xF2, 0x46, 0xE3, 0x08, 0xAD,
	0x8D, 0x49, 0x33, 0x24, 0x37, 0xA5, 0x0A, 0xF9, 0x5E, 0x95,
	0xF9, 0x50, 0xDA, 0x2B, 0x80, 0x4F, 0x10, 0x4F, 0xAB, 0xE4,
	0x96, 0xB1, 0xA1, 0x28, 0xCE, 0x6D, 0xB6, 0x17, 0x33, 0x2A,
	0xE0, 0xC3, 0x80, 0xAA, 0x3D, 0x1A, 0x5C, 0x48, 0xA0, 0x48,
	0x60, 0xCC, 0xC7, 0x29, 0x4F, 0xB8, 0x96, 0xDF, 0xC6, 0x6A,
	0xC2, 0x83, 0x5E, 0xFC, 0xD7, 0x4E, 0xCA, 0x14, 0xB4, 0xC6,
	0x30, 0x29, 0xC7, 0xCE, 0x79, 0x42, 0x2D, 0x22, 0x28, 0x99,
	0x59, 0x14, 0xFB, 0x04, 0xAD, 0x79, 0x3C, 0x74, 0x34, 0xC6,
	0x7A, 0x1C, 0x13, 0x07, 0x17, 0xB1, 0x8A, 0x02, 0xA7, 0x70,
	0x3C, 0x5B, 0xBA, 0x88, 0xA2, 0xE6, 0x4B, 0x2A, 0xC1, 0x1E,
	0x42, 0xDD, 0x83, 0x2B, 0x00, 0xCC, 0xF8, 0x80, 0x03, 0x7E,
	0x97, 0xA4, 0x04, 0xE1, 0xB2, 0x0B, 0xE2, 0xF3, 0x91, 0x91,
	0x80, 0xA0, 0xC5, 0x44, 0x67, 0xB1, 0x56, 0xD0, 0x13, 0x58,
	0x7B, 0x6E, 0x12, 0xE7, 0x3A, 0x90, 0xE4, 0x2C, 0x44, 0x17,
	0xA3, 0xBD, 0x21, 0x68, 0x45, 0x61, 0x20, 0x57, 0x8D, 0x4A,
	0xF1, 0xE6, 0xD3, 0x17, 0xC9, 0xB0, 0xF8, 0x3A, 0x87, 0x6A,
	0x7E, 0x25, 0x45, 0xDC, 0x9A, 0x1D, 0xAC, 0x10, 0xB6, 0xF6,
	0x07, 0x4C, 0x50, 0x92, 0xF9, 0xE1, 0x3E, 0xAD, 0x3B, 0x80,
	0x20, 0xA8, 0x34, 0x04, 0xD6, 0x0D, 0x2D, 0x46, 0x69, 0x5E,
	0x8C, 0x4B, 0xB0, 0x1C, 0x37, 0xD8, 0x0D, 0x72, 0x7B, 0xE6,
	0xEE, 0x04, 0x81, 0x98, 0x78, 0x69, 0x88, 0xD8, 0xDF, 0x04,
	0xF0, 0x80, 0xE2, 0x0A, 0xD3, 0x60, 0x94, 0xDF, 0x49, 0xF7,
	0x52, 0x95, 0xA6, 0xAF, 0x8C, 0x13, 0x10, 0x09, 0xAA, 0x03,
	0xAC, 0x2C, 0x89, 0x2D, 0x2C, 0x61, 0x0F, 0xBE, 0x5C, 0x29,
	0x01, 0x7C, 0x9E, 0xD2, 0xFF, 0x34, 0xA1, 0x9E, 0xEE, 0xBF,
	0x28, 0x18, 0x3A, 0x17, 0xA6, 0x40, 0x94, 0xD5, 0xC4, 0xEC,
	0x27, 0x0A, 0x40, 0x1C, 0xC4, 0x16, 0x80, 0x4E, 0x6F, 0xDD,
	0xA5, 0x6A, 0x03, 0xE8, 0xBA, 0xB2, 0xAA, 0x7A, 0x7F, 0x4B,
	0x30, 0x11, 0x11, 0x12, 0x4A, 0xFE, 0xB2, 0x99, 0xC6, 0x12,
	0x1A, 0x98, 0xC0, 0x15, 0x41, 0xE1, 0x55, 0x35, 0x54, 0xF2,
	0x1C, 0xE2, 0x78, 0x85, 0x66, 0xD3, 0x9C, 0x8A, 0x88, 0x7C,
	0x86, 0x7F, 0x48, 0xBE, 0xB7, 0x1C, 0xE4, 0xCF, 0x35, 0xEE,
	0x24, 0xA6, 0x62, 0xD6, 0x36, 0x1F, 0x66, 0x10, 0x5D, 0xEF,
	0x07, 0x64, 0xA8, 0xD0, 0xAD, 0x2F, 0x47, 0x02, 0xA2, 0x0F,
	0x73, 0x96, 0x2A, 0x21, 0x20, 0x36, 0x01, 0xA3, 0x2F, 0x5E,
	0xC8, 0x80, 0x3A, 0x54, 0xA6, 0xB5, 0xD0, 0x19, 0xBF, 0xC4,
	0x35, 0x01, 0x0B, 0x2A, 0x8E, 0x61, 0x4A, 0xDD, 0xB2, 0x4A,
	0xE1, 0x0C, 0x15, 0x94, 0x9C, 0xD2, 0x54, 0x93, 0x85, 0x16,
	0x49, 0x69, 0xA0, 0x41, 0x34, 0x16, 0x69, 0x28, 0x74, 0x11,
	0x88, 0x44, 0xC8, 0x46, 0x5E, 0x62, 0xFF, 0x6E, 0xC5, 0xA8,
	0xE8, 0x8A, 0x8A, 0xFA, 0x2D, 0x94, 0x14, 0xD4, 0x51, 0x16,
	0xB0, 0x40, 0xDC, 0xF3, 0xAA, 0x97, 0x39, 0x1A, 0xDA, 0x7F,
	0x41, 0x61, 0x25, 0x1E, 0xDF, 0x46, 0x29, 0x44, 0x80, 0xEA,
	0x10, 0xE4, 0x0F, 0x94, 0xA6, 0x52, 0x20, 0x06, 0x9C, 0x69,
	0x48, 0x1F, 0x45, 0x30, 0x4B, 0x21, 0x02, 0xE6, 0xF3, 0x44,
	0x35, 0xC1, 0xC8, 0xC9, 0x68, 0x6C, 0x43, 0xA4, 0x56, 0x07,
	0x36, 0x11, 0xFB, 0x6D, 0x8E, 0xF0, 0x62, 0x5A, 0x3C, 0x8B,
	0x23, 0xF1, 0x46, 0xE2, 0x76, 0x2A, 0x6F, 0xBB, 0x09, 0x24,
	0x18, 0x64, 0xE6, 0x5C, 0xD0, 0x85, 0x69, 0xF0, 0x4F, 0x66,
	0x97, 0x40, 0x01, 0x27, 0xD1, 0x41, 0xCC, 0xEB, 0x4D, 0xB7,
	0x04, 0xC4, 0x91, 0xE0, 0x95, 0x8A, 0x43, 0x26, 0x2D, 0x1F,
	0x88, 0xA0, 0xD8
);

START_TEST(test_bliss_signature_fail)
{
	const bliss_param_set_t set2 = { .id = BLISS_B_II };
	const bliss_param_set_t *set;
	bliss_signature_t *signature;
	chunk_t encoding;
	int k;

	signature = bliss_signature_create(&set2);
	ck_assert(signature);
	encoding = signature->get_encoding(signature);
	ck_assert(encoding.len == 0);
	signature->destroy(signature);

	signature  = bliss_signature_create_from_data(&set2, data);
	ck_assert(!signature);

	set = bliss_param_set_get_by_id(BLISS_B_I);
	ck_assert(set);

	for (k = 0; k < data.len - 2; k++)
	{
		chunk_t fragment = { data.ptr, k };

		signature  = bliss_signature_create_from_data(set, fragment);
		ck_assert(!signature);
	}
	signature  = bliss_signature_create_from_data(set, data);
	ck_assert(signature);
	signature->destroy(signature);
}
END_TEST

Suite *bliss_signature_suite_create()
{
	Suite *s;
	TCase *tc;

	s = suite_create("bliss_signature");

	tc = tcase_create("signature_fail");
	tcase_add_test(tc, test_bliss_signature_fail);
	suite_add_tcase(s, tc);

	return s;
}
