# swedish.tcl:
# Text for menu names and status bar help messages in Swedish.
# Part of Scid (Shane's Chess Information Database).
# Contributed by Martin Skjldebrand, martin@skjoldebrand.org
# Thanks to: Hans Eriksson, for looking over the translation file

proc setLanguage_W {} {

# File menu:
menuText W File "Arkiv" 0
menuText W FileNew "Ny..." 0 {Skapa en ny Scid databas}
menuText W FileOpen "ppna..." 0 {ppna en befintlig Scid databas}
menuText W FileClose "Stng" 0 {Stng den aktiva Scid databasen}
menuText W FileFinder "Sk filer" 4 {ppna skdialogen}
menuText W FileBookmarks "Bokmrken" 0 {Hantera bokmrken (kortkommando: Ctrl+B)}
menuText W FileBookmarksAdd "Nytt bokmrke" 0 \
  {Markera den aktiva stllningen i partiet}
menuText W FileBookmarksFile "Spara bokmrke" 0 \
  {Spara bokmrket fr den aktiva stllningen i partiet}
menuText W FileBookmarksEdit "Redigera bokmrken..." 0 \
  {Redigera bokmrken}
menuText W FileBookmarksList "Visa bokmrken som lista" 19 \
  {Visar bokmrkena som lista, inte undermenyer}
menuText W FileBookmarksSub "Visa bokmrken i undermenyer" 17 \
  {Visar bokmrkena som undermenyer, inte lista}
menuText W FileMaint "Databasverktyg" 0 {Scids databasverktyg}
menuText W FileMaintWin "Verktygsfnster" 0 \
  {ppna/ stng verktygsfnstret}
menuText W FileMaintCompact "Komprimera databasen..." 0 \
  {Komprimera databasen, avlgsna raderade partier och oanvnda namn}
menuText W FileMaintClass "Klassificera partier enligt ECO..." 2 \
  {Klassificera om alla partier enligt ECO-systemet}
menuText W FileMaintSort "Sortera databasen..." 0 \
  {Sortera partierna i den aktiva databasen}
menuText W FileMaintDelete "Radera dubbletter..." 0 \
  {Sk dubbletter och markera dem som raderingsbara}
menuText W FileMaintTwin "Sk dubbletter" 0 \
  {ppna/ stng dubblettfnstret fr att ska dubblettpartier}
menuText W FileMaintName "Stavningskontroll" 0 {Namnredigering och stavningskontroll}
menuText W FileMaintNameEditor "Redigera namn" 0 \
  {Redigera spelarnamn utifrn rttstavningsfilen}
menuText W FileMaintNamePlayer "Stavningskontrollera namn..." 22 \
  {Stavningskontrollera namn utifrn rttstavningsfilen}
menuText W FileMaintNameEvent "Stavningskontrollera evenemang..." 21 \
  {Stavningskontrollera evenemang utifrn rttstavningsfilen}
menuText W FileMaintNameSite "Stavningskontrollera platser..." 21 \
  {Stavningskontrollera platser utifrn rttstavningsfilen}
menuText W FileMaintNameRound "Stavningskontrollera ronder..." 21 \
  {Stavningskontrollera ronder utifrn rttstavningsfilen}
menuText W FileReadOnly "Enbart lsbar..." 8 \
  {Avlgsna temporrt redigeringsmjligheterna till databasen}
menuText W FileSwitch "Byt databas" 0 \
  {Byt till en annan ppnad databas} 
menuText W FileExit "Avsluta" 0 {Avsluta Scid}
menuText W FileMaintFixBase "Fixa trasig databas" 0 {Frsk att fixa en trasig databas}

# Edit menu:
menuText W Edit "Redigera" 0
menuText W EditAdd "Lgg till variant" 0 {Skapa en variant vid denna stllning}
menuText W EditDelete "Radera variant" 0 {Radera en variant vid denna stllning}
menuText W EditFirst "Skapa huvudvariant" 6 \
  {Gr en av varianterna till huvudvariant}
menuText W EditMain "Skapa nytt textdrag" 11 \
  {Gr en av varianterna till partifortsttning}
menuText W EditTrial "Testa variant" 6 \
  {Starta/ stoppa testlge, undersk en id p brdet}
menuText W EditStrip "Ta bort" 3 {Avlgsna kommentarer eller varianter frn partiet}
menuText W EditUndo "ngra" 0 {ngra senaste ndring i parti}
# ====== TODO To be translated ======
menuText W EditRedo "Redo" 0 {Redo last game change}
menuText W EditStripComments "Kommentarer" 0 \
  {Avlgsna alla kommentarer och noteringar frn partiet}
menuText W EditStripVars "Varianter" 0 {Avlgsna alla varianter frn partiet}
menuText W EditStripBegin "Avlgsna tidigare drag" 9 \
  {Avlgsna dragen fram till den aktuella stllningen} 
menuText W EditStripEnd "Avlgsna resterande drag" 0 \
  {Avlgsna partiets resterande drag} 
menuText W EditReset "Tm Clipbase" 1 \
  {Tmmer den temporra databasen}
menuText W EditCopy "Kopiera partiet till Clipbase" 21 \
  {Kopierar det aktuella partiet till Clipbase}
menuText W EditPaste "Klistra in det senaste Clipbasepartiet" 8 \
  {Klistrar in det senaste tillagda i Clipbase i den aktiva databasen}
menuText W EditPastePGN "Klistra in Clipbasetext som PGNparti..." 10 \
  {Tolka Clipbasetexten som ett parti i PGN notation och klistra in det hr}
menuText W EditSetup "Skapa stllning..." 0 \
  {Skapa en utgngsstllning fr aktuellt parti}
menuText W EditCopyBoard "Kopiera stllning" 0 \
  {Kopiera den aktuella stllningen i FEN kod till urklippshanteraren} 
menuText W EditPasteBoard "Klistra in utgngsstllning" 10 \
  {Klistra in stllningen frn aktuellt parti i den temporra databasen}

# Game menu:
menuText W Game "Partier" 0
menuText W GameNew "Nytt parti" 0 \
  {terstll brdet infr ett nytt parti (raderar alla ndringar)}
menuText W GameFirst "Ladda det frsta partiet" 10 {Laddar det frsta partiet i filtret}
menuText W GamePrev "Ladda fregende parti" 7 {Ladda fregende parti i filtret}
menuText W GameReload "Brja om partiet" 0 \
  {terstll partiet (raderar alla ndringar)}
menuText W GameNext "Ladda nsta parti" 6 {Ladda nsta parti i filtret}
menuText W GameLast "Ladda det sista partiet" 10 {Ladda det sista partiet i filtret}
menuText W GameRandom "Ladda parti slumpmssigt" 14 \
  {Ladda ett av datorn slumpmssigt valt parti} 
menuText W GameNumber "Ladda parti nummer..." 6 \
  {Ladda ett parti genom att ange dess nummer}
menuText W GameReplace "Spara: Erstt parti..." 7 \
  {Spara partiet och erstt tidigare version}
menuText W GameAdd "Spara: Nytt parti..." 1 \
  {Spara ett nytt parti}
menuText W GameDeepest "Identifiera ppningen" 0 \
  {G till den mest detaljerade stllningen i ECO boken}
menuText W GameGotoMove "G till drag nummer..." 8 \
  {G till ett specifikt drag i partiet}
menuText W GameNovelty "Hitta nyhet..." 7 \
  {Hitta det frsta draget i partiet som inte spelats tidigare}

# Search Menu:
menuText W Search "Sk" 0
menuText W SearchReset "terstll skfilter" 0 {terstll skfiltret s att alla partiet ingr}
menuText W SearchNegate "Omvnt filter" 0 {Ta med partier som utesluts av filtret}
menuText W SearchCurrent "Aktuell position..." 8 {Sk partier med aktuell position p brdet}
menuText W SearchHeader "I huvud..." 2 {Anvnd fast information (spelare, evenemang, plats, mm)}
menuText W SearchMaterial "Material/stllning..." 0 {Skning baserad p material eller stllning}
menuText W SearchUsing "Anvnd skfil..." 10 {Anvnd en fil med lagrade skvillkor}

# Windows menu:
menuText W Windows "Fnster" 0
menuText W WindowsComment "Kommentarseditor" 0 {ppna/ stng kommentarseditorn}
menuText W WindowsGList "Partilista" 5 {ppna/ stng partilistan}
menuText W WindowsPGN "PGN fnster" 0 \
  {ppna/ stng PGN fnstret}
menuText W WindowsPList "Spelarfrteckning" 7 {ppna/ stng en frteckning ver spelarna i den aktiva databasen} 
menuText W WindowsTmt "Turneringar" 0 {Lista turneringar}
menuText W WindowsSwitcher "Databasvxlaren" 0 \
  {ppna/ stng databasvxlaren}
menuText W WindowsMaint "Verktygsfnster" 0 \
  {ppna/ stng verktygsfnstret}
menuText W WindowsECO "ECO fnster" 0 {ppna/ stng ECO blddraren}
menuText W WindowsStats "Statistikfnster" 0 \
  {ppna/ stng statistikfnstret}
menuText W WindowsTree "Trdfnster" 2 {ppna/ stng varianttrdets fnster}
menuText W WindowsTB "Slutspelsdatabas" 2 \
  {ppna/ stng slutspelsdatabasfnstret}
menuText W WindowsBook "Bokfnster" 0 {ppna/stng Bokfnstret}
menuText W WindowsCorrChess "Korrespondensfnster" 0 {ppna/stng Korrespondensfnstret}

# Tools menu:
menuText W Tools "Verktyg" 0
menuText W ToolsAnalysis "Analysmotor..." 6 \
  {Starta/ stoppa en analysmotor}
menuText W ToolsAnalysis2 "Analysmotor 2..." 12 \
  {Starta/ stoppa en andra analysmotor}
menuText W ToolsCross "Resultattabell" 0 {Visa en resultattabell fr den aktuella turneringen}
menuText W ToolsEmail "Eposthanterare" 0 \
  {ppna/ stng eposthanteraren}
menuText W ToolsFilterGraph "Filterdiagram" 7 \
  {ppna/ stng filterdiagramfnstret} 
menuText W ToolsAbsFilterGraph "Absolut Filtergraf" 7 {ppna/stng filtergraffnstret fr absolutvrden}
menuText W ToolsOpReport "ppningsrapport" 0 \
  {Skapa en ppningsrapport utifrn den aktuella stllningen}
menuText W ToolsOpenBaseAsTree "ppna databas som trd" 0   {ppna en databas och anvnd den i Trdfnstret}
menuText W ToolsOpenRecentBaseAsTree "ppna senaste databasen som trd" 0   {ppna den senaste databasen och anvnd den i Trdfnstret}
menuText W ToolsTracker "Sk material"  0 {ppnar dialog fr att ska efter en viss materiell balans} 
menuText W ToolsTraining "Trning"  0 {Trningsverktyg (taktik, ppningar,...) }
menuText W ToolsTacticalGame "Taktiskt parti"  0 {Spela ett parti med taktik}
menuText W ToolsSeriousGame "Serist parti"  0 {Spela ett serist parti}
menuText W ToolsTrainOpenings "ppningar"  0 {Trna med en repetoar}
menuText W ToolsTrainReviewGame "Granska parti"  0 {Gissa drag spelade i ett parti}
menuText W ToolsTrainTactics "Taktik"  0 {Lsa taktik}
menuText W ToolsTrainCalvar "Variantberkning"  0 {Variantberkningstrning}
menuText W ToolsTrainFindBestMove "Hitta bst drag"  0 {Hitta bsta draget}
menuText W ToolsTrainFics "Spela p Internet"  0 {Spela p freechess.org}
# ====== TODO To be translated ======
menuText W ToolsEngineTournament "Engine tournament"  0 {Start a tournament between chess engines}
menuText W ToolsBookTuning "Bokfininstllning" 0 {Bokfininstllning}
menuText W ToolsConnectHardware "Anslut Hrdvara" 0 {Anslut extern hrdvara}
menuText W ToolsConnectHardwareConfigure  "Konfiguration" 0 {Konfiguration}
menuText W ToolsConnectHardwareNovagCitrineConnect "Anslut Novag Citrine" 0 {Anslut Novag Citrine}
menuText W ToolsConnectHardwareInputEngineConnect "Anslut Inmatningsschackmotor" 0 {Anslut Inmatningsschackmotor (t.ex. DGT)}
menuText W ToolsPInfo "Spelarinformation"  0 \
  {ppna/ uppdatera spelarinformation}
menuText W ToolsPlayerReport "Spelarrapport..." 3 \
  {Skapa en spelarrapport}
menuText W ToolsRating "Ratingdiagram" 0 \
  {Skapa ett ratingdiagram fr spelarna i partiet}
menuText W ToolsScore "Resultatdiagram" 8 {Visa resultatdiagrammet}
menuText W ToolsExpCurrent "Exportera aktuellt parti" 1 \
  {Spara aktuellt parti till en textfil}
menuText W ToolsExpCurrentPGN "Exportera till PGN..." 15 \
  {Spara aktuellt parti till en PGN-fil}
menuText W ToolsExpCurrentHTML "Exportera till HTML..." 15 \
  {Spara aktuellt parti till en HTML-fil}
menuText W ToolsExpCurrentHTMLJS "Exportera till HTML och JavaScript-fil..." 15 {Spara aktuellt parti till en HTML och JavaScript-fil}  
menuText W ToolsExpCurrentLaTeX "Exportera till LaTeX..." 15 \
  {Spara aktuellt parti till en LaTeX-fil}
menuText W ToolsExpFilter "Exportera alla filtrerade partier" 15 \
  {Spara alla filterade partier till en textfil}
menuText W ToolsExpFilterPGN "Exportera till PGN..." 15 \
  {Spara alla filterade partier till en PGN-fil}
menuText W ToolsExpFilterHTML "Exportera till HTML..." 15 \
  {Spara alla filterade partier till en HTML-fil}
menuText W ToolsExpFilterHTMLJS "Exportera filtrerade till HTML och JavaScript-fil..." 17 {Spara alla filtrerade partier till en HTML och JavaScript-fil}  
menuText W ToolsExpFilterLaTeX "Exportera till LaTeX..." 15 \
  {Spara alla filterade partier till en LaTeX-fil}
menuText W ToolsImportOne "Importera ett parti i PGN-format..." 0 \
  {Importera ett parti i PGN-format}
menuText W ToolsImportFile "Importera flera partier i PGN-format..." 16 \
  {Importera flera partier i PGN-format frn en fil}
menuText W ToolsStartEngine1 "Starta schackmotor 1" 0  {Starta schackmotor 1}
menuText W ToolsStartEngine2 "Starta schackmotor 2" 0  {Starta schackmotor 2}
menuText W ToolsCaptureBoard "Spara aktuellt schackbrde..." 0  {Spara det aktuella schackbrdet som en bild.}
menuText W Play "Spela" 0
menuText W CorrespondenceChess "Korrespondensschack" 0 {Funktioner fr eMail och Xfcc baserad Korrespondensschack}
menuText W CCConfigure "Konfigurera..." 0 {Konfigurera externa verktyg och generella instllningar}
menuText W CCConfigRelay "Konfigurera observationer..." 10 {Konfigurera partier att observera}
menuText W CCOpenDB "ppna Databas..." 0 {ppna standardkorrespondensdatabasen}
menuText W CCRetrieve "Hmta Partier" 0 {Hmta partier via extern (Xfcc-)hjlpare}
menuText W CCInbox "Hantera Inkorg" 0 {Hantera alla filer i Scids Inkorg}
menuText W CCSend "Skicka Drag" 0 {Skicka ditt drag via eMail eller extern (Xfcc-)hjlpare}
menuText W CCResign "Ge upp" 0 {Ge upp (inte via eMail)}
menuText W CCClaimDraw "Hvda Remi" 0 {Skicka drag och hvda Remi (inte via eMail)}
menuText W CCOfferDraw "Erbjud Remi" 0 {Skicka drag och erbjud Remi (inte via eMail)}
menuText W CCAcceptDraw "Acceptera Remi" 0 {Acceptera en erbjuden Remi (inte via eMail)}
menuText W CCNewMailGame "Nytt eMail-parti..." 0 {Starta ett nytt eMail-parti}
menuText W CCMailMove "Skicka Drag..." 0 {Skicka draget via eMail till motstndaren}
menuText W CCGamePage "Partisida..." 0 {Starta upp partiet via weblsaren}
menuText W CCEditCopy "Kopiera partilista till Clipbase" 0 {Kopiera partierna som CSV-lista till Clipbase}

# Options menu:
menuText W Options "Alternativ" 2
menuText W OptionsBoard "Brdet" 0 {ndra brdets utseende}
menuText W OptionsBoardSize "Brdstorlek" 0 {ndra brdets storlek}
menuText W OptionsBoardPieces "Pjsutseende" 1 {ndra pjsernas utseende} 
menuText W OptionsBoardColors "Frger..." 0 {ndra brdets frger}
menuText W OptionsBoardGraphics "Rutor..." 0 {Vlj texturer fr rutor}
translate W OptionsBGW {Vlj textur fr rutor}
translate W OptionsBoardGraphicsText {Vlj grafikfiler fr vita och svarta rutor:}
menuText W OptionsBoardNames "Spelarnamn..." 0 {Redigera spelares namn}
menuText W OptionsExport "Export" 0 {ndra exportalternativ}
menuText W OptionsFonts "Typsnitt" 0 {ndra typsnitt}
menuText W OptionsFontsRegular "Normal" 0 {ndra det normala typsnittet}
menuText W OptionsFontsMenu "Menu" 0 {ndra menytypsnittet}
menuText W OptionsFontsSmall "Liten" 0 {ndra det lilla typsnittet}
menuText W OptionsFontsTiny "Tiny" 0 {Change the tiny font}
menuText W OptionsFontsFixed "Fixerad" 0 {ndra det fixerade typsnittet}
menuText W OptionsGInfo "Partiinformation" 0 {Alternativ fr partiinformation}
menuText W OptionsLanguage "Sprk" 0 {Vlj sprk}
menuText W OptionsMovesTranslatePieces "verstt pjser" 0 {verstt frsta bokstaven fr pjser}
menuText W OptionsMovesHighlightLastMove "Markera senaste draget" 0 {Markera senaste draget}
menuText W OptionsMovesHighlightLastMoveDisplay "Visa" 0 {Visa senaste markerade draget}
menuText W OptionsMovesHighlightLastMoveWidth "Bredd" 0 {Tjockhet p rad}
menuText W OptionsMovesHighlightLastMoveColor "Frg" 0 {Frg p rad}
# ====== TODO To be translated ======
menuText W OptionsMovesHighlightLastMoveArrow "include Arrow" 0 {Include Arrow with Highlight}
menuText W OptionsMoves "Drag" 0 {Alternativ fr dragangivelse}
menuText W OptionsMovesAsk "Frga fre erstt drag" 0 \
  {Frga innan du erstter befintliga drag}
menuText W OptionsMovesAnimate "Frdrjning vid manuellt spel" 1 \
  {Ange tid mellan varje drag nr dragen grs automatiskt}
menuText W OptionsMovesDelay "Frdrjning vid automatspel..." 1 \
  {Ange frdrjning mellan dragen nr datorn spelar sjlv}
menuText W OptionsMovesCoord "Koordinater" 0 \
  {Acceptera koordinater ("g1f3") vid dragangivelse}
menuText W OptionsMovesSuggest "Visa freslagna drag" 0 \
  {Visa/ Dlj freslagna drag}
menuText W OptionsShowVarPopup "Visa Variantfnster" 0 {Starta/Avsluta visningen av ett Variantfnster}  
menuText W OptionsMovesSpace "Lgg till mellanslag efter dragnummer" 0 {Lgg till mellanslag efter dragnummer}  
menuText W OptionsMovesKey "Tangentkomplettering" 0 \
  {Starta/ stng av dragkomplettering vid tangentinmatning}
menuText W OptionsMovesShowVarArrows "Visa pilar fr variationer" 0 {Vxlar p/av pilar som visar drag i variationer}
# ====== TODO To be translated ======
menuText W OptionsMovesGlossOfDanger "Color Coded Gloss of Danger" 0 {Turn on/off color coded gloss of danger}
menuText W OptionsNumbers "Talformat" 3 {Vlj hur tal visas}
menuText W OptionsStartup "Start" 3 {Vlj vilka fnster som ska ppnas vid start}
menuText W OptionsTheme "Tema" 0 {ndra utseende p grnssnitt}
menuText W OptionsWindows "Fnster" 1 {Fnsteralternativ}
menuText W OptionsWindowsIconify "Minimera automatiskt" 5 \
  {Minimera alla fnster nr huvudfnstret minimeras}
menuText W OptionsWindowsRaise "Autofokus" 0 \
  {Visa ter vissa fnster (t ex. resultatrknare) automatiskt nr de dljs}
menuText W OptionsSounds "Ljud..." 2 {Konfigurera ljud fr att annonsera drag}
menuText W OptionsWindowsDock "Dockningsfnster" 0 {Dockningsfnster}
menuText W OptionsWindowsSaveLayout "Spara layout" 0 {Sparar layout}
menuText W OptionsWindowsRestoreLayout "terstll layout" 0 {terstller layout}
menuText W OptionsWindowsShowGameInfo "Visa partiinformation" 0 {Visar partiinformation}
menuText W OptionsWindowsAutoLoadLayout "Automatiskt ppna frsta layouten" 0 {ppnar automatiskt frsta layouten vid uppstart}
menuText W OptionsToolbar "Verktygsflt" 0 \
  {Visa/ dlj huvudfnstrets verktygsflt}
menuText W OptionsECO "Ladda ECO fil..." 7 {Ladda ECO-klassificeringen vid start}
menuText W OptionsSpell "Ladda Rttstavningsfil..." 7 \
  {Ladda rttstavningsfilen vid start}
menuText W OptionsTable "Katalog fr slutspelsdatabaser..." 0 \
  {Vlj en fil som innehller en slutspelsdatabas; alla vriga filer i samma katalog kommer att anvndas}
menuText W OptionsRecent "Senast anvnda filer..." 16 \
  {ndra antalet senast anvnda filer som visas i Arkivmenyn} 
menuText W OptionsBooksDir "ppningsbokskatalog..." 0 {Anger ppningsbokskatalogen}
menuText W OptionsTacticsBasesDir "Taktikbaskatalog..." 0 {Anger Taktikbaskatalog (fr trning)}
# ====== TODO To be translated ======
menuText W OptionsPhotosDir "Photos directory..." 0 {Sets the photos bases directory}
# ====== TODO To be translated ======
menuText W OptionsThemeDir "Load Theme(s)..."  0 { Load a GUI theme package file }
menuText W OptionsSave "Spara alternativ" 7 \
  "Spara alla alternativ till en instllningsfil"
menuText W OptionsAutoSave "Autospara vid avslut" 1 \
  {Spara alla alternativ nr du avslutar Scid}
# ====== TODO To be translated ======
menuText W OptionsMenuColor "Setup Menu Colors..." 0 { }
# ====== TODO To be translated ======
translate W MenuColorForeground "Textcolor"
# ====== TODO To be translated ======
translate W MenuColorBackground "Background"
# ====== TODO To be translated ======
translate W MenuColorSelect "Select"

# Help menu:
menuText W Help "Hjlp" 0
menuText W HelpContents "Innehll" 0 {Visa innehll} 
menuText W HelpIndex "Index" 0 {Hjlpsystemets indexsida}
menuText W HelpGuide "Snabbguide" 0 {Visa snabbguiden}
menuText W HelpHints "Tips" 0 {Visa tips}
menuText W HelpContact "Kontaktinformation" 0 {Visa kontaktinformation}
menuText W HelpTip "Dagens tips" 0 {Anvndbara Scid tips}
menuText W HelpStartup "Startfnster" 5 {Visa startfnstret}
menuText W HelpAbout "Om Scid" 0 {Information om Scid}

# Game info box popup menu:
menuText W GInfoHideNext "Dlj nsta drag" 0
menuText W GInfoMaterial "Visa materialvrden" 0
menuText W GInfoFEN "Visa FEN" 5
menuText W GInfoMarks "Visa frgade flt och pilar" 22 
menuText W GInfoWrap "Radbrytning" 0
menuText W GInfoFullComment "Visa fullstndiga kommentarer" 18
menuText W GInfoPhotos "Visa bilder" 5 ;
menuText W GInfoTBNothing "Slutspelsdatabaser: inget" 20
menuText W GInfoTBResult "Slutspelsdatabaser: endast resultat" 28
menuText W GInfoTBAll "Slutspelsdatabaser: resultat och bsta drag" 33
menuText W GInfoDelete "terta/Radera detta parti" 0
menuText W GInfoMark "(Av-)Markera detta parti" 5
menuText W GInfoInformant "Konfigurera Informant-parametrar" 0

# General buttons:
translate W Back {Tillbaka}
translate W Browse {Blddra}
translate W Cancel {Avbryt}
translate W Continue {Fortstt}
translate W Clear {Rensa}
translate W Close {Stng}
translate W Contents {Innehll}
translate W Defaults {Standard}
translate W Delete {Radera}
translate W Graph {Diagram}
translate W Help {Hjlp}
translate W Import {Importera}
translate W Index {Index}
translate W LoadGame {Ladda parti}
translate W BrowseGame {Blddra genom partier}
translate W MergeGame {Sl samman parti}
translate W MergeGames {Sl samman partier}
translate W Preview {Frhandsgranska}
translate W Revert {ngra inmatning}
translate W Save {Spara}
translate W Search {Sk}
translate W Stop {Stoppa}
translate W Store {Spara}
translate W Update {Uppdatera}
translate W ChangeOrient {ndra fnstrets orientering}
translate W ShowIcons {Visa Ikoner} ;# ***
translate W None {Ingen}
translate W First {Frsta}
translate W Current {Aktuella}
translate W Last {Sista}

# General messages:
translate W game {parti}
translate W games {partier}
translate W move {drag}
translate W moves {drag}
translate W all {alla}
translate W Yes {Ja}
translate W No {Nej}
translate W Both {Bda}
translate W King {Kung}
translate W Queen {Dam}
translate W Rook {Torn}
translate W Bishop {Lpare}
translate W Knight {Springare}
translate W Pawn {Bonde}
translate W White {Vit}
translate W Black {Svart}
translate W Player {Spelare}
translate W Rating {Rating}
translate W RatingDiff {Ratingskillnad (Vit - Svart)}
translate W AverageRating {Medelrating}
translate W Event {Evenemang}
translate W Site {Plats}
translate W Country {Land}
translate W IgnoreColors {Ignorera frger}
translate W Date {Datum}
translate W EventDate {Evenemangsdatum}
translate W Decade {Decennium}
translate W Year {r}
translate W Month {Mnad}
translate W Months {Januari Februari Mars April Maj Juni Juli Augusti September Oktober November December}
translate W Days {Sn Mn Tis Ons Tor Fre Lr}
translate W YearToToday {Idag}
# ====== TODO To be translated ======
translate W YearToTodayTooltip {Set date from 1 year back to today}
translate W Result {Resultat}
translate W Round {Rond}
translate W Length {Lngd}
translate W ECOCode {ECO kod}
translate W ECO {ECO}
translate W Deleted {Raderad}
translate W SearchResults {Skresultat}
translate W OpeningTheDatabase {ppnar databas}
translate W Database {Databas}
translate W Filter {Filter}
translate W noGames {inga partier}
translate W allGames {alla partier}
translate W empty {tom}
translate W clipbase {Clipbase}
translate W score {resultat}
translate W StartPos {Utgngsstllning}
translate W Total {Totalt}
translate W readonly {bara lsbar} ;# ***

# Standard error messages:
translate W ErrNotOpen {Databasen r inte ppen.}
translate W ErrReadOnly {Databasen r skrivskyddad. Du kan inte ndra i den.}
translate W ErrSearchInterrupted {Skningen avbrts; resultatet r inte fullstndigt.}

# Game information:
translate W twin {dubblett}
translate W deleted {raderad}
translate W comment {kommentar}
translate W hidden {dold}
translate W LastMove {Senaste draget}
translate W NextMove {Nsta}
translate W GameStart {Utgngsstllning}
translate W LineStart {Varianten brjar}
translate W GameEnd {Slutstllning}
translate W LineEnd {Varianten slut}

# Player information:
translate W PInfoAll {Resultat fr <b>alla</b> partier}
translate W PInfoFilter {Resultat fr <b>filtrerade</b> partier}
translate W PInfoAgainst {Resultat mot}
translate W PInfoMostWhite {De vanligaste ppningarna som vit}
translate W PInfoMostBlack {De vanligaste ppningarna som svart}
translate W PInfoRating {Ratinghistoria}
translate W PInfoBio {Biografisk information}
translate W PInfoEditRatings {Redigera rating} 

# Tablebase information:
translate W Draw {Remi}
translate W stalemate {patt}
translate W withAllMoves {med alla drag}
translate W withAllButOneMove {med alla drag utom ett}
translate W with {med}
translate W only {bara}
translate W lose {frlust}
translate W loses {frluster}
translate W allOthersLose {alla andra drag frlorar}
translate W matesIn {med matt i}
translate W hasCheckmated {har satt matt}
translate W longest {lngst}
translate W WinningMoves {Vinstdrag} 
translate W DrawingMoves {Remidrag} 
translate W LosingMoves {Frlustdrag} 
translate W UnknownMoves {Oknt resultat} 
# ====== TODO To be translated ======
translate W SideLongest {Side    Longest    %     %     %\n}
# ====== TODO To be translated ======
translate W toNoveMate {to move   mate    Win  Draw  Loss\n}
# ====== TODO To be translated ======
translate W NoSummary {\nNo summary for this tablebase.}
# ====== TODO To be translated ======
translate W MutualZugzwang {Mutual zugzwangs: }
# ====== TODO To be translated ======
translate W SelectetZugzwang {\nSelected zugzwang positions:}
# ====== TODO To be translated ======
translate W WdrawBloss {White draws, Black loses:}
# ====== TODO To be translated ======
translate W BdrawWloss {Black draws, White loses:}
# ====== TODO To be translated ======
translate W AllLoss {" Whoever moves loses:     " }

# Tip of the day:
translate W Tip {Tips}
translate W TipAtStartup {Tips vid start}

# Tree window menus:
menuText W TreeFile "Fil" 0
menuText W TreeFileFillWithBase "Fyll Cache med databas" 0 {Fyll Cachefilen med alla partier i den aktuella databasen}
menuText W TreeFileFillWithGame "Fyll Cache med parti" 0 {Fyll Cachefilen med aktuellt parti i den aktuella databasen}
menuText W TreeFileSetCacheSize "Cachestorlek" 0 {Ange Cachestorleken}
menuText W TreeFileCacheInfo "Cacheinformation" 0 {F information om Cacheanvndning}
menuText W TreeFileSave "Spara cachefil" 0 {Spara trdcache (*.stc)-filen}
menuText W TreeFileFill "Fyll cachefil" 0 \
 {Fyll cachefilen med vanliga ppningar}
menuText W TreeFileBest "Lista bsta partier" 0 {Visa lista ver de bsta partierna i trdet}
menuText W TreeFileGraph "Diagramfnster" 0 {Visa diagrammet fr denna gren i trdet}
menuText W TreeFileCopy "Kopiera trd till urklipp" 1 \
  {Kopierar trdrelaterad statistik till urklipp}
menuText W TreeFileClose "Stng trdfnstret" 0 {Stng trdfnstret}
menuText W TreeMask "Skmask" 0
menuText W TreeMaskNew "Ny" 0 {Ny skmask}
menuText W TreeMaskOpen "ppna" 0 {ppna skmask}
menuText W TreeMaskOpenRecent "ppna senaste" 0 {ppna senaste skmasken}
menuText W TreeMaskSave "Spara" 0 {Spara skmask}
menuText W TreeMaskClose "Stng" 0 {Stng skmask}
menuText W TreeMaskFillWithGame "Fyll med parti" 0 {Fyll skmask med parti}
menuText W TreeMaskFillWithBase "Fyll med databas" 0 {Fyll skmask med alla partier i databasen}
menuText W TreeMaskInfo "Info om skmask" 0 {Visa statistik fr aktuell skmask}
menuText W TreeMaskDisplay "Visa skmaskkarta" 0 {Visa skmaskdata i trdform}
menuText W TreeMaskSearch "Sk" 0 {Sk i aktuell skmask}
menuText W TreeSort "Sortera" 0
menuText W TreeSortAlpha "Alfabetiskt" 0
menuText W TreeSortECO "ECO kod" 0
menuText W TreeSortFreq "Frekvens" 0
menuText W TreeSortScore "Resultat" 0
menuText W TreeOpt "Alternativ" 0
menuText W TreeOptSlowmode "Lngsam mod" 0 {Lngsam mod fr uppdateringar (hg noggrannhet)}
menuText W TreeOptFastmode "Snabb mod" 0 {Snabb mod fr uppdateringar (ingen dragtranspositionering)}
menuText W TreeOptFastAndSlowmode "Snabb och lngsam mod" 0 {Snabb mod sedan lngsam mod fr uppdateringar}
menuText W TreeOptStartStop "Automatisk uppdatering" 0 {Vxlar automatisk uppdatering av trdfnstret}
menuText W TreeOptLock "Ls" 0 {Ls/ ls upp trdet fr den aktuella databasen}
menuText W TreeOptTraining "Trna" 0 {Starta/ stng av trningslge}
menuText W TreeOptAutosave "Spara cache filen automatiskt" 0 \
  {Spara cachefilen automatiskt nr trdfnstret stngs}
menuText W TreeHelp "Hjlp" 0
menuText W TreeHelpTree "Trdhjlp" 0
menuText W TreeHelpIndex "Hjlpindex" 0
translate W SaveCache {Spara cache}
translate W Training {Trna}
translate W LockTree {Ls}
translate W TreeLocked {Lst}
translate W TreeBest {Bst}
translate W TreeBestGames {Bsta partier i trdet}
# Note: the next message is the tree window title row. After editing it,
# check the tree window to make sure it lines up with the actual columns.
translate W TreeTitleRow \
  { Drag      ECO     Frekvens      Res.    Elo~  Niv  r~   %Remi} 
translate W TreeTotal {TOTALT} 
translate W DoYouWantToSaveFirst {Vill du spara frst}
translate W AddToMask {Lgg till i skmask}
translate W RemoveFromMask {Ta bort frn skmask}
translate W AddThisMoveToMask {Lgg till deta drag i skmask}
translate W SearchMask {Sk i skmask}
translate W DisplayMask {Visa skmask}
translate W Nag {NAG-kod}
translate W Marker {Markera}
translate W Include {Inkludera}
translate W Exclude {Exkludera}
translate W MainLine {Huvudvariant}
translate W Bookmark {Bokmrke}
translate W NewLine {Ny variant}
translate W ToBeVerified {Att bli verifierad}
translate W ToTrain {Att trna}
translate W Dubious {Tveksam}
translate W ToRemove {Att ta bort}
translate W NoMarker {Ingen markering}
translate W ColorMarker {Frg}
translate W WhiteMark {Vit}
translate W GreenMark {Grn}
translate W YellowMark {Gul}
translate W BlueMark {Bl}
translate W RedMark {Rd}
translate W CommentMove {Kommentera drag}
translate W CommentPosition {Kommentera position}
translate W AddMoveToMaskFirst {Lgg till drag till skmask frst}
translate W OpenAMaskFileFirst {ppna en skmaskmaskfil frst}
translate W Positions {Positioner}
translate W Moves {Drag}

# Finder window:
menuText W FinderFile "Fil" 0
menuText W FinderFileSubdirs "Sk i underkataloger" 0
menuText W FinderFileClose "Stng Filskaren" 0
menuText W FinderSort "Sortera" 0
menuText W FinderSortType "Typ" 0
menuText W FinderSortSize "Storlek" 0
menuText W FinderSortMod "Frndrad" 0
menuText W FinderSortName "Namn" 0
menuText W FinderSortPath "Skvg" 0
menuText W FinderTypes "Typer" 0
menuText W FinderTypesScid "Sciddatabaser" 0
menuText W FinderTypesOld "Sciddatabaser i ldre format" 0
menuText W FinderTypesPGN "PGN-filer" 0
menuText W FinderTypesEPD "EPD-filer" 0
menuText W FinderTypesRep "ppningsfiler" 0
menuText W FinderHelp "Hjlp" 0
menuText W FinderHelpFinder "Hjlp fr Filskaren" 0
menuText W FinderHelpIndex "Hjlpindex" 0
translate W FileFinder {Filskaren}
translate W FinderDir {Katalog}
translate W FinderDirs {Kataloger}
translate W FinderFiles {Filer}
translate W FinderUpDir {upp}
translate W FinderCtxOpen {ppna}
translate W FinderCtxBackup {Spara}
translate W FinderCtxCopy {Kopiera}
translate W FinderCtxMove {Flytta}
translate W FinderCtxDelete {Ta bort}

# Player finder:
menuText W PListFile "Fil" 0
menuText W PListFileUpdate "Uppdatera" 0
menuText W PListFileClose "Stng spelarfrteckningen" 1 
menuText W PListSort "Sortera" 0
menuText W PListSortName "Namn" 0
menuText W PListSortElo "Elo" 0
menuText W PListSortGames "Partier" 0
menuText W PListSortOldest "ldst" 0 
menuText W PListSortNewest "Yngst" 0

# Tournament finder:
menuText W TmtFile "Fil" 0
menuText W TmtFileUpdate "Uppdatera" 0
menuText W TmtFileClose "Stng turneringshanteraren" 0
menuText W TmtSort "Sortera" 0
menuText W TmtSortDate "Datum" 0
menuText W TmtSortPlayers "Spelare" 0
menuText W TmtSortGames "Partier" 0
menuText W TmtSortElo "Elo" 0
menuText W TmtSortSite "Plats" 0
menuText W TmtSortEvent "Evenemang" 1
menuText W TmtSortWinner "Vinnare" 0
translate W TmtLimit "Listbegrnsningar"
translate W TmtMeanElo "Lgsta snitt Elo"
translate W TmtNone "Inga turneringar hittades."

# Graph windows:
menuText W GraphFile "Fil" 0
menuText W GraphFileColor "Spara som Postscript (i frg)" 8
menuText W GraphFileGrey "Spara som Postscript (i grskala)" 8
menuText W GraphFileClose "Stng fnster" 6
menuText W GraphOptions "Alternativ" 0
menuText W GraphOptionsWhite "Vit" 0
menuText W GraphOptionsBlack "Svart" 0
menuText W GraphOptionsBoth "Bda" 1
menuText W GraphOptionsPInfo "Spelarinformation" 0
translate W GraphFilterTitle "Filterdiagram: antal per 1000 partier"
translate W GraphAbsFilterTitle "Filtergraf: frekvens fr partierna"
translate W ConfigureFilter {Konfigurera X-axlar fr r, Rating och Drag}
translate W FilterEstimate "Uppskatta"
translate W TitleFilterGraph "Scid: Filtergraf"

# Analysis window:
translate W AddVariation {Lgg till variation}
translate W AddAllVariations {Lgg till alla variationer}
translate W AddMove {Lgg till drag}
translate W Annotate {Kommentera}
translate W ShowAnalysisBoard {Visa Analysbrde}
translate W ShowInfo {Visa schackmotorinformation}
translate W FinishGame {Avsluta parti}
translate W StopEngine {Stoppa schackmotor}
translate W StartEngine {Starta schackmotor}
translate W LockEngine {Ls schackmotor vid nuvarande position}
translate W AnalysisCommand {Analysera}
translate W PreviousChoices {Fregende val}
translate W AnnotateTime {Ange tid mellan drag i sekunder}
translate W AnnotateWhich {Lgg till variationer}
translate W AnnotateAll {Fr bda sidors drag}
translate W AnnotateAllMoves {Kommentera alla drag}
translate W AnnotateWhite {Endast vits drag}
translate W AnnotateBlack {Endast svarts drag}
translate W AnnotateBlundersOnly {Nr partidraget r en uppenbar blunder}
translate W AnnotateBlundersOnlyScoreChange {Analysen rapporterar blunder, med vrderingsfrndringar frn/till: }
translate W BlundersThreshold {Trskelvrde}
translate W ScoreAllMoves {Score all moves}
translate W LowPriority {Kr som lgprioriterad process} 
translate W ClickHereToSeeMoves {Klicka hr fr att se drag}
translate W ConfigureInformant {Konfigurera Informant-parametrar}
translate W Informant!? {Intressant drag}
translate W Informant? {Dligt drag}
translate W Informant?? {Blunder}
translate W Informant?! {Tveksamt drag}
translate W Informant+= {Vit har en mindre frdel}
translate W Informant+/- {Vit har en liten frdel}
translate W Informant+- {Vit har en avgrande frdel}
translate W Informant++- {Partiet anses vara vunnet}
translate W Book {Bok}
translate W OtherBookMoves {Motstndarens bok}
translate W OtherBookMovesTooltip {Drag som motstndaren har ett svar p}

# Analysis Engine open dialog:
translate W EngineList {Lista ver schackprogram}
translate W EngineName {Namn}
translate W EngineCmd {Startkommando}
translate W EngineArgs {Parametrar} 
translate W EngineDir {Katalog}
translate W EngineElo {Elo}
translate W EngineTime {Datum}
translate W EngineNew {Ny}
translate W EngineEdit {Redigera}
translate W EngineRequired {Fet stil indikerar obligatoriska flt; vriga flt r frivilliga} 

# Stats window menus:
menuText W StatsFile "Fil" 0
menuText W StatsFilePrint "Skriv ut till fil..." 0
menuText W StatsFileClose "Stng fnster" 0
menuText W StatsOpt "Alternativ" 0

# PGN window menus:
menuText W PgnFile "Fil" 0
menuText W PgnFileCopy "Kopiera partiet till Clipbase" 0
menuText W PgnFilePrint "Skriv ut till..." 0
menuText W PgnFileClose "Stng PGN-fnster" 0
menuText W PgnOpt "Presentation" 0
menuText W PgnOptColor "Frg" 0
menuText W PgnOptShort "Kort (3-raders) huvud" 0
menuText W PgnOptSymbols "Symbolbaserad kommentar" 1
menuText W PgnOptIndentC "Indragna kommentarer" 0
menuText W PgnOptIndentV "Indragna variationer" 7
menuText W PgnOptColumn "Spaltstil (ett drag per rad)" 1
menuText W PgnOptSpace "Utrymme efter dragnummer" 1
menuText W PgnOptStripMarks "Avlgsna koder fr frgade flt och pilar" 1 
menuText W PgnOptBoldMainLine "Anvnd Fet Text fr Huvudvariationsdrag" 4
menuText W PgnColor "Frger" 0
menuText W PgnColorHeader "Huvud..." 0
menuText W PgnColorAnno "Noteringar..." 0
menuText W PgnColorComments "Kommentarer..." 0
menuText W PgnColorVars "Variationer..." 0
menuText W PgnColorBackground "Bakgrund..." 0
menuText W PgnColorMain "Huvudvariation..." 0
menuText W PgnColorCurrent "Aktuellt drag bakgrund..." 1
menuText W PgnHelp "Hjlp" 0
menuText W PgnHelpPgn "PGN-hjlp" 0
menuText W PgnHelpIndex "Index" 0
translate W PgnWindowTitle {PGN-version av partiet %u} 

# Crosstable window menus:
menuText W CrosstabFile "Fil" 0
menuText W CrosstabFileText "Skriv ut till textfil..." 9
menuText W CrosstabFileHtml "Skriv ut till HTML-fil..." 9
menuText W CrosstabFileLaTeX "Skriv ut till LaTeX-fil..." 9
menuText W CrosstabFileClose "Stng resultattabellsfnstret" 0
menuText W CrosstabEdit "Redigera" 0
menuText W CrosstabEditEvent "Evenemang" 0
menuText W CrosstabEditSite "Plats" 0
menuText W CrosstabEditDate "Datum" 0
menuText W CrosstabOpt "Presentation" 0
menuText W CrosstabOptAll "Alla-mter-alla" 0
menuText W CrosstabOptSwiss "Schweizer" 0
menuText W CrosstabOptKnockout "Knock Out" 0
menuText W CrosstabOptAuto "Auto" 1
menuText W CrosstabOptAges "lder i r" 8
menuText W CrosstabOptNats "Nationalitet" 0
menuText W CrosstabOptRatings "Rating" 0
menuText W CrosstabOptTitles "Titlar" 0
menuText W CrosstabOptBreaks "Tie-break pong" 4
menuText W CrosstabOptDeleted "Inkludera raderade partier" 8 
menuText W CrosstabOptColors "Frg (endast Schweizer)" 0
menuText W CrosstabOptColumnNumbers "Numrerade kolumner (Endast alla-mot-alla)" 2 
menuText W CrosstabOptGroup "Gruppresultat" 0
menuText W CrosstabSort "Sortera" 0
menuText W CrosstabSortName "Namn" 0
menuText W CrosstabSortRating "Rating" 0
menuText W CrosstabSortScore "Resultat" 0
menuText W CrosstabColor "Frg" 0
menuText W CrosstabColorPlain "Ren text" 0
menuText W CrosstabColorHyper "Hypertext" 0
menuText W CrosstabHelp "Hjlp" 0
menuText W CrosstabHelpCross "Hjlp fr resultattabell" 0
menuText W CrosstabHelpIndex "Hjlpindex" 0
translate W SetFilter {Bestm filter}
translate W AddToFilter {Utka filter}
translate W Swiss {Schweizer}
translate W Category {Kategori} 

# Opening report window menus:
menuText W OprepFile "Fil" 0
menuText W OprepFileText "Skriv ut till textfil..." 9
menuText W OprepFileHtml "Skriv ut till HTML-fil..." 9
menuText W OprepFileLaTeX "Skriv ut till LaTeX-fil..." 9
menuText W OprepFileOptions "Alternativ..." 0
menuText W OprepFileClose "Stng rapportfnstret" 0
menuText W OprepFavorites "Favoriter" 1 
menuText W OprepFavoritesAdd "Lgg till rapport..." 0 
menuText W OprepFavoritesEdit "Redigera favoritrapport..." 0 
menuText W OprepFavoritesGenerate "Skapa rapport..." 0 
menuText W OprepHelp "Hjlp" 0
menuText W OprepHelpReport "Hjlp fr ppningsrapporter" 0
menuText W OprepHelpIndex "Hjlpindex" 0

# Header search:
translate W HeaderSearch {Sk i partihuvud}
translate W EndSideToMove {Sida vid draget vid slutet av partiet}
translate W GamesWithNoECO {Partier utan ECO-kod?}
translate W GameLength {Partilngd}
translate W FindGamesWith {Hitta flaggade partier}
translate W StdStart {Normal utgngsstllning}
translate W Promotions {Frvandlingar}
translate W Comments {Kommentarer}
translate W Variations {Variationer}
translate W Annotations {Noteringar}
translate W DeleteFlag {Raderingsflagga}
translate W WhiteOpFlag {Vits ppning}
translate W BlackOpFlag {Svarts ppning}
translate W MiddlegameFlag {Mittspel}
translate W EndgameFlag {Slutspel}
translate W NoveltyFlag {Nyhet}
translate W PawnFlag {Bondestruktur}
translate W TacticsFlag {Taktiska stllningar}
translate W QsideFlag {Damflygelsinitiativ}
translate W KsideFlag {Kungsflygelsinitiativ}
translate W BrilliancyFlag {Utmrkt parti}
translate W BlunderFlag {Bortsttningar}
translate W UserFlag {Anvndare}
translate W PgnContains {PGN innehller text}
translate W Annotator {Kommentator}
translate W Cmnts {Bara kommenterade partier}

# Game list window:
translate W GlistNumber {Nummer}
translate W GlistWhite {Vit}
translate W GlistBlack {Svart}
translate W GlistWElo {Elo, vit}
translate W GlistBElo {Elo, svart}
translate W GlistEvent {Evenemang}
translate W GlistSite {Plats}
translate W GlistRound {Rond}
translate W GlistDate {Datum}
translate W GlistYear {r}
translate W GlistEDate {Startdatum}
translate W GlistResult {Resultat}
translate W GlistLength {Lngd}
translate W GlistCountry {Land}
translate W GlistECO {ECO}
translate W GlistOpening {ppning}
translate W GlistEndMaterial {Slutmaterial}
translate W GlistDeleted {Raderad}
translate W GlistFlags {Flaggor}
translate W GlistVars {Variationer}
translate W GlistComments {Kommentarer}
translate W GlistAnnos {Noteringar}
translate W GlistStart {Start}
translate W GlistGameNumber {Partinummer}
translate W GlistAverageElo {Medel-Elo}
translate W GlistRating {Rating}
translate W GlistFindText {Sk text}
translate W GlistMoveField {Drag}
translate W GlistEditField {Konfiguration}
translate W GlistAddField {Lgg till}
translate W GlistDeleteField {Ta bort}
translate W GlistWidth {Bredd}
translate W GlistAlign {Justering}
translate W GlistAlignL {Justera: vnster}
translate W GlistAlignR {Justera: hger}
translate W GlistAlignC {Justera: centrera}
translate W GlistColor {Frg}
translate W GlistSep {Separator}
translate W GlistCurrentSep {-- Aktuell --}
translate W GlistNewSort {Ny}
translate W GlistAddToSort {Lgg till}
translate W GsortSort {Sortera...}
translate W GsortDate {Datum}
translate W GsortYear {r}
translate W GsortEvent {Evenemang}
translate W GsortSite {Plats}
translate W GsortRound {Runda}
translate W GsortWhiteName {Vits namn}
translate W GsortBlackName {Svarts namn}
translate W GsortECO {ECO}
translate W GsortResult {Resultat}
translate W GsortMoveCount {Antal drag}
translate W GsortAverageElo {Medel-Elo}
translate W GsortCountry {Land}
translate W GsortDeleted {Borttagen}
translate W GsortEventDate {Evenemangsdatum}
translate W GsortWhiteElo {Vits Elo}
translate W GsortBlackElo {Svarts Elo}
translate W GsortComments {Kommentarer}
translate W GsortVariations {Variationer}
translate W GsortNAGs {Kommentarssymboler}
translate W GsortAscending {Stigande}
translate W GsortDescending {Sjunkande}
translate W GsortAdd {Lgg till}
translate W GsortStore {Spara}
translate W GsortLoad {ppna}
translate W GlistRemoveThisGameFromFilter  {Ta bort detta parti frn Filter}
translate W GlistRemoveGameAndAboveFromFilter  {Ta bort parti (och alla ovanfr det) frn Filter}
translate W GlistRemoveGameAndBelowFromFilter  {Ta bort parti (och alla nedanfr det) frn Filter}
translate W GlistDeleteGame {Ta tillbaka detta parti} 
translate W GlistDeleteAllGames {Ta bort alla partier i filtret} 
translate W GlistUndeleteAllGames {Ta tillbaka alla partier i filtret} 
translate W GlistMergeGameInBase {Lgg till parti i annan databas} 

# Maintenance window:
translate W DatabaseName {Databasnamn:}
translate W TypeIcon {Ikontyp:}
translate W NumOfGames {Partier:}
translate W NumDeletedGames {Raderade partier:}
translate W NumFilterGames {Partier i filter:}
translate W YearRange {Tidsperiod:}
translate W RatingRange {Ratingintervall:}
translate W Description {Beskrivning} 
translate W Flag {Flagga}
translate W CustomFlags {Anpassade flaggor}
translate W DeleteCurrent {Ta bort aktuellt parti}
translate W DeleteFilter {Ta bort partierna i filtret}
translate W DeleteAll {Ta bort alla partier}
translate W UndeleteCurrent {terta aktuellt parti}
translate W UndeleteFilter {terta partierna i filtret}
translate W UndeleteAll {terta alla partier}
translate W DeleteTwins {Ta bort dubbletter}
translate W MarkCurrent {Markera aktuellt parti}
translate W MarkFilter {Markera partierna i filtret}
translate W MarkAll {Markera alla partier}
translate W UnmarkCurrent {Avmarkera aktuellt parti}
translate W UnmarkFilter {Avmarkera partierna i filtret}
translate W UnmarkAll {Avmarkera alla partier}
translate W Spellchecking {Rttstava}
translate W Players {Spelare}
translate W Events {Evenemang}
translate W Sites {Platser}
translate W Rounds {Ronder}
translate W DatabaseOps {Databashantering}
translate W ReclassifyGames {ECO-klassificera partier}
translate W CompactDatabase {Komprimera databasen}
translate W SortDatabase {Sortera databasen}
translate W AddEloRatings {Lgg till Elorating}
translate W AutoloadGame {Ladda partinummer automatiskt}
translate W StripTags {Avlgsna PGN-taggar}
translate W StripTag {Avlgsna taggar}
translate W Cleaner {Snygga till databasen}
translate W CleanerHelp {
Databasstdaren i Scid genomfr allt det underhll av databasen du vljer nedan p den aktiva databasen.

De nuvarande instllningarna i ECO-klassificering och Radera dubbletter kommer att appliceras om du vljer dessa tgrder.
}
translate W CleanerConfirm {
Nr du vl startat Databasstdaren kan du inte avbryta den!

P en stor databas kan detta ta ett bra tag. Tidstgngen beror p valda tgrder och deras instllningar.

r du sker p att du vill pbrja databasunderhllet nu?
}
translate W TwinCheckUndelete {att vxla; "u" tar tillbaka bda)}
translate W TwinCheckprevPair {Tidigare par}
translate W TwinChecknextPair {Nsta par}
translate W TwinChecker {Scid: Dublettpartikontrollerare}
translate W TwinCheckTournament {Partier i turnering:}
translate W TwinCheckNoTwin {Ingen dublett  }
translate W TwinCheckNoTwinfound {Ingen dublett detekterades fr detta parti.\nFr att visa dubletter med detta fnster, mste du frst anvnda "Ta bort dublettpartier..."-funktionen. }
translate W TwinCheckTag {Dela taggar...}
translate W TwinCheckFound1 {Scid hittade $result dublettpartier}
translate W TwinCheckFound2 { och ange deras borttagningsflaggor}
translate W TwinCheckNoDelete {Det finns inga partier i denna databas att ta bort.}
translate W TwinCriteria1 { Dina instllningar fr att hitta dublettpartier r potentiellt sannorlika att\norsaka att icke-dublettpartier med liknande drag blir markerade som dubletter.}
translate W TwinCriteria2 {Det r rekommenderat att om du vljer "Nej" fr "samma drag" och att du vljer "Ja" fr Frger, Evenemang, Plats, Runda, r och Mnads instllningar.\nVill du fortstta och ta bort dubletter nd? }
translate W TwinCriteria3 {Det r rekommenderat att du specificerar "Ja" fr tminstonde tv av "samma plats", "samma runda" och "samma r" instllningar.\nVill du fortstta och ta bort dubletter nd?}
translate W TwinCriteriaConfirm {Scid: Bekrfta dublettinstllningar}
translate W TwinChangeTag "ndra fljande partitaggar:\n\n"
translate W AllocRatingDescription "Detta kommando kommer att anvnda den aktuella stavningskontrollfilen fr att lgga till Elo-rating till partier i denna databas. Dr en spelare inte har en aktuell rating men hans/hennes rating vid tiden fr partiet r listat i stavningskontrollfilen, kommer denna rating att lggas till."
translate W RatingOverride "Skriv ver existerande inte-noll rating?"
translate W AddRatings "Lgg till rating till:"
translate W AddedRatings {Scid lade till $r Elo-ratingar i $g partier.}
translate W NewSubmenu "Ny undermeny"

# Comment editor:
translate W AnnotationSymbols  {Symboler:}
translate W Comment {Kommentar:}
translate W InsertMark {Infoga symbol} 
translate W InsertMarkHelp {
Infoga/ta bort markering: Vlj frg, typ av markering samt ruta.
Infoga/ta bort pil: Hger-klicka tv rutor.
}

# Nag buttons in comment editor:
translate W GoodMove {Bra drag}
translate W PoorMove {Dligt drag}
translate W ExcellentMove {Utmrkt drag}
translate W Blunder {Blunder}
translate W InterestingMove {Intressant drag}
translate W DubiousMove {Tveksamt drag}
translate W WhiteDecisiveAdvantage {Vit har en avgrande frdel}
translate W BlackDecisiveAdvantage {Svart har en avgrande frdel}
translate W WhiteClearAdvantage {Vit har en klar frdel}
translate W BlackClearAdvantage {Svart har en klar frdel}
translate W WhiteSlightAdvantage {Vit har en liten frdel}
translate W BlackSlightAdvantage {Svart har en liten frdel}
translate W Equality {Jmnvikt}
translate W Unclear {Oklar}
translate W Diagram {Diagram}

# Board search:
translate W BoardSearch {Positionsskningar}
translate W FilterOperation {Hantering av aktuellt filter:}
translate W FilterAnd {AND (Restriktivt filter)}
translate W FilterOr {OR (Ackumulativt filter)}
translate W FilterIgnore {IGNORE (Anvnd ej filter)}
translate W SearchType {Sktyp:}
translate W SearchBoardExact {Exakt position (alla pjser p samma rutor)}
translate W SearchBoardPawns {Bnder (samma material, alla bnder p samma rutor)}
translate W SearchBoardFiles {Filer (samma material, alla bnder p samma filer)}
translate W SearchBoardAny {Obestmt (samma material, bnder och pjser p valfria rutor)}
translate W SearchInRefDatabase {Sk i databas}
translate W LookInVars {Sk i variationer}

# Material search:
translate W MaterialSearch {Materialskning}
translate W Material {Material}
translate W Patterns {Stllningar}
translate W Zero {Inga/-en}
translate W Any {Flera}
translate W CurrentBoard {Aktuell stllning}
translate W CommonEndings {Vanliga slutspel}
translate W CommonPatterns {Vanliga stllningar}
translate W MaterialDiff {Skillnad i material}
translate W squares {rutor}
translate W SameColor {Samma frg}
translate W OppColor {Motsatt frg}
translate W Either {Antingen eller}
translate W MoveNumberRange {Dragintervall}
translate W MatchForAtLeast {Trffa minst}
translate W HalfMoves {halvdrag}

# Common endings in material search:
translate W EndingPawns {Bondeslutspel}
translate W EndingRookVsPawns {Torn mot Bonde (Bnder)}
translate W EndingRookPawnVsRook {Torn och 1 Bonde mot Torn}
translate W EndingRookPawnsVsRook {Torn och Bonde (Bnder) mot Torn}
translate W EndingRooks {Torn mot Torn slutspel}
translate W EndingRooksPassedA {Torn mot Torn slutspel med en fri a-bonde}
translate W EndingRooksDouble {Dubbla Torn slutspel}
translate W EndingBishops {Lpare mot Lpare slutspel}
translate W EndingBishopVsKnight {Lpare mot Springare slutspel}
translate W EndingKnights {Springare mot Springare slutspel}
translate W EndingQueens {Dam mot Dam slutspel}
translate W EndingQueenPawnVsQueen {Dam och 1 Bonde mot Dam}
translate W BishopPairVsKnightPair {Tv Lpare mot Tv Springare mittspel}

# Common patterns in material search:
translate W PatternWhiteIQP {Vit Isolerad dambonde}
translate W PatternWhiteIQPBreakE6 {Vit Isolerad dambonde: d4-d5 brott mot e6}
translate W PatternWhiteIQPBreakC6 {Vit Isolerad dambonde: d4-d5 brott mot c6}
translate W PatternBlackIQP {Svart Isolerad dambonde}
translate W PatternWhiteBlackIQP {Vit Isolerad dambonde mot Svart Isolerad dambonde}
translate W PatternCoupleC3D4 {Vit c3+d4 Isolaterat Bondepar}
translate W PatternHangingC5D5 {Svart Hngande Bnder p c5 och d5}
translate W PatternMaroczy {Maroczy Center (med Bnder p c4 och e4)}
translate W PatternRookSacC3 {Tornoffer p c3}
translate W PatternKc1Kg8 {O-O-O mot O-O (Kc1 mot Kg8)}
translate W PatternKg1Kc8 {O-O mot O-O-O (Kg1 mot Kc8)}
translate W PatternLightFian {Ljus-Ruta Fianchetton (Lpare-g2 mot Lpare-b7)}
translate W PatternDarkFian {Mrk-Ruta Fianchetton (Lpare-b2 mot Lpare-g7)}
translate W PatternFourFian {Fyra Fianchetton (Lpare p b2,g2,b7,g7)}

# Game saving:
translate W Today {Idag}
translate W ClassifyGame {Klassificera parti}

# Setup position:
translate W EmptyBoard {Tm brdet}
translate W InitialBoard {Utgngsstllning}
translate W SideToMove {Frg vid draget}
translate W MoveNumber {Antal drag}
translate W Castling {Rockad}
translate W EnPassantFile {En Passant fil}
translate W ClearFen {Rensa FEN}
translate W PasteFen {Klistra in FEN}
translate W SaveAndContinue {Spara och fortstt}
translate W DiscardChangesAndContinue {Ignorera ndringar\noch fortstt}
translate W GoBack {G tillbaka}

# Replace move dialog:
translate W ReplaceMove {Erstt drag}
translate W AddNewVar {Lgg till ny variation}
translate W NewMainLine {Ny huvudvariation}
translate W ReplaceMoveMessage {Det finns redan ett drag i denna stllning.

Du kan erstta detta drag, och frlora samtliga fljande, eller lgga till ditt drag som en ny variation.

(Om du stnger av "Frga fre erstt drag" i Alternativ:Drag menyn slipper du denna frga i framtiden.)}

# Make database read-only dialog:
translate W ReadOnlyDialog {Om du ger denna databas endast lsbar kan du inte gra ngra ndringar i den.
Inga partier kan sparas eller ersttas, och du kan inte ndra flaggor fr raderbara partier.
Alla sorteringsinstllningar eller ECO-klassificeringar kommer att vara temporra.

Du kan gra den skrivbar igen genom att helt enkelt stnga och ppna den igen.

Vill du verkligen ange att databasen endast ska vara lsbar?}

# Clear game dialog:
translate W ClearGameDialog {Detta parti har ndrats.

Vill du verkligen fortstta och frlora ndringarna?
}

# Exit dialog:
translate W ExitDialog {Vill du verkligen avsluta Scid?}
translate W ExitUnsaved {De fljande databaserna har osparade frndringar. Om du avslutar nu, kommer dessa frndringar att g frlorade.} 

# Import window:
translate W PasteCurrentGame {Klistra in aktuellt parti}
translate W ImportHelp1 {Ange eller klistra in ett parti i PGN-format i omrdet ovan.}
translate W ImportHelp2 {Eventuella felaktigheter kommer att anges hr.}
translate W OverwriteExistingMoves {Skriv ver existerande drag ?}

# ECO Browser:
translate W ECOAllSections {alla ECO avdelningar}
translate W ECOSection {ECO avdelning}
translate W ECOSummary {Sammanfattning fr}
translate W ECOFrequency {Underkodsfrekvens fr}

# Opening Report:
translate W OprepTitle {ppningsrapport}
translate W OprepReport {Rapport}
translate W OprepGenerated {Skapad av}
translate W OprepStatsHist {Statistik och historik}
translate W OprepStats {Statistik}
translate W OprepStatAll {Rapporterade partier}
translate W OprepStatBoth {Bda med rating}
translate W OprepStatSince {Sedan}
translate W OprepOldest {De ldsta partierna}
translate W OprepNewest {De yngsta partierna}
translate W OprepPopular {Aktuell popularitet}
translate W OprepFreqAll {Frekvens totalt:   }
translate W OprepFreq1   {Under det senaste ret: }
translate W OprepFreq5   {Under de 5 senaste ren: }
translate W OprepFreq10  {Under de 10 senaste ren: }
translate W OprepEvery {en gng var %u parti}
translate W OprepUp {kat %u%s gentemot samtliga r}
translate W OprepDown {minskat %u%s gentemot samtliga r}
translate W OprepSame {ingen frndring gentemot samtliga r}
translate W OprepMostFrequent {Spelas mest av}
translate W OprepMostFrequentOpponents {Vanligaste motstndaren}
translate W OprepRatingsPerf {Rating och resultat}
translate W OprepAvgPerf {Genomsnittrating och resultat}
translate W OprepWRating {Vits rating}
translate W OprepBRating {Svarts rating}
translate W OprepWPerf {Vits resultat}
translate W OprepBPerf {Svarts resultat}
translate W OprepHighRating {Partierna med hgst genomsnittsrating}
translate W OprepTrends {Resultattrender}
translate W OprepResults {Lngd och frekvens}
translate W OprepLength {Partiets lngd}
translate W OprepFrequency {Frekvens}
translate W OprepWWins {Vita vinster: }
translate W OprepBWins {Svarta vinster: }
translate W OprepDraws {Remier:      }
translate W OprepWholeDB {Hela databasen}
translate W OprepShortest {Kortaste vinster}
# translate W OprepShortWhite {De kortaste vita vinsterna}
# translate W OprepShortBlack {De kortaste svarta vinsterna}
translate W OprepMovesThemes {Drag och teman}
translate W OprepMoveOrders {Dragordning fr att n rapportstllningen}
translate W OprepMoveOrdersOne \
  {Stllningen nddes bara genom en dragordning:}
translate W OprepMoveOrdersAll \
  {Det fanns %u dragordningar som ledde fram denna stllning:}
translate W OprepMoveOrdersMany \
  {Det fanns %u dragordningar som ledde fram denna stllning. De %u vanligaste r:}
translate W OprepMovesFrom {Drag frn rapportstllningen}
translate W OprepMostFrequentEcoCodes {De mest frekommande ECO-koderna}
translate W OprepThemes {Positionella teman}
translate W OprepThemeDescription {Temanfrekvens de frsta %u dragen av varje parti}
# translate W OprepThemeDescription {Antal teman vid drag %u}
translate W OprepThemeSameCastling {Rockad p samma flygel}
translate W OprepThemeOppCastling {Rockad p olika flyglar}
translate W OprepThemeNoCastling {Ingen har gjort rockad}
translate W OprepThemeKPawnStorm {Bondestorm p kungsflygeln}
translate W OprepThemeQueenswap {Dambyte}
translate W OprepThemeWIQP {Isolerad vit dambonde} 
translate W OprepThemeBIQP {Isolerad svart dambonde}
translate W OprepThemeWP567 {Vit bonde p 5e/6e/7e raden}
translate W OprepThemeBP234 {Svart bonde p 2a/3e/4e raden}
translate W OprepThemeOpenCDE {ppen c/d/e linje}
translate W OprepTheme1BishopPair {Endast den ena sidan har lparparet}
translate W OprepEndgames {Slutspel}
translate W OprepReportGames {Antal partier i rapporten}
translate W OprepAllGames    {Samtliga partier}
translate W OprepEndClass {Material i slutstllningen}
translate W OprepTheoryTable {Teorisammanstllning}
translate W OprepTableComment {Skapad frn de %u hgst rankade partierna.}
translate W OprepExtraMoves {Ytterligare antal drag i notfrteckningen}
translate W OprepMaxGames {Maximalt antal partier i sammanstllningen}
translate W OprepViewHTML {Visa HTML}
translate W OprepViewLaTeX {Visa LaTeX}

# Player Report:
translate W PReportTitle {Spelarrapport} 
translate W PReportColorWhite {med de vita pjserna} 
translate W PReportColorBlack {med de svarta pjserna} 
translate W PReportMoves {efter %s} 
translate W PReportOpenings {ppningar} 
translate W PReportClipbase {Tm Clipbase och kopiera liknande partier dit} 


# Piece Tracker window:
translate W TrackerSelectSingle {Vnsterklicka fr att vlja denna pjs.} 
translate W TrackerSelectPair {Vnsterklicka fr att vlja denna pjs; anvnd hger musknapp fr att ocks vlja den relaterade pjsen.}
translate W TrackerSelectPawn {Vnsterklicka fr att vlja denna pjs; anvnd hger musknapp fr att vlja alla tta bnder.}
translate W TrackerStat {Statistik}
translate W TrackerGames {% partier med drag till rutan}
translate W TrackerTime {% tid p varje ruta}
translate W TrackerMoves {Drag}
translate W TrackerMovesStart {Ange vid vilket drag skningen ska brja.}
translate W TrackerMovesStop {Ange vid vilket drag skningen ska sluta.}

# Game selection dialogs:
translate W SelectAllGames {Alla partier i databasen}
translate W SelectFilterGames {Endast partierna i filtret}
translate W SelectTournamentGames {Endast partierna i den aktuella turneringen}
translate W SelectOlderGames {Endast ldre partier}

# Delete Twins window:
translate W TwinsNote {Partier mste minst ha samma spelare fr att kunna identifieras som dubbletter samt uppfylla andra kriterier du kan ange nedan. Nr dubbletter hittas raderas det kortare partiet. Tips: det bsta r att anvnda rttstavningen innan dubblettjmfrelsen eftersom detta frbttrar mjligheten fr upptckt av dubbletter.}
translate W TwinsCriteria {Kriterium: Dubbletter mste ha...}
translate W TwinsWhich {Ange vilka partier som ska jmfras}
translate W TwinsColors {Samma frger?}
translate W TwinsEvent {Samma evenemang?}
translate W TwinsSite {Samma plats?}
translate W TwinsRound {Samma rond?}
translate W TwinsYear {Samma r?}
translate W TwinsMonth {Samma mnad?}
translate W TwinsDay {Samma dag?}
translate W TwinsResult {Samma resultat?}
translate W TwinsECO {Samma ECO-kod?}
translate W TwinsMoves {Samma drag?}
translate W TwinsPlayers {Jmfr spelarnas namn:}
translate W TwinsPlayersExact {Exakt kopia}
translate W TwinsPlayersPrefix {Endast de 4 frsta bokstverna}
translate W TwinsWhen {Nr dubbletter tas bort}
translate W TwinsSkipShort {Ignorera alla partier som r kortare n 5 drag?}
translate W TwinsUndelete {terta alla partier frst?}
translate W TwinsSetFilter {Filtrera alla borttagna dubbletter?}
translate W TwinsComments {Spara alltid partier med kommentarer?}
translate W TwinsVars {Spara alltid partier med variationer?}
translate W TwinsDeleteWhich {Ange vilket parti som ska tas bort:} 
translate W TwinsDeleteShorter {Det kortare partiet} 
translate W TwinsDeleteOlder {Partiet med lgst nummer} 
translate W TwinsDeleteNewer {Partiet med hgst nummer} 
translate W TwinsDelete {Ta bort partier}

# Name editor window:
translate W NameEditType {Typ av namn att redigera}
translate W NameEditSelect {Partier att redigera}
translate W NameEditReplace {Erstt}
translate W NameEditWith {med}
translate W NameEditMatches {Matchar: Tryck Ctrl+1 till Ctrl+9 fr att vlja}
translate W CheckGames {Kontrollera partier}
translate W CheckGamesWhich {Kontrollera partier}
translate W CheckAll {Alla partier}
translate W CheckSelectFilterGames {Bara partier i filter}

# Classify window:
translate W Classify {Klassificera}
translate W ClassifyWhich {ECO-klassificera vilka partier?}
translate W ClassifyAll {Alla partier (skriv ver gamla ECO-koder)}
translate W ClassifyYear {Alla partier spelade under det senaste ret}
translate W ClassifyMonth {Alla partier spelade den senaste mnaden}
translate W ClassifyNew {Endast partier som nnu ej klassificerats}
translate W ClassifyCodes {ECO-koder som ska anvndas}
translate W ClassifyBasic {Enbart standardkoder ("B12", ...)}
translate W ClassifyExtended {Scidextensioner ("B12j", ...)}

# Compaction:
translate W NameFile {Namnfil}
translate W GameFile {Partifil}
translate W Names {Namn}
translate W Unused {Ej anvnd}
translate W SizeKb {Storlek (kb)}
translate W CurrentState {Aktuell status}
translate W AfterCompaction {Efter komprimering}
translate W CompactNames {Namn, komprimera namnfil}
translate W CompactGames {Partier, komprimera partifil}
translate W NoUnusedNames "Det finns inga oanvnda namn, s namnfilen r redan fullt komprimerad."
translate W NoUnusedGames "Partifilen r redan fullt komprimerad."
translate W GameFileCompacted {Partifilen fr databasen blev komprimerad.}

# Sorting:
translate W SortCriteria {Kriterium}
translate W AddCriteria {Lgg till kriterium}
translate W CommonSorts {Normal sortering}
translate W Sort {Sortering}

# Exporting:
translate W AddToExistingFile {Lgg till partier till en existerande fil?}
translate W ExportComments {Exportera kommentarer?}
translate W ExportVariations {Exportera variationer?}
translate W IndentComments {Dra in kommentarer?}
translate W IndentVariations {Dra in variationer?}
translate W ExportColumnStyle {Kolumnstil (ett drag per rad)?}
translate W ExportSymbolStyle {Symbolbaserade kommentarer:}
translate W ExportStripMarks {Avlgsna koder fr flt och pilar frn kommentarerna?} 

# Goto game/move dialogs:
translate W LoadGameNumber {Ange partiets nummer:}
translate W GotoMoveNumber {G till drag nummer:}

# Copy games dialog:
translate W CopyGames {kopiera partier}
translate W CopyConfirm {
 Vill du verkligen kopiera
 de [::utils::thousands $nGamesToCopy] filtrerade partierna
 ur databasen "$fromName"
 till databasen "$targetName"?
}
translate W CopyErr {Kan ej kopiera partier}
translate W CopyErrSource {klldatabasen}
translate W CopyErrTarget {mldatabasen}
translate W CopyErrNoGames {har inga partier i filtret}
translate W CopyErrReadOnly {kan bara lsas}
translate W CopyErrNotOpen {r ej ppen}

# Colors:
translate W LightSquares {Ljusa flt}
translate W DarkSquares {Mrka flt}
translate W SelectedSquares {Valda flt}
translate W SuggestedSquares {Freslagna flt}
translate W WhitePieces {Vita pjser}
translate W BlackPieces {Svarta pjser}
translate W WhiteBorder {Vit kantlinje}
translate W BlackBorder {Svart kantlinje}

# Novelty window:
translate W FindNovelty {Hitta nyhet}
translate W Novelty {Nyhet}
translate W NoveltyInterrupt {Nyhetsskningen avbrts}
translate W NoveltyNone {Inga nyheter hittades i detta parti}
translate W NoveltyHelp {
Scid kommer att frska hitta det frsta draget som leder till en position som inte annars finns i denna databas eller i spelppingsboken baserad p ECO.
}

# Sounds configuration:
translate W SoundsFolder {Ljudfilskatalog}
translate W SoundsFolderHelp {Katalogen ska ha filerna King.wav, a.wav, 1.wav, etc}
translate W SoundsAnnounceOptions {Instllningar fr Dragannonsering}
translate W SoundsAnnounceNew {Annonsera nya drag nr de grs}
translate W SoundsAnnounceForward {Annonsera drag nr du gr fram ett drag}
translate W SoundsAnnounceBack {Annonsera drag nr du gr fram eller tillbaka ett drag}

# Upgrading databases:
translate W Upgrading {Uppdaterar}
translate W ConfirmOpenNew {
Denna databas r i ett gammal format (Scid 3) och kan inte ppnas i Scid 4, men en databas i det nya formatet (Scid 4) har redan skapats.

Vill du ppna den senare databasen istllet?
}
translate W ConfirmUpgrade {
Denna databas r i ett gammalt format (Scid 3). En databas i det nyare formatet mste skapas innan den kan anvndas i Scid 4.

Genom att uppdatera skapas en databas i det nya formatet med samma innehll; uppdateringen ndrar ingenting i den gamla databasen.

Detta kan ta ett tag men behver bara gras en gng. Om du tycker att det tar alltfr lng tid kan du avbryta processen.

Vill du uppdatera denna databas nu?
}

# Recent files options:
translate W RecentFilesMenu {Antal senast ppnade filer i Arkivmenyn}
translate W RecentFilesExtra {Antal senast ppnade filer i extra undermeny}

# My Player Names options:
translate W MyPlayerNamesDescription {
Ange en lista p dina favoritspelare hr nedanfr. Skriv ett namn per rad. Jokertecken ("?", t ex, motsvarar ett enstaka tecken medan "*" str fr flera tecken) r tilltna.

Varje gng ett parti med en spelare vars namn str i denna lista ppnas kommer brdet automatiskt att vridas s att partiet visas frn spelarens perspektiv.
} 
translate W showblunderexists {visa blunder finns}
translate W showblundervalue {visa blundervrde}
translate W showscore {visa vrdering}
translate W coachgame {trnarparti}
translate W configurecoachgame {konfigurera trnarparti}
translate W configuregame {Konfigurera parti}
translate W Phalanxengine {Phalanx schackmotor}
translate W Coachengine {Trnarschackmotor}
translate W difficulty {svrighetsgrad}
translate W hard {svr}
translate W easy {ltt}
translate W Playwith {Spela med}
translate W white {vit}
translate W black {svart}
translate W both {bda}
translate W Play {Spela}
translate W Noblunder {Ingen blunder}
translate W blunder {blunder}
translate W Noinfo {-- Ingen information --}
translate W PhalanxOrTogaMissing {Phalanx eller Toga hittades inte}
translate W moveblunderthreshold {drag r en blunder om frlust r strre n}
translate W limitanalysis {begrnsa schackmotors analystid}
translate W seconds {sekunder}
translate W Abort {Avbryt}
translate W Resume {Fortstt}
translate W OutOfOpening {utanfr ppning}
translate W NotFollowedLine {Du fljde inte variationen}
translate W DoYouWantContinue {Vill du fortstta ?}
translate W CoachIsWatching {Trnaren observerar}
translate W Ponder {Permanent tnkande}
translate W LimitELO {Begrnsa ELO-styrka}
translate W DubiousMovePlayedTakeBack {Ett tveksamt drag spelades, vill du ta tillbaka det ?}
translate W WeakMovePlayedTakeBack {Ett svagt drag spelades, vill du ta tillbaka det ?}
translate W BadMovePlayedTakeBack {Ett dligt drag spelades, vill du ta tillbaka det ?}
translate W Iresign {Jag ger upp}
translate W yourmoveisnotgood {ditt drag r inte bra}
translate W EndOfVar {Slut p variation}
translate W Openingtrainer {ppningstrnare}
translate W DisplayCM {Visa kandidatdrag}
translate W DisplayCMValue {Visa kandidatdragens vrden}
translate W DisplayOpeningStats {Visa statistik}
translate W ShowReport {Visa rapport}
translate W NumberOfGoodMovesPlayed {bra drag spelade}
translate W NumberOfDubiousMovesPlayed {tveksamma drag spelade}
translate W NumberOfMovesPlayedNotInRepertoire {drag spelade som inte finns i repetoar}
translate W NumberOfTimesPositionEncountered {gnger positionen ptrffats}
translate W PlayerBestMove  {Tillt bara bsta dragen}
translate W OpponentBestMove {Motstndare spelar bsta dragen}
translate W OnlyFlaggedLines {Bara markerade variationer}
translate W resetStats {Nollstll statistik}
translate W Repertoiretrainingconfiguration {Repetoartrnings-konfiguration}
translate W Loadingrepertoire {ppnar repetoar}
translate W Movesloaded {ppnat drag}
translate W Repertoirenotfound {Repetoar hittades inte}
translate W Openfirstrepertoirewithtype {ppna frst en repetoardatabas med ikon/typ angivet p hger sida}
translate W Movenotinrepertoire {Drag finns inte i repetoar}
translate W PositionsInRepertoire {Positioner i repetoar}
translate W PositionsNotPlayed {Positioner inte spelade}
translate W PositionsPlayed {Positioner spelade}
translate W Success {Framgng}
translate W DubiousMoves {Tveksamma drag}
translate W OutOfRepertoire {Utanfr repetoar}
translate W ConfigureTactics {Konfigurera taktik}
translate W ResetScores {Nollstll pong}
translate W LoadingBase {ppnar bas}
translate W Tactics {Taktik}
translate W ShowSolution {Visa lsning}
translate W NextExercise {Nsta vning}
translate W PrevExercise {Tidigare vning}
translate W StopTraining {Avbryt trning}
translate W Next {Nsta}
translate W ResettingScore {Nollstller pong}
translate W LoadingGame {ppnar parti}
translate W MateFound {Matt hittad}
translate W BestSolutionNotFound {Bsta lsningen hittades INTE !}
translate W MateNotFound {Matt hittades inte}
translate W ShorterMateExists {En kortare matt finns}
translate W ScorePlayed {Pong spelad}
translate W Expected {frvntat}
translate W ChooseTrainingBase {Vlj trningsbas}
translate W Thinking {Tnker}
translate W AnalyzeDone {Analys klar}
translate W WinWonGame {Vinn vunnet parti}
translate W Lines {Variationer}
translate W ConfigureUCIengine {Konfigurera UCI-schackmotor}
translate W SpecificOpening {Specifik ppning}
translate W StartNewGame {Starta nytt parti}
translate W FixedLevel {Fast niv}
translate W Opening {ppning}
translate W RandomLevel {Slumpmssig niv}
translate W StartFromCurrentPosition {Starta frn den aktuella positionen}
translate W FixedDepth {Fast skdjup}
translate W Nodes {Noder} 
translate W Depth {Skdjup}
translate W Time {Tid} 
translate W SecondsPerMove {Sekunder per drag}
translate W Engine {Schackmotor}
translate W TimeMode {Tidsmod}
translate W TimeBonus {Tid + bonus}
translate W TimeMin {min}
translate W TimeSec {sek}
translate W AllExercisesDone {Alla vningar gjorda}
translate W MoveOutOfBook {Drag utanfr bok}
translate W LastBookMove {Sista bokdrag}
translate W AnnotateSeveralGames {Kommentera flera partier\nfrn aktuellt till :}
translate W FindOpeningErrors {Hitta ppningsfel}
translate W MarkTacticalExercises {Markera taktiska vningar}
translate W UseBook {Anvnd bok}
translate W MultiPV {Flera variationer}
translate W Hash {Hashminne}
translate W OwnBook {Anvnd schackmotorbok}
translate W BookFile {ppningsbok}
translate W AnnotateVariations {Kommentera variationer}
translate W ShortAnnotations {Korta kommentarer}
translate W addAnnotatorTag {Lgg till kommentator-tagg}
translate W AddScoreToShortAnnotations {Lgg till vrdering till korta kommentarer}
translate W Export {Exportera}
translate W BookPartiallyLoaded {Bok delvis ppnad}
translate W Calvar {Berkning av variationer}
translate W ConfigureCalvar {Konfiguration}
translate W Reti {Reti}
translate W English {Engelsk}
translate W d4Nf6Miscellaneous {1.d4 Nf6 Diverse}
translate W Trompowsky {Trompowsky}
translate W Budapest {Budapest}
translate W OldIndian {Gammalindisk}
translate W BenkoGambit {Benko-gambit}
translate W ModernBenoni {Modern Benoni}
translate W DutchDefence {Hollndskt frsvar}
translate W Scandinavian {Skandinaviskt}
translate W AlekhineDefence {Alekhines frsvar}
translate W Pirc {Pirc}
translate W CaroKann {Caro-Kann}
translate W CaroKannAdvance {Caro-Kann Avancemang}
translate W Sicilian {Siciliansk}
translate W SicilianAlapin {Siciliansk Alapin}
translate W SicilianClosed {Stngd Siciliansk}
translate W SicilianRauzer {Siciliansk Rauzer}
translate W SicilianDragon {Siciliansk Drake}
translate W SicilianScheveningen {Siciliansk Scheveningen}
translate W SicilianNajdorf {Siciliansk Najdorf}
translate W OpenGame {ppet parti}
translate W Vienna {Wiener}
translate W KingsGambit {Kungsgambit}
translate W RussianGame {Ryskt parti}
translate W ItalianTwoKnights {Italianskt/Tvspringar}
translate W Spanish {Spanskt}
translate W SpanishExchange {Spanskt Avbytesvariant}
translate W SpanishOpen {pett Spanskt}
translate W SpanishClosed {Stngt Spanskt}
translate W FrenchDefence {Franskt Frsvar}
translate W FrenchAdvance {Fransk Avancemang}
translate W FrenchTarrasch {Fransk Tarrasch}
translate W FrenchWinawer {Fransk Winawer}
translate W FrenchExchange {Fransk Avbytesvariant}
translate W QueensPawn {Dambonde}
translate W Slav {Slav}
translate W QGA {Antagen Damgambit}
translate W QGD {Avbjd Damgambit}
translate W QGDExchange {Avbjd Damgambit Avbytesvariant}
translate W SemiSlav {Semi-Slav}
translate W QGDwithBg5 {Avbjd Damgambit med Bg5}
translate W QGDOrthodox {Avbjd Damgambit Ortodox}
translate W Grunfeld {Grnfeld}
translate W GrunfeldExchange {Grnfeld Avbytesvariant}
translate W GrunfeldRussian {Grnfeld Ryskt}
translate W Catalan {Catalan}
translate W CatalanOpen {ppen Catalan}
translate W CatalanClosed {Stngd Catalan}
translate W QueensIndian {Damindiskt}
translate W NimzoIndian {Nimzo-Indiskt}
translate W NimzoIndianClassical {Nimzo-Indiskt Klassiskt}
translate W NimzoIndianRubinstein {Nimzo-Indiskt Rubinstein}
translate W KingsIndian {Kungsindiskt}
translate W KingsIndianSamisch {Kungsindiskt Smisch}
translate W KingsIndianMainLine {Kungsindiskt Huvudvariation}
translate W ConfigureFics {Konfigurera FICS}
translate W FICSGuest {Logga in som Gst}
translate W FICSServerPort {Server-port}
translate W FICSServerAddress {IP-adress}
translate W FICSRefresh {Uppdatera}
translate W FICSTimesealPort {Timeseal-port}
translate W FICSSilence {Tystnad}
translate W FICSOffers {Erbjuder}
translate W FICSConsole {Konsol}
translate W FICSGames {Partier}
translate W FICSUnobserve {Sluta observera parti}
translate W FICSProfile {Visa din historik och profil}
translate W FICSRelayedGames {terutsnda partier}
translate W FICSFindOpponent {Hitta motstndare}
translate W FICSTakeback {Ta tillbaka}
translate W FICSTakeback2 {Ta tillbaka 2}
translate W FICSInitTime {Initialtid (minuter)}
translate W FICSIncrement {Inkrementering (sekunder)}
translate W FICSRatedGame {Ratingparti}
translate W FICSAutoColour {automatisk}
translate W FICSManualConfirm {bekrfta manuellt}
translate W FICSFilterFormula {Filtrera med formel}
translate W FICSIssueSeek {Skfrga}
translate W FICSChallenge {Utmana}
translate W FICSAccept {acceptera}
translate W FICSDecline {avbj}
translate W FICSColour {frg}
translate W FICSSend {skicka}
translate W FICSConnect {Anslut}
translate W FICSdefaultuservars {Anvnd standardvariabler}
translate W FICSObserveconfirm {Vill du observera parti} 
# ====== TODO To be translated ======
translate W FICSpremove {Enable premove}
translate W GameReview {Partiversikt}
translate W GameReviewTimeExtended {Utkad tid}
translate W GameReviewMargin {Felmarginal}
translate W GameReviewAutoContinue {Fortstt automatiskt nr drag r korrekt}
translate W GameReviewReCalculate {Anvnd utkad tid}
translate W GameReviewAnalyzingMovePlayedDuringTheGame {Analysera drag spelat under partiet}
translate W GameReviewAnalyzingThePosition {Analysera positionen}
translate W GameReviewEnterYourMove {Ange ditt drag}
translate W GameReviewCheckingYourMove {Kontrollerar ditt drag}
translate W GameReviewYourMoveWasAnalyzed {Ditt drag analyserades}
translate W GameReviewYouPlayedSameMove {Du speladade samma drag som i partiet}
translate W GameReviewScoreOfYourMove {Vrdering av ditt drag}
translate W GameReviewGameMoveScore {Partidragets vrdering}
translate W GameReviewEngineScore {Schackmotorns vrdering}
translate W GameReviewYouPlayedLikeTheEngine {Du spelade som schackmotorn}
translate W GameReviewNotEngineMoveButGoodMove {Inte schackmotordraget, men det r ocks ett bra drag}
translate W GameReviewMoveNotGood {Detta drag r inte bra, vrderingen r}
translate W GameReviewMovesPlayedLike {Drag spelade som}
translate W GameReviewMovesPlayedEngine {Drag apelade som schackmotorn}
translate W CCDlgConfigureWindowTitle {Konfigurera Korrespondensschack}
translate W CCDlgCGeneraloptions {Generella instllningar}
translate W CCDlgDefaultDB {Standarddatabas:}
translate W CCDlgInbox {Inkorg (skvg):}
translate W CCDlgOutbox {Utkorg (skvg):}
translate W CCDlgXfcc {Xfcc-Konfiguration:}
translate W CCDlgExternalProtocol {Extern Protokollhanterare (t.ex. Xfcc)}
translate W CCDlgFetchTool {Hmtningsverktyg:}
translate W CCDlgSendTool {Sndverktyg:}
translate W CCDlgEmailCommunication {eMail-kommunikation}
translate W CCDlgMailPrg {eMail-program:}
translate W CCDlgBCCAddr {(B)CC-address:}
translate W CCDlgMailerMode {Mod:}
translate W CCDlgThunderbirdEg {t.ex. Thunderbird, Mozilla Mail, Icedove...}
translate W CCDlgMailUrlEg {t.ex. Evolution}
translate W CCDlgClawsEg {t.ex Sylpheed Claws}
translate W CCDlgmailxEg {t.ex. mailx, mutt, nail...}
translate W CCDlgAttachementPar {Bilage-parameter:}
translate W CCDlgInternalXfcc {Anvnd internt Xfcc-std}
translate W CCDlgConfirmXfcc {Bekrfta drag}
translate W CCDlgSubjectPar {mnes-parameter:}
translate W CCDlgDeleteBoxes {Tm In-/Utkorg} 
translate W CCDlgDeleteBoxesText {Vill du verkligen tmma dina In- och Utkorgskataloger fr Korrespondensschack? Detta krver en ny synkronisering fr att visa den seanaste statusen p dina partier} 
translate W CCDlgConfirmMove {Bekrfta drag} 
translate W CCDlgConfirmMoveText {Om du bekrftar, kommer fljande drag och kommentar att skickas till servern:} 
translate W CCDlgDBGameToLong {Inkonsekvent huvudvariation}
translate W CCDlgDBGameToLongError {Huvudvariationen i din databas r lngre n partiet i din Inkorg. Om Inkorgen innehller aktuella partier, dvs precis efter en synkronisering, lades ngra drag felaktigt till i huvudvariationen i databasen.\nI detta fall var god och frkorta huvudvariationen till (maximalt) drag\n}
translate W CCDlgStartEmail {Starta ett nytt eMail-parti}
translate W CCDlgYourName {Ditt Namn:}
translate W CCDlgYourMail {Din eMail-address:}
translate W CCDlgOpponentName {Motstndarnamn:}
translate W CCDlgOpponentMail {Motstndarens eMail-address:}
translate W CCDlgGameID {Parti-ID (unikt):}
translate W CCDlgTitNoOutbox {Scid: Korrespondensschackutkorg}
translate W CCDlgTitNoInbox {Scid: Korrespondensschackinkorg}
translate W CCDlgTitNoGames {Scid: Inga Korrespondensschackpartier}
translate W CCErrInboxDir {Korrespondensschacksinkorgskatalog:}
translate W CCErrOutboxDir {Korrespondensschacksutkorgskatalog:}
translate W CCErrDirNotUsable {finns inte eller r inte mjlig att anvnda!\nVar god och kontrollera och korrigera instllningarna.}
translate W CCErrNoGames {innehller inga partier!\nVar god och hmta dem frst.}
translate W CCDlgTitNoCCDB {Scid: Ingen Korrespondensdatabas}
translate W CCErrNoCCDB {Ingen Databas av typ 'Korrespondens' r ppnad. Var god och ppna en innan du anvnder Korrespondensschackfunktioner.}
translate W CCFetchBtn {Hmta partier frn servern och bearbeta Inkorgen}
translate W CCPrevBtn {G till tidigare parti}
translate W CCNextBtn {G till nsta parti}
translate W CCSendBtn {Skicka drag}
translate W CCEmptyBtn {Tm Inkorgen och Utkorgen}
translate W CCHelpBtn {Hjlp med ikoner och statusindikatorer.\nFr generell Hjlp tryck p F1!}
translate W CCDlgServerName {Servernamn:}
translate W CCDlgLoginName  {Inloggningsnamn:}
translate W CCDlgPassword   {Lsenord:}
# ====== TODO To be translated ======
translate W CCDlgShowPassword {Show password}
translate W CCDlgURL        {Xfcc-URL:}
translate W CCDlgRatingType {Ratingtyp:}
translate W CCDlgDuplicateGame {Icke unikt parti-ID}
translate W CCDlgDuplicateGameError {Detta parti finns fler n en gng i din databas. Var god och ta bort alla dubbletter och komprimera din partifil (Arkiv/Underhll/Komprimera Databas).}
translate W CCDlgSortOption {Sorterar:}
translate W CCDlgListOnlyOwnMove {Bara partier dr jag r vid draget}
translate W CCOrderClassicTxt {Plats, Evenemang, Runda, Resultat, Vit, Svart}
translate W CCOrderMyTimeTxt {Min klocka}
translate W CCOrderTimePerMoveTxt {Tid per drag till nsta tidskontroll}
translate W CCOrderStartDate {Startdatum}
translate W CCOrderOppTimeTxt {Motstndarens klocka}
translate W CCDlgConfigRelay {Konfigurera ICCF-observationer}
translate W CCDlgConfigRelayHelp {G till partisidan p http://www.iccf-webchess.com och visa partiet att observera.  Om du ser schackbrder kopiera webadressen frn din weblsare till listan nedanfr. Bara en webadress per rad!\nExempel: http://www.iccf-webchess.com/MakeAMove.aspx?id=266452}
translate W ExtHWConfigConnection {Konfigurera extern hrdvara}
translate W ExtHWPort {Port}
translate W ExtHWEngineCmd {Schackmotorkommando}
translate W ExtHWEngineParam {Schackmotorparameter}
translate W ExtHWShowButton {Visa knapp}
translate W ExtHWHardware {Hrdvara}
translate W ExtHWNovag {Novag Citrine}
translate W ExtHWInputEngine {Inmatningsschackmotor}
translate W ExtHWNoBoard {Inget brde}
translate W NovagReferee {Nedteckna bara dragen}
translate W IEConsole {Inmatningsschackmotorkonsol}
translate W IESending {Drag skickade fr}
translate W IESynchronise {Synkronisera}
translate W IERotate  {Rotera}
translate W IEUnableToStart {Kunde inste starta Inmatningsschackmotor:}
translate W DoneWithPosition {Klar med position}
translate W Board {Brde}
translate W showGameInfo {Visa partiinformation}
translate W autoResizeBoard {ndra storleken p brdet automatiskt}
translate W DockTop {Drag verst}
translate W DockBottom {Drag nederst}
translate W DockLeft {Drag till vnster}
translate W DockRight {Drag till hger}
translate W Undock {Avdocka}
translate W ChangeIcon {ndra ikon...}
# ====== TODO To be translated ======
translate W NewGameListWindow {New Game List Window}
# ====== TODO To be translated ======
translate W LoadatStartup {Load at startup}
# ====== TODO To be translated ======
translate W ShowHideDB {Show/Hide databases}
# ====== TODO To be translated ======
translate W ChangeFilter {Change filter}
# ====== TODO To be translated ======
translate W ChangeLayout {Load/Save/Change sorting criteria and column layout}
# ====== TODO To be translated ======
translate W ShowHideStatistic {Show/Hide statistics}
# ====== TODO To be translated ======
translate W BoardFilter {Show only games that matches the current board position}
# ====== TODO To be translated ======
translate W CopyGameTo {Copy Game to}
# ====== TODO To be translated ======
translate W FindBar {Find Bar}
# ====== TODO To be translated ======
translate W FindCurrentGame {Find current game}
# ====== TODO To be translated ======
translate W DeleteGame {Delete game}
# ====== TODO To be translated ======
translate W UndeleteGame {Undelete game}
# ====== TODO To be translated ======
translate W ResetSort {Reset sort}
# ====== TODO To be translated ======
translate W ConvertNullMove {Convert null moves to comments}
# ====== TODO To be translated ======
translate W SetupBoard {Setup Board}
# ====== TODO To be translated ======
translate W Rotate {Rotate}
# ====== TODO To be translated ======
translate W SwitchColors {Switch colors}
# ====== TODO To be translated ======
translate W FlipBoard {Flip Board}
# ====== TODO To be translated ======
translate W ImportPGN {Import PGN game}
# ====== TODO To be translated ======
translate W ImportingFiles {Importing PGN files in}
# ====== TODO To be translated ======
translate W ImportingFrom {Importing from}
# ====== TODO To be translated ======
translate W ImportingIn {Import games in}
# ====== TODO To be translated ======
translate W UseLastTag {Use last\ngame's tags}
# ====== TODO To be translated ======
translate W Random {Random}
# ====== TODO To be translated ======
translate W BackToMainline {Go back to mainline}
# ====== TODO To be translated ======
translate W LeaveVariant {Leave variant}
# ====== TODO To be translated ======
translate W Autoplay {Autoplay}
# ====== TODO To be translated ======
translate W ShowHideCoords {Show/Hide Coord.}
# ====== TODO To be translated ======
translate W ShowHideMaterial {Show/Hide Material}
# ====== TODO To be translated ======
translate W FullScreen {Full Screen}
# ====== TODO To be translated ======
translate W FilterStatistic {Filter Statistics}
# ====== TODO To be translated ======
translate W MakeCorrections {Make Corrections}
# ====== TODO To be translated ======
translate W Surnames {Surnames}
# ====== TODO To be translated ======
translate W Ambiguous {Ambiguous}
}

############################################################
#
# Swedish tips section:

set tips(W) {
  {
    Scid har ver 30 <a Index>hjlpsidor</a>, och i de flesta fnster kan du
    genom att trycka <b>F1</b> f hjlp om det fnster du fr tillfllet har
    aktivt.
  }
  {
    Vissa fnster (t ex partiinformation och <a Switcher>databasvljaren</a>) 
    har en meny fr hger musknapp. Prova att hgerklicka i varje fnster s
    ser du vilka som har det och vilka funktioner du kommer t den vgen.
  }
  {
    Du kan ange drag p mer n ett stt, s du kan vlja vilket som passar dig
    bst. Du kan anvnda musen (med eller utan dragfrslag) eller tangentbordet
    (med eller utan autokomplettering). Ls hjlpsidan fr 
    <a Moves>att ange drag</a> fr mer information.
  }
  {
    Om du har databaser du ofta ppnar s kan du lgga till ett 
    <a Bookmarks>bokmrke</a> fr varje databas. Du kommer d att kunna ppna 
    databaserna snabbare via bokmrkesmenyn.
  }
  {
    Du kan se alla drag i det aktuella partiet (inklusive variationer och kommentarer)
    genom att ppna <a PGN>PGN-fnstret</a>.
    Du navigerar igenom partiet i PGN-fnstret genom att klicka p valfritt drag med
    vnster musknapp. Genom att klicka p draget med mellan- eller hgermusknapp s
    fr du en frhandsvisning av just den stllningen.
  }
  {
    Du kan kopiera partier mellan databaserna i <a Switcher>databasvljaren</a> genom
    att dra-och-slppa dem mellan respektive databas.
  }
  {
    Scid kan ppna PGN filer, ven de som r komprimerade med Gzip (dvs har en .gz filndelse). 
    PGN filer ppnas med enbart lsrttigheter, s om du vill redigera en PGN fil i Scid 
    mste du kopiera filen till en Scid databas med hjlp av <a Switcher>databasvljaren</a>.
  }
  {
    Om du ofta anvnder <a Tree>Trdfnstret</a> med stora databaser, r det vrt att vlja
    <b>Fyll cache fil</b> frn Arkivmenyn i Trdfnstret. Detta innebr att trdstatistik fr 
    mnga av de vanligare stllningarna sparas, vilket ger en snabbare trdtkomst fr databasen
    ifrga.
  }
  {
    <a Tree>Trdfnstret</a> kan visa alla drag frn den aktuella stllningen. Men om ocks vill 
    se alla dragfljder som har lett till denna stllning kan du f fram det genom att skapa en
   <a OpReport>ppningsrapport</a>.
  }
  {
    Du kan vnster- eller hgerklicka i en kolumn i <a GameList>partilistan</a> fr att ndra 
    dess bredd.
  }
  {
    Med <a PInfo>spelarinformationen</a> aktuell (klicka p endera spelarens namn under brdet i 
    huvudfnstret fr att f fram den) r det enkelt att <a Searches Filter>filtrera</a> fram partier
    av en srskild spelares enskilda resultat. Klicka bara p valfritt vrde som har angivits med
    <red>rd text</red>.
  }
  {
    Nr du studerar ppningar kan det vara en pong att markera valen <b>Bnder</b> eller <b>Filer</b> i 
    <a Searches Board>Sk aktuell position</a>. Genom dessa val kan du hitta andra ppningar som ger
    liknande bondestrukturer.
  }
  {
    Du kan hgerklicka i partiinformationsdelen av huvudfnstret (under brdet) fr att f fram en 
    kontextmeny. Du kan t ex gra s att Scid dljer nsta drag i ett parti, vilket kan vara anvndbart 
    om du vill trna genom att "gissa" nsta drag.
  }
  {
    Om du ofta <a Maintenance>underhller</a> stora databaser kan du utfra flera underhllsuppgifter 
    vid samma tillflle via <a Maintenance Cleaner>databasverktyget</a>.
  }
  {
    Om du har en stor databas dr de flesta partierna har ett evenemangsdatum och du vill ha partierna i 
    datumordning br du vervga att <a Sorting>sortera</a> den p evenemangsdatum i frsta hand och 
    evenemang i andra hand, istllet fr datum och evenemang, d detta kommer att hlla turneringspartierna
    frn olika datum samman. (Under frutsttning att alla partier har samma evenemangsdatum naturligtvis).
    Alternativt kan du se till att flten evenemang, rond och datum r s enhetliga och korrekta som mjligt.
    (ms).
  }
  {
    Det kan vara en bra ide att <a Maintenance Spellcheck>stavningskontrollera</a> din databas innan du 
    <a Maintenance Twins>raderar dubbletter</a> d Scid har strre mjlighet att hitta dubbletterna och 
    markera dessa fr borttagning.
  }
  {
    <a Flags>Flaggor</a> r anvndbara fr att markera upp partier med karaktristika du vill ska p senare,
    ssom bondestllning, taktiska finesser, osv. Du kan ska p flaggor nr du sker p flt i partihuvudet.
  }
  {
    Om du gr igenom ett parti, och helt enkelt vill testa en ny variation utan att frndra partiet i sig, kan 
    du sl p Frskslget (Trial mode) genom att trycka <b>Ctrl+Mellanslag</b> eller frn verktygsraden. terg till
    ursprungspartiet nr du r klar.
  }
  {
    Om du vill hitta det mest betydelsefulla partiet (med hgst rankade spelare) i en viss position kan du
    ppna <a Tree>Trdfnstret</a> och i denna ppna listan med de bsta partierna. I trdfnstret kan du till
    och med begrnsa partierna till endast ett srskilt resultat.
  }
  {
    Ett bra stt att studera en ppning r att i en stor databas sl p trningslget i <a Tree>Trdfnstret</a>, 
    och sedan spela igenom databasen fr att se vilka varianter som frekommer oftast.
  }
  {
    Om du har tv databaser ppna, och vill ha ett varianttrd att studera medan du gr igenom ett parti
    i den andra databasen kan du <b>lsa</b> trdet i den databasen och sedan byta till den andra.
  }
  {
    <a Tmt>Turneringsskaren (tournament finder)</a> r inte bara anvndbar fr att lokalisera en srskild 
    turnering. Du kan ocks anvnda den fr att ska efter turneringar en specifik spelare nyligen deltagit 
    i, eller att blddra genom turneringar som genomfrts i ett visst land.
  }
  {
    Det finns ett antal vanliga stllningstyper definierade i <a Searches Material>Sk material/stllning</a>
    fnstret som du kan ha nytta av nr du studerar ppningar och mittspel.
  }
  {
    Nr du sker p <a Searches Material>material eller stllning</a> kan det ofta vara frdelaktigt att begrnsa
    skningen till sdana partier dr stllningen eller materialet frekommit i tminstone ngra drag. Du slipper
    du f med trffar dr situationen du sker uppkom helt tillflligt.
  }
  {
    Om du har en viktig databas du inte vill radera av misstag kan du vlja  <b>Enbart lsbar</b> frn <b>Arkiv</b>
    menyn efter att du har ppnat den. Alternativt kan du stta dess filrttigheter till enbart lsrttigheter.
  }
  {
    Om du anvnder XBoard eller WinBoard (eller ngot annat program som kan hantera FEN notation via urklippshanteraren)
    och vill kopiera den aktuella stllningen frn ditt program r det snabbaste sttet att gra det s hr:
    Vlj <b>Copy Position</b> frn <b>File</b> menyn i Xboard/Winboard, vlj sedan <b>Klistra in utgngsstllning</b>
    i Redigera menyn i Scid.
  }
  {
    I <a Searches Header>Sk i huvud</a>, r spelare-, evenemang-, plats-, och rondnamn oknsliga fr stora eller sm
    bokstver och ger trffar varhelst de finns i ett namn. Om du vill kan du ange att du istllet vill att skningen <b>ska</b>
    ta versaler/gemener i beaktande. Genom att anvnda jokertecken inom citationstecken (dr "?" = motsvarar obestmt
    enskilt tecken och "*" = noll eller flera tecken). Om du exempelvis anger "*BEL" (med citationstecken) i det platsfltet
    hittar du alla partier spelade i Belgien, men exkluderar de som spelats i Belgrad.
  }
  {
    Om du vill redigera ett drag i ett parti utan att frlora alla de drag som spelats efter detta kan du ppna
    <a Import>Importera ett parti i PGN-format</a> fnstret i Verktygsmenyn. Klicka dr p <b>Klistra in aktuellt parti</b> 
    , redigera partiet och avsluta med <b>Importera</b>.
  }
  {
    Om du har en ECO klassificeringsfil laddad, kan du n den mest exakt klassificerade stllningen fr det aktuella partiet
    genom att vlja <b>Identifiera ppning</b> i <b>Partier</b> menyn (kortkommando: Ctrl+Shift+D).
  }
  {
    Nr du vill se hur stor en fil r, eller vill se nr den senast redigerades innan du ppnar den kan du anvnda
    <a Finder>file finder</a> (Arkiv - Sk filer).
  }
  {
    En <a repetoire>repetoarfil</a> r ett utmrkt stt att hlla koll p dina favoritppningar, eller hitta partier dr
    dr de har spelats. Nr du vl har skapat en repetoarfil kan du genomska nya filer utifrn repetoarfilen, och titta 
    igenom alla partier med just dina ppningar.
  }
  {
    Genom att skapa en <a OpReport>ppningsrapport</a> har du en utmrkt mjlighet att lra dig en ny spelppning. Du kan f
    information om resultat, hur remiaktig den r, vilka vanliga positionella teman som dyker upp, och mycket mer.
  }
  {
    Du kan kommentera den aktuella stllningen med de vanligaste symbolerna (!, !?, +=, etc) utan att behva anvnda 
    <a Comment>kommentarseditorn<a>. Dr du exempelvis vill ange ett bra drag skriver du "!" och trycker sedan ENTER
    s lggs "!" symbolen till draget. Se ven hjlpsidan <a Moves>ange drag</a> fr mer detaljerad information.
  }
  {
    Om du blddrar igenom ppningarna i en databas i <a Tree>trdfnstret</a>, fr du en anvndbar verblick ver hur
    vl ppningen fungerar i sentida partier mellan hgrankade spelare om du ppnar statistikfnstret (kortkommando: Ctrl+I).
  }
  {
    Du ndrar enkelt huvudfnstrets brdstorlek genom att hlla nere <b>Ctrl</b> och <b>Shift</b> tangenterna, samtidigt
    som du trycker hger- eller vnster piltangent.
  }
  {
    Efter genomfrd <a Searches>skning</a>, r det enkelt att navigera genom urvalet genom att hlla nere <b>Ctrl</b> 
    tangenten samtidigt som du trycker upp- eller nerpiltangenterna fr att g till fregende eller nsta parti i 
    <a Searches Filter>urvalet</a>.
  }
{
  Du kan relativt enkelt rita pilar och frga rutor till dina kommentarer. ppna <b>Kommentarseditorn</b>, klicka p <b>Infoga symbol</b> och vlj nskad frg. Om du nu klicka p en frsta ruta, och drefter klickar p en andra s dras en pil i nskad frg frn den frsta till den andra rutan. Klickar du bara p en ruta, blir den frgad.
  }
}

##########
#
# ECO Opening name translations:

translateECO W {
  Accelerated {, Accelererad}
  {: Accelerated} Accelererad
  Accepted {, Antagen}
  {: Accepted} Antagen
  Advance Avancemang
  {as Black} {som Svart}
  Attack Angrepp
  Bishop Lpare
  Bishop's Lpar
  Classical Klassisk
  Closed Stngd
  {Closed System} {Stngt system}
  Counterattack Motangrepp
  Countergambit Motgambit
  Declined {, Avbjd}
  Defence Frsvar
  deferred frvgrad
  Deferred {, frvgrad}
  Early Tidig
  Exchange Avbyte
  Game Parti
  Improved frbttrad
  King's Kung
  Knight Springar
  Line Variant
  {Main Line} Huvudvariant
  Open ppen
  Opening ppning
  Queen's Dam
  Queenswap Damavbyte
  Symmetrical Symmetrisk
  Variation Variation
  Wing Flygel
  with med
  without utan

  Alekhine Aljechin
  Averbakh Averbach
  Botvinnik Botvinnik
  Chigorin Chigorin
  Polugaevsky Polugajevski
  Rauzer Rauzer
  Sveshnikov Sveschnikov

  Austrian sterrikisk
  Berlin Berlin
  Bremen Bremen
  Catalan Katalansk
  Czech Tjeckisk
  Dutch Hollndsk
  English Engelsk
  French Fransk
  Hungarian Ungersk
  Indian Indisk
  Italian Italiensk
  Latvian Lettisk
  Meran Meran
  Moscow Moskva
  Polish Polsk
  Prague Prag
  Russian Rysk
  Scandinavian Skandinavisk
  Scheveningen Scheveningen
  Scotch Skottsk
  Sicilian Siciliansk
  Slav Slavisk
  Spanish Spansk
  Swedish Svensk
  Swiss Schweizisk
  Vienna Wiener
  Yugoslav Jugoslavisk

  {Accelerated Fianchetto} {Accelererad Fianchetto}
  {Accelerated Pterodactyl} {Accelererad Pterodactyl}
  {Alekhine Defence} Aljechins Frsvar
  {Alekhine Variation} Aljechin-Variant
  {Alekhine: Smisch Attack} {Aljechin: Wiener-system (Smisch-Angrepp)}
  {Anderssen Opening} Anderssen-ppning
  {Anti-King's Indian} Anti-Kungsindisk
  {Austrian Attack} {sterrikiskt Angrepp}
  {Benko Gambit} Volga-Gambit
  {Benko Opening} Benk-ppning
  {Berlin Defence} {Berlinfrsvar}
  Chameleon Chamaleon
  Chelyabinsk Chelyabinsk
  {Classical Defence} {Klassiskt frsvar}
  {Spanish: Classical Defence} {Spanskt: Klassiskt (Cordel-) frsvar}
  {Classical Exchange} {Klassiskt Avbyte}
  {Classical Variation} {Klassisk Variant}
  {Closed Berlin} {Stngd Berlin}
  {Open Berlin} {ppen Berlin}
  {Bird's,} {Bird,}
  {Bird's Defence} Birds frsvar
  {Bird's Deferred} {Frvgrad Bird}
  {Bishop's Opening} Lparspel
  {Botvinnik System} Botvinnik-system
  {Central Variation} Centralvariant
  {Centre Attack} Centrumsangrepp
  {Centre Game} Mittgambit
  {Danish Gambit} {Nordisk Gambit}
  Dragon Drake
  {Dutch Variation} {Hollndsk Variant}
  {Early Exchange} {Tidigt Avbyte}
  {Early Queenswap} {Tidigt Dambyte}
  {English Attack} {Engelskt Angrepp}
  {English: King's} {Engelskt: Kungsbonde}
  {English Variation} {Engelsk Variant}
  {Englund Gambit} Englunds Gambit
  {Exchange Variation} Avbytesvariant
  {Fianchetto Variation} Fianchettovariant
  {Flohr Variation} Flohr-Variant
  {Four Knights} Fyrspringar
  {Four Knights Game} Fyrspringarspel
  {Four Pawns} Fyrbonde
  {Four Pawns Attack} Fyrbondeangrepp
  {French Variation} {Fransk Variant}
  {From Gambit} {From-Gambit}
  {Goring Gambit} {Gring-Gambit}
  {Grob Gambit} {Grobs Gambit}
  {Hungarian Defence} {Ungerskt frsvar}
  {Indian Variation} {Indisk Variant}
  {Italian Game} {Italienskt Parti}
  KGD {Avbjd Kungssgambit}
  {Classical KGD} {Klassisk avbjd Kungsgambit}
  {Keres Variation} Keres-Variant
  KGA {Antagen Kungsgambit}
  {KGA: Bishop's Gambit} Kungslpargambit
  {KGA: King's Knight Gambit} Kungsspringargambit
  {King's Gambit} Kungsgambit
  {King's Gambit Accepted} {Antagen Kungsgambit}
  {King's Gambit Accepted (KGA)} {Antagen Kungsgambit}
  {King's Indian} Kungsindisk
  KIA {Kungsindiskt Angrepp}
  {King's Knight Gambit} Kungsspringargambit
  {King's Pawn} Kungsbonde
  {Lasker Variation} {Lasker-Variant}
  {Latvian Gambit} {Lettisk Gambit}
  {Maroczy Bind} {Maroczy-bindning}
  {Marshall Variation} Marshall-Variant
  {Modern Attack} {Modernt Angrepp}
  {Modern Steinitz} {Modern Steinitz}
  {Modern Variation} {Modern Variant}
  {Moscow Variation} {Moskva-variant}
  Nimzo-Indian Nimzoindisk
  {Old Benoni} {Klassisk Benoni}
  {Old Indian} Gammalindisk
  {Old Indian Attack} {Gammalindisk Indisk attack}
  {Old Steinitz} Gammal Steinitz-ppning
  {Open Game} {ppet Parti}
  {Poisoned Pawn} {Frgiftad Bonde}
  {Polish Variation} {Polsk Variant}
  {Polugaevsky Variation} {Polugajevski-Variant}
  {Queen's Gambit} Damgambit
  {Queen's Gambit Accepted} {Antagen Damgambit}
  QGA {Antagen Damgambit}
  {Queen's Gambit Accepted (QGA)} {Antagen Damgambit}
  {Reversed QGA} {Omvnd antagen Damgambit}
  QGD {Avbjd Damgambit}
  {Queen's Gambit Declined (QGD)} {Avbjd Damgambit}
  {Reversed QGD} {Omvnd avbjd Damgambit}
  {Queen's Indian} Damindisk
  {Queen's Pawn} Dambonde
  {Queen's Pawn Game} Dambondespel
  {Reversed Slav} {Omvnd Slavisk}
  {Rubinstein Variation} Rubinstein-Variant
  {Russian Game} {Ryskt Parti}
  {Russian Game (Petroff Defence)} {Ryskt Parti}
  {Russian-Three Knights Game} {Ryskt trespringarspel}
  {Scandinavian (Centre Counter)} Skandinavisk
  Schliemann Jnisch
  {Schliemann (Jnisch)} {Jnisch-Gambit (Schliemann)}
  {Scotch Opening} {Skottsk ppning}
  {Sicilian Defence} {Sicilianskt frsvar}
  {Sicilian Variation} {Siciliansk Variant}
  {Slav Defence} {Slaviskt frsvar}
  Smith-Morra Morra
  {Smith-Morra Accepted} {Antagen Morra-Gambit}
  {Smith-Morra Gambit} Morra-Gambit
  {Spanish (Ruy Lopez)} {Spanskt Parti}
  {Start position} Utgngsstllning
  {Steinitz Deferred} Frvgrad Rubinstein
  {Swedish Variation} {Svensk Variant}
  {Swiss Variation} {Schweizisk Variant}
  {Tarrasch's Gambit} {Tarrasch-Gambit}
  {Three Knights} Trespringar
  {3 Knights} Trespringar
  {Three Knights Game} Trespringarspel
  {Three Pawns Attack} Trebondeangrepp
  {Two Knights} Tvspringar
  {Two Knights Defence} Tvspringar-frsvar
  {Two Knights Variation} Tvspringar-variant
  {Two Pawns} Tvbonde
  {Two Pawns Attack} Tvbondeangrepp
  {Wing Gambit} Flygel-Gambit
  {Yugoslav Attack} {Jugoslaviskt Angrepp}
}

############################################################
#
# Swedish help pages:

# Basic help pages completed, no links no other sections.

##########
# Contents
#
set helpTitle(W,Contents) "Innehllsfrteckning"
set helpText(W,Contents) {<h1>Hjlp med Scid: Innehllsfrteckning</h1>

<h3>Komma igng och allmnt om Scid</h3>
<p>Fljande texter och dess lnkar r under versttning. Detta pbrjades i Scid 3.4 beta 1 (2002 07 27). 
 /Martin S.</p>
Detta betyder att menyerna r versatta. Rubriktexterna br kunna vara versatta till Scid 3.4 men alla lnkar
frn rubriktexterna r frmodligen inte det. /Martin S.</p>

<ul>
<li><a Guide><b>Komma igng</b> med Scid</a> <red>(Ls detta frst)</red></li>
<li><a Hints><b>Tips</b> om hur du fr ut mer av Scid</a></li>
<li><a MainWindow><b>Huvudfnstret</b></a></li>
<li><a Menus><b>Menyerna</b></a> <red>(Uppdaterad!)</red></li>
<li><a Moves>Ange <b>drag</b></a> <red>(Uppdaterad!)</red></li>
<li><a Searches><b>Ska</b> i Scid</a></li>
<li><a Clipbase>Att anvnda <b>Clipbase (Urklippsdatabasen)</b></a></li>
<li><a Annotating><b>Kommentera partier</b></a> <red>(Ny!)</red></li>
</ul>

<h4>Andra Scid-fnster</h4>

<ul>
<li><a Analysis><b>Analysfnstret</a></li>
<li><a Book><b>Bokfnstret</b></a></li>
<li><a CalVar><b>Berkning av variationer-fnstret</b></a></li>
<li><a Comment><b>Kommentareditor</b> </a></li>
<li><a Crosstable><b>Korstabellfnster</a></li>
<li><a Switcher><b>Databasvxlaren</b> </a></li>
<li><a Email><b>Email-fnster</a></li>
<li><a Finder><b>Sk filer</b> </a></li>
<li><a GameList><b>Partilistan</b> </a></li>
<li><a Import><b>Importfnstret</a></li>
<li><a OpeningTrainer><b>ppningstrnarfnstret</b>  </a></li>
<li><a Reports><b>Rapporter</b></a> <red>(Uppdaterad!)</red></li>
<li><a PGN><b>PGN-fnster</a></li>
<li><a PTracker><b>Pjsspraren</b></a></li>
<li><a PList><b>Spelarlistan</b></a></li>
<li><a PInfo><b>Spelarinfo</b> </a></li>
<li><a Repertoire><b>Repetoar-Editor</a></li>
<li><a TacticalGame><b>Taktiskt partifnstret</b> </a></li>
<li><a Tmt><b>Sk turneringar</a></li>
<li><a Tree><b>Trdfnstret</a></li>
<li><a Graphs><b>Graffnster</a></li>
<li><a TB>Slutspelstabeller</a><red>(Uppdaterad!)</red></li>
</ul>

<h4>Andra funktioner och information</h4>
<ul>
<li><a Bookmarks><b>Bokmrken</b></a></li>
<li><a Cmdline>Kommandorad-alternativ</a></li>
<li><a Compact><b>Komprimera databas</a></li>
<li><a Correspondence>Korrespondensschack</a></li>
<li><a Maintenance><b>Underhll databas</a></li>
<li><a ECO><b>ECO</a></li>
<li><a EPD><b>EPD</a></li>
<li><a Export><b>Exportera partier</a> <red>(Uppdaterad!)</red></li>
<li><a Flags>Parti-markeringarna</a></li>
<li><a LaTeX>Scid och LaTeX</a></li>
<li><a Options><b>Alternativ</a><red>(Uppdaterad!)</red></li>
<li><a Sorting><b>Sortera databas</a></li>
<li><a Pgnscid><b>Pgnscid</a></li>
<li><a NAGs>NAG-vrden</a></li>
<li><a Formats>Filformat</a></li>
<li><a Author>Kontaktinformation</a></li>
</ul>

<p><footer>(Uppdaterad: Scid 3.6.1, December 2004)</footer></p>
}

###############
### Topic Index

set helpTitle(W,Index) "Hjlp-index"
set helpText(W,Index) {<h1>Scid: Hjlp-index</h1>

<h3>A</h3>
<ul>
<li><a Options>Alternativ</a></li>
<li><a Analysis>Analysfnstret</a></li>
<li><a Moves>Ange drag</a></li>
</ul>

<h3>B</h3>
<ul>
<li><a CalVar>Berkning av variationer-fnstret</a></li>
<li><a GameList Browsing>Blddra partilistor</a></li>
<li><a Book>Bokfnstret</a></li>
<li><a Bookmarks>Bokmrken</a></li>
<li><a Tree Best>Bsta partier</a></li>
</ul>

<h3>D</h3>
<ul>
<li><a Sorting>Databassortering</a></li>
<li><a Maintenance>Databasunderhll</a></li>
<li><a Switcher>Databasvxlaren</a></li>
<li><a Translator>Den svenska versttningen</a></li>
</ul>

<h3>E</h3>
<ul>
<li><a ECO>ECO</a></li>
<li><a ECO Browser>ECO-blddrar</a>-fnster</li>
<li><a ECO Codes>ECO kodsystem</a></li>
<li><a Email>Email-fnster</a></li>
<li><a EPD>EPD-filer</a></li>
<li><a Export>Exportfilter</a></li>
<li><a Export>Exportera partier som text</a></li>
</ul>

<h3>F</h3>
<ul>
<li><a Formats>Filformat</a></li>
</ul>

<h3>G</h3>
<ul>
<li><a Graphs Filter>Graffilter</a></li>
<li><a Graphs>Graffnster</a></li>
</ul>

<h3>H</h3>
<ul>
<li><a MainWindow>Huvudfnstret</a></li>
</ul>

<h3>I</h3>
<ul>
<li><a Import>Importfnstret</a></li>
<li><a Contents>Innehllsfrteckning</a></li>
</ul>

<h3>K</h3>
<ul>
<li><a Guide>Komma igng med Scid</a></li>
<li><a Cmdline>Kommandorad-alternativ</a></li>
<li><a Comment>Kommentareditor</a></li>
<li><a Annotating Null>Kommentera Nulldrag</a></li>
<li><a Annotating>Kommentera partier</a></li>
<li><a Compact>Komprimera databas</a></li>
<li><a Correspondence>Korrespondensschack</a></li>
<li><a Crosstable>Korstabellfnster</a></li>
<li><a Author>Kontaktinformation</a></li>
</ul>

<h3>L</h3>
<ul>
<li><a LaTeX>LaTeX</a> utdataformat</li>
</ul>

<h3>M</h3>
<ul>
<li><a Menus>Menyerna</a></li>
<li><a Menus File>Meny Arkiv</a></li>
<li><a Menus Edit>Meny Redigera</a></li>
<li><a Menus Game>Meny Partier</a></li>
<li><a Menus Search>Meny Sk</a></li>
<li><a Menus Windows>Meny Fnster</a></li>
<li><a Menus Tools>Meny Verktyg</a></li>
<li><a Menus Options>Meny Alternativ</a></li>
<li><a Menus Help>Meny Hjlp</a></li>
</ul>

<h3>N</h3>
<ul>
<li><a NAGs>NAG-vrden</a></li>
</ul>

<h3>P</h3>
<ul>
<li><a GameList>Partilistan</a></li>
<li><a Flags>Partimarkeringarna</a></li>
<li><a PGN>PGN-fnster</a></li>
<li><a Pgnscid>Pgnscid</a></li>
<li><a PTracker>Pjsspraren</a></li>
</ul>

<h3>R</h3>
<ul>
<li><a Reports Opening>Rapporter</a></li>
<li><a Graphs Rating>Ratinggraf</a></li>
<li><a Repertoire>Repetoar-Editor</a></li>
</ul>

<h3>S</h3>
<ul>
<li><a Analysis List>Schackmotorlista</a></li>
<li><a LaTeX>Scid och LaTeX</a></li>
<li><a Hints>Scidtips</a></li>
<li><a MainWindow Autoplay>Sjlvspelsmod</a></li>
<li><a TB>Slutspelstabeller</a></li>
<li><a Guide>Snabbguide till att anvnda Scid</a></li>
<li><a Sorting>Sortera databas</a></li>
<li><a PInfo>Spelarinfo</a></li>
<li><a Reports Player>Spelarrapport</a></li>
<li><a Maintenance Spellcheck>Stavningskontrollera namn</a></li>
<li><a Finder>Sk filer</a></li>
<li><a Searches Filter>Skfilter</a></li>
<li><a Searches Header>Sk partidata</a></li>
<li><a PList>Sk spelare</a></li>
<li><a Searches Board>Sk stllning</a></li>
<li><a Searches>Ska i Scid</a></li>
<li><a Searches Material>Sk material</a></li>
<li><a Tmt>Sk turneringar</a></li>
</ul>

<h3>T</h3>
<ul>
<li><a TacticalGame>Taktiskt partifnstret</a></li>
<li><a Moves Trial>Testa variant mod</a></li>
<li><a Hints>Tips</a></li>
<li><a Tree>Trdfnstret</a></li>
<li><a Options Fonts>Typsnitt</a></li>
</ul>

<h3>U</h3>
<ul>
<li><a Maintenance>Underhll databas</a></li>
<li><a Maintenance Cleaner>Underhll: Databasrensaren</a></li>
<li><a Maintenance Editing>Underhll: ndra spelarnamn</a></li>
<li><a Maintenance Twins>Underhll: Ta bort dubbletter</a></li>
<li><a Maintenance Spellcheck>Underhll: Stavningskontrollera spelarnamn</a></li>
<li><a Clipbase>Urklippsdatabasen</a></li>
</ul>

<h3>V</h3>
<ul>
<li><a Annotating Vars>Varianter</a></li>
</ul>

<h3></h3>
<ul>
<li><a ECO>ppningsklassificering (ECO)</a></li>
<li><a Repertoire>ppningsrepetoar</a></li>
<li><a Reports Opening>ppningsrapport</a></li>
<li><a OpeningTrainer>ppningstrnarfnstret</a></li>
</ul>

<p><footer>(Uppdaterad: Scid 3.5, February 2003)</footer></p>
}

####################
### Quick Guide help:

set helpTitle(W,Guide) "Komma igng med Scid"
set helpText(W,Guide) {<h1>Komma igng med Scid</h1>
<p>
Scid r en schackdatabashanterare som du kan anvnda till att blddra och <a Searches>ska</a> (enligt kriterier du stller upp) igenom 
databaser med schackpartier. Du kan ocks redigera de partier du vill.
</p>
<p>
Scid anvnder sitt eget <a Formats>databasformat</a> baserat p tre filer. Det r mycket kompakt och snabbt, men kan konvertera svl 
till som frn PGN (Portable Game Notation) standarden om man s nskar. Scids <a PGN>PGN-fnster</a> visar texten till det aktuella
partiet i PGN-format.
</p>
<p>
Du kan anvnda Scid till att lgga till och ta bort partier i en databas genom att anvnda svl mus som tangentbordet fr att skriva in
drag. Se vidare <a Moves>att skriva in drag</a> fr en noggrannare beskrivning.
</p>
<p>
Du kan ocks anvnda Scid fr att hantera <a PGN>PGN</a> filer genom att klistra in PGN-text i Scids <a Import>Importfnster</a> 
eller genom att ppna en PGN-fil i Scid. PGN-filer kan dock inte redigeras av Scid (de ppnas skrivskyddade). Eftersom PGN-filer
anvnder mer minne och laddas lngsammare rekommenderas du att konvertera stora PGN-filer till en Scid databas med verktyget
<a Pgnscid>Pgnscid</a>.
</p>
<p>
Scids <a MainWindow>huvudfnster</a> (det med schackbrdet) visar det aktuella partiet och databasen i detalj. Du kan nr som helst ppna 
upp till fyra databaser (fem om du rknar med Urklippsdatabasen <a Clipbase>Clipbase</a>). Var och ett av dessa kommer att ha sitt eget aktuella
parti. (Partier med ID-numret 0 visar att detta r ett parti som nnu inte ingr i den aktuella databasen). Du blddrar mellan de ppnade databaserna
via <a Menus File>Filmenyn</a>.
</p>
<p>
Ls grna vriga hjlpsidor i <a Index>Innehllsfrteckningen</a> fr mer information.
</p>
<p>
Ls <a Author>kontaktinformationssidan</a> om du vill komma i kontakt med skaparen av Scid. Fr frgor om den svenska versttningen ska du
<b>inte</b> kontakta upphovsmannen utan istllet <a Translator>versttaren</a>.
</p>

<p><footer>(Uppdaterad: Scid 3.1, December 2001)</footer></p>
}


set helpTitle(W,Author) "Kontaktinformation"
set helpText(W,Author) {<h1>Kontaktinformation</h1>
<p>
Scids webbsajt finns p: <br>
<b><url http://scid.sourceforge.net/>http://scid.sourceforge.net/</url></b>
</p>
<p>
P hemsidan kan du hmta den senaste versionen av Scid och andra extrafiler som kan bli tillgngliga.
</p>
<p>Den mest uppdaterade hjlpen kommer alltid att finnas tillgnglig online hos:
<b><url http://scid.sourceforge.net/tutorial/>http://scid.sourceforge.net/tutorial/</url></b>
Typiskt kommer denna att vara mer uppdaterad n den hjlp som distribueras med Scid, eller dessa hjlp-
sidor i Scid.
</p>

<p>Den svenska versttningen av Scid har gjorts av Martin Skjldebrand. Synpunkter p versttningen ska <b>inte</b>
skickas till Shane. Dremot fr du grna skicka kommentarer, frgor och frslag till rttningar till versttaren p adressen:<br>
<b>martin@skjoldebrand.org</b>
</p>
}

####################
### Hints page:
set helpTitle(W,Hints) "Scid-tips"
set helpText(W,Hints) {<h1>Scid-tips</h1>
<p>
Denna sida innehller anvndbara tips i form av frgor och svar. Genom att lsa igenom denna sida, kan du senare komma att
anvnda Scid bttre. Om du nyligen brjat anvnda Scid, s ls till en brjan <a Guide>Kom igng</a>.
Det mesta av informationen p denna sida finns refererad mer utfrligt p andra sidor i hjlpen. Du finner dem i <a Index>Innehllsfrteckningen</a>.
Om har ngot du tips du tycker passar bra fr denna sida, s skicka den till <a Author>upphovsmannen</a>.
</p>

<h4>Kan Scid ladda en databas nr den startas?</h4>
<p>
Ja, du kan ange databaser, PGN-filer eller <a EPD>EPD-filer</a>
p kommandoraden som t ex;
<ul>
<li> <b>scid  mybase  games.pgn.gz</b> </li>
</ul>
som laddar Scid-databasen <b>mybase</b> och den Gzip-komprimerade PGN-filen <b>games.pgn.gz</b>.
</p>

<h4>Finns det enklare stt att ndra storleken p brdet n via Alternativmenyn?</h4>
<p>
Ja, du kan anvnda kortkommandorna <b>Ctrl+Shift+VnsterPil</b> och <b>Ctrl+Shift+HgerPil</b> fr att frminska eller 
frstora brdets storlek.
</p>

<h4>Jag brukar trna genom att spela igenom partier, s jag vill inte att Scid visar nsta drag i partiinformationen
nedanfr brdet. Kan jag dlja detta p ngot stt?</h4>
<p>
Du kan dlja nsta drag genom att hgerklicka partiinformationen och vlja  <b>Dlj nsta drag</b> i menyn som ppnas.
</p>

<h4>Var finner jag ECO-koden fr ppningen p brdet?</h4>
<p>
ECO-koden visas p sista raden i partiinformationen nedanfr brdet i  <a MainWindow>huvudfnstret</a>,
om du har laddat ECO-klassificeringsfilen (<b>scid.eco</b>). <br>
Hjlpsidan fr <a ECO>ECO-koder</a> frklarar hur man laddar ECO-klassificeringsfilen och stller in programmet s att
den laddas varje gng man startar Scid.
</p>

<h4>Jag hller p och matar in ett parti och befinner mig nu vid drag 30. Nu ser jag att drag 10 blev fel. Hur kan jag ndra
detta utan att gra om alltihop?</h4>
<p>
Du kan anvnda <a Import>Importfnstret</a>; se vidare <a Moves Mistakes>mata in drag</a> fr mer information.
</p>

<h4>Hur kopierar jag partier frn en databas till en annan?</h4>
<p>
Anvnd <a Switcher>Databasvxlaren</a>. Drag frn klldatabasen till mldatabasen s kopierar du allt i klldatabasen till
mldatabasen. Genom att anvnda <a Searches Filter>Filter</a> kan du begrnsa det du kopierar frn den ena databasen till den andra.
</p>

<h4>Varje gng jag anger ett drag som redan finns fr jag frgan "Erstt drag?". Hur undviker jag detta?</h4>
<p>
Du kan antingen stnga av <b>Frga fre erstt drag</b> valmjligheten i menyn <menu>Altervativ: Drag</menu</menu>; eller
tnka p att gra ndringarna genom att ta tillbaka dragen genom att hgerklicka med musen. Det senare alternativet raderar dragen helt ur
partiet.
</p>

<h4>Hur ndrar kolumnbredden i partilistan?</h4>
<p>
Hger- eller vnsterklicka p kolumntiteln fr den kolumn du vill ndra.
</p>

<h4>Hur anvnder jag trdfnstret fr ett filtrerade partier - till skillnad mot att anvnda den fr hela databasen?</h4>
<p>
Anvnd <a Clipbase>Urklippsdatabasen (Clipbase)</a>. Filtera databasen att visa endast de partier du vill anvnda i trdet, 
kopiera sedan partierna till Urklippsdatabasen (Clipbase) via <a Switcher>Databasvxlaren</a>. ppna drefter trdfnstret
med den senare databasen som aktiv.
</p>

<h4>Trdet r lngsamt nr jag jobbar med stora databaser. Gr det att snabba upp den?</h4>
<p>
Spara trdcachen ofta s sparar du resultaten fr framtida anvndning. Se vidare cache-sektionen i hjlpen fr 
<a Tree>trdet</a> fr mer detaljerad information.
</p>

<h4>Kan jag redigera PGN-texten fr ett parti direkt?</h4>
<p>
Du kan inte anvnda <a PGN>PGN-</a>fnstret till att redigera det aktuella partiet, dremot kan du anvnda 
<a Import>Importfnstret</a>. ppna fnstret (kortkommando: <b>Ctrl+Shift+I</b>) och klicka p klistra in aktuellt parti
<b>Paste current game</b>, redigera partiet och klicka sedan p <b>Importera</b>.
</p>

<h4>I min databas finns mnga spelarnamn som r felstavade. Hur rttar jag allt detta?</h4>
<p>
Du kan rtta enstaka namn, eller gra en stavningskontroll fr hela databasen via menyvalen i <menu>Arkiv: Databasverktyg</menu>.
Se vidare hjlpen fr <a Maintenance Editing>Databasunderhll</a>.
</p>

<h4>Jag har tv databaser ppna: den ena innehller mina egna partier, den andra r mnga stormstarpartier.
Hur jmfr jag ett av mina egna partier mot partierna i databasen med stormstarpartier?</h4>
<p>
ppna <a Tree>Trdfnstret</a> i databasen med stormstarpartier och vlj <term>Ls</term> fr att lsa trdet i den databasen. 
Nr du sedan byter till den andra databasen kommer trdet att fortstta visa informationen frn databasen med stormstarpartier.
</p>

<p><footer>(Uppdaterad: Scid 2.6,  augusti 2001)</footer></p>
}


#################
# Authors, translators
#

set helpTitle(W,Translator) "Den svenska versttningen"
set helpText(W,Translator) {<h1>Den svenska versttningen</h1>
<p>
Scids webbsajt finns p: <br>
<b><url http://scid.sourceforge.net/>http://scid.sourceforge.net/</url></b>. Dr kan du hmta den senaste versionen av Scid och 
de andra filerna till programmet som du kan ha behov av. Dr finns ocks den senaste versionen av den svenska sprkfilen.
</p>
<p>Den svenska versttningen av Scid har gjorts av Martin Skjldebrand. Skicka grna kommentarer, frgor och frslag till rttningar
till versttaren p adressen:<br>
<b>martin@skjoldebrand.org</b>
</p>
}

####################
### Main window help:

set helpTitle(W,MainWindow) "Huvudfnstret"
set helpText(W,MainWindow) {<h1>Scid: huvudfnstret</h1>
<p>
P brdet i huvudfnstret visas den aktuella stllningen i det aktiva partiet. Du fr ocks information om partiet och den
aktiva databasen. Fr ytterligare information om <a Menus>Menyerna</a> och olika stt att <a Moves>Ange drag</a> hnvisas till
andra hjlpsidor.
</p>

<h3>Att navigera i partier</h3>
<p>
Navigationsknapparna vid brdet har fljande funktioner (frn vnster till hger):
</p>
<ul>
<li> <button tb_start> G till utgngsstllningen. </li>
<li> <button tb_prev> G tillbaka ett drag. </li>
<li> <button tb_next> G framt ett drag. </li>
<li> <button tb_end> G till slutstllningen. </li>
<li> <button tb_invar> G in i varianten. </li>
<li> <button tb_outvar> G ur varianten. </li>
<li> <button tb_addvar> Lgg till ny variant. </li>
<li> <button tb_play> Start/stopp fr autospelslge (se nedan). </li>
<li> <button tb_trial> Start/stopp fr <a Moves Trial>Frskslge</a>. </li>
<li> <button tb_flip> Rotera brdet 180 grader. </li>
<li> <button tb_coords> Visa/dlj koordinater. </li>
</ul>

<h4><name Autoplay>Autospelslge</name></h4>
<p>
I autospelslge gr Scid automatiskt bda spelarnas drag i det aktuella partiet. Frdrjningen mellan varje drag kan anges i
menyn <menu>Alternativ: Drag</menu> och sparas nr du sparar ndringarna av instllningsmjligheterna.
</p>
<p>
Kortkommandot <b>Ctrl+Z</b> startar eller avbryter autospelslget. Du kan ocks g ur autospelslge genom att trycka
 <b>Esc</b>-tangenten.
</p>
<p>
Om du startar autospelslge nr <a Analysis>Analysfnstret</a> r ppet <term>kommenteras</term> partiet: stllningsbedmningen 
och analysen av varje stllning lggs till som en ny variant vid varje drag.
Se hjlpen fr <a Analysis>Analysfnstret</a> fr mer information.
</p>

<h3>Partiinformation</h3>
<p>
Nedanfr brdet visas information om det aktuella partiet. Denna del av huvudskrmen kallas <term>partiinformationsomrdet</term>.
P de tre frsta raderna ges grundinformation ssom spelarnas namn, resultat, datum och spelplats. Den fjrde raden aktuell
stllning och nsta drag.
</p>
<p>
Rad fem visar <a ECO>ECO</a> (Encyclopedia of Chess
Openings) koden fr den aktuella stllningen, om stllningen ingr i den ECO-fil som anvnds.
</p>
<p>
Nr man hgerklickar p partiinformationsomrdet visas en meny med instllningsmjligheter som r relevanta fr just denna del av
programmet. Du kan t ex vlja att dlja nsta drag (anvndbart om du trnar genom att "gissa" nsta drag i  partiet) eller ta bort
/terta det aktuella partiet. Kortkommandot fr denna funktion r funktionsknappen F9.
</p>

<h4>Slutspelsdatabaser</h4>
<p>
Partiinformationsomrdet visar resultaten frn slutspelsdatabaserna om du har ngra installerade och om stllningen terfinns 
i dessa. Se hjlpsidan fr <a TB>Slutspelsdatabaser</a> fr mer information.
</p>

<h3>Statusraden</h3>
<p>
Statusraden (lngst ner i huvudfnstret) visar information om den aktuella databasen.
Det frsta fltet visar partiets status: <b>XX</b> betyder att det har frndrats men nnu inte sparats, medan <b>--</b> 
betyder att partiet inte har ndrats, <b>%%</b>, slutligen, betyder att databasen r skrivskyddad (det gr inte att ndra i partiet.).
</p>
<p>
Om du vill, kan du ppna databasen skrivskyddad. ndra rttigheterna till scid-filerna (eller enbart indexfilen) genom att i UNIX(-lika)
system ge kommandot:
<b>chmod a-w myfile.si3</b>
vid kommandoraden.I MS-DOS eller Windows ndrar du filattributet Arkiv med Attrib filnamn +A (i MS-DOS) eller Filhanteraren/Utforskaren etc. (i Windows).)
</p>
<p>
Statusraden visar ocks hur mnga partiet som ingr i det aktiva <a Searches Filter>Filtret</a>.
</p>

<p><footer>(Uppdaterad: 3.6.11-beta Januari 2007)</footer></p>
}

####################
### Menus help screen:

set helpTitle(W,Menus) "Menyerna"
set helpText(W,Menus) {<h1>Menyerna</h1>

<h3><name File>Arkiv</name></h3>
<ul>
<li><menu>Ny</menu>: Skapar en ny, tom, Scid databas.</li>
<li><menu>ppna</menu>: ppnar en befintlig Scid-databas.</li>
<li><menu>Stng</menu>: Stnger den aktiva Scid-databasen.</li>
<li><menu>Sk filer</menu>: ppnar <a Finder>Skdialogen</a> fr filer.</li>
<li><menu>Bokmrken</menu>: Hanterar <a Bookmarks>bokmrken</a>.</li>
<li><menu>Nytt bokmrke</menu>: Markerar den aktiva stllningen i partiet som ett bokmrke.</li>
	<li><menu>Spara bokmrke</menu>: Sparar bokmrket fr den aktiva stllningen i partiet.</li>
	<li><menu>Redigera bokmrken</menu>: Redigerar dina bokmrken.</li>
	<li><menu>Visa bokmrken som lista</menu>: Visar bokmrkena som lista, inte som undermenyer.</li>
	<li><menu>Visa bokmrken i undermenyer</menu>: Visar bokmrkena som undermenyer, inte som en lista.</li>
	</ul>
<li><menu>Databasverktyg</menu>: <a Maintenance>Underhll</a> databasen.</li>
    </li>
	<ul>
	<li><menu>Verktygsfnster</menu>: ppnar/ stnger verktygsfnstret.</li>
	<li><menu>Klassificera partier enligt ECO</menu>: Klassificerar alla partier enligt ECO-systemet.</li>
	<li><menu>Ta bort dubbletter</menu>: Tar bort <a Maintenance Twins>Dubblettpartier</a> i databasen.</li>
	<li><menu>Namn</menu>: Erstter alle frekomster av en spelar-,
      resultat-, ort- eller rundeinmatning.</li>
      </ul>
      <li><menu>Skrivskyddad</menu>: Avlgsnar temporrt redigeringsmjligheterna till databasen.</li>
<li><menu>Byt databas</menu>: Byter till en annan ppnad databas.</li>
	<ul>
		<li><menu>Base 1/2/3/4/5</menu>: Hr byter du mellan de olika databaserna i databasvxlarna, inklusive <a Clipbase>Urklippsdatabasen</a>.</li>
	</ul>
	<ul>
	<li><menu>Komprimera databasen</menu>: Komprimerar databasen, avlgsna borttagna partier och oanvnda namn.</li>
	<li><menu>Sortera databasen</menu>: Sorterar partierna i den aktiva databasen.</li>
  	<li><menu>Sk dubbletter"</menu>: ppnar/ stnger dubblettfnstret fr att ska dubblettpartier.</li>
	<li><menu>Stavningskontroll</menu>: Namnredigerar och stavningskontrollerar.</li>
		<ul>
		<li><menu>Redigera namn</menu>: Redigerar spelarnamn utifrn rttstavningsfilen.</li>
		<li><menu>Stavningskontrollera namn</menu>: Stavningskontrollerar namn utifrn rttstavningsfilen.</li>
		<li><menu>Stavningskontrollera evenemang</menu>: Stavningskontrollerar evenemang utifrn rttstavningsfilen.</li>
		<li><menu>Stavningskontrollera platser</menu>: Stavningskontrollerar platser utifrn rttstavningsfilen.</li>
		<li><menu>Stavningskontrollera ronder</menu>: Stavningskontrollerar ronder utifrn rttstavningsfilen.</li>
  		</ul>
	</ul>	
<li><menu>Avsluta</menu>: Avslutar Scid. </li>
</ul>

<h3>Redigera</h3>
<ul>
<li><menu>Lgg till variant</menu>: Skapar en variant vid denna stllning. Antingen fr nsta drag, eller fr fregende drag om det r det frsta draget.</li>
<li><menu>Ta bort variant</menu>: Visar en undermeny med de borttagbara varianterna.</li>
<li><menu>Skapa huvudvariant</menu>: Upphjer en av varianterna till huvudvariant.</li>
<li><menu>Skapa nytt textdrag</menu>: Gr en av varianterna till nytt partidrag.</li>
<li><menu>Testa en id</menu>: Slr p <a Moves Trial>Testlge</a> fr att tillflligt testa en id. Frndrar inte partiet.</li>
<li><menu>Ta bort</menu>: Avlgsnar kommentarer eller varianter ur partiet.</li>
<br>
<li><menu>Tm Clipbase</menu>: Tmmer Urklippsdatabasen <a Clipbase>Clipbase</a> p partier.</li>
<li><menu>Kopiera partiet till Clipbase</menu>: Kopierar det aktuella partiet till Urklippsdatabasen <a Clipbase>Clipbase</a>.</li>
<li><menu>Klistra in det senaste Clipbasepartiet</menu>: Klistrar in det aktiva partiet i <a Clipbase>Clipbase</a> i den aktiva databasen och gr det aktivt.</li>
<br>
<li><menu>Skapa stllning</menu>: Skapar en utgngsstllning fr aktuellt parti.</li>
<li><menu>Kopiera stllning</menu>: Kopierar den aktuella stllningen i FEN-kod till Urklippsdatabasen.</li>
<li><menu>Klistra in utgngsstllning</menu>: Klistrar in stllningen frn aktuellt parti i den temporra databasen.</li>
</ul>

<h3>Partier</h3>
<ul>
<li><menu>Nytt parti</menu>: terstller brdet infr ett nytt parti (detta tar bort alla ndringar).</li>
<li><menu>Ladda frsta/fregende/nsta/sista partiet</menu>: Dessa laddar respektive parti i <a Searches Filter>Skfiltret</a>.</li>
<li><menu>Ladda om partiet</menu>: Laddar om aktuellt parti och tar bort alla gjorda ndringar..</li>
<li><menu>Ladda parti slumpmssigt</menu>:  Laddar ett av datorn slumpmssigt valt parti.</li> 
<li><menu>Ladda parti nummer...</menu>: Laddar ett parti genom att ange dess nummer.</li>
<br>
<li><menu>Spara: Erstt parti...</menu>: Sparar partiet och erstter tidigare version.</li>
<li><menu>Spara: Nytt parti...</menu>: Sparar det aktuella partiet och lgger till det till databasen.</li>
<br>
<li><menu>Identifiera ppningen</menu>: Gr till den mest detaljerade stllningen i ECO-boken.</li>
<li><menu>G till drag nummer...</menu>: Gr till ett specifikt drag i partiet.</li>
<li><menu>Hitta nyhet...</menu>: Hittar det frsta draget i partiet som inte spelats tidigare.</li>
</ul>

<h3>Sk</h3>
<ul>
<li><menu>terstll skfilter</menu>: terstller <a Searches Filter>Skfiltret</a> s att alla partiet ingr i urvalet.</li>
<li><menu>Omvnt filter</menu>: Tar med de partier som utesluts av filtret.</li>
<br>
<li><menu>Aktuell stllning...</menu>: Sker partier med <a Searches Board>Den aktuella stllningen</a> p brdet.</li>
<li><menu>I huvud...</menu>: Anvnder <a Searches Header>Fast information</a> (spelare, evenemang, plats, mm).</li>
<li><menu>Material/Stllning...</menu>: Sker baserad p <a Searches Material>Material</a> eller <a Searches Pattern>Stllning</a>.</li>
<br>
<li><menu>Anvnd skfil...</menu>: Anvnder en fil med <a Searches Settings>lagrade</a>.</li>
</ul>

<h3>Fnster</h3>
<ul>
<li><menu>Kommentarseditor</menu>: ppnar/ stnger <a Comment>Kommentarseditorn</a>.</li>
<li><menu>Partilista</menu>: ppnar/ stnger <a GameList>Partilistan</a>.</li>
<li><menu>PGN fnster</menu>: ppnar/ stnger <a PGN>PGN-fnstret</a>.</li>
<li><menu>Spelarfrteckning</menu>: ppnar/ stnger en frteckning ver spelarna i den aktiva databasen.</li> 
<li><menu>Turneringar</menu>: Listar <a Tmt>Turneringar</a>.</li>
<br>
<li><menu>Databasvxlaren</menu>: ppnar/ stnger <a Switcher>Databasvxlaren</a>. Databasvxlaren underlttar byte mellan olika databaser
och kopiering av partier frn den ena databasen till den andra.</li>
<li><menu>Databasverktyg</menu>: ppnar/ stnger <a Maintenance>Verktygsfnstret</a>.</li>
<br>
<li><menu>ECO fnster</menu>: ppnar/ stnger <a ECO browser>ECO blddraren</a>.</li>
<li><menu>Repetoareditor</menu>: ppnar/ stnger verktyget fr <a repetoire>Spelppningshantering</a>.</li>
<li><menu>Statistikfnster</menu>: ppnar/ stnger <term>Statistikfnstret</term>. Hr hittar du en statistisk sammanfattning av partierna i  
 <a Searches Filter>Skfiltret</a>.</li>
<li><menu>Trdfnster</menu>: ppnar/ stnger <a Tree>Varianttrdet</a>.</li>
<li><menu>Slutspelsdatabas</menu>: ppnar/ stnger slutspelsdatabasfnstret som ger dig viss information om <a TB>Slutspelsdatabaserna</a>.</li>
</ul>

<h3>Verktyg</h3>
<ul>
<li><menu>Analysmotor...</menu>: Startar/ stoppar en analysmotor, t ex Crafty, som kontinuerligt bedmmer den aktuella stllningen
p brdet i ett <a Analysis>Analysfnster</a>.</li>
<li><menu>Analysmotor 2...</menu>: Startar/ stoppar en andra analysmotor, t ex Crafty.</li>
<li><menu>Resultattabell</menu>: Skapar en <a Crosstable>Resultattabell</a> fr den aktuella turneringen/matchen som det aktuella partiet ingr i</li>
<li><menu>Eposthanteraren</menu>: ppnar/ stnger <a Email>Eposthanteraren</a> fr hantering av korrespondensschack.</li>
<br>
<li><menu>ppningsrapport</menu>: Skapar en <a OpReport>ppningsrapport</a> utifrn den aktuella stllningen.</li>
<li><menu>Sk material</menu>: ppnar dialog fr att <a PTracker>Ska efter en viss materiell balans</a>.</li>
<br>
<li><menu>Spelarinformation</menu>: Visar/ uppdaterar <a PInfo>Spelarinformation</a> fr den ene av tv spelare i det aktuella partiet.</li>
<li><menu>Ratingdiagram</menu>: Skapar ett <a Graphs Rating>Ratingdiagram</a> fr spelarna i partiet.</li>
<li><menu>Resultatdiagram</menu>: Visar <a Graphs Score>Resultatdiagrammet</a>.</li>
<br>
<li><menu>Exportera aktuellt parti ...</menu>: Sparar aktuellt parti till olika format; text, HTML eller LaTeX. Se vidare
   hjlpsidan fr  att <a Export>Exportera</a> partier.</li>
<li><menu>Exportera alla filtrerade partier</menu>: Sparar alla <a Searches Filter>filterade</a> partier till olika format; text, HTML eller LaTeX. Se vidare
   hjlpsidan fr  att <a Export>Exportera</a> partier.</li>
<br>
<li><menu>Importera ett parti i PGN-format...</menu>: ppnar <a Import>Importfnstret</a> fr att ange eller klistra in ett parti i 
 <a PGN>PGN-format</a> fr import till en Scid databas.</li>
<li><menu>Importera flera partier i PGN-format...</menu>: Importerar flera partier i PGN-format frn en fil.</li>
</ul>

<h3>Alternativ</h3>
<p>
Denna meny ger tillgng till de flesta av de parametrar som styr hur Scid fungerar.
Menyvalet <menu>Spara alternativ</menu> sparar de aktuella instllningarna till filen
 "<b>~/.scid/scidrc</b>" (eller <b>scid.opt</b> i katalogen som innehller den exekverbara
scid-filen, Scid.exe, om Windows); denna fil laddas varje gng du startar Scid.
</p>

<h3>Hjlp</h3>
<p>
Denna meny innehller hjlpfunktioner och ger tillgng till bl a fnstret "Dagens tips"
och startfnstret som informerar om vilka filer Scid laddat vid uppstart. 
</p>

<p><footer>(Uppdaterad: Scid 3.5, februari 2003)</footer></p>
}
	
####################
### Entering moves help:

set helpTitle(W,Moves) "Ange drag"
set helpText(W,Moves) {<h1>Ange drag</h1>
<p>
I Scid, kan du ange partidrag svl med musen som med tangentbordet. Nr du rr musmarkren ver en ruta p
brdet kommer du att mrka att svl rutan som ytterligare en ruta fr en annan frg. Om det finns ett legalt
drag till eller frn den ruta du fr musmarkren ver. Detta r det <term>Freslagna draget</term>.
Du utfr detta drag genom att <term>Vnsterklicka</term> med musen. Om detta str dig kan du stnga av denna funktion
i Alternativmenyn.

</p>
<p>
Fr att utfra ett annat drag kan du <term>klicka och hlla nere vnster</term> musknapp: flytta sedan musen till nskad
 ruta och slpp musknappen.
</p>
<p>
Om du vill kan du utfra drag genom att klicka tv gnger istllet fr att anvnda klicka-och-drag tekniken. Klicka d 
frst p utgngsrutan med den <term>Mittersta musknappen</term> och klicka sedan med samma musknapp p destinationsrutan.
(Tipset gller kanske framfrallt anvndare av UNIX(-lika) system, som ofta har stor nytta av 3-knappsmss).
</p>

<h4>Ta tillbaka ett drag</h4>
<p>
Man kan ta tillbaka ett drag genom att hgerklicka med musen. Detta gr tillbaka ett drag och tar bort det senast utfrda draget i partiet
eller varianten.
</p>

<h4>Erstt tidigare drag</h4>
<p>
Om du anger ett drag i en stllning dr ett drag redan angivits kommer Scid att frga om du verkligen vill erstta den tidigare
draget (draget och alla varianter lngre fram som r beroende av draget tas bort), eller om du vill skapa en ny variant istllet.
En del anvnder tycker att frgan r strande och vill alltid erstta det tidigare draget, s man kan konfigurera Scid till att inte
stlla denna frga. Du hittar mjligheten i  menyn <menu>Alternativ: Drag</menu> "<i>Frga fre erstt drag</i>".
</p>

<h4><name Trial>Testlge</name></h4>
<p>
Om du gr igenom ett parti och kommer till en stllning dr du vill testa en id utan att pverka det registrerade partiet s vljer du
<b>Testa en id</b> frn menyn <menu>Redigera</menu> fr att stta p testlge. I testlge kan du gra drag och frndringar av partiet som
r temporra, dvs de sparas inte nr du tergr frn testlge.
</p>

<h3><name Mistakes>Rtta fel</name></h3>
<p>
Om du skriver in ett parti och pltsligt upptcker ett fel flera drag tidigare r det mjligt att rtta till detta utan att 
behva gra om alla drag efter feldraget. Det enda sttet r att redigera PGN-versionen av partiet: ppna <a Import>Importfnstret</a>, 
vlj Klistra in aktivt parti, korrigera felet och vlj drefter "Importera".
</p>

<h3>Ange drag via tangentbordet</h3>
<p>
Du kan ange drag via tangentbordet genom att helt enkelt skriva in dem med bokstver och siffror. Lgg mrke till att dragen
ska anges i <term>SAN-notation</term>, <i>utan</i> (x) tecknet fr slag eller (=) tecknet fr promovering. Dragnotationen r 
inte versal/gemenknslig s t ex:
[n][f][3] r samma drag som Nf3 -- men kontrollera med noten nedan fr drag som str i konflikt med varandra.
</p>
<p>
Fr att skerstlla att inga drag r prefix fr ett annat drag s anvnds en srskild metod att ange rockad. Kort och lng rockad
representeras med hjlp av bokstver som fljer:
kort rockad anges med  [O][K]
lng rockad anges med [O][Q] istllet fr det vanliga O-O och O-O-O.
</p>
<p>
Nr du anger drag kommer du i statusraden att se en lista ver giltiga drag. Du kan, genom att trycka <b>[Mellanslag]</b> vlja det frsta i listan och fra in det
i partiet. Fr att ta bort tecken anvnder du de vanliga raderingstangenterna.
</p>
<p>
<b>OBS</b> gemena tecken kopplas i frsta hand till bnder, vilket betyder att [b]kan betyda b-bonden istllet fr lparen (Bishop). Om du hamnar
i situationer nr konflikter uppstr mste du istllet ange pjserna med versaler (B) i detta fallet.
</p>
<b>versttarens kommentar</b> Scid frstr inte svenska. Detta betyder att du inte kan anvnda de svenska frkortningarna till att ange drag. [s][f][6] 
frsts inte av Scid (dremot funkar [n][f][6] utmrkt). Om du vill anvnda tangentbordet att skriva in drag fr du istllet anvnda notationen [g][8][f][6] fr
samma drag.
</p>
<h4>Autokomplettering</h4>
<p>
I Alternativmenyn kan du sl p eller av <term>Autokomplettering</term>
av drag.
Med denna pslagen grs draget s fort du skrivit in tillrckligt mycket fr att srskilja det frn andra mjliga drag. Exempelvis rcker det att skriva [n][f] istllet
fr [n][f][3] fr draget <b>Nf3</b>i utgngsstllningen.
</p>
<p><b>versttarens kommentar</b> Scid frstr som sagt inte svenska. Dremot fungerar det med rutangivelsen om t ex pjsen p g1 bara har ett flt 
att g till.</p>

<h3><name Null>Ange null-drag</name></h3>
<p>
<a Annotating Null>Null</a> (tomma, planerade) drag kan vara anvndbara i  kommentarer fr att hoppa ver den ena spelarens drag. Du anger null-drag
genom att sl den ena kungen med den andra, eller via tangentbordet genom att skriva  "<b>--</b>" (minustecknet tv gnger).
</p>
<p><b>versttarens kommentar</b> "null" r en dataterm fr att beskriva ingenting (till skillnad mot noll som har ett vrde om dock noll, null har inget vrde).
Shane anvnder termen null hr, ngon som har frslag p bttre i den svenska versttningen? Kolla introduktionssidan fr att fresl ngonting.</p>

<h3>Ange de vanligaste kommentarsymbolerna</h3>
<p>
Du kan ven ange <a NAGs>Kommentarsymboler</a> via tangentbordet utan att behva anvnda <a Comment>Kommentarseditorn</a>. 
Fljande lista kan anges via tangentbordet:
<ul>
<li> !	: [!][ENTER] </li>
<li> ?	: [?][ENTER] </li>
<li> !?	: [!][?][ENTER] </li>
<li> ?!	: [?][!][ENTER] </li>
<li> !!	: [!][!][ENTER] </li>
<li> ??	: [?][?][ENTER] </li>
<li> </li>
<li> +-	: [+][-] </li>
<li> +/-	: [+][/] </li>
<li> +=	: [+][=] </li>
<li> =	: [=][ENTER] </li>
<li> -+	: [-][+] </li>
<li> -/+	: [-][/] </li>
<li> =+	: [=][+] </li>
</ul>

<p><footer>(Uppdaterad: Scid 3.4,  juli 2002)</footer></p>
}


########################################
### Searches help screen:

set helpTitle(W,Searches) "Ska i Scid"
set helpText(W,Searches) {<h1>Ska i Scid</h1>
<p>
I Scid kan man ska information p flera olika stt. 
Det finns tre huvudmetoder att anvnda sig av beroende p vilken typ av information man
r ute efter:
<ul>
<li><b>1)</b> utifrn den aktuella stllningen p brdet, </li>
<li><b>2)</b> utifrn specifikt material eller en specifik stllningstyp; och </li>
<li><b>3)</b> utifrn fast information, t ex spelare, ort, resultat eller datum. </li>
</ul>
<p>
Utver dessa metoder kan man anvnda sig av en automatisk skfunktion, <a Tree>Trdfnstret</a>, som frklaras
separat.
</p>

<h3><name Filter>Skfiltret</name></h3>
<p>
Skningar baseras i  Scid p <term>Filter</term>.
Ett filter representerar en delmngd av den aktiva databasen. Vid varje specifikt tillflle kommer ett parti att antingen vara
del av denna delmngd (filtret) eller uteslutas av detta. I varje typ av skning (se ovan) kan du vlja att begrnsa, utka eller
ignorera det aktiva filtret och istllet ska i hela databasen. Detta gr att man stegvis kan bygga komplicerade skningar. 
Du kan ocks kopiera alla filtrerade partier frn den ena databasen till den andra genom att anvnda <a Switcher>Databasvxlaren</a>.
</p>

<p>
Nr du sker p exakt stllning, <a Tree>Trd</a> eller Material/Stllningstyp, sparas dragnumret i den frsta stllningen och varje
parti med identisk stllning lagras i minnet s att man, nr man senare laddar de framskta partierna, automatiskt kommer till den stllning
som var av intresse (som skningen grundades p).
</p>
<p>
<b>OBS</b> skningen gller endast textdragen, inte varianterna.
</p>

<h3><name Board>Sk: Aktuell stllning</name></h3>
<p>
Med denna metod hittas partier med samma stllning som det p brdet i huvudfnstret. Rockadmjligheter och 
rttigheter att gra <i>En passant</i> ignoreras. Det finns fyra undertyper att vlja p, samtliga krver att stllningen har exakt samma material och spelare vid draget fr att en trff ska
anses ha intrffat:
<ul>
<li> [1] exakt (de bda stllningarna mste vara exakt lika), </li>
<li> [2] bnder (bondestrukturen mste vara identisk, men de vriga pjsernas placering kan variera), </li>
<li> [3] linjer (antalet vita och svarta bnder p varje linje mste vara identisk - i vrigt kan pjsplaceringen variera), och slutligen; </li>
<li> [4] material (bnder och pjser kan st var som helst p brdet.). </li>
</ul>
<p>
Att ska p bondestllning r anvndbart nr man studerar spelppningar med likartad bondstruktur, medan att ska p linjer och material r lmpliga metoder fr
att finna liknande stllningar i slutspel. Nr man sker p specifika stllningar kan man skapa den frst (frn menyvalet <menu>Redigera: Skapa stllning</menu>) och starta skningen drifrn.
(Man kan naturligtvis ocks spela upp stllningen p brdet, <i>versttarens anmrkning</i>).
</p>
<p>
Du kan ange att skningen ven ska leta i varianter (istllet fr att bara inkludera de egentliga partidragen) genom att markera kryssrutan <b>Sk i varianter</b>, 
men detta kan gra skningen lngsammare om databasen r stor och har mnga partier med varianter.
</p>

<h3><name Material>Sk: Material/stllningstyp</name></h3>
<p>
Denna skning r anvndbar nr man vill finna slut- eller mittspelsteman. Du kan specificera minimalt och maximalt antal av varje pjstyp, och hitta stllningar
av typen "Lpare p f7" eller "Bonde p f-linjen". Det finns ett antal vanliga stllningstyper frdefinierade, t ex "Torn och Bondeslutspel" eller "Isolerade d-bnder".
</p>
<p>
<b>Tips:</b><br>
Tidstgngen fr denna typ av skning kan variera kraftigt. Man kan minska tiden som behvs genom att anvnda sig av frnuftiga begrnsningar.
Om man, som exempel,  vill underska slutspel kan man stta det minimala antalet drag partiet ska innehlla till 20. D kommer alla partier 
med frre n 20 drag att ignoreras.
</p>

<h3><name Header>Sk: fasta uppgifter ("header search")</name></h3>
<p>
Denna skning anvnds fr att finna aspekter p partier som lagras i partihuvudet (jmfr med eposthuvud) ssom datum, resultat, plats och ratingtal. Den
krver ingen avkodning av dragen i partiet. Fr att en trff ska registreras krvs att alla flt du specificerar stmmer verens. Namnflten  (Vit, Svart, 
Evenemang, Plats och Rond) r versal/gementoleranta. Trffar registrerars p all text i dessa flt och mellanslag ignoreras .
</p>
<p>
Du kan generera exakta skningar och anvnda jokertecken i huvudflten som nmnts ovan. Jokertecknet  <b>?</b> betyder "Ett
valfritt tecken" medan <b>*</b> betyder "Inget eller flera valfria tecken". Man genererar exakta skningar genom att innesluta den text man
nskar hitta i citattecken ("). Exempel:
</p>

<p>
En skning p platsen <b>USA</b> kommer att generera amerikanska stder, men ven <b>Lausanne SUI</b>, vilket du frmodligen inte var ute efter! 
Detta lser man genom att istllet ska efter platsen <b>"*USA"</b> (notera citattecknen) som endast kommer att presentera stder i USA.</p>
<p>
Om du sker efter en srskild spelare (eller tv srskilda spelare) som vit eller svart och det inte spelar ngon roll vet som har vilken frg vljer du med 
frdel <b>Ignorera frg</b> i stllet fr svart/vit i frgangivelsen.
</p>
<p>
Avslutningsvis kan fasta skningar gras fr att hitta valfri text (VERSAL/gemen-knsligt och utan jokertecken) i PGN-versionen av partierna. Du kan
ange upp till tre textstrngar, och alla mste finnas i ett parti fr att de ska rknas som en trff. Denna skning r mycket anvndbar nr det gller
kommentarsfltet eller extra mrkord i partierna (exempelvis  <b>frlorar p tid</b> eller <b>Kommentator</b>), eller fr en dragfljd som 
<b>Bxh7+</b> och <b>Kxh7</b> nr en lpare har offrats (och accepterats) p h7.

Tnk dock p att denna typ av skningar kan vara <i>mycket</i> tidskrvande eftersom alla partier som mter vissa kriterier mste avkodas och
genomskas efter textstrngen/-arna. Det r drfr en bra id att begrnsa denna typ av skning s mycket som mjligt. Exempel:
</p>

<p>
Fr att hitta partier med underpromovering till torn sker man p <b>=R</b> och stter <b>Frvandlingar</b> flaggan till Ja.
Fr att hitta text i kommentarer stter du flaggan <b>Kommentarer</b> till Ja.
Om du sker p dragen <b>Bxh7+</b> och <b>Kxh7</b>, kan det vara en id att begrnsa partierna till de som har resultatet  1-0 resultatet och innehller
minst 20 halvdrag. Eller gr en Material-/Stllningstypsskning fr att hitta partier dr lparen flyttas till h7.
</p>

<h3><name Settings>Spara skkriterierna</name></h3>
<p>
I Material/Stllningstyp och Huvudskningsfnstren finns valet att  
<term>Spara instllningarna</term>. Detta ger dig mjligheten att spara de aktuella skkriterierna fr senare anvndning.
Kriterierna sparas till en <term>Skningsfil</term> med filndelsen  .sso. Fr att teranvnda en tidigare sparad skningfil
vljer du <menu>ppna ...</menu> frn menyn <menu>Sk</menu>.
</p>

<h3>Sktider och ignorerade partier</h3>
<p>
De flesta skningar meddelar en hur lng tid skningen tog och hur mnga partier som <term>Ignorerades</term>. Ignorerade partier
r de som exkluderats frn en skning utan att ngot av dess drag har avkodats (frn Scids databasformat). Detta baseras p information
som lagrats i index. Se vidare hjlpfilen om <a Formats>Filformat</a> fr ytterligare information. 
</p>

<p><footer>(Uppdaterad: Scid 3.0, november 2001)</footer></p>
}

#################
### Clipbase help:

set helpTitle(W,Clipbase) "Urklippsdatabasen"
set helpText(W,Clipbase) {<h1>Urklippsdatabasen</h1>
<p>
Frutom de databaser du ppnar sjlv, ppnar Scid ytterligare en - <term>Urklippsdatabasen</term>. Urklippsdatabasen,
fungerar precis som alla andra databaser, med ett undantag. Den existerar bara i datorns arbetsminne och sparar inte data
ngonstans permanent. Urklippsdatabasen tms sledes nr du stnger av datorn.
</p>
<p>
Urklippsdatabasen r anvndbar som en tillfllig lagringsplats, fr att sl samman skresultat frn olika databaser, eller fr att man dr
kan behandla resultat frn en skning som en egen databas. 
</p>
<p>
Antag, exempelvis, att du vill frbereda dig fr en srskild motstndare. Du har skt igenom databasen efter partier av denne dr motstndaren
spelar vit. Kopiera alla partier i <a Searches Filter>Skfiltret</a> till Urklippsdatabasen. Du kan gra det genom att i <a Switcher>Databasvxlaren</a>
 dra dem frn deras ordinarie databas till Urklippsdatabasen. Drefter kan du ppna Urklippsdatabasen och underska partierna i  <a Tree>Trdfnstret</a>, 
till exempel fr att kartlgga motstndarens ppningsrepetoar.
</p>
<p>
Observera att du kan kopiera partier frn en databas till en annan utan att anvnda Urklippsdatabasen som mellanlagringsplats. Notera ocks att
Urklippsdatabasen <i>inte</i> kan stngas via menyvalet <menu>Arkiv: Stng</menu>medan du r i Urklippsdatabasen. Det som hnder d r
motsvarigheten till  <menu>Redigera: terstll Urklippsdatabasen</menu>, dvs databasen tms.
</p>
<p>
Du kan maximalt ha 100000 partier i minnet samtidigt.
</p>

<p><footer>(Uppdaterad: Scid 2.5,  juni 2001)</footer></p>
}

#################################
### Variations and comments help:

set helpTitle(W,Annotating) "Kommentera partier"
set helpText(W,Annotating) {<h1>Kommentera partier</h1>
<p>
I Scid kan lgga till noter till partierna. Det finns tre typer av anteckningar du kan lgga till till varje drag:
symboler, kommentarer och varianter.
</p>

<h3>Symboler och kommentarer</h3>
<p>
Symboler anvnds fr stllningsbedmningar om vem som str bst (t ex "+-" eller "=") , om draget som just gjordes var bra eller dligt
(t ex "!" eller "?") medan kommentarer kan best av valfri text. Fr att lgga till symboler och kommentarer anvnder man
<a Comment>Kommentarseditorn</a>. Det finns ocks en srskild hjlpsida fr <a NAGs>Standardsymbolerna</a>.
</p>
<p>
Tnk p att ven om varje drag kan ha fler symboler, kan det bara ha en kommentar. En kommentar fr frsta draget skrivs ut som 
text fre partidragen. 
</p>

<h3><name Vars>Varianter</name></h3>
<p>
En <term>variant</term> r en alternativ fortsttning av partiet som skulle ha kunnat utfras vid ngot
tillflle i partiet. Varianter kan innehlla kommentarer, symboler och varianter. Knappen mrkt "<b>V</b>" 
ovanfr brdet i huvudfnstret, samt valmjligheter frn menyn <menu>Redigera</menu> kan anvndas till att skapa,
navigera i och redigera varianter.
</p>

<h4>Kortkommandon</h4>
<p>
Nr det finns varianter till ett drag visas dem i partiinformationsomrdet. Den frsta varianten r <b>v1</b>, den andra
r <b>v2</b>, osv. Fr att flja en variant kan man klicka p den, eller trycka  "<b>v</b>" fljt av variantens nummer 
(Om det bara finns en variant rcker det med att trycka <b>v</b>.). Kortkommandot fr att g ur en variant r "<b>z</b>".
</p>

<h3><name Null>Null-drag</name></h3>
<p>
Det kan ibland vara anvndbart att hoppa ver drag i varianter. Du kan exempelvis till draget 14.Bd3 lgga till en variant och
nmna att det hotar 15.Bxh7+ Kxh7 16.Ng5+ med angrepp. Du kan ocks gra detta genom att anvnda <term>Null-drag</term>
mellan 14.Bd3 och 15.Bxh7+, i exemplet ovan. Ett null-drag visas som "<b>--</b>" och infogas genom att med musen utfra det
ogiltiga draget att med kungen sl den andra kungen, eller att helt enkelt skriva in "<b>--</b>" (tv minustecken).
</p>
<p>
Observera att null-drag inte ingr i PGN standarden, s om du vill exportera partier som innehller null-drag till en PGN-fil mste du 
vlja mellan att bevara null-dragen(-t) eller konvertera dem till kommentarer fr att bibehlla exportmjligheter till andra
program. Se hjlpsidan fr att <a Export>Exportera</a> partier fr mer information.
</p>

<p><footer>(Uppdaterad: Scid 3.4, juli 2002)</footer></p>
}

####################
### Analysis window:

set helpTitle(W,Analysis) "Analysfnstret"
set helpText(W,Analysis) {<h1>Scids Analysfnster</h1>

<h3>Analysfnster</h3>
<p>
Scids analysfnster visar analysen frn en schackmotor
av den aktuella positionen. Nr positionen ndras skickar Scid den 
nya positionen till schackmotorn samt visar dess vrdering av 
denna position. 
</p>

<p>
Vrderingen som visas i analysfnstret r alltid frn vits perspektiv, 
s en negativ vrdering indikerar att svart str bttre. Den nedre delen av fnstret 
(med scrollrutan) visar historiken fr vrderingar producerat av schackprogrammet fr den 
aktuella positionen, s att du kan se hur vrderingen har ndrats. 
</p>

<p>
Fr att lgga till det bsta draget valt av en schackmotor som ett nytt drag i det aktuella partiet 
klickar du p Lgg till drag knappen. 
</p>

<h3>Schackmotorlistan</h3>

<p>
Scid behller en lista p de schackmotorer du har anvnt, tillsammans med en uppskattad Elo-rating 
(om du antar en) och datumet nr varje schackmotor sist anvndes. Du kan sortera schackmotorlistan 
efter namn, Elo-rating, eller datum. Vlj Ny eller ndra knapparna fr att lgga till en ny schackmotor till 
listan eller ndra detaljerna fr en existerande schackmotor. 
</p>

<h3>Schackmotorkommandon och kataloger</h3>

<p>
Fr varje schackmotor mste du specificera den exekuterbara filen att kra samt i vilken katalog Scid ska 
kra den i. 
</p>

<p>
Den mest sannorlika orsaken till problem att starta en schackmotor r valet av vilken katalog schackmotorn 
ska kra i. Vissa schackmotorer krver en instllnings- eller ppningsboksfil i sina startkataloger 
fr att fungera bra. Andra schackmotorer (som Crafty) skriver loggfiler till katalogen de startar i, s 
du mste kra dem i en katalog dr du har tillstnd att skriva i. Om kataloginstllningarna fr en 
schackmotor r ".", kommer Scid att starta en schackmotor i den aktuella katalogen. 
</p>

<p>
S om en schackmotor som borde fungera bra i Scid inte startar frsk att ndra dess kataloginstllning. 
Fr att undvika att schackmotorer skapar loggfiler i mnga olika kataloger rekommenderar jag att starta schackmotorer 
i katalogen med Scids anvndarfiler (detta r dr Scid.exe filen finns i Windows, 
eller ~/.scid/ i Unix); det finns en knapp i dialogrutan fr att ndra schackmotordetaljer med namnet 
Scid.exe-katalogen i Windows eller ~/.scid i Unix som lter dig vlja vilken schackmotor som ska starta i denna katalog. 
</p>

<h3>Trning</h3>

<p>
Med Trningsknappen kan du spela drag mot schackprogrammet. Tiden fr varje drag 
r fixerad och analysresultet visas inte d. 
</p>

<h3>Kommentera ett parti</h3>

<p>
Lgg till variation knappen i analysfnstret lgger till den aktuella vrderingen och bsta analyserade
dragfljd som en ny variation i partiet. 
</p>

<p>
Du kan gra detta automatiskt fr ett antal drag (kommentera partiet) genom att klicka p 
kommentarknappen. Detta frgar dig efter ngra kommentarsalternativ och sedan startar 
sjlvspelsmod. Nr sjlvspelsmod anvnds och analysfnstret r ppet lggs 
en variation innehllande vrderingen och bsta dragfljden automatiskt till fr varje 
position nr sjlvspelsmod gr igenom partiet. Bara positioner frn den aktuella 
positionen till slutet av partiet (eller tills du lmnar sjlvspelsmod) kommenteras, 
s du kan hoppa ver att kommentera ppningsdragen genom att g till en mittspelsposition 
innan du startar sjlvspel. 
</p>

<p>
Fr att avbryta kommentarer stng av sjlvspelsmod, till exampel genom att trycka
ner Esc-tangenten i huvudfnstret. 
</p>

<p>
Observera att fr enkelhet finns kommentarknappen bara tillgnglig i fnstret ppnat som 
schackmotor 1. Om du ppnar en schackmotor som schackmotor 2 kan du inte anvnda den fr att
kommentera partiet. 
</p>

<h3>Analysbrdet</h3>

<p>
Genom att klicka p schackbrdeknappen i ett analysfnster visar du eller dljer du analysbrdet, 
som visar positionen vid slutet av den av den bsta funna aktuella dragfljden hittad av 
schackmotorn. 
Detta fungerar fr de flesta Scid-kompatibla schackmotorer men inte fr alla; 
det beror p den dragnotation som schackmotorn anvnder. 
</p>

<h3>Schackmotorprioritet</h3>

<p>
Om en schackmotor anvnder fr mycket CPU-tid och pverkar anvndningen av Scid eller 
andra program kan det hjlpa att stta p "Lg CPU-prioritet" i proxyn; 
det ger schackmotorn en lg prioritet fr CPU-anvndning. 
</p>

<h3>Grnssnittsdetaljer</h3>

<p>
Fr att anvnda analysfnstret behver du ett schackprogram som stder WinBoard/Xboard-protokollet. 
</p>

<p>
Scid skickar kommandorna <b>"xboard"</b>,<b>"post"</b> och <b>"protover 2"</b> till en schackmotor nr den startar, 
och anvnder <b>"setboard"</b> och <b>"analyze"</b> kommandorna fr mer effektiv kommunikation 
om schackprogrammet svarar vilket indikerar att det stder dem. Om en schackmotor inte stder 
<b>"setboard"</b> kommandot kan det inte analysera ett parti som brjar med en 
ickestandard startposition. 
</p>

<p>
Fr program som inte stder analyskommandot skickar Scid fljande 
kommandon varje gng positionen ndras: <b>"new"</b> och <b>"force"</b>, 
sedan dragen i partiet till den aktuella position sedan <b>"go"</b>. 
</p>

<p>
Bob Hyatts utmrkta gratis schackmotor Crafty r vad jag anvnder och rekommenderar fr 
analysfnstret, men mnga andra WinBoard eller XBoard kompatibla schackmotorer har 
anvnts framgngsrikt med Scid. Ngra nedladdningssajter fr ngra schackmotorer listas nedan. 
</p>

<p>
Crafty: <url ftp://ftp.cis.uab.edu/pub/hyatt/>ftp://ftp.cis.uab.edu/pub/hyatt/</url> 
</p>

<p>
Yace: <url http://home1.stofanet.dk/moq/>http://home1.stofanet.dk/moq/</url> 
</p>

<p>
Phalanx: <url ftp://ftp.math.muni.cz/pub/math/people/Dobes/>ftp://ftp.math.muni.cz/pub/math/people/Dobes/</url> 
</p>

<p>
Comet: <url http://members.aol.com/utuerke/comet/>http://members.aol.com/utuerke/comet/</url> 
</p>

<p>
Gnuchess: <url http://www.gnu.org/software/chess/chess.html>http://www.gnu.org/software/chess/chess.html</url> 
</p>

<p>
The Crazy Bishop: <url http://remi.coulom.free.fr/>http://remi.coulom.free.fr/</url> 
</p>
<p><footer>(Uppdaterat: Scid 3.4, September 2002)</footer></p>
}





###############################
### Comment editor window help:

set helpTitle(W,Comment) "Kommentareditor"
set helpText(W,Comment) {<h1>Scids Kommentareditor</h1>

<h3>Kommentarseditorfnstret</h3>

<p>
Kommentareditorfnstret lter dig lgga till eller ndra kommentarer och symboliska kommentarssymboler 
fr drag i det aktuella schackpartiet. 
</p>

<h3>Kommentarsymboler</h3>

<p>
Scid anvnder PGN-standarden fr kommentarsymboler, accepterar NAGs (Numeriska annotationsglypfer) 
vrden fr kommentarer. Ngra av de mest vanliga symbolerna (som "!" eller "+-") visas 
som symboler och har en knapp i kommentarseditorfnstret fr snabb inmatning. Fr andra symboler, 
kan du skriva in det lmpliga numeriska NAG-vrdet som r ett nummer frn 1 till 255. Till exempel, 
NAG-vrdet 36 betyder "Vit har initiativet" och visas som "$36" i PGN-texten till partiet.  
</p>

<p>
Se hjlpsidan om NAG-vrden fr NAG vrden som definieras av bl a PGN-standard. 
</p>

<p>
Tips: Du kan lgga till de vanligaste dragvrderingssymbolerna (!, ?, !!, ??, !? och ?!) i huvudfnstret 
utan att behva anvnda kommentarseditorfnstret, genom att skriva in symbolerna fljt av att trycka 
p <b>[Enter]</b> tangenten. Detta r speciellt anvndbart om du skriver in schackdrag genom att anvnda
tangentbordet. 
</p>

<h3>Kommentarer</h3>

<p>
Du kan ndra kommentarer genom att skriva in text och anvnda Rensa, ngra och Lagra 
knapparna. Du behver inte trycka p Lagra knappen fr att uppdatera en kommentar; 
den uppdateras automatiskt nr du gr till en annan position i partiet. 
</p>

<h3>Frga rutor</h3>

<p>
Du kan frga alla rutor med valfri frg genom att anvnda ett specialkommando,som kan 
finnas varsomhelst i en kommentar. Kommandoformatet r: 
</p>

<p>
[%mark square color]
</p>

<p>
dr square r ett rutnamn som d4 och frg r varje definierat frgnamn 
(som red, blue, darkGreen, lightSteelBlue, etc) eller RGB-kod (a # fljt av 
sex hexadecimala siffror, som #a0b0c8). Om frgen utelmnas blir rutan
rd. 
</p>

<p>
En kommentar kan innehlla obegrnsat antal frgkommandon, men varje mste ha sin 
egen [%mark ...] markering. Till exempel, kommentarstexten
</p>

<p>
Nu r d6-rutan  [%mark d6] svag och springaren kan attackera den frn b5. [%mark b5 #000070] 
</p>

<p>
frgar rutan d6 rd och rutan b5 frgas med den mrkbl frgen #000070. 
</p>

<h3>Rita pilar</h3>

<p>
Du kan rita en pil frn en ruta till en annan genom att anvnda ett specialkommentarskommando 
liknande det fr att frga rutor. Formatet r: 
</p>

<p>
[%arrow fromSquare toSquare color]
</p>

<p>
dr fromSquare och toSquare r namn p rutor som d4 och frg r varje definierat 
frgnamn (som  red, blue, etc) eller RGB code (som #a0b0c0). Om frgen inte specificeras
blir den rd. 
</p>

<p>
Till exempel, kommentarstexten 
</p>

<p>
C3-springaren och c4-lparen kontrollerar den svaga d5 rutan. 
[%arrow c3 d5 red] [%arrow c4 d5 blue] 
</p>

<p>
kommer att rita en rd pil frn c3 till d5 och en bl pil frn c4 till d5. 
</p>

<p><footer>(Uppdaterat: Scid 3.2, February 2002)</footer></p>
}


###########################
### Crosstable window help:

set helpTitle(W,Crosstable) "Korstabellfnster"
set helpText(W,Crosstable) {<h1>Scids korstabellfnster</h1>

<h3>Korstabellfnstret</h3>

<p>
Korstabellfnstret visar turneringskorstabellen fr det aktuella partiet. 
Varje gng du uppdaterar korstabellfnstret (genom att trycka p Uppdatera knappen, 
genom att trycka Enter tangenten i korstabellfnstret, eller genom att trycka <b>Ctrl+Shift+X</b> 
i huvud- eller partilistefnstren), sker Scid efter alla partier i samma turnering som det
aktuella partiet. 
</p>

<p>
Alla partier som spelas upp till tre mnader fre eller efter det aktuella partiet, 
med exakt samma Evenemangs- och Ortmarkeringar anses vara i turneringen. 
</p>

<p>
Ett enkelt klick med vnstra musknappen p ett resultat i korstabellen laddar detta  
parti. Du kan lgga till alla partier i turneringen till filtret med Lgg till filter knappen
i korstabellen. 
</p>

<h3>Korstabellfnstermenyer</h3>

<p>
<b>[Arkiv]</b> menyn lter dig spara den aktuella tabellen till en fil med text-, 
LaTeX- eller HTML-tabellformat. 
</p>

<p>
<b>[Visa]</b> menyn lter dig vlja tabellformat: 
All-play-all, Swiss eller Knockout eller Auto. 
</p>

<p>
All-play-all formatet (fr round-robin-typ evenemang) har en begrnsning p 30 spelare, 
men Swiss formatet (fr turneringar med mnga spelare) kan visa upp till 
200 spelare och upp till 20 rundor. Auto, som vljer det bsta formatet automatiskt 
fr varje turnering r standardinstllningen. 
</p>

<p>
Observera att Scid anvnder Rundemarkeringen fr varje parti fr att producera en Swisskorstabell, 
s du kommer inte att se ngra partier i Swisskorstabellen fr en turnering om dess partier inte 
har numeriska rundevrden som: 1, 2, 3, etc. 
</p>

<p>
Visa menyn lter dig ocks stlla in de data som ska presenteras att inkludera eller exkludera rating, 
lnder och spelartitlar. Du kan ocks vlja om frgallokationer i Swisstabeller ska synas. 
</p>

<p>
Separat ponggrupps-alternativet pverkar bara utseendet p tabellen nr spelarna sorteras
efter pong: det ger en tomrad mellan varje grupp av spelare med samma pong. 
</p>

<p>
<b>[Sortera]</b> menyn lter dig sortera spelarna efter namn, rating eller pong; 
efter pong r standardinstllningen. 
</p>

<p>
<b>[Frg]</b> menyn lter dig stta p eller av frg i hypertextvisning. Eftersom det kan ta lng tid att 
formattera och visa stora korstabeller i hypertext sparar det mycket tid att vlja vanlig text
fr stora evenemang. Men i enkel text kan du inte klicka p spelare eller partier. 
</p>

<h3>Duplikerade partier i korstabeller</h3>

<p>
Fr att f bra resultat med korstabeller br du markera dubblettpartier fr borttagning och 
ha en konsistent stavning i partierna av namn p spelare, ort och evenemang. Se Underhll 
databas fr hjlp med att ta bort dubbletter och ndra (eller stavningskontrollera) 
spelar-/evenemangs-/ortsnamn. 
</p>

<p><footer>(Uppdaterat: Scid 3.1, December 2001)</footer></p>
}


###########################
### Database switcher help:

set helpTitle(W,Switcher) "Databasvxlaren"
set helpText(W,Switcher) {<h1>Scids databasvxlare</h1>

<h3>Databasvxlaren</h3>

<p>
Databasvxlaren ger en mjlighet att enkelt byta mellan databaser 
eller kopiera partier mellan databaser. Namnet, filterinstllningen 
pch en ikon fr varje databas visas medan den aktiva databasen 
markeras med en gul bakgrund. 
</p>

<p>
Du kan ppna databasvxlaren frn  <b>[Fnster]</b> menyn eller genom att 
anvnda dess tangentkombination: <b>Ctrl+D</b>. 
</p>

<p>
Fr att kopiera alla filtererade partier frn en databas till en annan, drag med den vnstra 
musknappen nedtryckt frn klldatabasen till destinationsdatabasen. Du kommer d att se en  
bekrftelsedialog (om destinationsdatabasen inte r Clipbase) om partierna kan 
kopieras eller se ett felmeddelande om partierna inte kan kopieras (till exempel, 
om en vald databas inte r ppnad). 
</p>

<p>
Genom att klicka med hger musknapp p en databas visas en popup-menu fr 
denna databas, frn vilken du kan ndra databasikon eller nollstlla databasens 
filter. Du kan ocks anvnda denna meny fr att ndra orienteringen av den 
(fr att arrangera databasen vertikalt eller horisontellt) vilket r anvndbart fr 
mindre bildskrmar. 
</p>

<p><footer>(Uppdaterat: Scid 3.1, December 2001)</footer></p>
}


######################
### Email window help:

set helpTitle(W,Email) "Email-fnster"
set helpText(W,Email) {<h1>Scids Email-fnster</h1>

<h3>Email-fnstret</h3>

<p>
Scids email-fnster ger en mjlighet att hantera korrespondensschackpartier 
med email. Om du inte spelar emailschack har du inget intresse fr detta. 
Men om du spelar korrespondensschack via email kan du skicka dina 
emailmeddelanden direkt frn Scid! 
</p>

<p>
Fr att anvnda emailhanteraren flj fljande steg: 
</p>

<p>
<li>1) Skapa partierna fr din motstndare i databasen. </li>
<li>2) I emailhanteringsfnstret vlj Lgg till och skriv in detaljerna om dina motstndare: 
namn, email-adress samt antal partier i databasen. </li>
<li>3) Vlj Skicka email i emailfnstret varje gng du har lagt till drag till partierna 
och vill skicka ett meddelande. </li>
Nr du skickar ett email-meddelande genererar Scid meddelandet med partierna 
i PGN-format utan kommentarer eller variationer eftersom du vanligtvis inte vill att din 
motstndare ska se din analys. Du kan ndra meddelandet innan du skickar det fr att lgga
till villkorade drag eller annan text. 
</p>

<p>
Fr varje motstndare kan du ha obegrnsat antal partier; en eller tv r det mest vanliga. 
Observera att Scid inte kontrollerar om antalet partier ndras, s efter att ha stllt in detaljerna 
om dina motstndare var noga att undvika att ta bort partier eller sortera din databas med emailpartier 
eftersom detta kommer att ndra i partier och gra antalet partier fr varje motstndare felaktigt. 
</p>

<h3>Begrnsningar</h3>

<p>
Scid har inte nnu mjlighet att kontrollera din emailkatalog, s du mste fortfarande lgga till
dina motstndares drag till partierna manuellt. 
</p>

<h3>Konfiguration<h3>

<p>
En kopia av varje emailmeddelande som skickats av Scid sparas i filen ~/.scid/scidmail.log. 
Om du vill att de ska sparas i en annan fil behver du ndra i filen tcl/start.tcl 
och omkompilera Scid. 
</p>

<p>
Scid kan skicka emailmeddelanden genom att anvnda en SMTP server eller sendmail. 
Anvnd instllningsknappen i emailhanteraren fr att specificera vilken du vill anvnda. 
</p>

<p>
Scid lagrar motstndardetaljerna fr en databas i en fil med samma namn som databasen
med filndelsen  ".sem". 
</p>

<p><footer>(Uppdaterat: Scid 3.0, November 2001)</footer></p>
}


############################
### File Finder window help:

set helpTitle(W,Finder) "Sk filer"
set helpText(W,Finder) {<h1>Sk filer</h1>

<h3>Sk filer<h3>

<p>
Sk filer hjlper dig att hitta filer som du kan anvnda i Scid: 
databaser, PGN-filer, EPD-filer samt repetoarfiler. 
</p>

<p>
Den visar anvndbar information om varje fil, som dess storlek 
(see nedan) och datum fr senaste ndringen. Du kan ppna varje visad 
fil genom att vlja den genom att klicka en gng med vnstra musknappen. 
</p>

<h3>Ska i underkataloger</h3>

<p>
Nr du vill hitta alla filer i alla underkataloger till den aktuella katalogen, 
s markerar du i markeringsrutan fr Leta i underkataloger. Detta fr Scid att rekursivt 
genomska varje underkatalog efter filer som kan ppnas i Scid. Detta kan 
ta lng tid om det finns mnga underkataloger, s du kanske inte vill gra detta 
fr en katalog nra roten av filsystemet. Du kan avbryta filskningen genom att 
trycka p Stoppknappen. 
</p>

<h3>Filstorlekar</h3>

<p>
Betydelsen av de filstorlekar som visas beror p filtypen. 
Fr Scid-databaser och PGN-filer r det antalet partier. Fr EPD-filer 
r det antalet positioner. Fr repetoarfiler r det antalet 
(inkludera- eller exkludera)ppningar. 
</p>

<p>
Fr alla filtyper utom Scid-databaser r den angivna filstorleken en uppskattning baserad p 
de frsta 64 kilobytesen av filen, s den angivna storleken kanske inte r korrekt fr 
filer som r strre n 64 kb. Uppskattade storlekar visas med ett ungefrtecken (~) 
fr att visa att de inte r exakta. 
</p>

<p><footer>(Uppdaterat: Scid 2.7, September 2001)</footer></p>
}


#########################
### GameList window help:

set helpTitle(W,GameList) "Partilistan"
set helpText(W,GameList) {<h1>Partilistan</h1>
<p>
Partilistafnstret ger en enradig sammanfattning av varje
parti i det aktuella <term>Filtret</term> .
</p>

<h3>Navigationen i partilistan</h3>

<p>
Du kan blddra i partilistan med skjutregulatorn eller med de fyra
knapparna i nedre delen av listan .
Du kan ocks anvnda tangenterna <b>[Pos1]</b>, <b>[End]</b>, <b>[Bild i]</b>, <b>[Bild ab]</b> svl som
cursortangenterna , fr att scrolla med tangentbordet.
</p>

<p>
Du kan hitta  nsta parti i listan, som innehller en bestmd
text i Vit-, Svart-, Turnerings- eller Ortsfltet , med 
<b>Sk text</b>-inmatningsflten.
</p>

<h3>tgrder med partier i listan</h3>

<p>
Fr att ladda ett parti p listan klickar du dubbelt med
den vnstra musknappen.
Ett klick med dem mittersta musknappen visar de frsta dragen i partiet;
det r nyttigt, nr man vill se ppningen fre ppnandet av ett parti.
</p>
<p>
Den hgra musknappen ger en meny fr det utvalda partiet,
dr du kan ta bort partier (eller "ta tillbaka partier") eller utesluta partier frn 
filtret. Observera att borttagandet inte grs direkt utan det grs frst
nr databasen  <a Compact>komprimeras</a>.
</p>

<h3>Konfigurera partilistan</h3>
<p>
Fr att konfigurera partilistan, klickar du med den vnstra eller
hgra musknappen i en kolumnverskrift. Du kan ven ndra bredd,
, infoga eller ta bort samt ndra frg p varje kolumn.
</p>
<p>
Nr du bara vill ndra kolumnbredden, finns det fr detta en
tangentkombination: klickar du med nedtryckt <b>[Ctrl]</b>- (eller
<b>[Shift]</b>)-tangent med den vnstra musknappen i 
den versta delen av kolumnen  blir kolumnen mindre med den hgra
musknappen blir den bredare.
</p>

<h3>ndra storlek p partilistan</h3>
<p>
Storleken p partilistan blir sparat i alternativfilen varje gng,
som du sparar dina instllningar.
Du kan ocks nr du vill att partilistan standardmssigt ska visa 10 partier ,
frndra storleken p partilistafnstret och vlja
<b>Spara instllningar</b> i <menu>Alternativ</menu>-menyn.
</p>

<h3><name Browsing>Se partier och infoga variant</name></h3>
<p>
Kontextmenyn fr Partilistan (och ngra andra fnster, som bl a
<a Reports Opening>ppningsrapport</a>-Fnstren och listan med de
<a Tree Best>Bsta partierna</a> i <a Tree>Dragtrd</a>-Fnstret)
tillter val av parti att ladda, titta p eller infogandet av en variant.
</p>
<p>
Nr <term>Betrakta parti</term> blir valt, blir dragen i
det utvalda partiet (utan kommentarer eller varianter) visat i ett
separat fnster. Det r en nyttig metod att titta p ett annat parti
i frgrunden utan att ndra i det aktuellt laddade partiet.
</p>
<p>
Funktionen <term>Infoga variant</term> gr det mjligt att infoga 
varianter i det utvalda partiet. Scid finner den
sista mjliga tidpunkten, d det valda partiet avvek frn det aktuella
(med betraktande av dragomkastningar), och infogar denna position
som en variant. 
</p>

<p><footer>(Uppdaterat: Scid 3.2, Februari 2002)</footer></p>
}


#######################
### Import window help:

set helpTitle(W,Import) "Importfnstret"
set helpText(W,Import) {<h1>Importfnstet</h1>
<p>
Scids Importfnster mjliggr att enkelt infoga ett
parti i <a PGN>PGN-format</a> till Scid eller till ett annat 
program.
</p>
<p>
I det stora fnsteromrdet skriver du  in eller infogar partitexten i
PGN-format och i det gra omrdet nedanfr finns 
felmeddelanden eller varningar.
</p>

<h3>Bearbeta det aktuella partiet i Importfnstret</h3>
<p>
Importfnstret ger ocks en ytterligare bekvm mjlighet fr
ndringar i det aktuella partiet: du kan i det aktuella partiet i
importfnster infoga (med funktionen <b>Infoga aktuellt parti</b>), 
ndra i texten och drefter klicka p <b>Importera</b> .
</p>

<h3>PGN-markeringar i Importfnstret</h3>
<p>
Scid frvntar sig PGN-markeringar ("header tags") som
<ul>
<li> <b>[Resultat "*"]</b> </li>
</ul>
fre dragen, men du kan ocks infoga ett partifragment som
<ul>
<li> <b>1.e4 e5 2.Bc4 Bc5 3.Qh5?! Nf6?? 4.Qxf7# 1-0</b> </li>
</ul>
utan PGN-markeringar , och Scid importerar det.
</p>

<h3>Anvnda PGN-filer i Scid</h3>
<p>
Nr du vill anvnda en PGN-fil i Scid , utan att i frvg konvertera den med
<a Pgnscid>Pgnscid</a> , finns det tv mjligheter.
</p>
<p>
I det frsta alternativet kan du importera parti-filen med menyalternativet
<menu>Verktyg: Importera PGN-partier ...</menu> .
</p>
<p>
Alternativet tv vore att ppna PGN-filen direkt i Scid . Dessutom
blir PGN-filen bara ppnat fr lsande och behver mer minnesutrymme n
en jmfrbar Scid-databas, denna mjlighet r allts bara att rekommendera
fr relativt sm PGN-filer .
</p>

<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}


########################
### Reports help:

set helpTitle(W,Reports) "Rapporter"
set helpText(W,Reports) {<h1>Rapporter</h1>
<p>
Hos Scid r en <term>Rapport</term> ett dokument, som innehller information om
en bestmd Position och/eller en bestmd spelare . 
Scid kan skapa tv typer av rapporter: 
ppningsrapporter och Spelarrapporter.
</p>

<h3><name Opening>ppningsrapport</name></h3>
<p>
Scid kan skapa en <term>ppningsrapport</term> , som har interessant
information om den aktuella ppningspositionen. Fr att skapa 
ppningsrapporten frvissar du dig frst att den aktuella positionen r den som
du vill ha rapporten fr,
sedan vljer du <b>ppningsrapport</b> i menyn <menu>Verktyg</menu>.
</p>
<p>
<term>ppningsrapport</term>-fnstret ger resulatet av rapporten. 
<b>Data</b>-menyn innehller alternativ,
fr att spara rapporten i Text-, HTML- eller
<a LaTeX>LaTeX</a>-format.
</p>
<p>
De frsta avsnitten i rapporten presenterar information om de
partier, som har rapportpositionen, och de drag som har spelats i denna
stllning. Du kan se om ppningen r populr , om den leder till mnga korta remier 
och med vilka dragfljder (dragomkastningar) den blir uppndd.
</p>
<p>
Avsnittet om positionella teman informerar om vanligheten av
bestmda typiska teman i rapportpartierna. Till detta blir
de frsta 20 dragen (allts de frsta 40 positionerna frn utgngsstllningen)
i varje parti unterskt. Fr att ett parti ska finnas med som har ett bestmt tema
mste detta tema minst frekomma fyra gnger inom de frsta 20 dragen i partiet. 
Drmed undviks att ett kortsiktig frekomst av ett tema (som t ex en isolerad
dambonde, som genast blir slagen) att resultatet blir missvisande.
</p>
<p>
Den sista och lngsta delen av rapporten r teoritabellerna. Nr du
sparar rapporten i en fil kan du vlja om du bara vill ha teoritabellerna, 
en kompakt rapport utan teoritabellerna eller
hela rapporten.
</p>
<p>
Nstan alla avsnitt i rapporten kan stllas in med ppningsrapport-alternativ
eller stngas av eller p.
Du kan allts anpassa rapporten, s att den bara innehller den fr dig intressanta 
informationen.
</p>
<p>
Med den mesta informationen i rapportfnstret, som r frgkodad, 
leder ett klick p vnster musknapp till en aktion. Till exempel kan du
ladda ett parti genom att klicka p det eller stlla in filtret genom att
klicka p ett positionstema s att rapporten bara innehller partier med
detta tema .
</p>

<h4>Favoriter</h4>
<p>
Med  <menu>Favoriter</menu>-menyn i rapportfnstret har du 
mjlighet att frvalta en lista av frdefinierade ppningsrapportpositioner 
och mycket enkelt skapa rapporter fr exakt dessa positioner. 
Nr du vljer "Infoga i rapport..." im Favorit-menyn
blir den aktuella stllningen vald som en srskild rapportposition. 
Du uppmanas d att ange ett namn, som d anvnds nr 
favoritrapporter skapas.
</p>
<p>
Vlj "Skapa rapport..." i Favorit-menyn, fr att skapa en rapport
fr varje vald position i den aktuella databasen . 
I ett dialogfnster kan du d ange typ och format p rapporten 
svl som den katalog, dr rapportfilerna blir sparade. 
Den passande filndelsen fr det valda utdataformatet
blir d automatiskt valt (till exempel ".html" fr HTML-format).
</p>

<h3><name Player>Spelarrapport</name></h3>
<p>
En <term>Spelarrapport</term> liknar mycket en ppningsrapport,
men innehller information om partier fr en enskild spelare med
vit eller med svart. Du kan antingen f en spelarrapport via verktygs-menyn
eller frn <a PInfo>Spelarinformations</a>-fnstret.
</p>
<p>
En Spelarrapport kan skapas antingen fr alla partier/fr en bestmd spelare
/fr en bestmd frg eller bara fr de partier, som
har ftt den aktuella stllningen p huvudfnster-brdet.
</p>

<h3>Inskrnkningar</h3>
<p>
Fr de flesta ppningsdata finns det en inskrnkning till 2000 partier,
nr ppningsposition innehller fler n 2000 partier kan
ngra resultat vara lite oklara.
</p>
<p>
Dessutom finns det en begrnsning till 500 partier fr teori-tabellerna. Nr
ppningspositionen finns i fler n 500 partier , anvnds bara de 500 partier med de 
hgsta genomsnittliga Elo-talen. Antalet partier fr
uppbyggnaden av teoritabellerna r instllningsbart.
</p>

<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}


####################
### PGN window help:

set helpTitle(W,PGN) "PGN-fnster"
set helpText(W,PGN) {<h1>PGN-fnster</h1>
<p>
Scids PGN-fnster ger innehllet i det aktuella partiet i 
Standard-PGN-format. I Partitexten syns kommentarer i
{icke runda} och varianter i (runda) klamrar.
</p>

<h3>PGN-format</h3>
<p>
PGN (Portable Game Notation) r ett utbredd standard fr verfring
av schackpartier mellan datorprogram. En PGN-parti bestr
av tv delar.
Den frsta delen r PGN-markeringarna ("Header"), som innehller inmatningar ("tags") som
till exempel
<b>[White "Kasparov, Gary"]</b>
och
<b>[Resultat "1/2-1/2"]</b> .
</p>
<p>
Den andra delen innehller de egentliga partidragen i
algebraisk standardnotation (SAN) tillsammans med eventuella varianter,
<a NAGs>Kommentarsymboler</a> och <a Comment>Kommentarer</a>.
</p>

<h3>tgrder i PGN-fnster</h3>
<p>
Du kan navigera i partiet med PGN-fnstret: Med
ett klick med vnstra musknappen p ett drag gr du till detta drag, med ett
klick med vnstra musknappen i en Kommentar kan du ndra i denna.
Cursortangenterna (liksom tangenterna <b>v</b> och <b>z</b> fr
att brja respektive avsluta varianter) anvnds fr att navigera i 
partiet precis som i huvudfnstret.
</p>

<h3>Instllningar fr PGN-presentation</h3>
<p>
Menyn PGN-fnster innehller alternativ fr fnstret i PGN presentationen. 
Scid kan visa partiet i frg eller visa det som en ren text
-- se  <menu>Presentations</menu>-menyn i PGN-fnstret.
Den frgade presentationen r ltt att lsa och tillter dig att vlja drag och
kommentarer med musen, men de r mycket lngsammare n enkel text. 
Fr mycket lnga partier br du kanske vlja enkel text.
</p>
<p>
Ocks formatet fr kommentarer och varianten kan du frndra,
fr att ge en bttre versikt eller fr att lta ge ut i separata delar.
</p>
<p>
PGN-presentationsalternativ och storleken p PGN-fnstret blir alltid sparat i
konfigurationsfilen nr du vljer <b>Spara alternativ</b> i <menu>Alternativ</menu>-Menyn.
</p>

<p><footer>(Uppdaterat: Scid 3.1, December 2001)</footer></p>
}


#######################
### Piece Tracker help:

set helpTitle(W,PTracker) "Pjsspraren"
set helpText(W,PTracker) {<h1>Pjsspraren</h1>

<h3>Pjsspraren</h3>

<p>
Pjsspraren r en funktion som sprar rrelserna fr en srskild pjs fr alla partier 
i det aktuella filtret och genererar ett "fotavtryck" fr att visa hur ofta varje pjs 
har varit p en viss ruta. 
</p>

<p>
Fr att anvnda pjsspraren se frst till att filtret innehller de partier du r 
intresserad av, som partier med en viss ppningsposition eller alla partier 
dr en viss spelare hade de vita pjserna. Vlj sedan pjs att spra och 
stll in andra alternativ; som frklaras hr nedan. Efter detta tryck p 
Uppdateraknappen. 
</p>

<p>
Informationen om den sprade pjsens rrelser visas p tv stt: ett grafiskt 
"fotavtryck" och en textlista med en rad med data per ruta. 
</p>

<h3>Vlja pjs att spra</h3>

<p>
Schackpjserna visas i startpositionen nedanfr fotavtrycksdiagrammet. En enkel pjs 
(som den vita b1 springaren eller den svarta d7 bonden) 
kan vljas med den vnstra musknappen och alla pjser av samma typ och frg 
(som alla vita bnder eller bda svarts torn) kan vljas med den hgra musknappen. 
</p>

<h3>Andra pjssprarinstllningar<h3>

<p>
Dragnummeromrdet kontrollerar nr sprningen ska starta och stoppa i varje parti. 
Standardinstllningen p 1-20 (betyder att sprningen ska stoppas efter svarts drag nr 20) 
r lmpligt fr att underska ppningsteman, men (till exempel) ett omrde som 15-35 
r bttre nr man sker efter mittspelstrender. 
</p>

<p>
Det finns tv typer av statistik som pjsspraren kan generera: 
</p>

<p>
% games with move to square: visar vilken proportion av de filtrerade partierna som 
innehller ett drag av den sprade pjsen fr varje ruta. Detta r standardinstllningen 
och vanligtvis det mest passande valet. 
% time in each square: visar proportionen av tid den sprade pjsen har spenderat 
p varje ruta. 
</p>

<h3>Tips</h3>

<p>
Det finns tminstonde tre bra anvndningar av pjsspraren: ppningspreparering, 
mittspelsteman och spelarpreparering. 
</p>

<p>
Fr ppningspreparering anvnd pjsspraren med dragtrdet ppnat. Genom att flja
pjser kan du se trender i den aktuella ppningen som vanliga bondeframsttar, 
springarutposter samt var lparna oftast placeras. Du kan ven finna det 
anvndbart att stta dragantalet till att starta efter det aktuella draget i partiet, 
s att dragen fram till och med den aktuella positionen inte inkluderas i statistiken. 
</p>

<p>
Fr mittspelsteman kan pjsspraren vara anvndbar nr filtret har stllts in att 
innehlla en viss ECO-omfattning (genom en Partihuvudskning) eller kanske ett 
mnster som en vit isolerad dambonde (genom en Material/mnsterskning). 
Stt dragantalet till ngot lmpligt (som 20-40) och spra pjser fr att t ex se 
bondeframsttar i det sena mittspelet eller tidiga slutspelet. 
</p>

<p>
Fr spelarpreparering anvnd en Partihuvudskning eller Spelarinformationsfnstret
fr att hitta alla partier av en viss spelare med en viss frg. Pjsspraren kan d
anvndas fr att t ex upptcka hur sannorlikt det r att spelaren fianchettar lpare, 
gr lng rockad eller stller upp bnderna p d5 eller e5. 
</p>

<p><footer>(Uppdaterat: Scid 3.3, April 2002)</footer></p>
}

#####################
### Player List help:

set helpTitle(W,PList) "Spelarlistan"
set helpText(W,PList) {<h1>Spelarlistan</h1>

<h3>Spelarlistan</h3>

<p>
Spelarlistan visar en lista p spelarnamn i den aktuella databasen. 
Genom att vlja en spelare ppnas spelarinfofnstret fr att visa mer detaljerad
information om den spelaren. 
</p>

<p>
Fem kolumner som syns visar varje spelares namn, Hgsta uppndda ELO, 
antal spelade partier samt ret fr deras ldsta och nyaste parti. 
Klicka p valfri kolumntitel p toppen av listan fr att sortera listan efter den
kolumnen. 
</p>

<p>
Kontrollerna nedanfr listan lter dig filtrera listinnehllet. 
Du kan ndra den maximala liststorleken, skriva in ett VERSAL-/gemenoknsligt spelarnamn 
prefix (som "ada" fr att ska efter "Adams"), 
och begrnsa Elo-omfattningen och antalet spelade partier. 
</p>

<p><footer>(Uppdaterat: Scid 3.4, August 2002)</footer></p>
}

#####################
### Player Info help:

set helpTitle(W,PInfo) "Spelarinfo"
set helpText(W,PInfo) {<h1>Spelarinfo</h1>

<h3>Spelarinfofnstret</h3>

<p>
Spelarinformationsfnstret skapas eller uppdateras nr du klickar med den vnstra 
musknappen p ett spelarnamn i spelinformationsytan (nedanfr schackbrdet) 
eller i korstabellfnstret. 
</p>

<p>
Den visar frhoppningsvis anvndbar information om spelaren, inklusive deras framgng 
med vit och svart, favoritppningar (med ECO-kod), och ratinghistoria. 
</p>

<p>
Alla procenttal som visas r en frvntad pong (mtt p framgng), frn den spelarens 
perspektiv -- s hgre r alltid bttre fr spelaren oavsett om de r vit eller svart. 
</p>

<p>
Du kan se spelarens ratinghistoria i en tabell genom att trycka p  Ratingtabellknappen. 
</p>

<p>
Varje antal skrivet i rtt kan klickas med den vnstra musknappen fr att stlla in filtret fr de
partier den representerar. 
</p>

<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}


###########################
### Repertoire editor help:

set helpTitle(W,Repertoire) "Repetoar-Editor"
set helpText(W,Repertoire) {<h1>Repetoar-Editor</h1>

<h3>Repertoar-Editor</h3>

<p>
Repetoar-editorn lter dig skapa, se och ndra repetoarfiler. 
En repetoarfil (*.sor) r en lista p de ppningspositioner du vill n eller 
frsker undvika, och du kan anvnda den fr att hantera dina 
schackppningspreferenser men den gr ven att anvnda fr att ska i
databaser med Scid. 
</p>

<h3>Repetoargrupper och linjer</h3>

<p>
En repetoar innehller tv typer av element: grupper och linjer. 
Grupper r inte en del av din repetoar; de anvnds bara fr att 
strukturera den p samma stt som kataloger ger struktur till filerna p en hrddisk,CD,DVD
eller diskett. 
</p>

<p>
Linjer i en repetoar finns i tv typer: Inkludera linjer, som representerar de 
ppningspositioner du r intereserad av och frsker uppn medan exkluderalinjer,som r
de du inte r intresserade av att spela och frsker undvika. 
Till exempel, om du spelar en accepterad damgambit (QGA) dvs 1.d4 d5 2.c4 dxc4 som svart
och du spelar alla drag efter 3.e4 utom 3...Sf6, mste du ha 1.d4 d5 2.c4 dxc4 3.e4 som en 
Inkluderalinje och 1.d4 d5 2.c4 dxc4 3.e4 Nf6 som en Exkluderalinje. 
</p>

<h3>Kommentarer och anteckningar</h3>

<p>
Varje grupp eller linje kan ha kommentarer anknytna till sig. 
Det finns tv typer: korta (enrads-) kommentarer som syns med rtt i repetoarhierarkin brevid 
dragen i en grupp eller linje medan lnga (flerradiga-) kommentarer bara visas nr gruppen  
eller linjen vljs. 
</p>

<p>

<h3>Anvnda Repetoar-editorn</h3>

<p>
Den vnstra sidan av fnstret visar repetoarhierarkin. 
Du kan klicka p folderikoner fr att expandera och krympa grupper, 
och klicka p dragen i en  grupp eller linje fr att vlja den och se dess kommentarer. 
Inkludelinjer visas med bl accepteraikoner medan exkluderalinjer visas med rda kors. 
</p>

<p>
Om en linje eller grupp har en kort kommentar, visas den efter dragen. 
Om den har en lng kommentar indikeras detta med ** efter dragen. 
Grupperna har en siffra inom parentes efter sina drag som visar det antal inkludera- och 
excluderalinjer de innehller. 
</p>

<p>
Genom att klicka med hger musknapp p en grupp eller linje ger det en meny med funktioner
fr att ta bort den eller frndra dess status. 
</p>

<h3>Den hgra sidan av fnstret innehller tre delar.</h3>

<p> 
Den frsta delen r en lista p dragen i den aktuellt valda linjen eller gruppen. 
Du kan klicka med vnster musknapp p den fr att klistra in dragen i Importfnstret, 
vilket r anvndbart fr att lta det aktuella partiet starta med en linje i repetoaren. 
Den andra delen innehller en kort kommentar fr linjen eller gruppen, 
och den tredje delen innehller dess lnga kommentar. 
</p>

<h3>Lgga till grupper och linjer till repetoaren</h3>

<p>
Fr att lgga till en linje eller grupp till fnstret mata bara in dragen p schackbrdet i 
huvudfnstret och anvnd sedan <b>[Redigera]</b> menyn i Repetoar-editorn fr att lgga till det 
som en grupp, inkluderalinje eller excluderalinje. 
</p>

<p>
Fr att ta bort en grupp eller linje klicka med hger musknapp p den och vlj det lmpliga 
kommandot frn menyn som visas. 
</p>

<h3>Ska databaser med repetoarfiler</h3>

<p>
Repetoar-editorns <b>[Sk]</b> meny lter dig ska den aktuella databasen med repetoaren. 
Varje parti blir genomskt efter positionerna i repetoaren och blir bara matchade i skningen
om den djupaste repetoarpositionen som hittas r en inkluderalinje. 
</p>

<p>
Du kan vlja att ska genom att anvnda hela repetoaren eller bara de visade linjerna. 
Att ska bara de visade linjerna r anvndbart nr du bara vill anvnda en del av repetoaren. 
Till exempel kan en repetoar ha tv huvudgrupper , 
en fr 1.e4 och en fr 1.d4. Om du r bara interesserad av 1.e4 linjerna, 
krymp bara 1.d4 gruppen och sk sedan bara de visade linjerna. 
</p>

<h3>Extra tips</h3>

<p>
En repetoarfil r bra fr att hitta nya partier i dina ppningssystem. 
Till exempel varje gng du fr en ny PGN-fil att lgga till till din huvuddatabas 
(som den excellenta vecko PGN-filen frn The Week In Chess), 
ppna bara PGN-filen i Scid och gr en repetoarskning. 
Sedan kan du blddra i de filtrerade partierna fr att se alla de spelade partierna som finns i 
din repetoar. 
</p>

<p>
Du kan vilja behlla tv repertoarfiler: en fr svart och en fr vit, 
s att du kan ska med varje fil separat. 
</p>

<p>
En repertoarfil kan ppnas frn kommandoraden, till exempel: 
scid minbas vit.sor 
</p>

<p>
Du kan ndra en repetoarfil (*.sor) i valfri texteditor, men var noga att bevara dess format 
s att den frblir laddbar eller skbar i Scid. 
</p>

<p><footer>(Uppdaterat: Scid 2.6, Augusti 2001)</footer></p>
}


##################################
### Tournament Finder window help:

set helpTitle(W,Tmt) "Sk turneringar"
set helpText(W,Tmt) {<h1>Sk turneringar</h1>

<h3>Sk turneringar</h3>

<p>
Sk turneringar lter dig hitta turneringar i den aktuella databasen. 
Den sker i alla databasepartier och samlar data om de funna turneringarna. 
Observera att tv partier anses vara i samma turnering om de har 
samma Evenemangsmarkering , samma Ortsmarkering och spelades inom tre mnader. 
</p>

<p>
Du kan begrnsa listan p turneringar med antalet spelare och partier, 
datum, genomsnittling Elo rating och land genom att ndra i flten nedanfr turneringslistan 
och sedan trycka p Uppdateraknappen. 
</p>

<p>
Den visade listan kan sorteras efter datum,antal spelare, antal partier, 
genomsnittlig Elo , Ort, Evenemang eller Namn . Vlj kategori 
i <b>[Sorterings]</b> menyn eller klicka p en kolumntitel fr att frndra i sorteringsfltet. 
</p>

<p>
Fr att ladda det frsta partiet i en visad turnering klicka bara med vnster musknapp 
nr dess rad markerats. Detta kommer ocks att uppdatera Korstabellfnstret om det
r ppnat. 
Om du istllet trycker hger musknapp kommer partiet att laddas och korstabellfnstret
blir ppnat ven om det r stngt. 
</p>

<p>
Fr att snabba upp turneringsskningar r det en bra id att vlja en ganska litet omrde 
(som ngra r) eller vlja ett speciellt land (efter dess trebokstavs standardkod). 
Genom detta minskas kraftigt det antal partier Scid mste g igenom fr att bilda 
turneringar av partierna i databasen. 
</p>

<p><footer>(Uppdaterat: Scid 3.3, April 2002)</footer></p>
}


####################
### Tree window help:

set helpTitle(W,Tree) "Trdfnstret"
set helpText(W,Tree) {<h1>Trdfnstret</h1>

<h3>Trdfnstret</h3>

<p>
Trdfnstret visar information om alla drag som gjorts frn den aktuella 
positionen i partier i databasen. I trdmoden uppdateras trdfnstret 
automatiskt nr brdet p huvudfnstret ndras. Detta kan vara lngsamt 
fr stora databaser. 
</p>

<p>
Observera att nr trdfnstret uppdateras nollstlls filtret och bara de partier 
som innehller den aktuella positionen inkluderas. 
</p>

<p>
Genom att trycka p vnster musknapp p ett drag i trdfnstret s adderas detta drag
till partiet. 
</p>

<h3>Trdfnstrets innehll</h3>

<p>
Trdfnstret visar ECO koden (om den finns), frekvens (bde som antal 
partier och en procentsats) och vrderingen av varje drag. 
Vrderingen berknas alltid frn vits perspektiv, 
s 100% betyder att vit vinner alla partier  
medan 0% betyder att svart vinner alla partier. 
</p>

<p>
Dragen i trdfnstret kan sorteras efter drag (alfabetiskt), 
ECO-kod, frekvens, eller vrdering. Du kan ndra sorteringsmetod i 
<b>[Sorterings]</b> menyn. 
</p>

<h3>Bsta partier</h3>

<p>
Trdfnstret har ett filmenykommando och knapp fr att ppna de 
Bsta partierna, vilka visar en lista p de hgst rankade partierna i 
den aktuellt visade trdgrenen. Partierna listas efter genomsnittlig 
rating och du kan begrnsa listan till att visa partier med ett speciellt 
resultat. 
</p>

<h3>Trdgraffnstret</h3>

<p>
Trdfnsterknapparna inkluderar en knapp markerad Graph som ger 
en grafisk visning av det relativa utfallet fr varje drag frn den aktuella 
positionen. Alla drag som har spelat minst 1% och minst 5 gnger visas. 
Procentsiffror r alltid frn vits perspektiv ven nr det r svarts drag. 
</p>

<p>
I trdgrafen plottas en rd linje fr att visa genomsnittet av alla partier 
frn den aktuella positionen och ytan mellan 50-55% (som de flesta 
standardppningar frvntas f) r markerad med bltt fr att assistera 
jmfrandet av drag. Observera att vit vanligtvis vinner cirka 55% av 
schackmstarpartierna. 
</p>

<h3>Lsa trdfnstret</h3>

<p>
Lsknappen i trdfnstret kan anvndas fr att lsa trdet till den 
aktuella databasen. Detta betyder att trdet kommer att fortstta att
anvnda denna databas ven nr du byter till en annan ppnad databas. 
Detta r anvndbart om du viss anvnda en stor databas som en referens 
nr du spelar igenom ett parti i en annan databas: 
bara ppna trdet i referensdatabasen, ls det och vxla sedan till
den andra databasen. 
</p>

<h3>Trning</h3>

<p>
Nr Trningscheckrutan i trdfnstret vljs kommer Scid  
slumpmssigt att gra ett drag varje gng du lgger till ett drag till partiet. 
Draget som Scid vljer beror p databasstatistiken, s ett drag som spelats
i 80% av databaspartierna kommer att vljas av Scid med 80% 
sannorlikhet. Att starta denna funktion och sedan dlja (eller ikonifiera)  
trdfnstret och spela ppningar mot en stor databas r ett bra stt att
testa din kunskap om ppningsrepetoaren. 
</p>

<h3>Anvnda Trdet med ppnade EPD-filer</h3>

<p>
Fr varje ppnad EPD-fil kommer trdfnstret att innehlla en extra kolumn 
som visar en kort (fem tecken) sammanfattning av innehllet i 
EPD-filen fr varje position som ns frn de listade dragen. 
</p>

<p>
Sammanfattningen kan vara en vrdering, en ppnings ECO-kod eller ett freslaget drag; 
det kommer att vara innehllet i det frsta EPD-fltet hittat frn fljande lista: 
ce, eco, nic, pv, pm, bm, id
eller bara det frsta EPD-fltet om ingen av de ovan nmnda finns. 
</p>

<p>
Fr en beskrivning av EPD flten, se EPD-fil hjlpsidan. 
Observera att om sammanfattningen r av ce fltet, 
visas det som en vrdering i bnder frn vits perspektiv
(istllet fr som em vrdering i hundradelsbnder frn perspektivet av sidan vid draget, 
som det sparas i EPD-filen) fr att frbttra lsbarheten. 
</p>

<h3>Cache fr snabbare resultat</h3>

<p>
Scid har en cache fr trdskresultat fr de positioner med de 
mest matchande partierna. Om du gr framt och bakt i ett parti 
i trdmod kommer du att se att trdfnstret uppdateras  nstan omedelbart 
nr positionen som sks finns i cachen. 
</p>

<p>
Trdfnstret har ett filmenykommando kallat Spara Cache. 
Nr du vljer detta kommer det aktuella innehllet i trdcachen att sparas till 
en fil (med filndelsen * .stc) fr att snabba upp framtida anvndning av 
Trdmoden med denna databas. 
</p>

<p>
Fyll cache filkommandot i filmenyn fr trdfnstret fyller cachefilen med data fr 
mnga ppningspositioner. Det gr en trdskning fr omkring 100 av de mest 
vanliga ppningspositionerna och sparar sedan cachefilen. 
</p>

<p>
Observera att en trdcachefil (*.stc) r helt verfldig; 
du kan ta bort den utan att pverka databasen, 
och den tas ven bort av Scid nr en tgrd grs som kan gra den icke uppdaterad 
som till exempel att lgga till eller erstta ett parti eller sortera databasen. 
</p>

<p><footer>(Uppdaterat: Scid 3.0, November 2001)</footer></p>
}


################
### Graphs help:

set helpTitle(W,Graphs) "Graffnster"
set helpText(W,Graphs) {<h1>Graffnster</h1>

<h3>Graffnster</h3>

<p>
Scid har ett antal fnster som visar information grafiskt. 
De frklaras hr nedanfr. 
</p>

<h3>Filtergraffnstret</h3>

<p>
Filtergraffnstret visar trender efter datum eller efter Elo-rating fr 
partierna i det aktuella filtret jmfrt med hela databasen. 
Till exempel r det anvndbart nr trdet r ppnat som ett redskap 
fr att visa hur den aktuella ppningspositionen har frndrats i popularitet 
p senare r eller tiotal r eller om det r speciellt populrt bland hgre-rankade 
spelare som stormstare. Varje pong p grafen representerar antalet partier i 
filtret per 1000 partier i hela databasen, 
fr ett speciellt dator eller ett visst Eloratingomrde. 
</p>

<p>
Nr filtergrafen plottas efter rating anvnder Scid den genomsnittliga 
(aritmetiskt medelvrde) ratingen fr varje parti. Uppskattade ratings 
(som de som finns i stavningsfilen) anvnds inte. Om en spelare i ett 
parti har en rating men motstndaren inte har det, 
antas motstndaren ha samma upp till 2200. 
Till exempel, om en spelare r rankad 2500 och motstndaren inte 
har en rating blir genomsnittsratingen (2500+2200)/2=2350. 
</p>

<h3>Ratinggraffnstret</h3>

<p>
Ratinggraffnstret visar ratinghistorian fr en spelare eller tv 
spelare i det aktuella partiet. Du kan producera grafen fr en spelare 
genom att trycka p Ratinggrafknappen i spelarinformationsfnstret 
eller skapa den fr de tv spelarna i de aktuella partiet genom att vlja Ratinggraf 
frn <b>[Verktygs]</b> menyn. 
</p>

<h3>Vrderingsgraffnstret</h3>

<p>
Vrderingsgraffnstret visar de numeriska vrderingarna (pong) 
sparade i kommentarerna till det aktuella partiet som en graf. 
Du kan klicka med vnster musknapp ngonstans i vrderingsgrafen fr att g till
motsvarande position i partiet. 
</p>

<p>
Tv typer av vrderingskommentarer finns: dessa produceras av Scids analysfnster
(som har formatet 1.e4 {"+0.25 ...."} r alltid vrderade frn vits perspektiv) 
och de som produceras av Craftys analyskommando 
(som har formatet 1.e4 ({9:+0.25} ....) och ocks r vrderade frn vits perspektiv). 
</p>

<h3>Trdgraffnstret</h3>

<p>
Trdgraffnstret finns i trdfnstret. Det visar resultatet av de mest populra
dragen frn den aktuella positionen. 
Mer information finns i avsnittet om trdfnster. 
</p>

<p><footer>(Uppdaterat: Scid 3.3, April 2002)</footer></p>
}


####################
### Tablebases help:

set helpTitle(W,TB) "Slutspelstabeller"
set helpText(W,TB) {<h1>Slutspelstabeller</h1>

<h3>Slutspelsdatabaser</h3>

<p>
En slutspelsdatabas r en fil som innehller den perfekta resultatinformationen om alla positioner 
med ett visst material , som Kung och Torn mot Kung och Bonde. 
Slutspelstabeller fr alla materiella situationer med upp till fem pjser (inklusive Kungar) 
har genererats och ngra enkla 6-pjsslutspelstabeller finns ocks tillgngliga. 
</p>

<p>
Scid kan anvnda slutspelsdatabaser i Nalimov-format som anvnds av mnga nyare schackmotorer. 
Dessa slutar ofta med ndelserna .nbw.emd eller .nbb.emd. Alla 3-, 4- och 5-pjs 
Nalimov-slutspelstabeller kan anvndas i Scid. 
</p>

<h3>Anvnda slutspelstabeller i Scid</h3>

<p>
Fr att anvnda slutspelstabeller i Scid specificera bara deras kataloger
genom att vlja Slutspelstabellkatalog i <b>[Alternativ]</b> menyn. Du kan vlja upp till 
4 kataloger dr dina slutspelstabeller r sparade. Du kan trycka p ... 
knappen till hger om en inmatning fr att vlja en katalog fr att specificera att
katalogen till den ska anvndas. 
</p>

<p>
Nr en position som hittats i slutspelstabellen har ntts visar partiinformationsytan 
nedanfr schackbrdet slutspelstabellinformation. 
Du kan konfigurera mngden information som visas genom att klicka med den hgra
musknappen i den eller vlja Partiinformation frn  <b>[Alternativ]</b> menyn. 
Genom att vlja "Resultat och bsta drag"  ges den mest anvndbara informationen, 
men det r ofta mycket lngsammare n "Bara resultat". 
</p>

<h3>Slutspelstabellfnster</h3>

<p>
Du kan f nnu mer slutspelstabellinformation om den aktuella positionen genom att 
ppna Slutspelstabellfnstet i ([Fnster] menyn, tangentkombination: <b>Ctrl+Shift+=</b>). 
Detta fnster visar resultatet med perfekt spel av alla legala drag frn den 
aktuella positionen. 
</p>

<p>
Fnstret har tv huvudsakliga delar. Sammanfattningsdelen (till vnster) visar 
vilka slutspelstabeller Scid har hittat p din dator och en sammanfattning fr varje 
slutspelstabell. Resultatdelen (till hger) visar optimala resultat fr alla drag frn den
aktuella positionen som visas i huvudfnstret. 
</p>

<h3>Sammanfattningsdelen</h3>

<p>
Den vre delen av sammanfattningsdelen lter dig vlja en speciell slutspelstabell. 
De som du har tillgngliga visas i bltt och de slutspelstabeller som inte finns visas
i grtt. Den nedre delen av sammanfattningsdelen visar sammanfattningsinformation
fr den valda slutspelstabellen. 
(Alla slutspelstabeller har inte en sammanfattning i Scid) 
</p>

<p>
Sammanfattningen inkluderar frekvensen(hur mnga partier per million som nr 
en position med detta material berknat frn en databas med mer n 
600000 msterpartier), en lngsta matt fr en sida samt antalet 
msesidiga (eller "reciprokala") dragtvng. Ett msesidigt dragtvng r en 
position dr vit vid draget fr remi och svart vid draget frlorar eller dr 
vit vid draget frlorar och svart vid draget fr remi eller dr den som r vid draget
frlorar. 
</p>

<p>
Fr ngra slutspelstabeller med msesidiga dragtvng visar sammanfattningen 
ocks en lista p alla dragtvngspositioner eller ett urval av dem. En fullstndig
lista p alla slutspelstabeller r inte mjlig eftersom vissa slutspelstabeller har 
tusentals msesidiga dragtvng. 
</p>

<p>
Du kan stta upp en slumpmssig position frn den valda slutspelsdatabasen
genom att trycka p Slumpknappen. 
</p>

<h3>Resultatdelen</h3>

<p>
Resultatdelen uppdateras nr schackbrdet i huvudfnstret ndras. 
Den frsta linjen visar hur mnga drag vinner (+), ger remi (=), frlorar (-), 
eller har ett oknt resultat (?). Resten av resultatdelen ger en mer detaljerad 
lista p resultat, rangordnande dem frn kortaste till lngsta matt, sedan remier, 
sedan lngsta till kortaste frluster. Alla avstnd r till matt. 
</p>

<h3>Resultatbrdet</h3>

<p>
I en slutspelstabellposition r det ofta anvndbart att se vad 
slutspelstabellresultatet skulle vara om alla pjser i den aktuella
positionen var p sina aktuella rutor men en srskild pjs flyttas ngon 
annanstans. Till exempel kan du vilja bestmma hur nra en kung mste vara
till en fribonde fr att vinna eller f remi i en srskild position. I slutspelsbcker
kallas denna information ofta vinstzonen eller remizonen fr en pjs i en position. 
</p>

<p>
Du kan hitta denna information i Scid genom att trycka p knappen med en
bild p schackbrdet fr att visa resultatbrdet i slutspelstabellfnstret. 
Nr du trycker p vnster musknapp p ngon av pjserna p brdet visas 
en symbol i varje tom ruta visande vad slutspelstabellresultatet blir 
(med samma sida vid draget som i den aktuella positionen p huvudfnstret) 
om den valda pjsen var p den rutan. 
</p>

<p>
Det finns fem olika symboler en ruta kan ha: en vit # betyder att vit vinner; 
ett svart  # betyder att svart vinner; ett bltt = betyder att positionen r remi; 
ett rtt X betyder  att positionen r illegal (eftersom kungarna str brevid 
varandra eller sidan vid draget ger schack); och ett rtt ? betyder att resultatet 
r oknt beroende p att den ndvndiga slutspelstabellen inte finns tillgnglig. 
</p>

<h3>F tillgng till slutspelstabellsfiler</h3>

<p>
Se avsnittet om relaterade lnkar fr hjlp med att hitta slutspelstabeller p Internet. 
</p>

<p><footer>(Uppdaterat: Scid 3.4, September 2002)</footer></p>
}


###################
### Bookmarks help:

set helpTitle(W,Bookmarks) "Bokmrken"
set helpText(W,Bookmarks) {<h1>Bokmrken</h1>
<p>
Scid lter dig bokmrka viktiga partier fr enkel framtida referens. 
Bokmrkesmenyn finns i <b>[Arkiv]</b> menyn och i verktygsraden och har
tangentkombinationen: 
<b>Ctrl+B</b> . 
</p>

<p>
Nr du vljer ett bokmrkt parti frn Bokmrkesmenyn 
kommer Scid att ppna dess databas om det r ndvndigt, hitta partiet, 
och g till den schackposition som var nr den bokmrktes. 
</p>

<p>
Bara partier i en Scidformaterad databas (inte en PGN-fil eller Clipbasen) 
kan bokmrkas. 
</p>

<p>
Om databasen till ett bokmrkt parti sorteras eller kompimeras kan 
bokmrkesdetaljerna bli inaktuella. Nr det hnder kommer Scid att
ska igenom databasen efter det bst matchande partiet 
(jmfr Spelare, Ort, Resultat, r etc) nr bokmrket vljs, 
s att det bokmrkta partiet fortfarande blir laddat. Men om 
detaljerna i det bokmrkta partiet ndras r det mjligt att ett annat 
parti kommer att matcha bokmrkesdetaljerna bttre och laddas istllet. 
S det r en bra id att om-bokmrka ett parti om du ndrar i dess 
Spelare, Ort, Resultat, Runda eller r. 
</p>

<h3>ndra bokmrken</h3>
<p>
Med bokmrkeseditorn kan du ndra menytexten som visas fr varje 
bokmrkt parti och lgga till kataloger fr att kategorisera bokmrken. 
</p>
<h3>Tips</h3>
<p>
Du kan anvnda bokmrken fr snabb tillgng till databaser du ofta 
anvnder genom att bokmrka ett parti frn varje databas. En annan 
god anvndning fr bokmrken r att lgga till viktiga partier du hittar
nr du studerar en viss schackppning. 
</p>

<p>
Bokmrkesmenyn innehller tv alternativ fr att kontrollera visandet av 
bokmrkeskataloger : de kan visas som undermenyer 
(anvndbart nr det finns mnga bokmrken) eller som en enkel lista. 
</p>

<p><footer>(Uppdaterat: Scid 3.0, November 2001)</footer></p>
}


##############################
### Command-line options help:

set helpTitle(W,Cmdline) "Kommandorad-alternativ"
set helpText(W,Cmdline) {<h1>Kommandorad-alternativ</h1>
<h3>Kommandorad-alternativ</h3>
<p>
Nr du startar Scid frn ett grnsnitt eller consol, 
finns det kommandorad-alternativ du kan specificera. 
Scid-format databaser (med eller utan en filndelse som <b>"*.si3"</b>) 
och PGN-filer att ppna kan anges, till exempel: 
<b>scid minbas nyapartier.pgn</b> 
kommer att starta Scid och ppna Scid-databasen <b>mybase</b> och  
PGN-filen <b>nyapartier.pgn</b>. 
</p>

<p>
Det finns ocks optionella argument fr att kontrollera vilka filer Scid 
ska leta efter och anvnda nr det startar.
Du kan stnga av anvndningen av slutspelstabeller med <b>-xtb</b> (eller <b>-xt</b>) alternativet, 
undvika att ladda in ECO ppningsklassificeringsfiler med <b>-xeco</b> eller <b>-xe</b>, 
och undvika att ladda in stavningsfilen med -xspell eller -xs.
Utver detta ger alternativet <b>-fast</b> eller <b>-f</b> alla dessa tre saker , 
s <b>scid -f</b> r samma som <b>scid -xeco -xspell -xtb</b>. 
</p>

(Updaterat: Scid 3.1, November 2001)


}


####################
### Compaction help:

set helpTitle(W,Compact) "Komprimera databas"
set helpText(W,Compact) {<h1>Komprimera databas</h1>
<p>
<h3>Komprimera databas</h3>

<p>
Att komprimera en databas r en speciell typ av underhll 
som hller en databas s liten och effektiv som mjligt. 
Att komprimera en databas betyder att ta bort allt oanvnt
utrymme i dess filer . Det finns tv typer: namnfils- och partifilskomprimering. 
</p>

<h3>Namnfilskomprimering</h3>

<p>
ver tiden kan du finna att databasen brjar att innehlla ett antal spelarnamn, 
evenemangs-, orts- eller rundenamn som inte lngre anvnds i ngot parti. 
Detta hnder ofta efter att du stavningskontrollerar namn. 
De oanvnda namnen slsar utrymme i namnfilen och kan sakta mer namnskningar. 
Namnfilskomprimering tar bort alla namn som inte anvnds i ngot parti. 
</p>

<h3>Partifilskomprimering</h3>

<p>
Nr ett parti erstts eller tas bort lmnas oanvnt utrymme i partifilen
(den strsta av de tre filerna i en Scid databas). 
Partifilskomprimering tar bort allt oanvnt utrymme och lmnar inga borttagna partier
i databasen. Observera att denna operation r slutgiltig:
efter komprimering r de bortagna partierna borta fr evigt! 
</p>

<p>
Partifilskomprimering rekommenderas ocks efter att ha sorterat en databas fr att
hlla ordningen p partifilen konsistent med den sorterade indexfilen. 
</p>

<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}


####################################
### Database maintenance tools help:

set helpTitle(W,Maintenance) "Underhll databas"
set helpText(W,Maintenance) {<h1>Underhll databas</h1>

<h3>Underhll databas</h3>
<p>
Scid har ett antal redskap fr att underhlla databaser, 
tillgngliga frn Scids Arkivmeny. Databaskomprimeringen 
och sorteringsfunktionerna frklaras i separata avsnitt. 
</p>


<h3>Underhllsfnstret</h3>
<p>
Det mesta av Scids databasunderhll kan gras frn underhllsfnstret 
, som kan ppnas frn 
<b>[Arkiv: Underhll]</b> eller <b>[Fnster]</b> menyerna eller med tangentkombinationen:
<b>Ctrl+M</b>. 
</p>

<p>
Du kan anvnda detta fnster fr att underhlla partimarkeringar, 
stavningskontrollera namn, komprimera eller sortera en databas. 
Observera att alla operationer som inte finns tillgngliga fr den aktuella
databasen (till exempel, p grund av att den r skrivskyddad eller en 
PGN-fil) visas med gr frg. 
</p>

<h3>Ta bort dubbla partier</h3>
<p>
I <b>[Arkiv: Underhll]</b> menyn finns ett kommando <b>[Ta bort dubbla partier...]</b> 
fr att detektera extra kopior (dubbletter) av partier i databasen. 
Detta kommando hittar alla dubbletter och fr varje par markeras det kortare 
partiet fr borttagning medan det lngre partiet lmnas kvar. 
Tv partier anses vara dubbletter om spelarna 
(och alla andra markeringar som du kan specificera) matchar exakt.
</p>

<p>
Om du specificerar  "samma drag" alternativet mste varje par av partier ha 
samma drag upp till lngden av det kortare partiet 
(eller upp till drag 60) fr att vara dubbletter. 
</p>

<p>
Nr du har tagit bort dubbletter r det en bra id att kontrollera att 
varje borttaget parti verkligen r en kopia av ett annat parti. Du kan gra detta
enkelt om du valde "Stt filter till alla borttagna partier" alternativet i ta bort
dubbletter dialogrutan. Filtret kommer d att innehlla alla borttagna partier. 
Du kan blddra genom dem  (med <b>p</b> och <b>n</b> tangenterna) med kontrollera 
dubbla partier fnstret  (finns i underhllsmenyn eller med tangentkombinationen <b>Ctrl+Shift+T</b>) 
fr att verifiera att varje borttaget parti r borttaget fr att det faktiskt r en dubblett av ett
annat parti. 
</p>

<h3>ndra spelar, evenemang, ort och rundenamn</h3>

<p>
Du kan finna felstavade namn i din databas och vilja korrigera dem. 
Du kan gra detta i Scid med Namneditorfnstret 
(tangentkombination: <b>Ctrl+Shift+N</b>), som finns i <b>[Arkiv: Underhll]</b>
undermenyn. 
</p>

<p>
Varje unikt namn lagras bara en gng i namnfilen, s om du ndrar ett namn s
ndrar du alla frekomster av det. 
</p>
<h3>Stavningskontrollera namn</h3>
<p>
Scid kommer med en stavningskontrollfil med namnet spelling.ssp, 
fr att korrigera spelar-, evenemang-, orts- och rundenamn. 
Scid kommer att frska ladda stavningskontrollfilen nr det startar; 
om den inte laddas in d kan du ladda in den frn <b>[Alternativ]</b> menyn. 
</p>

<p>
Nr stavningskontrollfilen r laddad kan du anvnda den p en Scid databas med 
stavningskontrollkommandorna i  <b>[Arkiv: Underhll]</b> menyn eller frn 
underhllsfnstret. 
</p>

<p>
Nr du stavningskontrollerar en databas producerar Scid en lista p korrektioner som du 
kan ndra i innan ngra ndringar grs, s att du kan ta bort alla korrektioner du inte
vill gra.
</p>

<p>
Stavningskontroll r speciellt viktigt fr att standardisera en databas s att alla frekomster
av en speciell spelare stavas likadant. Till exampel, med standard stavningskontrollfilen, 
s korrigeras namnen "Kramnik,V.", "Vladimir Kramnik", och "V. Kramnik" till "Kramnik, Vladimir". 
</p>

<p>
Stavningskontrollfilen har en ytterligare anvndning: nr den laddas anvnds dess spelardata
fr att frbttra spelarinformationsfnstret och korttabellfnstret: : du kommer att se FIDE 
mstartitlar som (gm = Internationell Stormstare, im = Internationell Mstare, etc) och 
landsinformation fr spelarna listas i stavningskontrollfilen. 
ver 6500 starka spelare frn historien och nutiden finns listade i <b>spelling.ssp</b> filen som 
kommer med Scid. 
</p>

<h3>Lgga till Elo rating till partier</h3>

<p>
"Lgg till Elo rating..." knappen i underhllsfnstret fr Scid att ska igenom den aktuella 
databasen efter partier dr en spelare inte har en rating, men dr stavningskontrollfilen 
har en Elo rating listad fr denna spelare vid tiden fr partiet. Scid kommer att lgga till all 
sdan rating automatiskt. Detta r mycket anvndbart fr en databas med mstarpartier 
som har f ratings.
</p>

<p>
Stavningskontrollfilen "spelling.ssp" som kommer med Scid innehller inte Elo rating 
informationen som behvs fr denna funktion, men en strre variant av den kallad "ratings.ssp" 
finns p Scids webbsajt. 
</p>

<h3>Rensaren</h3>
<p>
Rensaren (som finns i Underhllsfnstret) r ett redskap fr att gra ett antal 
underhllsarbeten p en databas med en tgrd. Du kan vlja vilka arbeten du vill 
gra och Scid kommer att utfra dem p den aktuella databasen utan att krva
anvndarinteraktion. Detta r speciallt anvndbart fr underhll av stora databaser. 
</p>

<h3>Stlla in att databasen ska ladda in ett parti automatiskt</h3>
<p>
Vid automatiskt laddande av ett parti i en databas s laddas detta parti in nr denna 
databas ppnas. Fr att ndra det automatiska laddandet av partiet i databasen, 
anvnd "Autoladda parti nummer..." knappen. Om du alltid vill att det sista partiet i en 
databas ska ppnas  (oavsett om hur mnga partier som finns i databasen),
s stll in det till ett hgt nummer som 9999999. 
</p>

<p><footer>(Uppdaterat: Scid 3.1, December 2001)</footer></p>
}


##############
### ECO guide:

set helpTitle(W,ECO) "ECO"
set helpText(W,ECO) {<h1>ECO-ppningsklassificering</h1>

<h3>ECO ppningsklassificering</h3>
<p>
Scid kan klassificera schackpartier enligt ECO 
(Encyclopedia of Chess Openings) schackppningsklassificering. 
En standard ECO-kod bestr av en bokstav (A-E) fljt av tv siffror, 
s det finns 500 distinkta standard ECO-coder. 
</p>

<h3>Scids utvidgningar av ECOs ppningsklassificering</h3>

<p>
ECO klassificeringen r vldigt begrnsad och inte tillrcklig fr moderna partier:
ngra av de 500 koderna syns nstan aldrig, medan ngra syns vldigt ofta. 
Fr att frbttra denna situation tillter Scid en optionell utkning av de grundlggande 
ECO-koderna: varje kod kan bli utkad med en bokstav (a-z) som dessutom kan utkas
ytterligare (med en siffra frn 1-4)  men det anvnds inte nnu i standard Scid ECO-filen . 
S en utkad Scid ECO-kod ser ut antingen som "A41e" eller som "E99b2". 
Mnga av de mest vanliga ECO-koderna som finns i moderna mstarpartier har
utkningar definerade i Scids ECO-fil. 
</p>

<h3>ECO Blddrarfnstret</h3>

<p>
ECO Blddrarfnstret visar dig de positioner som anvnds fr att klassificera varje ECO-kod, 
samt frekvensen och resultatet av ECO-koderna i den aktuella databasen. 
</p>

<p>
Den vre delen visar frekvensen fr varje ECO-kod i den aktuella databasen. 
Frgerna i grafen finns i tre sektioner: den lgsta (ljusaste frgen) visar antalet vita vinster, 
den mittersta visar antalet remier, och den hgsta (mrkaste frgen) visar antalet svarta vinster. 
Detta lter dig snabbt se om en ppning r bra eller dlig fr vit eller om remier r mycket vanliga. 
</p>

<p>
Fr att g till en djupare ECO niv klicka med vnster musknapp p en del av grafen
(eller skriv den bokstav eller siffra den motsvarar). Fr att g tillbaka till en hgre niv, 
klicka med hger musknapp i grafen eller tryck p vnsterpilen (eller delete eller bakt). 
</p>

<p>
Den nedre delen visar de positioner som utgr en speciell ECO-kod, 
enligt den ECO-fil som du har ppnat. 
</p>

<h3>ppna Scids ECO-fil</h3>
<p>
ECO-filen som kommer med Scid heter scid.eco och Scid frsker att ppna den nr det 
startar. Om Scid inte kan hitta den behver du gra fljande fr att anvnda 
ECO-klassificeringen: 
</p>

<p>
(a) I Scid anvnd menykommandot <b>[Alternativ: Ladda ECO-fil]</b> och vlj filen <b>scid.eco</b>. 
(b) Spara alternativ (i  <b>[Alternativ]</b> menyn). 
Efter att du har gjort deta kommer ECO-filen att laddas varje gng du startar Scid. 
</p>

<h3>ECO-koderna</h3>
<p>
Den grundlggande strukturen i ECO r:
</p>

A 1.d4 Nf6 2...; 1.d4 ...; 1.c4; 1.diverse
<ul>
<li>A0 1.diverse (A02-A03 1.f4: Birds ppning, A04-A09 1.Nf3: Reti, Kungsindisk attack) </li>
<li>A1 1.c4 ...: Engelsk </li>
<li>A2 1.c4 e5: Kungsengelsk </li> 
<li>A3 1.c4 c5: Engelsk, Symmetriskt </li> 
<li>A4 1.d4 ...: Dambonde </li>
<li>A5 1.d4 Nf6 2.c4 ..: Indiskt frsvar </li> 
<li>A6 1.d4 Nf6 2.c4 c5 3.d5 e6: Modern Benoni </li> 
<li>A7 A6 + 4.Nc3 exd5 5.cxd5 d6 6.e4 g6 7.Nf3 </li>
<li>A8 1.d4 f5: Hollndskt frsvar </li>
<li>A9 1.d4 f5 2.c4 e6: Hollndskt frsvar </li>
</ul>
B 1.e4 c5; 1.e4 c6; 1.e4 d6; 1.e4 diverse 
<ul>
<li>B0 1.e4 ... (B02-B05 1.e4 Nf6: Alekhines frsvar; B07-B09 1.e4 d6: Pirc) </li>
<li>B1 1.e4 c6: Caro-Kann </li>
<li>B2 1.e4 c5: Sicilianskt frsvar </li> 
<li>B3 1.e4 c5 2.Nf3 Nc6: Sicilianskt </li>
<li>B4 1.e4 c5 2.Nf3 e6: Sicilianskt </li>
<li>B5 1.e4 c5 2.Nf3 d6: Sicilianskt </li>
<li>B6 B5 + 3.d4 cxd4 4.Nxd4 Nf6 5.Nc3 Nc6 </li>
<li>B7 B5 + 4.Nxd4 Nf6 5.Nc3 g6: Siciliansk Drake </li>
<li>B8 B5 + 4.Nxd4 Nf6 5.Nc3 e6: Siciliansk Scheveningen </li> 
<li>B9 B5 + 4.Nxd4 Nf6 5.Nc3 a6: Siciliansk Najdorf </li>
</ul>
C 1.e4 e5; 1.e4 e6 

<ul>
<li>C0 1.e4 e6: Franskt Frsvar </li>
<li>C1 1.e4 e6 2.d4 d5 3.Nc3: Franskt, Winawer/Klassisk </li> 
<li>C2 1.e4 e5: ppet parti </li>
<li>C3 1.e4 e5 2.f4: Kungsgambit </li>
<li>C4 1.e4 e5 2.Nf3: ppet parti </li>
<li>C5 1.e4 e5 2.Nf3 Nc6 3.Bc4: Italienskt; Tvspringar </li>
<li>C6 1.e4 e5 2.Nf3 Nc6 3.Bb5: Spanskt (Ruy Lopez) </li>
<li>C7 1.e4 e5 2.Nf3 Nc6 3.Bb5 a6 4.Ba4: Spanskt </li>
<li>C8 C7 + 4...Nf6 5.O-O: Spanskt, ppet och Stngt (C80-C83 5.O-O Nxe4: Spanskt, ppet system; C84-C89 5.O-O Be7: Spanskt, Stngt system) </li>
<li>C9 C8 + 5...Be7 6.Re1 b5 7.Bb3 d6: Spanskt, Stngt </li>
</ul>
D 1.d4 d5; 1.d4 Nf6 2.c4 g6 med 3...d5 
<ul>
<li>D0 1.d4 d5: Dambonde </li>
<li>D1 1.d4 d5 2.c4 c6: Slaviskt frsvar </li> 
<li>D2 1.d4 d5 2.c4 dxc4: Antagen damgambit </li>
<li>D3 1.d4 d5 2.c4 e6: Avbjd damgambit  </li>
<li>D4 D3 + 3.Nc3 Nf6 4.Nf3 c5/c6: Semi-Tarrasch; Semi-Slav </li>
<li>D5 D3 + 3.Nc3 Nf6 4.Bg5: Avbjd klassisk damgambit</li>
<li>D6 D5 + 4...Be7 5.e3 O-O 6.Nf3 Nbd7: Avbjd  ortodox damgambit </li>
<li>D7 1.d4 Nf6 2.c4 g6 with 3...d5: Grnfeld </li>
<li>D8 1.d4 Nf6 2.c4 g6 3.Nc3 d5: Grnfeld </li>
<li>D9 1.d4 Nf6 2.c4 g6 3.Nc3 d5 4.Nf3: Grnfeld </li>
</ul>
 
E 1.d4 Nf6 2.c4 e6; 1.d4 Nf6 2.c4 g6 

<ul>
<li>E0 1.d4 Nf6 2.c4 e6: Katalanskt, mm </li>
<li>E1 1.d4 Nf6 2.c4 e6 3.Nf3 (b6): Damindiskt, mm </li>
<li>E2 1.d4 Nf6 2.c4 e6 3.Nc3 (Bb4): Nimzo-Indiskt, mm </li>
<li>E3 E2 + 4.Bg5 or 4.Qc2: Nimzo-Indiskt </li>
<li>E4 E2 + 4.e3: Nimzo-Indiskt, Rubinstein </li>
<li>E5 E4 + 4...O-O 5.Nf3: Nimzo-Indiskt, huvudvariant </li> 
<li>E6 1.d4 Nf6 2.c4 g6: Kungindiskt </li>
<li>E7 1.d4 Nf6 2.c4 g6 3.Nc3 Bg7 4.e4: Kungsindiskt </li>
<li>E8 E7 + 4...d6 5.f3: Kungsindiskt, Smisch </li>
<li>E9 E7 + 4...d6 5.Nf3: Kungsindiskt, huvudvarianter </li>
</ul>

<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}

####################
### Calvar window help:

set helpTitle(W,CalVar) "Berkning av variationer"
set helpText(W,CalVar) {<h1>Berkning av variationer-fnstret</h1>
  <p>
Denna trningsvning r ocks knd som Stoyko-vningen.
Dess syfte r att analysera en komplex position och utvrdera s mnga sunda variationer som mjligt,
och ge en korrekt vrdering fr varje av dem.
  </p>
<p><h3>Konfiguration</h3></p>
Tre parametrars anges :
<ul>
<li>Den UCI-schackmotor som kommer att analysera olika variationer</li>
<li>Den tid, i sekunder, som schackmotorn kommer att anvnda fr att analysera positionen</li>
<li>Den tid, i sekunder, som schackmotorn kommer att anvnda fr att analysera varje variation som har angivits av anvndaren</li>
</ul>
<p><h3>Ange variationer</h3></p>
Drag anges som vanligt med musklick p brdet men de visas inte. Vid slutet p varje variation behver anvndaren ange en vrdering genom att klicka p en av knapparna med NAG-vrden.
  <p><h3>Vrderingsverifikation</h3></p>
Varje gng en vrdering anges till en variation berknar schackmotorn dess vrde och lgger till variationen och vrderingen precis nedanfr anvndarens.
  <p><h3>Klar med position</h3></p>
Nr anvndaren tror att han har hittat alla de bsta variationerna, kommer tryckandet p <b>Klar med position</b> att lgga till i partiet
(med kommentaren <b>Missad variation</b>), de variationer som har en hgre vrdering n de bsta variationerna som har angetts av anvndaren.

  <p><footer>(Uppdaterat: Scid 3.6.21, December 2007)</footer></p>
}

####################
### EPD files help:

set helpTitle(W,EPD) "EPD"
set helpText(W,EPD) {<h1>EPD-filer</h1>

<h3>EPD filer</h3>
<p>
En EPD (extended position description) fil r en samling av positioner, 
dr varje position har ngon tillhrande text. Det r precis som PGN r det 
en vanlig standard fr schackinformation. 
</p>

<p>
En EPD-fil har ett antal definierade <b>opcodes (flt)</b> som r lagrade 
separade med semikolon <b>(;)</b> i filen men visas p olika rader 
i ett Scid EPD-fnster fr att gra ndringar lttarer. Ett semikolon inom ett 
EPD-flt lagras som <b>"\s"</b> av Scid fr att skilja det frn en markering av slutet av fltet. 
Varje position och dess tillhrande opcodes lagras p en enkel rad i EPD-filen. 
</p>

<p>
Standard <b>EPD-opcodes</b> inkluderar: 
</p>

<p>
<li><b>acd</b> Analysrkning: skdjup.</li> 
<li><b>acn</b> Analysrkning: antal skta noder.</li> 
<li><b>acs</b> Analysrkning: sktid i sekunder.</li> 
<li><b>bm</b> Bsta drag: drag som anses bst av ngon anledning.</li> 
<li><b>ce</b> Hundradelsbondevrdering: vrdering i hundradelar av en bonde fr den sida 
som r vid draget (Observera att detta skiljer sig frn Analysfnstret som visar 
vrderingen i bnder frn vits perspektiv).</li> 
<li><b>cX</b> Kommentar (dr <b>X</b> r en siffra frn 0-9).</li> 
<li><b>eco</b> ECO ppningskod.</li> 
<li><b>id</b> Unik identifikation av denna position.</li> 
<li><b>nic</b> New In Chess (NIC) ppningskod.</li> 
<li><b>pm</b> Frutsptt drag: det frsta draget i den frutspdda variationen (PV).</li> 
<li><b>pv</b> Frutspdd variation: den bsta dragfljden.</li>
</p>

<p>
EPD-filer har ett antal anvndningar: Scid anvnder en EPD-fil fr att klassificera
partier enligt Encyclopedia of Chess Openings (ECO) , 
och du kan skapa en EPD-fil fr din ppningsrepetoar samt 
lgga till kommentarer fr positioner du vanligtvis nr i partier. 
</p>

<p>
Du kan skapa en ny EPD-fil eller ppna en existerande frn  <b>[Ny]</b> och <b>[ppna]</b> 
kommandorna i  <b>[Arkiv]</b> menyn. Som mest kan fyra EPD-filer vara ppnade. 
</p>

<h3>EPD fnster</h3>

<p>
Fr varje ppnad EPD-fil ser du will ett fnster som visar texten fr den aktuella positionen. 
Du behver inte trycka p <b>Spara</b> knappen fr att spara de frndringar du gr med 
en positionstext; texten sparas nr du gr till en annan position i partiet. 
</p>

<h3>Navigera i EPD-filer</h3>

<p>
Fr att blddra genom positionerna i en EPD-fil anvnd <b>[Nsta position]</b> och <b>[Tidigare position]</b> 
kommandorna frn EPD-fnstret i <b>[Verktygs]</b> menyn eller anvnd tangentkombinationerna 
<b>Ctrl+NerPil</b> och <b>Ctrl+UppPil</b>. Dessa kommandon gr till nsta eller fregende position i filen, 
tar bort det aktuella partiet och stller in den nya startpositionen. 
</p>

<h3>Ta bort EPD-flt</h3>

<p>
EPD-filer du finner p Internet kan innehlla flt som inte intresserar dig och de kan 
slsa mycket utrymme i filen. Till exempel, en EPD-fil med datorvrderingar kan ha 
<b>ce</b>, <b>acd</b>, <b>acn</b>, <b>pm</b>, <b>pv</b> och <b>id</b> flt 
men du kanske bara behver <b>ce</b> och <b>pv</b> flten. 
</p>

<p>
Du kan ta bort en EPD-opcode frn alla positioner i EPD-filen genom att anvnda <b>[Ta bort EPD flt]</b> 
frn EPD-fnstret i <b>[Verktygs]</b> menyn. 
</p>

<h3>EPD-fnstrets resultat</h3>

<p>
Alla EPD-fnster visar: 
</p>

<ul>
<li>- filstatus (-- betyder ofrndrad, <b>XX</b> betyder frndrad, och <b>%%</b> betyder skrivskyddad); </li>
<li>- filnamn; </li>
<li>- antal positioner i filen; </li>
<li>- legala drag frn den aktuella positionen fr att n en annan position i denna EPD-fil.</li> 
</ul>
<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}


###################
### Exporting help:

set helpTitle(W,Export) "Exportera partier"
set helpText(W,Export) {<h1>Exportera partier</h1>
<p>
Du kan anvnda funktionerna i <menu>Verktygs</menu>-menyn, fr det
aktuella partiet eller fr alla partier i det aktuella filtret fr att exportera dragen
i en textfil.
</p>
<p>
Tre Textdata-format str till frfogande: <a PGN>PGN</a> (portable
game notation), HTML (fr Webbsidor) och LaTeX (ett populrt
Textbearbetningssystem).
</p>
<p>
Vid export kan du vlja att skapa en ny fil 
eller infoga partierna i en existierande partifil.
</p>

<h3>Diagram</h3>
<p>
Nr du exporterar i HTML- eller LaTeX-format , infogar Scid automatiskt
dr ett diagram , dr det finns en diagram-<a NAGs>NAG</a> ("D")
eller ett med tecknet "#" brjande <a Comment>Kommentar</a>
i partiet .
</p>

<h3><name Null>Null-drag vid PGN-Export</name></h3>
<p>
Scid tillter att det sparas <a Annotating Null>Null- (inga drag)
drag</a> , d dessa kan vara hjlpsamma vid kommentarer av varianter. 
Det finns dock inga Null-drag i PGN-Standarden. 
Nr du d exporterar Scid-partier med Null-drag i en PGN-fil
kan andra program oftast inte lsa in partierna.
</p>
<p>
Fr att lsa detta problem stller Scid en annan funktion till frfogande,
<b>Omvandla Null-drag till kommentarer</b>, nr partier blir exporterade i 
PGN-format. Nr du vill skapa en PGN-fil, som kan anvndas av
andra program, anvnder du denna funktion som omvandlar varianter med nolldrag 
till kommentarer.
Nr du nd vill skapa en PGN-fil, som senare kan importeras av Scid med bibehllande av
Null-drag stnger du av denna funktion.
</p>

<h3>HTML-Export</h3>
<p>
Scid kan exportera partier i en HTML-filer. Fr att infoga diagram ,
mste diagrambilderna finnas (i katalogen "<b>bitmaps/</b>" )
i en underkatalog till "<b>bitmaps/</b>" i katalogen under  HTML-filen.
</p>

<h3>LaTeX-Export</h3>
<p>
Scid kan exportera partier i en LaTeX-fil. Partier blir sparade i
tv kolumner per sida och dragen blir sparade i algebraisk
notation med symboler fr pjserna.
</p>
<p>
Fr mer information se hjlpsidan <a LaTeX>Scid och LaTeX</a>.
</p>

<p><footer>(Uppdaterat: Scid 3.4, Juli 2002)</footer></p>
}


####################
### Flags help:

set helpTitle(W,Flags) "Parti-markeringarna"
set helpText(W,Flags) {<h1>Parti-markeringarna</h1>

<p>
En <term>Markering</term> ("Flags") r ett Knnetecken p ngon
schackegenskap, som kan markeras fr varje parti i databasen. 
Det finns 13 av anvndare instllbara
markeringar, som du kan stta direkt i varje parti . Av dessa
har bara ta bort-markeringen en srskild betydelse: partier, som
r markerade med ta bort-markeringen, r markerade fr att tas bort
och tas bort, nr databasen blir
<a Compact>komprimerad</a> .
</p>
<p>
De andra 12 av anvndare instllbara markeringarna och deras
symboler r:
</p>

<ul>
<li>ppningen Vit (W)</li>
<li>ppningen Svart (B)</li>
<li>Mittspelet (M)</li>
<li>Slutspelet (E)</li>
<li>Nyhet (N)</li>
<li>Bondestruktur (P)</li>
<li>Taktik (T)</li>
<li>Spel p damflygeln (Q)</li>
<li>Spel p Kungsflygeln (K)</li>
<li>Utomordentligt (!)</li>
<li>Blunder (?)</li>
<li>Anvndar-definierat (U)</li>
</ul>

<p>
En markering kan sttas fr det aktuella partiet, fr alla partier i
filtret eller fr alla partier i databasen i
<a Maintenance>Underhlls</a>-fnstret.
</p>
<p>
Du kan anvnda  <a Searches Header>Skning efter Partidata</a> ,
fr att finna alla datenbaspartier , som har en bestmd markering 
eller anvnda markeringarna som en del av en komplex skning.
</p>
<p>
D alla av anvndare instllbara markeringar inte har ngon betydelse fr
Scid (med undantag av ta bort-markeringar), kan du anvnda dessa fr
dina egna syften. Till exempel kan anvnda markeringen "Spel p kungsflygeln" (K) 
fr att leta efter bland annat bondestormar mot kungen , pjsangrepp mot kungen 
eller slutspel med alla bnder p kungsflygeln.
</p>

<p><footer>(Uppdaterat: Scid 3.0, November 2001)</footer></p>
}


###############
### LaTeX help:

set helpTitle(W,LaTeX) "Scid och LaTeX"
set helpText(W,LaTeX) {<h1>Scid och LaTeX</h1>
<p>
Scid kan spara partier och ppningsresultat i LaTeX-format i filer. 
LaTeX r en utvidgning av TeX, ett populrt Textbehandlingssystem.
</p>
<p>
Fr att Scid ska kunna skapa LaTeX-filer , mste du
(naturligtvis) ha installerat LaTeX  och schackteckensnitts-paketet "chess12". 
Detta paket r normalt inte en del av
LaTeX-Standardinstallation, dvs om du har LaTeX , har
du kanske inte schackteckensnittet.
</p>
<p>
Information om nedladdning och installation av
LaTeX-schackteckensnittet hittar du p lnken
<url http://scid.sourceforge.net/latex.html>Using LaTeX with Scid</url>
p <url http://scid.sourceforge.net/>Scids Webbsida</url>.
</p>

<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}


###########################
### Options and Fonts help:

set helpTitle(W,Options) "Alternativ"
set helpText(W,Options) {<h1>Alternativ och preferenser</h1>
<p>
Mnga alternativ och preferenser i Scid (som till exempel brdstorleken, frger,
teckensnitt och standardinstllningar) kan man ndra i <menu>Alternativ</menu>-menyn. 
Alla dessa (och fler instllningar, som till exempel den sista katalogen i vilket du har lst in en
databas och storleken p ngra fnster)
blir sparat i en instllningsfil, nr du vljer 
<b>Spara instllningar</b> i Alternativ-menyn.
Varje gng som Scid startar blir denna instllningsfil laddad.
</p>
<p>
Nr du arbetar med Windows , finns instllningsfilen <b>scid.opt</b>
i samma katalog som Scids programfil. Fr anvndare av
Unix-Operativsystem (som Solaris eller Linux) r filen
<b>~/.scid/scidrc</b>.
</p>

<h3><name MyPlayerNames>Faststlla spelarnamn</name></h3>
<p>
Det kan vara s att du vill se brdet i huvudfnstret fr en (eller flera) spelare 
frn dennes eller deras perspektiv nr dennes eller deras partier ppnas. 
Du kan ange en lista med sdana namn med <b>Mina Spelarnamn...
</b> i Menyn <menu>Alternativ/Schachbrde</menu>. 
I Dialogfnstret matar du d in ett spelarnamn per rad. 
Jokertecken som ("<b>?</b>" fr ett oknt tecken och "<b>*</b>"
fr en teckenkedja av noll eller flera tecken) r tilltna.
</p>

<h3><name Fonts>Stlla in teckensnitt</name></h3>
<p>
Scid har tre teckensnitt som anvnds i de flesta fnster
och du kan anpassa alla tre individuellt. De heter
<b>normal</b>, <b>liten</b> och <b>fast</b>.
</p>
<p>
Det fasta teckensnittet borde vara ett teckensnitt med fast bredd
(inte-proportionellt) . Det anvnds av <a Tree>Dragtrdet</a> och 
<a Crosstable>Korstabeller</a> .
</p>

<p><footer>(Uppdaterat: Scid 3.5, Februar 2003)</footer></p>
}


####################
### Pgnscid help:

set helpTitle(W,Pgnscid) "Pgnscid"
set helpText(W,Pgnscid) {<h1>Pgnscid</h1>
<p>
<term>Pgnscid</term> r ett separat program, som du kan
anvnda fr att konvertera PGN-filer ("portable game notation") 
till Scid-Databaser.
</p>
<p>
Fr att konvertera en fil med namnet <i>partier.pgn</i> , skriver du
bara
<ul>
<li> <b>pgnscid partier.pgn</b> </li>
</ul>
och Scid-Databasen (bestende av filerna
<i>partier.si3</i>, <i>partier.sg3</i> och <i>partier.sn3</i>) blir
skapade.
Felmeddelanden eller varningar blir skrivna i filen <i>partier.err</i>
.
</p>
<p>
Nr du vill att databasen ska skapas i en annan katalog eller
med ett annat namn, kan du ange datenbasnamnen
i kommandoraden, till exempel skapar
<ul>
<li> <b>pgnscid partier.pgn databas</b> </li>
</ul>
en databas bestende av filerna <i>databas.si3</i>,
<i>databas.sg3</i> och <i>datenbas.sn3</i>.
</p>
<p>
Observera att pgnscid (och ocks Scid) direkt kan lsa gzip-komprimerade
PGN-filer som till exempel. <b>datenbas.pgn.gz</b>.
</p>

<h3>Alternativ</h3>
<p>
Pgnscid accepterar tv optionella argument fr filnamnen:
<b>-f</b> och <b>-x</b>.
</p>
<p>
Alternativet <b>-f</b> tvingar fram verskrivandet av en existerande
databas; normalt ndrar pgnscid inte i en redan
existerande databas.
</p>
<p>
Alternativet <b>-x</b> gr att pgnscid ignorerar text mellan partierna. 
Normalt blir text mellan partierna sparat som en kommentar fre det
fljande partiet. Detta alternativ gller bara text mellan partier; 
standardkommentarer i partierna blir dessutom konverterade och sparade.
</p>

<h3>Formatera spelarnamn</h3>
<p>
Fr att minska antalet olika stavningar av samma spelare
genomfr pgnscid ngra Grundformateringar
. Till exempel blir antalet mellanrum efter ett
komma satt till ett medan mellanrum i brjan eller slutet av ett namn
blir bortagna.
Hollndska Namn som "van den" och "Van Der" blir dessutom
normaliserade, s att de har ett stort "V" och litet "d".
</p>
<p>
Du kan ven ndra Spelar-, Turnerings-, Orts- och Rundebeteckningar i Scid
(och till och med utfra automatisk skrivkorrektur);
fr detaljerna se hjlpsidan <a Maintenance Editing>Underhll</a>.
</p>

<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}





#################
### Sorting help:

set helpTitle(W,Sorting) "Sortera databas"
set helpText(W,Sorting) {<h1>Sortera databas</h1>
<p>
<term>Sortera</term>-Funktionerna sorterar alla partier i en
databas. Du kan vlja flera sorteringskriterier .
Nr tv partier r likvrdiga efter ett kriterium, blir
de sorterade efter det andra kriteriet och s vidare.
</p>

<h3>Sorteringskriterier</h3>
<p>
De tillgngliga sorteringskriterierna r:
</p>
<ul>
<li> Datum (ldsta partier frst)
<li> r (som Datum, men bara ret anvnds)
<li> Turnering (Tilldragelse)
<li> Ort
<li> Land (de sista 3 bokstverna i orten)
<li> Runda
<li> Vit
<li> Elo-tal (Genomsnitt av Vit och Svart, hgst frst)
<li> Svart
<li> Resultat (Vit vinner, drefter remier, drefter Svart vinner)
<li> Lngd (Antal hela drag i partiet)
<li> ECO-kod enligt <a ECO>Encyclopedia of Chess Openings</a>)
</ul>

<h3>Sorteringsresultatet</h3>
<p>
Nr du inte sorterar en skrivskyddad Scid-Databas , blir 
sorteringsresultatet skrat genom att lngvarigt ndra i ordningsfljden 
i databaspartierna. Om du bara vill gra en temporr sortering ,
skyddar du frst databasen mot verskrivande med med menyfunktionen
<menu>Fil: Skrivskydd</menu>.
</p>
<p>
Nr du sorterar en databas , som r skrivskyddad eller bestr av
en PGN-fil , kan sorteringsresultatet inte bli skrat , vilket gr att 
den sorterade partiordningsfljden gr frlorad nr filen
stngs.
</p>
<p>
Observera att sorteringen av en databas i
<a Searches filtret>Skfilter</a> ndrar i alla partier.
</p>

<h3>Viktig hjlp fr databas-sortering:</h3>
<p>
Nr en Databas blir sorterad , r indexfilen ndrad, men
partifilen r ofrndrad. Det vill sga, sorteringen av en databas
lmnar partidata-filen i en tillfllig ordningsfljd relativ till 
indexfilen. Detta kan gra <a Tree>Dragtrd</a>-,
Positions- och Material/Mnster-<a Searches>Skningar</a> mrkbart
<b>lngsammare</b>, du br drfr efter att ha sorterat databasen
ndra i partifilen genom att <a Compact>Komprimera</a> ,
fr att f bra skprestanda .
</p>

<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}





####################
### NAG values help:

set helpTitle(W,NAGs) "NAG-vrden"
set helpText(W,NAGs) {<h1>Standard-NAG-vrden</h1>
<p>
Standard-NAG-vrden (Numeric Annotation Glyph = "numeriska
Anmrkningglyfer"), som definieras i <a Author Related>PGN-Standard</a> ,
r:
</p>
<cyan>
<ul>
<li>  1   Bra drag (!) </li>
<li>  2   Dligt drag (?) </li>
<li>  3   Utomordentligt drag (!!) </li>
<li>  4   Stort misstag / Blunder (??) </li>
<li>  5   Intressant drag (!?) </li>
<li>  6   Tveksamt drag (?!) </li>
<li>  7   Tvingat drag </li>
<li>  8   Det enda draget; det finns inga andra bra drag </li>
<li>  9   Smsta draget </li>
<li> 10   Utjmnad position (=) </li>
<li> 11   Lika chanser, lugn stllning (=) </li>
<li> 12   Lika chanser, aktiv stllning (=) </li>
<li> 13   Oklar stllning (~) </li>
<li> 14   Vit har en liten frdel, str ngot bttre (+=) </li>
<li> 15   Svart har en liten frdel, str ngot bttre (=+) </li>
<li> 16   Vit har frdel, str bttre (+/-) </li>
<li> 17   Svart har frdel, str bttre (-/+) </li>
<li> 18   Vit har en avgrande frdel (+-) </li>
<li> 19   Svart har en avgrande frdel (-+) </li>
<li> 20   Vit har en vervldigande frdel (+-) </li>
<li> 21   Svart har en vervldigande frdel (-+) </li>
<li> 22   Vit r i dragtvng </li>
<li> 23   Svart r i dragtvng </li>
<li> 24   Vit har en liten utrymmesfrdel </li>
<li> 25   Svart har en liten utrymmesfrdel </li>
<li> 26   Vit har en utrymmesfrdel </li>
<li> 27   Svart har en utrymmesfrdel </li>
<li> 28   Vit har en avgrande utrymmesfrdel </li>
<li> 29   Svart har en avgrande utrymmesfrdel </li>
<li> 30   Vit har ett litet Tids-(Utvecklings)frsprng </li>
<li> 31   Svart har ett litet Tids-(Utvecklings)frsprng </li>
<li> 32   Vit har ett Tids-(Utvecklings)frsprng </li>
<li> 33   Svart har ett Tids-(Utvecklings)frsprng </li>
<li> 34   Vit har ett avgrande Tids-(Utvecklings)frsprng </li>
<li> 35   Svart har ett avgrande Tids-(Utvecklings)frsprng </li>
<li> 36   Vit har initiativet </li>
<li> 37   Svart har initiativet </li>
<li> 38   Vit har ett uthlligt initiativ </li>
<li> 39   Svart har ett uthlligt initiativ </li>
<li> 40   Vit har ett angrepp </li>
<li> 41   Svart har ett angrepp </li>
<li> 42   Vit har ingen tillrcklig kompensation fr materialet </li>
<li> 43   Svart har ingen tillrcklig kompensation fr materialet </li>
<li> 44   Vit har tillrcklig kompensation fr materialet </li>
<li> 45   Svart har tillrcklig kompensation fr materialet </li>
<li> 46   Vit har mer n tillrcklig kompensation fr materialet </li>
<li> 47   Svart har mer n tillrcklig kompensation fr materialet </li>
<li> 48   Vit har en ltt vervikt i centrum </li>
<li> 49   Svart har en ltt vervikt i centrum </li>
<li> 50   Vit har en vervikt i centrum </li>
<li> 51   Svart har en vervikt i centrum </li>
<li> 52   Vit har en avgrande vervikt i centrum </li>
<li> 53   Svart har en avgrande vervikt i centrum </li>
<li> 54   Vit har en ltt vervikt p kungsflygeln </li>
<li> 55   Svart har en ltt vervikt p kungsflygeln </li>
<li> 56   Vit har en vervikt p kungsflygeln </li>
<li> 57   Svart har en vervikt p kungsflygeln </li>
<li> 58   Vit har en avgrande vervikt p kungsflygeln </li>
<li> 59   Svart har en avgrande vervikt p kungsflygeln </li>
<li> 60   Vit har en ltt vervikt p damflygeln </li>
<li> 61   Svart har en ltt vervikt p damflygeln </li>
<li> 62   Vit har en vervikt p damflygeln </li>
<li> 63   Svart har en vervikt p damflygeln </li>
<li> 64   Vit har en avgrande vervikt p damflygeln </li>
<li> 65   Svart har en avgrande vervikt p damflygeln </li>
<li> 66   Vit har en svag stllning </li>
<li> 67   Svart har en svag stllning </li>
<li> 68   Vit har en bra skrad stllning </li>
<li> 69   Svart har en bra skrad stllning </li>
<li> 70   Vit har en dligt skrad kung </li>
<li> 71   Svart har en dligt skrad kung </li>
<li> 72   Vit har en bra skrad kung </li>
<li> 73   Svart har en bra skrad kung </li>
<li> 74   Den vita kungen str dligt </li>
<li> 75   Den svarta kungen str dligt </li>
<li> 76   Den vita kungen str bra </li>
<li> 77   Den svarta kungen str bra </li>
<li> 78   Vit har en mycket svag bondestruktur </li>
<li> 79   Svart har en mycket svag bondestruktur </li>
<li> 80   Vit har en svag bondestruktur </li>
<li> 81   Svart har en svag bondestruktur </li>
<li> 82   Vit har en stark bondestruktur </li>
<li> 83   Svart har en stark bondestruktur </li>
<li> 84   Vit har en mycket stark bondestruktur </li>
<li> 85   Svart har en mycket stark bondestruktur </li>
<li> 86   Den vita springaren str dligt </li>
<li> 87   Den svarta springaren str dligt </li>
<li> 88   Den vita springaren str bra </li>
<li> 89   Den svarta springaren str bra </li>
<li> 90   Den vita lparen str dligt </li>
<li> 91   Den svarta lparen str dligt </li>
<li> 92   Den vita lparen str bra </li>
<li> 93   Den svarta lparen str bra </li>
<li> 94   Det vita tornet str dligt </li>
<li> 95   Det svarta tornet str dligt </li>
<li> 96   Det vita tornet str bra </li>
<li> 97   Det svarta tornet str bra </li>
<li> 98   Den vita damen str dligt </li>
<li> 99   Den svarta damen str dligt </li>
<li>100   Den vita damen str bra </li>
<li>101   Den svarta damen str bra </li>
<li>102   De vita pjserna r dligt koordinerade </li>
<li>103   De svarta pjserna r dligt koordinerade </li>
<li>104   De vita pjserna r bra koordinerade </li>
<li>105   De svarta pjserna r bra koordinerade </li>
<li>106   Vit har behandlat ppningen mycket dligt  </li>
<li>107   Svart har nehandlat ppningen mycket dligt </li>
<li>108   Vit har behandlat ppningen dligt </li>
<li>109   Svart har behandlat ppningen dligt </li>
<li>110   Vit har behandlat ppningen bra  </li>
<li>111   Svart har behandlat ppningen bra  </li>
<li>112   Vit har behandlat ppningen mycket bra  </li>
<li>113   Svart har behandlat ppningen mycket bra  </li>
<li>114   Vit har behandlat mittspelet mycket dligt </li>
<li>115   Svart har behandlat mittspelet mycket dligt  </li>
<li>116   Vit har behandlat mittspelet dligt  </li>
<li>117   Svart har behandlat mittspelet dligt </li>
<li>118   Vit har behandlat mittspelet bra  </li>
<li>119   Svart har behandlat mittspelet bra  </li>
<li>120   Vit har behandlat mittspelet mycket bra  </li>
<li>121   Svart har behandlat mittspelet mycket bra  </li>
<li>122   Vit har behandlat slutspelet mycket dligt  </li>
<li>123   Svart har behandlat slutspelet mycket dligt  </li>
<li>124   Vit har behandlat slutspelet dligt  </li>
<li>125   Svart har behandlat slutspelet dligt  </li>
<li>126   Vit har behandlat slutspelet bra  </li>
<li>127   Svart har behandlat slutspelet bra  </li>
<li>128   Vit har behandlat slutspelet mycket bra  </li>
<li>129   Svart har behandlat slutspelet mycket bra  </li>
<li>130   Vit har lite motspel </li>
<li>131   Svart har lite motspel </li>
<li>132   Vit har motspel </li>
<li>133   Svart har motspel </li>
<li>134   Vit har avgrande motspel </li>
<li>135   Svart har avgrande motspel </li>
<li>136   Vit r i ltt tidsnd </li>
<li>137   Svart r i ltt tidsnd </li>
<li>138   Vit r i allvarlig tidsnd </li>
<li>139   Svart r i allvarlig tidsnd </li>
</ul>
</cyan>

<p>
Fler freslagna Nag-vrden fr Schachinformator-symboler r bland annat:
</p>
<cyan>
<ul>
<li>140   Med iden ... </li>
<li>141   Riktat mot ... </li>
<li>142   Bttre r </li>
<li>143   Smre r </li>
<li>144   Likvrdigt r </li>
<li>145   Redaktrens anmrkning ("RR") </li>
<li>146   Nyhet ("N") </li>
<li>147   Svag punkt </li>
<li>148   Slutspelet </li>
<li>149   Linje </li>
<li>150   Diagonal </li>
<li>151   Vit har lparparet </li>
<li>152   Svart har lparparet </li>
<li>153   Olikfrgade lpare </li>
<li>154   Likfrgade lpare </li>
</ul>
</cyan>

<p>
Andra frslag r:
</p>
<cyan>
<ul>
<li>190   Etc. </li>
<li>191   Dubbelbnder </li>
<li>192   Isolerade bnder </li>
<li>193   Frenade bnder </li>
<li>194   Hngande bnder </li>
<li>195   Baktvnd bonde </li>
</ul>
</cyan>

<p>
Av Scid definierade symboler fr internt bruk:
</p>
<cyan>
<ul>
<li>201   Diagram ("D", ibland ocks "#") </li>
</ul>
</cyan>

<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}


######################
### File formats help:

set helpTitle(W,Formats) "Filformat"
set helpText(W,Formats) {<h1>Scids Filformat</h1>
<p>
Scid-Databaser bestr av tre viktiga filer: en
Indexfil, en Namnfil och en Partidatafil. 
Alla filer har en trebokstavsndelse, 
som brjar med "s": 
<b>".si3"</b> fr Indexfiler,
<b>".sn3"</b> fr Namnfiler och 
<b>".sg3"</b> fr Partidatafiler.
</p>

<h3>Indexfilen (.si3)</h3>
<p>
Denna fil innehller en beskrivning av databasen dr det finns en 
liten notering med fast lngd fr varje parti. Den aktuella storleken 
r 41 bytes per parti. Av dessa r 28 bytes vsentlig information 
som Resultat, Datum, Index fr Spelar-, Turnerings- och
Ortsnamn (de aktuella namnen finns i  namnfilen) .
</p>
<p>
De resterande 13 bytes innehller reduktant, men nyttig
information om partiet, som anvnds fr  Positions-,
Material- och Mnsterskningar. 
Se avsnittet <a Formats Fast>Ska snabbt</a> fr mer
information.
</p>

<h3>Namnfilen (.sn3)</h3>
<p>
Denna fil innehller alla Spelar-, Turnerings-, Orts- och Rundenamn, som
anvnds i databasen. Varje Namn r bara sparat en gng,
ven om det frekommer i mnga partier. Namnfilen r vanligtvis
den minsta av de tre viktiga databasfilerna.
</p>

<h3>Partidatafilen (.sg3)</h3>
<p>
Denna fil innehller de aktuella dragen, varianter och kommentarer fr varje
parti. Dragkodningen r mycket kompakt: de flesta dragen behver bara en 
byte.
</p>
<p>
Nr ett parti blir ersatt, blir dess nya version sparat i <i>slutet</i>
av filen, s att det inte ver tiden ansamlar sig icke anvnt sparutrymme. 
Du kan genom <a Compact>Komprimering</a>
terstlla den minimala storleken p en databas.
</p>

<h3>Andra Scid-Filer</h3>
<p>
En <a EPD>EPD</a>-fil (Filndelse: ".epd") innehller en rad 
schackpositioner, varje med en textkommentar.
EDP-filformatet beskrivs i <a Author Related>PGN-Standard</a>.
</p>
<p>
En E-Mail-fil (Filndelse: <b>".sem"</b>) sparas i en databas
av motstndaren, som ni skickar E-Mail till.
</p>
<p>
En Skalternativfil (Filndelse: <b>".sso"</b>) innehller instllningar fr
en <a Searches Header>Partidata</a>- eller
<a Searches Material>Material/Mnster</a>-skning.
</p>

<h3><name Fast>Ska snabbt i Scid</name></h3>
<p>
Som ovan nmns, innehller Indexfilen ngra reduktanta, men
nyttiga informationer om varje parti, som anvnds av Positions- eller
Materialskning.
</p>
<p>
Till exempel sparas materialet i slutstllningen. Om du
vill ska efter Torn- och Bondeslutspel, blir alla partier, som har en
Dam, en Lpare eller en Springare p brdet i slutstllningen,
snabbt genomskta.
</p>
<p>
En annan nyttig delinformation som sparas r ordningsfljden,
fr Bnderna att lmna sin utgngsstllning (genom drag eller
genom att de blir tagna). Detta blir anvnt fr skningar av bondedrag 
eller exakta skningar, i synnerhet efter ppningspositioner. Till exempel
blir vid skningen av utgngsstllningen fr den franska ppningen
(1.e4 e6) varje Parti, som brjar med 1.e4 c5 eller 1.d4 etc.
genomskt, Partier, som brjar med 1.e4 e5 , mste ven alltid
genomskas.
</p>

<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}



################
### Contact info

set helpTitle(W,Author) "Kontaktinformation"
set helpText(W,Author) {<h1>Kontaktinformation</h1>
<p>
Scids webbsajt finns p: <br>
<b><url http://scid.sourceforge.net/>http://scid.sourceforge.net/</url></b>
</p>
<p>
Dr kan du hmta den senaste versionen av Scid och de andra filerna till Scid, som du kan ha behov av.
</p>
<p>Den svenska versttningen av Scid har gjorts av Martin Skjldebrand. Synpunkter p versttningen ska <b>inte</b>
skickas till Shane. Dremot fr du grna skicka kommentarer, frgor och frslag till rttningar till versttaren p adressen:<br>
<b>martin@skjoldebrand.org</b>
</p>
<h3><name Related>Lnkar</name></h3>
<p>
Om Ni har gldje av Scid kan de fljande
Internetsidorna vara interessanta:
</p>
<ul>
<li><url http://www.tim-mann.org/chess.html>http://www.tim_mann.org/chess.html</url> --
Hemsida fr Tim Mann's <b>xboard & winboard</b> program: grafiska
grnssnitt fr schackprogram och anslutning till Internet Chess
Server. Den har ocks bra information om Crafty, GNUchess och
andra schackprogram.</li>

<li><url ftp://ftp.cis.uab.edu/pub/hyatt/>ftp://ftp.cis.uab.edu/pub/hyatt/</url> --
Det starka schackprogrammet Crafty.  <b>TB</b> -
underkatalogerna  innehller nstan alla Nalimov-slutspelstabeller, som
anvnds av ngra schackprogram och ven anvnds av Scid.</li>

<li><url http://www.chesscenter.com/twic/twic.html>http://www.chesscenter.com/twic/twic.html</url> --
TWIC (the week in chess), r ett framstende veckomagazin fr
internationella schackpartier, tillgngliga i PGN-format. </li>

<li><url http://scid.sourceforge.net/doc/standard.txt>http://scid.sourceforge.net/doc/standard.txt</url> --
 <b>PGN-Standard</b>, skapad av Steven J. Edwards 1994.
Textfilen frklarar PGN- och EPD-Formaten i detalj.</li>
</ul>

<p><footer>(Uppdaterat: Scid 2.5, Juni 2001)</footer></p>
}

# Book window help
set helpTitle(W,Book) "Bokfnstret"
set helpText(W,Book) {<h1>Bokfnstret</h1>
  <p>
  Bokfnstret visar en lista p alla bokfiler som finns i Scids bokkatalog. Formatet p bckerna r
  det som anvnds av Polyglot och schackmotorer som Fruit och Toga.
  </p>
  <p>
  Fr varje position, visar bokfnstret alla mjliga drag det innehller och deras
  relativa vikter i procent. Nr ett drag grs, uppdateras bokfnstret.
  Om det klickas p ett drag i bokfnstret grs detta drag i den aktuella positionen.
  </p>
  <p>
  Den aktuella boken som anvnds kan snabbt ndras genom att vlja en annan bok i den vre listan.
  </p>
  <p><footer>(Uppdaterat: Scid 3.6.5, Februari 2007)</footer></p>
}

# Tactical game window help
set helpTitle(W,TacticalGame) "Taktiskt parti-fnstret"
set helpText(W,TacticalGame) {<h1>Taktiskt parti-fnstret</h1>
  <p>
  Spela ett taktiskt parti mot en schackmotor som simulerar en motstndare med en angiven ELO-rating.
  Motstndaren spelas av Phalanx och trnaren spelas av Crafty. De rtta schackmotorerna vljs automatiskt
  genom sina namn, och br vara korrekt konfigurerade (detta r standard nr Scid installeras).
  </p>
  <p>
  De fljande parametrarna mste konfigureras :
  <ul>
  <li>svrighet : ELO-rating p motstndare</li>
  <li>specifik ppning : motstndaren spelar en specifik ppning (anvndbart fr ppningstrning)</li>
  <li>spelarens fel kontrolleras av en schackmotor som agerar som en trnare. Tiden som anvnds fr att bedma om ett
  drag r bra eller inte kan begrnsas</li>
  </ul>
  <p>Nr du r klar klicka bara p spela</p> 
  <p><footer>(Uppdaterat: Scid 3.6.5, Mars 2007)</footer></p>
}

# Opening Trainer window help
set helpTitle(W,OpeningTrainer) "ppningstrnare"
set helpText(W,OpeningTrainer) {<h1>ppningstrnare</h1>
  <p>
  En Sciddatabas kan anvndas som en repetoar, dr varje parti representerar en ppningsvariant.
  </p>
  
  <h3>ppningstrnarstatistik</h3>
  <p>
  Fyra tal visas fr att visa statistik fr den aktuella positionen :
  <ul>
  <li>Grn : antalet drag som spelades av anvndaren som r bra drag</li>
  <li>Gul : antalet tveksamma drag som spelades som r repertoaren</li>
  <li>Rd : antalet drag som spelades som inte finns i repertoaren</li>
  <li>Vit : antalet gnger positionen ptrffades</li>
  </ul>
  </p>
  
  <h3>Rapporten</h3>
  <p>
  Rapporten visar statistik fr hela repertoaren och ger information om anvndarens kunskaper :
  <ul>
  <li>Positioner i repertoaren : det totala antalet positioner i repertoaren (alla varianter i databasen)</li>
  <li>Positioner som inte spelats : de positioner som alldrig har ptrffats</li>
  <li>Positioner spelade : de positioner som spelades och summan av antalet gnger de har ptrffats. Notera att
  detta antal representerar antalet frekomster av en position i alla ppningsvarianter : detta antal kan snabbt bli stort
  fr positioner som r nra till startpositionen</li>
  <li>Bra drag : antalet bra drag gjorda av anvndaren</li>
  <li>Tveksamma drag : antalet svaga drag gjorda av anvndaren</li>
  <li>Utanfr repertoaren : antalet drag som anvndaren har gjort som inte finns i repertoaren</li>
  </ul>
  </p> 
  <p><footer>(Uppdaterat: Scid 3.6.11, April 2007)</footer></p>
}

####################
### Correspondence Chess help:
set helpTitle(W,Correspondence) "Korrespondensschack"
set helpText(W,Correspondence) {<h1>Korrespondensschack</h1>

<p>
Scid erbjuder nu tv huvudfunktioner fr korrespondens-
schack.
</p>
<ul>
   <li><b>eMail-schack</b> gr detta genom att skicka det aktuella partiet via eMail
   till din motstndare nr du har gjort ditt drag. Fr detta skapas ett eMail-
   meddelande i ditt fredragna email-program med det aktuella partiet
   bifogat till det i PGN-format. Givetvis tas alla kommentarer och
   variationer bort frst.
   </li>
   <li><b>Korrespondensschackservrar</b> stds med hjlp av
   Xfcc-protokollet. Hr anvnds externa verktyg fr att hmta partierna frn
   ditt/dina konto/konton och levererar dem till Scid fr synkronisering. Efter
   du har gjort ditt drag skickas detta till din motstndare genom
   Xfcc. Hmtnings- och sndningsverktygen r implementerade som externa verktyg fr
   enkel utkning om andra protokoll kommer.
   </li>
</ul>

<p>
Fr att anvnda korrespondensschackfuntioner mste en databas av typ
"Korrespondensschack" ppnas innan ngra
korrespondensschackfunktioner anvnds. OM du inte har en sdan databas
n, skapa bara en ny databas och ange dess typ till "Korrespondensschack"
med funktionen <a Maintenance>Underhll</a>.
Det r viktigt att ange typen s att Scid kommer att knna igen databasen fr
synkronisering genom denna typ. D denna databas r tom efter
skapandet kommer Scid att behandla alla korrespondensschackpartier det fr vid
den frsta synkroniseringen som nya partier och lgga till dem till denna databas.
</p>

<p>
Om ingen databas av typ "Korrespondensschack" r nu ppnad
kommer Scid att pminna dig om att gra s. Men, ppna inte mer n en
databas av denna typ d Scid inte d kan avgra vilken som ska anvndas.
</p>

<h3>Grundfunktionalitet</h3>

<p>
Om allting r korrekt konfigurerat kan anvndningen av korrespondens-
schackfunktionerna ltt ns med fljande knappar:
<ul>
   <li><button tb_CC_Retrieve> Hmtar korrespondensschackpartier.
   Fr detta startas ett externt hmtningsverktyg och alla partier hmtas
   s likvl som andra partier som lagras i Scids Inkorg
   (se nedan) r synkroniserade till den aktuella korrespondensschack-
   databasen.
   </li>
   <li><button tb_CC_Send> Skickar ditt drag till motstndaren genom att antingen
   skapa ett nytt eMail-meddelande i dett fredragna email-program eller genom att
   skicka ett drag till en schackserver om Xfcc anvnds.
   </li>
</ul>
</p>

<h3>Konfiguration</h3>

<p>
Korrespondensschack inom Scid r baserat p en normal Scid-
databas som har partierna och ngra externa verktyg till Scid som
hanterar de "icke-schack-delarna". Dessa verktyg och deras parametrar mste stllas
in en gng, och lagras sedan fr framtida anvndning.
</p>

<p>
Fr att n konfigurationsdialogen vlj <menu>Spela</menu>
<menu>Korrespondensschack</menu><menu>Konfigurera</menu> frn
menyn. Detaljerna beskrivs i <a CCSetupDialog>Korrespondensschack-
instllningar</a>. Nr denna dialog avslutas med <b>[Ok]</b> knappen kommer
dina instllningar automatiskt att lagras.
</p>

<h3>Hmta partierna</h3>
<p>
Beroende p om du spelar korrespondensschack via eMail eller via en
schackserver skiljer sig den aktuella hmtningsprocessen lite. Generellt
resulterar den i ett antal partier i PGN-format placerade i Scids Inkorgs-
katalog. Detta erbjuder ocks mjligheten till automatisk hmtning via
extern programvara.
</p>
<p>
Nr partierna finns i Scids Inkorg kommer <menu>Behandla Inkorg</menu>
frn menyn att bearbeta Inkorgen och lgga till nya drag till
de partier som redan finns i databasen. Dessutom kommer den att lgga till de partier
som inte hittas i den aktuella korrespondensschackdatabasen som nya partier.
</p>

<p><a CCeMailChess>Korrespondensschack via eMail</a> beskriver
detaljerna fr anvndning av eMail, medan <a CCXfcc>Korrespondens-
schack via schackserverar</a> beskriver motsvarande fr korrespondens-
schackservrar.
</p>

<h3>Stega igenom partier</h3>
<p>
Efter att partierna r hmtade laddas de i Scids klippboardsdatabas
och nya drag lggs till och lagras i den ppnade korrespondensschack-
databasen. Skillnades i
funktionen frn menyn <menu>Partier</menu> r, att dessa tv
knappar scrollar bara mellan partierna i Scids Inkorg som r
tnkt att vara dina aktuella pgende partier. Givetvis kan
Korrespondensschackdatabasen innehlla mnga fler partier, men
normalt vill du inte g igenom  dessa fr att se vad din
motstndare har gjort fr drag i ett aktuellt parti.
</p>
<p>
Notera att en taggskning krvs med ngra flt som
inte r indexerade av Scid. Drfr r det , inte att rekommendera
att lagra partier i en stor referensdatabas d
sktiderna kan bli ganska lnga. Om du spelar mycket och din egen
databas blir ganska stor, kan sktiden reduceras genom att flytta
avslutade partier till en arkivdatabas, eller genom att bara skapa en ny
databas fr de pgende partierna. Scid kommer att behandla alla partier som inte finns
redan i korrespondensschackdatabasen som nya partier och lgga till dem
automatiskt. Drfr, r det tillrckligt att ppna en tom databas av
typ "Korrespondensschack" och anvnda <menu>Behandla Inkorg</menu> fr att
importera alla nu pgende partier.
</p>
<p>
Motsvarande till de tv nmnda knapparna r <menu>Tidigare
Parti</menu> och <menu>Nsta Parti</menu> frn <menu>Korrepondens-
schack</menu> menyn.
</p>
<p>
Notera att om du anger dina spelarnamn korrekt (i menyn
<menu>Mina Spelarnamn</menu>) kommer Scid att rotera brdet fr dig att
alltid spela uppt. Du kan ha flera spelarnamn. Se ocks <a
Options MyPlayerNames>Mina Spelarnamn</a> fr detaljer.
</p>

<h3>Analysera och gr ett drag</h3>
<p>
Alla analysfunktioner kan anvndas fr korrespondensschackpartier.
Variationer, kommentarer etc. kan lggas till precis som i en normal partianalys.
Nr det r klart, kommer Scid att ta den senaste halvdraget som lades till
partiet och behandla det som det aktuella draget att skicka. Ingen kontroll grs
hr av om bara ett halvdrag lades till eller vilken sida som r vid draget,
drfr, mste bara ett halvdrag i huvudvarianten lggas till!  Om en
schackserver anvnds skickar Scid ocks den senaste kommentaren som lades till
servern vilket kan vara anvndbart fr kommunikationen med motstndaren. I
eMail-schack kan detta gras med det normala email-meddelandet, s dr tas alla
kommmentarer bort.
</p>
<p>
Genom att trycka p Sndknappen <button tb_CC_Send> kommer Scid att msta
bestmma den typ av korrespondensschackparti som visas (eMail eller
ett serverparti) och starta antingen ditt eMail-program eller det externa skicka-
verktyget fr att skicka ditt drag. Att anvnda <menu>Skicka drag</menu> r motsvarande
till denna knapp. Alternativt, kan <menu>eMail drag</menu> anvndas fr att
skicka det aktuella draget via eMail. Om det r ett eMail-parti r denna
funktion motsvarande till <menu>Skicka drag</menu>. Om det r ett server-
baserat parti genereras ett eMail-meddelande. Notera dock, att detta kommer
inte ndvndigtvis att innehlla en riktig mottagare d eMail-addresser inte byts ut
i serverbaserad korrespondensschack.
</p>

<p><footer>(Uppdaterat: Scid 3.6.23, Februari 2008)</footer></p>
}


set helpTitle(W,CCXfcc) "Korrespondensschackservrar"
set helpText(W,CCXfcc) {<h1>Korrespondensschackservrar</h1>

<p>
Det finns flera korrespondensschackserverar p
Internet. Generellt, r de anvnda med en webblsare, s ingen
specifik programvara krvs. Men mnga av dem erbjuder ocks ett
grnssnitt till specialiserad schackprogramvara via ett protokoll kallat Xfcc.
Integrationen av Xfcc grs i Scid via externa hjlpverktyg angivna
i <a CCSetupDialog>Konfiguration</a>-dialogen fr korrespondens-
schack.
</p>

<h3>Starta ett nytt parti</h3>
<p>
Xfcc tillter inte sjlv att ett nytt parti startas. Att ska efter en
motstndare och starta ett parti r istllet hanterat av schackservern
p dess hemsida. Nr partiet r startat kan dock, Scid anvndas fr att hmta
motstndarens drag, lgga till dem till den interna databasen,
analysera osv. Alla funktioner i Scid r till anvndarnas frfogande
men speciella moder av spel kanske inte tillter dem (t.ex.  normala partier
tillter vanligtvis inte anvndande av schackmotorer fr analys).
</p>

<h3>Hmta partier</h3>
<p>
ppna en databas som inehller korrespondensschackpartier. Denna databas
mste vara av typ "Korrespondensschack". 
</p>

Notera: 
<ul>
   <li>Om Scid inte hittar en korrespondensschackdatabas kommer den att
   informera dig att ppna en.
   </li>
   <li>Om databasen inte har partierna som r hmtade frn
   servern behandlas de som nya partier och lggs till databasen
   automatiskt.
   </li>
   <li>Scid kommer att anvnda den frsta databasen av typ "Korrespondensschack"
   som r ppnad. Av denna anledning br bara en sdan databas i taget
   vara ppnad.
   </li>
</ul>
<p>
Xfcc hmtar alltid omedelbart alla partier som finns p en specificerad server fr ditt
anvndarnamn. Fr att hmta partierna klicka bara p <button tb_CC_Retrieve>
ikonen eller vlj <menu>Hmta Partier</menu> frn
<menu>Korrespondensschack</menu>-menyn. D en serveranslutning
krvs fr att hmta nya partier var sker p att systemet har tillgng till ntverket.
Scid kommer att starta hmtningsverktyget som r konfigurerat i 
<a CCSetupDialog>Konfiguration</a>-dialogen vilket kommer att placera
partierna i PGN-format i Scids inkorg. Det kan ta lite tid att hmta
svaret, s vat tlmodig. Efter att partierna r hmtade uppdateras
korrespondensschackdatabasen med dem.
</p>
<p>
Nr partierna r hmtade sks deras motstndare i
korrespondensschackdatabasen och nya drag lggs till dr. D Xfcc
servrar kan erbjuda olika stt att infoga drag (via Internet eller mobil eller
andra program...) kan det vara s att Scid mste lgga till hlften av
partiet till databasen. Detta innebr inget problem. Scid kommer att lgga till alla drag
som fanns i partiet frn servern. Scid kommer dock inte att erstta
partiet frn brjan d etta kan ta bort all din analys.
Drfr r det <b>viktigt att notera</b> att du inte fr infoga drag till
huvudvarianten bortom ditt sista drag! Fr att lgga till fortsttningar var god
och anvnd variationer!
</p>
<p>
Notera att om andra kllor har placerat partier i din inkorg (t.ex. frn
din eMail-korrespondensschack) synkroniseras de ocks i
hmtningen till databasen d hela Inkorgen ocks bearbetas.
Detta tillter att eMail-partier lggs till i Inkorgen, sedan kan du vxla till Scid,
klicka p <button tb_CC_Retrieve> och alla partier r uppdaterade.Partier som inte
nnu finns i datasen behandlas som nya partier och lggs till
databasen.
</p>
<p>
<b>Notering fr programmerare</b>: hmtningsverktyget startas med Inkorgsskvgen som
parameter. Det r tnkt atrt fungera genom alla serverkonton och placera
korrekt formatterade PGN-filer i den skvg som anges till den. Dessa filer
br innehlla ytteliggare flt som r knda av cmail-verktyget.
 (Se <a CCeMailChess>Korrespondensschack via eMail</a> fr
information om de krvda flten.)
</p>

<p><footer>(Uppdaterat: Scid 3.6.23, Februari 2008)</footer></p>
}

#############
# eMail Chess:
set helpTitle(W,CCeMailChess) "Korrespondensschack via eMail"
set helpText(W,CCeMailChess) {<h1>Korrespondensschack via eMail</h1>

<p>
eMail erbjuder ett vldigt bekvmt stt att spela korrespondensschack.
Standardapplikationen fr detta i Un*x-vrden r till idag xboard
tillsammans med dess cmail-hjlpare. D den tillter nstan automatisk
hantering av korrespondensschack-eMail och drutver inte lgger till ngonting
som inte r PGN r det ocks modellen fr Scid att hantera
eMail-schack. Genom att bara bevara hela PGN-huvudet kan sdana partier
spelas med en motstndare som har ett verktyg fr att hantera PGN.
</p>

<h3>eMail-schack</h3>
<p>
Scid kan hantera eMail-korrespondensschackpartier nstan automatiskt.
Det stt p hur detta grs hlls kompatibelt med cmail-verktyget som
kommer med xboard p Un*x system. (Att ha sagt detta antyder att du
kan spela mot en motstndare med cmail/xboard.) Det fungerar genom att skicka
partierna som hela PGN-filer till och frn som email-bilagor, medan
huvudet innehller vissa huvudflt som lter dem knnas igen och
sorteras tillsammans. Av denna anledning mste anvndaren vara noggrann med
att ndra i huvudflten.  Notera att flten med explicita vrden mste
anges till exakt detta vrde fr eMail-schack. Att starta ett parti med
Scid gr det automatiskt, men du <b>fr inte</b> skriva ver
eller ta bort dem!
</p>
<p>
Ndvndiga huvudflt r:
</p>
<ul>
   <li><term>Event</term>: mste vara "Email correspondence game"
   </li>
   <li><term>Site</term>: mste vara "NET"
   </li>
   <li><term>Mode</term>: mste vara "EM"
   </li>
   <li><term>WhiteNA</term>: innehller eMail-addressen fr den vita spelaren. Notera
   att adressen bara lagras dr i formen
   <term>user@host.org</term>.
   </li>
   <li><term>BlackNA</term>: innehller eMail-addressen fr den svarta spelaren
   liknande WhiteNA.
   </li>
   <li><term>CmailGameName</term>: Innehller en <b>unik</b> identifierare fr
   partiet. Detta anvnds fr att sortera partierna.
   <p>
   Medan Scid kan anvnda ngot databasindex r detta inte mjligt fr
   icke-DB-baserade verktyg som cmail. Av denna anledning r
   <term>CmailGameName</term> parametern anvndarinmatad. Den mste vara
   unik! Det enklaste r ngonting avformen
   <term>xx-yy-yyyymmdd</term> dr xx r en beteckning p den vita
   spelaren, yy en beteckning fr den svarta spelaren, och yyyymmdd r det aktuella datumet.
   </p>
   <p>Fr Xfcc-baserade partier mste detta flt anges till en unik
   identifierare men dr kan servernamnet och det unika partinumret p
   denna server anvndas, dvs denna identifierare r av formen
   <term>MyXfccServer-12345</term>.
   </p>
   </li>
</ul>

<h3>Starta ett nytt parti</h3>
<p>
Detta pppnar en dialog fr inmatning av ditt eget och motstndarens namn som
de br vara i huvudet likvl som eMail-addresserna fr
bda spelarna. Bessutom mste ett <b>unikt</b> game ID infogas.
Det enklaste sttet fr detta Game ID r ngonting av formen
<term>xx-yy-yyyymmdd</term> dr xx r en frkortning fr den vita
spelaren, yy fr den svarta spelaren, och yyyymmdd r det aktuella datumet.
Denna Game id r en text och det r viktigt fr att identifiera partierna unikt.
Anvndare av cmail kommer ocks att knna denna Game ID som <i>partinamn</i>. Det fr
brar innehlla bokstveroch sifror, minustecknet och understrykning.
Var god och undvik andra tecken.
</p>
<p>
Efter att dialogen r avslutad genom att trycka p <b>[Ok]</b> knappen lggs ett
nytt parti till den aktuella ppnade korrespondensschackdatabasen
och PGN-huvudet fylls i ordentligt. Gr bara ditt drag och skicka det som
det beskrivs nedan.
</p>

<h3>Hmta partier</h3>

<p>
Scid hanterar inte din emailkorg automatiskt. Detta skulle,
med tanke p den stora variationen p mjliga email-program idag, involvera
en stor mngd programkod. Av denna anledning anvnder Scid ditt normala
eMail-program som r mycket mer lmpligt fr detta syfte n Scid
kan ngonsin bli. Fr att hmta ett parti till Scid spara bara den bifogade PGN-filen
i Scids inkorg och bearbeta inkorgen genom antingen <menu>Hmta
Partier</menu> eller  <button tb_CC_Retrieve> knappen eller
<menu>Bearbeta Inkorgen</menu>. Skillnaden mellan de tv r att
den frsta ocks startar det externa hmtningsverktyget och fyller
Inkorgen ytterliggare med partier frn andra kllor (som Xfcc). Drfr r
<button tb_CC_Retrieve> det mest bekvma sttet om du anvnder bda
typerna av korrespondensschackpartier.
</p>
<p>
<b>Notera</b> att <menu>Hmta Partier</menu> menyn eller  <button
tb_CC_Retrieve> knappen <b>inte</b> hmtar dina eMail-meddelanden! Du
mste spara dina PGN-filer i Scids Inkorg fr hand. Troligtvis kan detta
bli automatiserat av ditt eMail-program (p Un*x system r det enkelt att stta upp en
mime-hanterare genom <term>.mailcap</term>).
</p>

<h3>Skicka svaret</h3>

<p>
Efter att du har gjort ditt drag skicka det antingen med <menu>eMail drag</menu>
funktionen frn menyn via <menu>Skicka drag</menu> vilket r motsvarande till
<button tb_CC_Send>. Fr det senare  mste Scid knna igen partiet
som eMail-korrespondens och skicka det med email medan den fregende metoden
kommer att f Scid att generera ett eMail-meddelande.
</p>
<p>
Givetvis tar Scid bort alla kommentarer och variationer
innan det bifogas i det utgende eMailet d du inte vill skicka med
din analys.
</p>
<p>
Om ett GUI-emailprogram anvnds, ppnas dess vanliga skapafnster.
Addressen p din motstndare fylls i likvl som ett generiskt mne
som innehller game id fr enkel filtrering och bcc-addresses om den
r specificerad i <a CCSetupDialog>Konfigurations</a>-dialogen. Email-
texten r angiven till att innehlla FEN p den sista positionen och listan p
de tidigare gjorda dragen. P detta stt kan motstndaren snabbt se ditt
drag. SlutligenFinally, bifogar Scid det aktuelkla partiet inklusive ditt drag i
PGN-format till email-meddelandet.
</p>
<p>
Nr ett mailx kompatibelt verktyg anvnds ppnas inget fnster och emailet skickas
osynligt geonom att starta verktyget specificerat i bakgrunden. I
detta fall innehller det genererade emailet PGN ven i email-texten.
</p>
<p>
Notera att d eMail-schack fungerar genom att skicka hela PGN-filen fr du inte
lgga till mer n ditt drag. Scid kontrolerar inte hr om
mer n ett drag lades till huvudvarianten, d Scid helt enkelt inte
vet vilket drag det r, d du skickar ditt drag.
</p>
<p><footer>(Uppdaterat: Scid 3.6.23, Februari 2008)</footer></p>
}

#############
# Correspondence Chess setup dialog help:
set helpTitle(W,CCSetupDialog) "Korrespondensschackinstllningar"
set helpText(W,CCSetupDialog) {<h1>Korrespondensschackinstllningar</h1>

<p>
Indata i konfigurationsdialogen finns frdefinierat till vissa standard-
parametrar men dessa mste inte ndvndigtvis matcha ditt system, s
anpassning kommer skert att vara ndvndigt. Alla parametrar lagras i
konfigurationsfilen automatiskt nr dialogen r stngd via
<b>[Ok]</b> knappen. Parametrarna gller d omedelbart.
</p>

<p>
<b>Standarddatabas</b>:
Detta definierar standarddatabasen fr
korrespondensschackpartier. Den kan enkelt ns via
<menu>ppna Databas</menu> i  <menu>Korrespondensschack</menu>
menyn. Frdelen med denna metod r, att databasen inte
visas i <i>senaste databaser</i> listor och att du kan ha en
specifik fil fr detta. Denna databas <b>mste vara</b> av typ
"Korrespondensschack". Att ppna en databas av denna typ p ett annat
stt r ocks ok, s troligtvis vill du ignorera denna instllning
(t.ex. om du startar Scid med din korrespondensschackdatabas vid
uppstart.)
</p>

<p>
<b>Inkorg (skvg)</b>:
I denna katalog sker Scid efter korrespondensschackpartier sparade
i PGN-format. Dessa partier anvnds fr synkroniseringen av
korrespondensschackdatabasen. Generellt, bryr sig inte Scid om hur
partierna kommer till denna katalog. Scid kommer bara att arbeta sig igenom alla PGN-filer
som finns dr. Detta ger mjlighet att anvnda ngra externa verktyg
fr att hmta partier till denna plats. Drutver, i eMail-schack br man
bara spara PGN-filerna frn motstndaren i denna
katalog.
</p>
<p>
Scid kommer inte att lsa en mailkorg, utan hanterar bara
alla PGN-filer som r placerade i denna katalog. Notera ocks, att Scid kommer att
synkronisera partie med den aktuella databasen. Men, om ett parti
frn denna katalog inte nnu finns i databasen kommer det att
behandlas som ett nytt parti och lggas till databasen.
</p>
<p>
Fr att synkroniseringsprocessen ska fungera mste PGN-filerna innehlla
ngon ytterliggare huvudinformation som r i perfekt enlighet med
PGN-standarden. Var god och konsulera <a
CCeMailChess>)Korrespondensschack via eMail</a> om du vill skapa
ditt eget verktyg eller om du flyttar data frn ngot annat system.
</p>

<p>
<b>Utkorg (skvg)</b>:
Motsatsen till <i>Inkorgen</i>. Scid placerar hr PGN-filer fr de
utgnde partierna. Fr eMail-schack r detta ndvndigt d PGN-filerna mste
bifogas till ett eMail-meddelande.  Fr Xfcc, dr bara draget skickas
, r detta inte ndvndigt, men Utkorgskatalogen erbjuder
ett bekvmt stt att koppla upp din PDA eller ngon annan anvndning d
PGN-filerna i Utkorgen ocks kommer att innehlla ditt senaste drag.
</p>

<p>
<b>Hmtningsverktyg</b>:
Detta program startas fr att hmta korrespondensschack-
partier frn en korrespondensschackserver. Denna hjlpare mste bara
hmta partier frn den klla den tycker om, generera en korrekt PGN-
fil med de ndvndiga PGN-taggarna. Verktyg fr att hmta partier
frn Xfcc-servrar finns som externa program och dessa r de naturliga
verktygen att stlla in hr. Fr framtida protokoll kan man enkelt generera
ett externt hmtningsverktyg som hanterar detta protokoll. ven automatisering
r mjlig om denna funktionalitet r gjord externt.
</p>
<p>
Notera: Detta verktug r <b>inte</b> startat fr hmtning av eMailschack-
meddelanden!
</p>

<p>
<b>Skickaverktyg</b>: 
Detta r motsatsen till hmtningsverktygen, primrt ven avsett fr Xfcc
support eller ngon annat framtida protokoll som kan dyka upp. Skickaverktyget,
dock, startas frn Scid med flera parametrar som ser ut som:
<term>
SendTool Outbox Name GameID MoveCount Move "Comment" resign claimDraw offerDraw acceptDraw
</term>
</p>

<p>
Betydelsen av parametrarna r som fljer:
   <ul>
      <li><term>Outbox</term>: Utkorgsskvgen anges i denna dialog. Skicka-
      verktyget ska generera en korrekt formatterad PGN-fil
      dr.
      </li>
      <li><term>Name</term>: Namnet p spelaren vid draget som str
      i PGN-fltet. Fr Xfcc r detta loginnamnet. Det r
      identiskt som spelarnamnet i PGN-huvudet.
      </li>
      <li><term>MoveCount</term>: Dragnummer att skicka.
      </li>
      <li><term>Move</term>: Det aktuella draget i SAN.
      </li>
      <li><term>"Comment"</term>: En kommentar skickad till motstndaren. Scid
      infogar den sista kommentaren i partiet. Dvs dessa kommentarer r
      behandlade som kommentarer till motstndaren. Notera att kommentaren r
      citerad, s flerradiga kommentarer br vara mjligt.
      </li>
      <li><term>resign</term>: 0 eller 1, specificerar om anvndaren
      vill ge upp. Ange till 1 om anvndaren anvnder
      <menu>Ge upp</menu> frn <menu>Korrespondensschack</menu>
      menyn.
      </li>
      <li><term>claimDraw</term>: 0 eller 1, specificerar om anvndaren
      vill ha krver remi. Ange till 1 om anvndaren anvnder
      <menu>Krv remi</menu> frn <menu>Korrespondensschack</menu>
      menyn.
      </li>
      <li><term>offerDraw</term>: 0 eller 1, specificerar om anvndaren
      vill erbjuda remi. Ange till 1 om anvndaren anvnder <menu>Erbjud
      remi</menu> frn <menu>Korrespondensschack</menu> menyn.
      </li>
      <li><term>acceptDraw</term>: 0 eller 1, specificerar om anvndaren
      vill acceptera en remi som erbjuds av motstndaren. Ange till 1 om
      anvndaren anvnder <menu>Acceptera remi</menu> frn
      <menu>Korrespondensschack</menu>
      menyn.
      </li>
   </ul>
</p>
<p>
Notera: Denna funktion r <b>not</b> startat fr eMail-schack!
</p>

<p>
<b>eMail-program</b>:
Detta anger skvgen till ditt fredragna eMail-program. Detta program startas
fr eMail-schack fr att skriva ett meddelande till motstndaren.
</p>

<p>
<b>(B)CC-Address</b>:
En kopia p det utgene meddelandet skickas till denna address som en kopia.
Notera dock, att om ett GUI-emailprogram anvnds har det normalt sin egen
utgende email-hantering. Drfr, kan angivande av denna address duplicera
meddelanden. Det kan dock anvndas fr att skicka ett parti till en annan address.
</p>

<p>
<b>Mod</b>:
Olyckligtvis finns det ett stort antal email-klienter och de anvnder
vldigt olika startkonventioner. Ngra vanliga konventioner, och
exempel p program som anvnder dem, listas hr. Emailprogrammet
kommer att startas med den valda konventionen. Om det inte r knt
vilken konvention som anvnds kan en av alternativen kanske matcha och
fungera. Notera dock att ett stort antal emailprogram r inte
kapabla att skicka bilagor nr de startas av ett annat program. I
detta fall mste du antingen byta din email-klient eller lgga till de bilagor
som har placerats i Scids Utkorg manuellt.
</p>
<p>Tips: mailx eller en av dess mnga kloner br vara tillgngliga som en
kommandoradsapplikation p nstan alla system som ett enkelt att stlla in
verktyg. Om ingen av dessa konventioner fungerar med din fredragna
klient eller om denna klient inte kan hantera email med bilagor via startande frn
kommandoraden, kan installation av mailx vara ett alternativ.
</p>
<p>Tips: mutt anvnder systemets emailtransport (dvs
sendmail/exim/postfix). Att stlla in dem r (troligtvis) inte enkelt
s mutt r ett perfekt alternativ. P en ordentlig Un*x med riktiga
instllningar br det vara det mest enkla sttet att hantera eMail-schack.
(Men det finns inte mnga korrekt instllda system , speciellt inte i
Linuxvrlden.)
</p>
<p>
<b>Bilageparameter</b>: 
Denna parameter anvnds fr att specificera en bilaga. Detta anvnds <b>bara</b>
i <term>mailx</term> mod.
</p>
<p>
<b>mnesparameter</b>:
Denna parameter anvnds fr att specificera mnet fr email-meddelandet. Det
anvnds <b>bara</b> i <term>mailx</term> mod.
</p>
<p><footer>(Uppdaterat: Scid 3.6.23, Februari 2008)</footer></p>
}
############################################################
#
# Swedish tip of the day:

set tips(W) {
  {
    Scid har ver 30 <a Index>Hjlpsidor</a>, och i de flesta fnster kan du
    genom att trycka <b>F1</b> f hjlp om det fnster du fr tillfllet har
    aktivt.
  }
  {
    Vissa fnster (t ex Partiinformation och <a Switcher>Databasvljaren</a>) 
    har en meny fr hger musknapp. Prova att hgerklicka i varje fnster s
    ser du vilka som har det och vilka funktioner du kommer t den vgen.
  }
  {
    Du kan ange drag p mer n ett stt, s du kan vlja vilket som passar dig
    bst. Du kan anvnda musen (med eller utan dragfrslag) eller tangentbordet
    (med eller utan autokomplettering). Ls hjlpsidan fr 
    <a Moves>Att ange drag</a> fr mer information.
  }
  {
    Om du har databaser du ofta ppnar s kan du lgga till ett 
    <a Bookmarks>Bokmrke</a> fr varje databas. Du kommer d att kunna ppna 
    databaserna snabbare via bokmrkesmenyn.
  }
  {
    Du kan se alla drag i det aktuella partiet (inklusive varianter och kommentarer)
    genom att ppna <a PGN>PGN-fnstret</a>.
    Du navigerar igenom partiet i PGN-fnstret genom att klicka p valfritt drag med
    vnster musknapp. Genom att klicka p draget med mellan- eller hgermusknapp s
    fr du en frhandsvisning av just den stllningen.
  }
  {
    Du kan kopiera partier mellan databaserna i <a Switcher>Databasvljaren</a> genom
    att dra-och-slppa dem mellan respektive databas.
  }
  {
    Scid kan ppna PGN filer, ven de som r komprimerade med Gzip (dvs har en .gz filndelse). 
    PGN filer ppnas med enbart lsrttigheter, s om du vill redigera en PGN-fil i Scid 
    mste du kopiera filen till en Scid-databas med hjlp av <a Switcher>Databasvljaren</a>.
  }
  {
    Om du ofta anvnder <a Tree>Trdfnstret</a> med stora databaser, r det vrt att vlja
    <b>Fyll cachefil</b> frn Arkivmenyn i Trdfnstret. Detta innebr att trdstatistik fr 
    mnga av de vanligare stllningarna sparas, vilket ger en snabbare trdtkomst fr databasen
    ifrga.
  }
  {
    <a Tree>Trdfnstret</a> kan visa alla drag frn den aktuella stllningen. Men om ocks vill 
    se alla dragfljder som har lett till denna stllning kan du f fram det genom att skapa en
   <a OpReport>ppningsrapport</a>.
  }
  {
    Du kan vnster- eller hgerklicka i en kolumn i <a GameList>Partilistan</a> fr att ndra 
    dess bredd.
  }
  {
    Med <a PInfo>Spelarinformationen</a> aktuell (klicka p endera spelarens namn under brdet i 
    huvudfnstret fr att f fram den) r det enkelt att <a Searches filtret>Filtrera</a> fram partier
    av en srskild spelares enskilda resultat. Klicka bara p valfritt vrde som har angivits med
    <red>rd text</red>.
  }
  {
    Nr du studerar ppningar kan det vara en pong att markera valen <b>Bnder</b> eller <b>Filer</b> i 
    <a Searches Board>Sk aktuell position</a>. Genom dessa val kan du hitta andra ppningar som ger
    liknande bondestrukturer.
  }
  {
    Du kan hgerklicka i partiinformationsdelen av huvudfnstret (under brdet) fr att f fram en 
    kontextmeny. Du kan t ex gra s att Scid dljer nsta drag i ett parti, vilket kan vara anvndbart 
    om du vill trna genom att "gissa" nsta drag.
  }
  {
    Om du ofta <a Maintenance>Underhller</a> stora databaser kan du utfra flera underhllsuppgifter 
    vid samma tillflle via <a Maintenance Cleaner>Databasverktyget</a>.
  }
  {
    Om du har en stor databas dr de flesta partierna har ett evenemangsdatum och du vill ha partierna i 
    datumordning br du vervga att <a Sorting>Sortera</a> den p evenemangsdatum i frsta hand och 
    evenemang i andra hand, istllet fr datum och evenemang, d detta kommer att hlla turneringspartierna
    frn olika datum samman. (Under frutsttning att alla partier har samma evenemangsdatum naturligtvis).
    Alternativt kan du se till att flten evenemang, rond och datum r s enhetliga och korrekta som mjligt.
    (ms).
  }
  {
    Det kan vara en bra id att <a Maintenance Spellcheck>Stavningskontrollera</a> din databas innan du 
    <a Maintenance Twins>Tar bort dubbletter</a> d Scid har strre mjlighet att hitta dubbletterna och 
    markera dessa fr borttagning.
  }
  {
    <a Flags>Flaggor</a> r anvndbara fr att markera upp partier med karaktristika du vill ska p senare,
    ssom bondestllning, taktiska finesser, osv. Du kan ska p flaggor nr du sker p flt i partihuvudet.
  }
  {
    Om du gr igenom ett parti, och helt enkelt vill testa en ny variant utan att frndra partiet i sig, kan 
    du sl p Frskslget (Trial mode) genom att trycka <b>Ctrl+Mellanslag</b> eller frn verktygsraden. terg till
    ursprungspartiet nr du r klar.
  }
  {
    Om du vill hitta det mest betydelsefulla partiet (med hgst rankade spelare) i en viss position kan du
    ppna <a Tree>Trdfnstret</a> och i denna ppna listan med de bsta partierna. I trdfnstret kan du till
    och med begrnsa partierna till endast ett srskilt resultat.
  }
  {
    Ett bra stt att studera en ppning r att i en stor databas sl p trningslget i <a Tree>Trdfnstret</a>, 
    och sedan spela igenom databasen fr att se vilka varianter som frekommer oftast.
  }
  {
    Om du har tv databaser ppna, och vill ha ett varianttrd att studera medan du gr igenom ett parti
    i den andra databasen kan du <b>Lsa</b> trdet i den databasen och sedan byta till den andra.
  }
  {
    <a Tmt>Turneringsskaren</a> r inte bara anvndbar fr att lokalisera en srskild 
    turnering. Du kan ocks anvnda den fr att ska efter turneringar en specifik spelare nyligen deltagit 
    i, eller att blddra genom turneringar som genomfrts i ett visst land.
  }
  {
    Det finns ett antal vanliga stllningstyper definierade i <a Searches Material>Sk Material/Stllning</a>
    fnstret som du kan ha nytta av nr du studerar ppningar och mittspel.
  }
  {
    Nr du sker p <a Searches Material>Material eller Stllning</a> kan det ofta vara frdelaktigt att begrnsa
    skningen till sdana partier dr stllningen eller materialet frekommit i tminstone ngra drag. Du slipper
    du f med trffar dr situationen du sker uppkom helt tillflligt.
  }
  {
    Om du har en viktig databas du inte vill radera av misstag kan du vlja  <b>Enbart lsbar</b> frn <b>Arkiv</b>
    menyn efter att du har ppnat den. Alternativt kan du stta dess filrttigheter till enbart lsrttigheter.
  }
  {
    Om du anvnder XBoard eller WinBoard (eller ngot annat program som kan hantera FEN-notation via Urklippshanteraren)
    och vill kopiera den aktuella stllningen frn ditt program r det snabbaste sttet att gra det s hr:
    Vlj <b>Kopiera position</b> frn <b>Arkiv</b>-menyn i Xboard/Winboard, vlj sedan <b>Klistra i utgngsstllning</b>
    i Redigera menyn i Scid.
  }
  {
    I <a Searches Header>Sk i huvud</a>, r spelare-, evenemang-, plats-, och rondnamn oknsliga fr VERSALER och
    gemener och ger trffar varhelst de finns i ett namn. Om du vill kan du ange att du istllet vill att skningen <b>ska</b>
    ta VERSALER/gemener i beaktande. Genom att anvnda jokertecken inom citationstecken (dr "?" = motsvarar obestmt
    enskilt tecken och "*" = noll eller flera tecken). Om du exempelvis anger "*BEL" (med citationstecken) i det platsfltet
    hittar du alla partier spelade i Belgien, men exkluderar de som spelats i Belgrad.
  }
  {
    Om du vill redigera ett drag i ett parti utan att frlora alla de drag som spelats efter detta kan du ppna
    <a Import>Importera ett parti i PGN-format</a> fnstret i Verktygsmenyn. Klicka dr p <b>Klistra i aktuellt parti</b> 
    , redigera partiet och avsluta med <b>Importera</b>.
  }
  {
    Om du har en ECO klassificeringsfil laddad, kan du n den mest exakt klassificerade stllningen fr det aktuella partiet
    genom att vlja <b>Identifiera ppning</b> i <b>Partier</b> menyn (kortkommando: <b>Ctrl+Shift+D</b>).
  }
  {
    Nr du vill se hur stor en fil r, eller vill se nr den senast redigerades innan du ppnar den kan du anvnda
    <a Finder>Sk filer</a> (Arkiv - Sk filer).
  }
  {
    En <a repetoire>Repetoarfil</a> r ett utmrkt stt att hlla koll p dina favoritppningar, eller hitta partier dr
    dr de har spelats. Nr du vl har skapat en repetoarfil kan du genomska nya filer utifrn repetoarfilen, och titta 
    igenom alla partier med just dina ppningar.
  }
  {
    Genom att skapa en <a OpReport>ppningsrapport</a> har du en utmrkt mjlighet att lra dig en ny spelppning. Du kan f
    information om resultat, hur remiaktig den r, vilka vanliga positionella teman som dyker upp, och mycket mer.
  }
  {
    Du kan kommentera den aktuella stllningen med de vanligaste symbolerna (!, !?, +=, etc) utan att behva anvnda 
    <a Comment>Kommentarseditorn<a>. Dr du exempelvis vill ange ett bra drag skriver du "!" och trycker sedan ENTER
    s lggs "!" symbolen till draget. Se ven hjlpsidan <a Moves>Ange drag</a> fr mer detaljerad information.
  }
  {
    Om du blddrar igenom ppningarna i en databas i <a Tree>Trdfnstret</a>, fr du en anvndbar verblick ver hur
    vl ppningen fungerar i sentida partier mellan hgratade spelare om du ppnar statistikfnstret (kortkommando: Ctrl+I).
  }
  {
    Du ndrar enkelt huvudfnstrets brdstorlek genom att hlla nere <b>Ctrl</b> och <b>Shift</b> tangenterna, samtidigt
    som du trycker hger- eller vnster piltangent.
  }
  {
    Efter genomfrd <a Searches>Skning</a>, r det enkelt att navigera genom urvalet genom att hlla nere <b>Ctrl</b> 
    tangenten samtidigt som du trycker upp- eller nerpiltangenterna fr att g till fregende eller nsta parti i 
    <a Searches filtret>Urvalet</a>.
  }
{
  Du kan relativt enkelt rita pilar och frga rutor till dina kommentarer. ppna <b>Kommentarseditorn</b>, klicka p <b>Infoga symbol</b> och vlj nskad frg. Om du nu klickar p en frsta ruta, och drefter klickar p en andra s dras en pil i nskad frg frn den frsta till den andra rutan. Klickar du bara p en ruta, blir den frgad.
  }
}
#}
