// -*- Mode: C++; -*-
//                            Package   : omniORB
// unknownUserExn.cc          Created on: 9/1998
//                            Author    : David Riddoch (djr)
//
//    Copyright (C) 2004 Apasphere Ltd
//    Copyright (C) 1996-1999 AT&T Laboratories Cambridge
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library. If not, see http://www.gnu.org/licenses/
//
//
// Description:
//   Implementation of CORBA::UnknownUserException.
//

#include <omniORB4/CORBA.h>

OMNI_USING_NAMESPACE(omni)

CORBA::UnknownUserException::UnknownUserException(Any* ex)
  : pd_exception(ex)
{
  if( !ex )
    throw omniORB::fatalException(__FILE__,__LINE__,
       "CORBA::UnknownUserException::UnknownUserException(Any*)");
  pd_insertToAnyFn    = insertToAnyFn; 
  pd_insertToAnyFnNCP = insertToAnyFnNCP;
}


CORBA::UnknownUserException::~UnknownUserException()
{
  delete pd_exception;
}


CORBA::Any&
CORBA::UnknownUserException::exception()
{
  return *pd_exception;
}


void
CORBA::UnknownUserException::_raise() const
{
  throw *this;
}


CORBA::UnknownUserException*
CORBA::UnknownUserException::_downcast(Exception* e)
{
  return (UnknownUserException*) _NP_is_a(e,
			 "Exception/UserException/UnknownUserException");
}


const CORBA::UnknownUserException*
CORBA::UnknownUserException::_downcast(const Exception* e)
{
  return (const UnknownUserException*) _NP_is_a(e,
		       "Exception/UserException/UnknownUserException");
}


CORBA::Exception*
CORBA::UnknownUserException::_NP_duplicate() const
{
  // pd_exception is guarenteed not null
  Any* ex = new Any(*pd_exception);
  Exception* e = new UnknownUserException(ex);
  return e;
}


const char*
CORBA::UnknownUserException::_NP_typeId() const
{
  return "Exception/UserException/UnknownUserException";
}


const char*
CORBA::UnknownUserException::_NP_repoId(int* size) const
{
  *size = sizeof("IDL:omg.org/CORBA/UnknownUserException:1.0");
  return "IDL:omg.org/CORBA/UnknownUserException:1.0";
}

void
CORBA::UnknownUserException::_NP_marshal(cdrStream& _s) const
{
  // I don't think we can be called.
  OMNIORB_ASSERT(0);
}


CORBA::Exception::insertExceptionToAny    CORBA::UnknownUserException::insertToAnyFn;
CORBA::Exception::insertExceptionToAnyNCP CORBA::UnknownUserException::insertToAnyFnNCP;


// Code generated by omniidl

static CORBA::TypeCode::_Tracker _0RL_tcTrack(__FILE__);

static CORBA::PR_structMember _0RL_structmember_CORBA_mUnknownUserException[] = {
  {"exception", CORBA::TypeCode::PR_any_tc()}
};

static CORBA::TypeCode_ptr _0RL_tc_CORBA_mUnknownUserException = CORBA::TypeCode::PR_exception_tc("IDL:omg.org/CORBA/UnknownUserException:1.0", "UnknownUserException", _0RL_structmember_CORBA_mUnknownUserException, 1, &_0RL_tcTrack);



static void _0RL_CORBA_mUnknownUserException_marshal_fn(cdrStream& _s, void* _v)
{
  CORBA::UnknownUserException* _p = (CORBA::UnknownUserException*)_v;
  CORBA::Any& a = _p->exception();
  a >>= _s;
}
static void _0RL_CORBA_mUnknownUserException_unmarshal_fn(cdrStream& _s, void*& _v)
{
  CORBA::Any* a = new CORBA::Any();
  *a <<= _s;

  CORBA::UnknownUserException* _p = new CORBA::UnknownUserException(a);
  _v = _p;
}
static void _0RL_CORBA_mUnknownUserException_destructor_fn(void* _v)
{
  CORBA::UnknownUserException* _p = (CORBA::UnknownUserException*)_v;
  delete _p;
}

void operator<<=(CORBA::Any& _a, const CORBA::UnknownUserException& _s)
{
  CORBA::UnknownUserException* _p = new CORBA::UnknownUserException(_s);
  _a.PR_insert(_0RL_tc_CORBA_mUnknownUserException,
               _0RL_CORBA_mUnknownUserException_marshal_fn,
               _0RL_CORBA_mUnknownUserException_destructor_fn,
               _p);
}
void operator<<=(CORBA::Any& _a, const CORBA::UnknownUserException* _sp)
{
  _a.PR_insert(_0RL_tc_CORBA_mUnknownUserException,
               _0RL_CORBA_mUnknownUserException_marshal_fn,
               _0RL_CORBA_mUnknownUserException_destructor_fn,
               (CORBA::UnknownUserException*)_sp);
}

CORBA::Boolean operator>>=(const CORBA::Any& _a, const CORBA::UnknownUserException*& _sp)
{
  void* _v;
  if (_a.PR_extract(_0RL_tc_CORBA_mUnknownUserException,
                    _0RL_CORBA_mUnknownUserException_unmarshal_fn,
                    _0RL_CORBA_mUnknownUserException_marshal_fn,
                    _0RL_CORBA_mUnknownUserException_destructor_fn,
                    _v)) {
    _sp = (const CORBA::UnknownUserException*)_v;
    return 1;
  }
  return 0;
}

static void _0RL_insertToAny__cCORBA_mUnknownUserException(CORBA::Any& _a, const CORBA::Exception& _e) {
  const CORBA::UnknownUserException & _ex = (const CORBA::UnknownUserException &) _e;
  operator<<=(_a,_ex);
}

static void _0RL_insertToAnyNCP__cCORBA_mUnknownUserException (CORBA::Any& _a, const CORBA::Exception* _e) {
  const CORBA::UnknownUserException* _ex = (const CORBA::UnknownUserException*) _e;
  operator<<=(_a,_ex);
}

class _0RL_insertToAny_Singleton__cCORBA_mUnknownUserException {
public:
  _0RL_insertToAny_Singleton__cCORBA_mUnknownUserException() {
    CORBA::UnknownUserException::insertToAnyFn = _0RL_insertToAny__cCORBA_mUnknownUserException;
    CORBA::UnknownUserException::insertToAnyFnNCP = _0RL_insertToAnyNCP__cCORBA_mUnknownUserException;
  }
};
static _0RL_insertToAny_Singleton__cCORBA_mUnknownUserException _0RL_insertToAny_Singleton__cCORBA_mUnknownUserException_;

