# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_tree import DataObjectTree


class PartitionedDataSetCollection(DataObjectTree):
    r"""
    PartitionedDataSetCollection - Composite dataset that groups
    datasets as a collection.
    
    Superclass: DataObjectTree
    
    PartitionedDataSetCollection is a CompositeDataSet that stores
    a collection of non-null PartitionedDataSets. These items can
    represent different concepts depending on the context. For example,
    they can represent region of different materials in a simulation or
    parts in an assembly. It is not requires that items have anything in
    common. For example, they can have completely different point or cell
    arrays.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPartitionedDataSetCollection, obj, update, **traits)
    
    def _get_data_assembly(self):
        return wrap_vtk(self._vtk_obj.GetDataAssembly())
    def _set_data_assembly(self, arg):
        old_val = self._get_data_assembly()
        self._wrap_call(self._vtk_obj.SetDataAssembly,
                        deref_vtk(arg))
        self.trait_property_changed('data_assembly', old_val, arg)
    data_assembly = traits.Property(_get_data_assembly, _set_data_assembly, desc=\
        r"""
        data_assembly provides a way to define hierarchical organization
        of partitioned-datasets. These methods provide access to the data
        assembly instances associated, if any.
        """
    )

    number_of_partitioned_data_sets = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set the number of blocks. This will cause allocation if the new
        number of blocks is greater than the current size. All new blocks
        are initialized to with empty `vtkpartitioned_data_set_collection`
        instances.
        """
    )

    def _number_of_partitioned_data_sets_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfPartitionedDataSets,
                        self.number_of_partitioned_data_sets)

    def get_number_of_partitions(self, *args):
        """
        get_number_of_partitions(self, idx:int) -> int
        C++: unsigned int get_number_of_partitions(unsigned int idx)
        Returns the number of partitions in a partitioned dataset at the
        given index.
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfPartitions, *args)
        return ret

    def set_number_of_partitions(self, *args):
        """
        set_number_of_partitions(self, idx:int, numPartitions:int) -> None
        C++: void set_number_of_partitions(unsigned int idx,
            unsigned int numPartitions)
        Set number of partitions at a given index. Note, this will call
        `set_number_of_partitioned_data_sets` if needed to grow the
        collection.
        """
        ret = self._wrap_call(self._vtk_obj.SetNumberOfPartitions, *args)
        return ret

    def get_partition(self, *args):
        """
        get_partition(self, idx:int, partition:int) -> DataSet
        C++: DataSet *get_partition(unsigned int idx,
            unsigned int partition)"""
        ret = self._wrap_call(self._vtk_obj.GetPartition, *args)
        return wrap_vtk(ret)

    def set_partition(self, *args):
        """
        set_partition(self, idx:int, partition:int, object:DataObject)
            -> None
        C++: void set_partition(unsigned int idx, unsigned int partition,
            DataObject *object)
        API to get/set partitions using a tuple index.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetPartition, *my_args)
        return ret

    def get_partitioned_data_set(self, *args):
        """
        get_partitioned_data_set(self, idx:int) -> PartitionedDataSet
        C++: PartitionedDataSet *get_partitioned_data_set(
            unsigned int idx)
        Returns the block at the given index. It is recommended that one
        uses the iterators to iterate over composite datasets rather than
        using this API.
        """
        ret = self._wrap_call(self._vtk_obj.GetPartitionedDataSet, *args)
        return wrap_vtk(ret)

    def set_partitioned_data_set(self, *args):
        """
        set_partitioned_data_set(self, idx:int,
            dataset:PartitionedDataSet) -> None
        C++: void set_partitioned_data_set(unsigned int idx,
            PartitionedDataSet *dataset)
        Sets the data object as the given block. The total number of
        blocks will be resized to fit the requested block no.
        
        @remark `dataset` cannot be nullptr.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetPartitionedDataSet, *my_args)
        return ret

    def get_composite_index(self, *args):
        """
        get_composite_index(self, idx:int) -> int
        C++: unsigned int get_composite_index(unsigned int idx)
        get_composite_index(self, idx:int, partition:int) -> int
        C++: unsigned int get_composite_index(unsigned int idx,
            unsigned int partition)
        Returns the composite index (sometimes referred to as the
        flat-index) for either a partitioned dataset or a specific
        partition in a partitioned dataset.
        """
        ret = self._wrap_call(self._vtk_obj.GetCompositeIndex, *args)
        return ret

    def get_partition_as_data_object(self, *args):
        """
        get_partition_as_data_object(self, idx:int, partition:int)
            -> DataObject
        C++: DataObject *get_partition_as_data_object(unsigned int idx,
            unsigned int partition)"""
        ret = self._wrap_call(self._vtk_obj.GetPartitionAsDataObject, *args)
        return wrap_vtk(ret)

    def remove_partitioned_data_set(self, *args):
        """
        remove_partitioned_data_set(self, idx:int) -> None
        C++: void remove_partitioned_data_set(unsigned int idx)
        Remove the given block from the dataset.
        """
        ret = self._wrap_call(self._vtk_obj.RemovePartitionedDataSet, *args)
        return ret

    _updateable_traits_ = \
    (('global_release_data_flag', 'GetGlobalReleaseDataFlag'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_partitioned_data_sets', 'GetNumberOfPartitionedDataSets'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display',
    'number_of_partitioned_data_sets'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PartitionedDataSetCollection, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PartitionedDataSetCollection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag'], [],
            ['number_of_partitioned_data_sets']),
            title='Edit PartitionedDataSetCollection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PartitionedDataSetCollection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

