/*
 * Copyright 2014 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#include "src/gpu/GrGeometryProcessor.h"
#include "src/gpu/GrProcessorAnalysis.h"
#include "src/gpu/ops/GrDrawOp.h"

GrColorFragmentProcessorAnalysis::GrColorFragmentProcessorAnalysis(
        const GrProcessorAnalysisColor& input,
        std::unique_ptr<GrFragmentProcessor> const fps[],
        int cnt) {
    fCompatibleWithCoverageAsAlpha = true;
    fIsOpaque = input.isOpaque();
    fUsesLocalCoords = false;
    fProcessorsToEliminate = 0;
    fKnowOutputColor = input.isConstant(&fLastKnownOutputColor);
    for (int i = 0; i < cnt; ++i) {
        if (fUsesLocalCoords && !fKnowOutputColor && !fCompatibleWithCoverageAsAlpha &&
            !fIsOpaque) {
            break;
        }
        const auto& fp = fps[i];
        if (fKnowOutputColor &&
            fp->hasConstantOutputForConstantInput(fLastKnownOutputColor, &fLastKnownOutputColor)) {
            ++fProcessorsToEliminate;
            fIsOpaque = fLastKnownOutputColor.isOpaque();
            // We reset these since the caller is expected to not use the earlier fragment
            // processors.
            fCompatibleWithCoverageAsAlpha = true;
            fUsesLocalCoords = false;
        } else {
            fKnowOutputColor = false;
            if (fIsOpaque && !fp->preservesOpaqueInput()) {
                fIsOpaque = false;
            }
            if (fCompatibleWithCoverageAsAlpha && !fp->compatibleWithCoverageAsAlpha()) {
                fCompatibleWithCoverageAsAlpha = false;
            }
            if (fp->usesLocalCoords()) {
                fUsesLocalCoords = true;
            }
        }
    }
}
