/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.dns;

import java.util.StringTokenizer;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.dns.ProviderMgr;

public class DNSPseudoURL {
    private String host = "localhost";
    private int port = 53;
    private String domain = ".";
    private boolean hostIpWasGiven = false;

    public DNSPseudoURL(String strForm) throws IllegalArgumentException {
        StringTokenizer st = null;
        StringTokenizer st2 = null;
        if (strForm == null) {
            throw new NullPointerException(Messages.getString("jndi.67"));
        }
        st = new StringTokenizer(strForm, "/", true);
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException(Messages.getString("jndi.68"));
        }
        String token = st.nextToken();
        if (!token.equals("dns:")) {
            throw new IllegalArgumentException(Messages.getString("jndi.69"));
        }
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            if (!token.equals("/") || !st.hasMoreTokens()) {
                throw new IllegalArgumentException(Messages.getString("jndi.6A"));
            }
            token = st.nextToken();
            if (token.equals("/")) {
                if (!st.hasMoreElements()) {
                    throw new IllegalArgumentException(Messages.getString("jndi.6A"));
                }
                token = st.nextToken();
                st2 = new StringTokenizer(token, ":");
                this.host = st2.nextToken();
                try {
                    ProviderMgr.parseIpStr(this.host);
                    this.hostIpWasGiven = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.hostIpWasGiven = false;
                }
                if (st2.hasMoreTokens()) {
                    this.port = Integer.parseInt(st2.nextToken());
                }
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (!token.equals("/") || !st.hasMoreTokens()) {
                        throw new IllegalArgumentException(Messages.getString("jndi.6A"));
                    }
                    this.domain = ProviderMgr.normalizeName(st.nextToken());
                }
            } else {
                this.domain = ProviderMgr.normalizeName(token);
            }
            if (st.hasMoreTokens()) {
                throw new IllegalArgumentException(Messages.getString("jndi.66"));
            }
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isHostIpGiven() {
        return this.hostIpWasGiven;
    }

    public int getPort() {
        return this.port;
    }
}

