#include "PreferencesDialog.h"
#include <QtGui>
#include "MainWindow.h"

PreferencesDialog::PreferencesDialog(QWidget *parent) :
    QDialog(parent)
{
    setWindowTitle(tr("Preferences"));
    setAttribute(Qt::WA_DeleteOnClose);
    QVBoxLayout *layout = new QVBoxLayout(this);

    mdiArea = (static_cast<MainWindow*>(parent))->mdiArea;
    mdiViewModeGroupBox = new QGroupBox(tr("&View Mode"));
    QVBoxLayout *vbox = new QVBoxLayout;
    mdiViewModeSubWindowRadio = new QRadioButton((tr("&Subwindows")));
    mdiViewModeTabbedRadio = new QRadioButton(tr("&Tabs"));
    if (mdiArea->viewMode() == QMdiArea::SubWindowView)
        mdiViewModeSubWindowRadio->setChecked(true);
    else
        mdiViewModeTabbedRadio->setChecked(true);

    vbox->addWidget(mdiViewModeSubWindowRadio);
    vbox->addWidget(mdiViewModeTabbedRadio);
    mdiViewModeGroupBox->setLayout(vbox);

    buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel);
    connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
    layout->addWidget(mdiViewModeGroupBox);
    layout->addWidget(buttonBox);
    setLayout(layout);
}

void PreferencesDialog::accept()
{
    if (mdiViewModeSubWindowRadio->isChecked())
        mdiArea->setViewMode(QMdiArea::SubWindowView);
    else
        mdiArea->setViewMode(QMdiArea::TabbedView);

    this->done(1);
}

void PreferencesDialog::reject()
{
    this->done(0);
}
