; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s                               -mtriple=x86_64-apple-darwin10 -mattr=+sse,+sse2,-x87 -verify-machineinstrs | FileCheck %s --check-prefixes=X64,SDAG-X64
; RUN: llc < %s -fast-isel -fast-isel-abort=1 -mtriple=x86_64-apple-darwin10 -mattr=+sse,+sse2,-x87 -verify-machineinstrs | FileCheck %s --check-prefixes=X64,FAST-X64
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=x86_64-apple-darwin10 -mattr=+sse,+sse2,-x87 -verify-machineinstrs | FileCheck %s --check-prefixes=GISEL-X64
; i686 with 64 bit store is issue.
; RUN: llc < %s                               -mtriple=i686-apple-darwin10 -mattr=-sse,-sse2,+x87 -verify-machineinstrs | FileCheck %s --check-prefixes=X86,SDAG-X86
; Allow fast-isel to fallback to selection dag on x86
; RUN: llc < %s -fast-isel -mtriple=i686-apple-darwin10 -mattr=-sse,-sse2,+x87 -verify-machineinstrs | FileCheck %s --check-prefixes=X86,FAST-X86
; llc < %s -global-isel -global-isel-abort=1 -mtriple=i686-apple-darwin10 -mattr=-sse,-sse2,+x87 -verify-machineinstrs | FileCheck %s --check-prefixes=GISEL-X86

  define i1 @fcmp_float_oeq(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_oeq:
; X64:       ## %bb.0:
; X64-NEXT:    cmpeqss %xmm1, %xmm0
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $1, %eax
; X64-NEXT:    ## kill: def $al killed $al killed $eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_oeq:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    sete %cl
; GISEL-X64-NEXT:    setnp %al
; GISEL-X64-NEXT:    andb %cl, %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_oeq:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %cl
; X86-NEXT:    sete %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
    %1 = fcmp oeq float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ogt(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_ogt:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    seta %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ogt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_ogt:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    seta %al
; X86-NEXT:    retl
    %1 = fcmp ogt float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_oge(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_oge:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    setae %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_oge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_oge:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setae %al
; X86-NEXT:    retl
    %1 = fcmp oge float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_olt(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_olt:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    seta %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_olt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_float_olt:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    seta %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_float_olt:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    seta %al
; FAST-X86-NEXT:    retl
    %1 = fcmp olt float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ole(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_ole:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    setae %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ole:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_float_ole:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setae %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_float_ole:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setae %al
; FAST-X86-NEXT:    retl
    %1 = fcmp ole float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_one(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_one:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    setne %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_one:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_one:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setne %al
; X86-NEXT:    retl
    %1 = fcmp one float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ord(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_ord:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    setnp %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ord:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setnp %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_ord:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %al
; X86-NEXT:    retl
    %1 = fcmp ord float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_uno(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_uno:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    setp %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_uno:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setp %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_uno:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %al
; X86-NEXT:    retl
    %1 = fcmp uno float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ueq(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_ueq:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    sete %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ueq:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_ueq:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    sete %al
; X86-NEXT:    retl
    %1 = fcmp ueq float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ugt(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_ugt:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    setb %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ugt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_float_ugt:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setb %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_float_ugt:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setb %al
; FAST-X86-NEXT:    retl
    %1 = fcmp ugt float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_uge(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_uge:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm0, %xmm1
; X64-NEXT:    setbe %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_uge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm0, %xmm1
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_float_uge:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setbe %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_float_uge:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setbe %al
; FAST-X86-NEXT:    retl
    %1 = fcmp uge float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ult(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_ult:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    setb %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ult:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_ult:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setb %al
; X86-NEXT:    retl
    %1 = fcmp ult float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ule(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_ule:
; X64:       ## %bb.0:
; X64-NEXT:    ucomiss %xmm1, %xmm0
; X64-NEXT:    setbe %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ule:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_ule:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setbe %al
; X86-NEXT:    retl
    %1 = fcmp ule float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_une(float %x, float %y) nounwind {
; X64-LABEL: fcmp_float_une:
; X64:       ## %bb.0:
; X64-NEXT:    cmpneqss %xmm1, %xmm0
; X64-NEXT:    movd %xmm0, %eax
; X64-NEXT:    andl $1, %eax
; X64-NEXT:    ## kill: def $al killed $al killed $eax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_une:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomiss %xmm1, %xmm0
; GISEL-X64-NEXT:    setne %cl
; GISEL-X64-NEXT:    setp %al
; GISEL-X64-NEXT:    orb %cl, %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_une:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %cl
; X86-NEXT:    setne %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
    %1 = fcmp une float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_oeq(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_oeq:
; X64:       ## %bb.0:
; X64-NEXT:    cmpeqsd %xmm1, %xmm0
; X64-NEXT:    movq %xmm0, %rax
; X64-NEXT:    andl $1, %eax
; X64-NEXT:    ## kill: def $al killed $al killed $rax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_oeq:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm1, %xmm0
; GISEL-X64-NEXT:    sete %cl
; GISEL-X64-NEXT:    setnp %al
; GISEL-X64-NEXT:    andb %cl, %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_double_oeq:
; X86:       ## %bb.0:
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %cl
; X86-NEXT:    sete %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
    %1 = fcmp oeq double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_ogt(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_ogt:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm1, %xmm0
; X64-NEXT:    seta %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_ogt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm1, %xmm0
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_double_ogt:
; X86:       ## %bb.0:
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    seta %al
; X86-NEXT:    retl
    %1 = fcmp ogt double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_oge(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_oge:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm1, %xmm0
; X64-NEXT:    setae %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_oge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm1, %xmm0
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_double_oge:
; X86:       ## %bb.0:
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setae %al
; X86-NEXT:    retl
    %1 = fcmp oge double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_olt(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_olt:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm0, %xmm1
; X64-NEXT:    seta %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_olt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm0, %xmm1
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_double_olt:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    seta %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_double_olt:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    seta %al
; FAST-X86-NEXT:    retl
    %1 = fcmp olt double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_ole(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_ole:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm0, %xmm1
; X64-NEXT:    setae %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_ole:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm0, %xmm1
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_double_ole:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setae %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_double_ole:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setae %al
; FAST-X86-NEXT:    retl
    %1 = fcmp ole double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_one(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_one:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm1, %xmm0
; X64-NEXT:    setne %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_one:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm1, %xmm0
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_double_one:
; X86:       ## %bb.0:
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setne %al
; X86-NEXT:    retl
    %1 = fcmp one double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_ord(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_ord:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm1, %xmm0
; X64-NEXT:    setnp %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_ord:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm1, %xmm0
; GISEL-X64-NEXT:    setnp %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_double_ord:
; X86:       ## %bb.0:
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %al
; X86-NEXT:    retl
    %1 = fcmp ord double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_uno(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_uno:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm1, %xmm0
; X64-NEXT:    setp %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_uno:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm1, %xmm0
; GISEL-X64-NEXT:    setp %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_double_uno:
; X86:       ## %bb.0:
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %al
; X86-NEXT:    retl
    %1 = fcmp uno double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_ueq(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_ueq:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm1, %xmm0
; X64-NEXT:    sete %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_ueq:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm1, %xmm0
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_double_ueq:
; X86:       ## %bb.0:
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    sete %al
; X86-NEXT:    retl
    %1 = fcmp ueq double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_ugt(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_ugt:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm0, %xmm1
; X64-NEXT:    setb %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_ugt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm0, %xmm1
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_double_ugt:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setb %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_double_ugt:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setb %al
; FAST-X86-NEXT:    retl
    %1 = fcmp ugt double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_uge(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_uge:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm0, %xmm1
; X64-NEXT:    setbe %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_uge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm0, %xmm1
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_double_uge:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setbe %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_double_uge:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setbe %al
; FAST-X86-NEXT:    retl
    %1 = fcmp uge double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_ult(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_ult:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm1, %xmm0
; X64-NEXT:    setb %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_ult:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm1, %xmm0
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_double_ult:
; X86:       ## %bb.0:
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setb %al
; X86-NEXT:    retl
    %1 = fcmp ult double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_ule(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_ule:
; X64:       ## %bb.0:
; X64-NEXT:    ucomisd %xmm1, %xmm0
; X64-NEXT:    setbe %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_ule:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm1, %xmm0
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_double_ule:
; X86:       ## %bb.0:
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setbe %al
; X86-NEXT:    retl
    %1 = fcmp ule double %x, %y
    ret i1 %1
  }

  define i1 @fcmp_double_une(double %x, double %y) nounwind {
; X64-LABEL: fcmp_double_une:
; X64:       ## %bb.0:
; X64-NEXT:    cmpneqsd %xmm1, %xmm0
; X64-NEXT:    movq %xmm0, %rax
; X64-NEXT:    andl $1, %eax
; X64-NEXT:    ## kill: def $al killed $al killed $rax
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_double_une:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    ucomisd %xmm1, %xmm0
; GISEL-X64-NEXT:    setne %cl
; GISEL-X64-NEXT:    setp %al
; GISEL-X64-NEXT:    orb %cl, %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_double_une:
; X86:       ## %bb.0:
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %cl
; X86-NEXT:    setne %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
    %1 = fcmp une double %x, %y
    ret i1 %1
  }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; FAST-X64: {{.*}}
; SDAG-X64: {{.*}}
